/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.dns;

import android.os.Build;
import android.util.Log;
import cn.jmessage.support.qiniu.android.dns.Domain;
import cn.jmessage.support.qiniu.android.dns.IResolver;
import cn.jmessage.support.qiniu.android.dns.IpSorter;
import cn.jmessage.support.qiniu.android.dns.Network;
import cn.jmessage.support.qiniu.android.dns.NetworkInfo;
import cn.jmessage.support.qiniu.android.dns.Record;
import cn.jmessage.support.qiniu.android.dns.http.DomainNotOwn;
import cn.jmessage.support.qiniu.android.dns.local.Hosts;
import cn.jmessage.support.qiniu.android.dns.util.LruCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public final class DnsManager {
    private final IResolver[] resolvers;
    private final LruCache<String, Record[]> cache;
    private final Hosts hosts = new Hosts();
    private final IpSorter sorter;
    private volatile NetworkInfo info = null;
    private volatile int index = 0;
    private static final String[] z;

    public DnsManager(NetworkInfo networkInfo, IResolver[] iResolverArray) {
        this(networkInfo, iResolverArray, null);
    }

    public DnsManager(NetworkInfo networkInfo, IResolver[] iResolverArray, IpSorter ipSorter) {
        this.info = networkInfo == null ? NetworkInfo.normal : networkInfo;
        this.resolvers = (IResolver[])iResolverArray.clone();
        this.cache = new LruCache();
        this.sorter = ipSorter == null ? new DummySorter() : ipSorter;
    }

    private static Record[] trimCname(Record[] recordArray) {
        ArrayList<Record> arrayList = new ArrayList<Record>(recordArray.length);
        for (Record record : recordArray) {
            if (record == null || record.type != 1) continue;
            arrayList.add(record);
        }
        return arrayList.toArray(new Record[arrayList.size()]);
    }

    private static void rotate(Record[] recordArray) {
        if (recordArray != null && recordArray.length > 1) {
            Record record = recordArray[0];
            System.arraycopy(recordArray, 1, recordArray, 0, recordArray.length - 1);
            recordArray[recordArray.length - 1] = record;
        }
    }

    private static String[] records2Ip(Record[] recordArray) {
        if (recordArray == null || recordArray.length == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(recordArray.length);
        for (Record record : recordArray) {
            arrayList.add(record.value);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean validIP(String string) {
        if (string == null || string.length() < 7 || string.length() > 15) {
            return false;
        }
        if (string.contains("-")) {
            return false;
        }
        try {
            int n2;
            int n3 = string.indexOf(46);
            if (n3 != -1 && Integer.parseInt(string.substring(0, n3)) > 255) {
                return false;
            }
            if ((n2 = string.indexOf(46, ++n3)) != -1 && Integer.parseInt(string.substring(n3, n2)) > 255) {
                return false;
            }
            return (n3 = string.indexOf(46, ++n2)) == -1 || Integer.parseInt(string.substring(n2, n3)) <= 255 || Integer.parseInt(string.substring(++n3, string.length() - 1)) <= 255 || string.charAt(string.length() - 1) == '.';
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean needHttpDns() {
        try {
            String string = TimeZone.getDefault().getID();
            return z[1].equals(string) || z[3].equals(string) || z[0].equals(string) || z[2].equals(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final String[] query(String string) throws IOException {
        return this.query(new Domain(string));
    }

    public final String[] query(Domain stringArray) throws IOException {
        if (stringArray == null) {
            throw new IOException(z[4]);
        }
        if (stringArray.domain == null || stringArray.domain.trim().length() == 0) {
            throw new IOException(z[5] + stringArray.domain);
        }
        if (DnsManager.validIP(stringArray.domain)) {
            return new String[]{stringArray.domain};
        }
        if ((stringArray = this.queryInternal((Domain)stringArray)) == null || stringArray.length <= 1) {
            return stringArray;
        }
        return this.sorter.sort(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String[] queryInternal(Domain domain) throws IOException {
        Object object;
        Record[] recordArray = null;
        if (domain.hostsFirst && (object = this.hosts.query(domain, this.info)) != null && ((String[])object).length != 0) {
            return object;
        }
        object = this.cache;
        // MONITORENTER : this.cache
        if (this.info.equals(NetworkInfo.normal) && Network.isNetworkChanged()) {
            this.cache.clear();
            IResolver[] iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            this.index = 0;
            // MONITOREXIT : iResolverArray
        } else {
            recordArray = (Record[])this.cache.get(domain.domain);
            if (recordArray != null && recordArray.length != 0) {
                if (!recordArray[0].isExpired()) {
                    if (recordArray.length > 1) {
                        DnsManager.rotate(recordArray);
                    }
                    // MONITOREXIT : object
                    return DnsManager.records2Ip(recordArray);
                }
                recordArray = null;
            }
        }
        // MONITOREXIT : object
        object = null;
        int n2 = this.index;
        for (int i2 = 0; i2 < this.resolvers.length; ++i2) {
            int n3 = (n2 + i2) % this.resolvers.length;
            NetworkInfo networkInfo = this.info;
            String string = Network.getIp();
            try {
                recordArray = this.resolvers[n3].resolve(domain, this.info);
            }
            catch (DomainNotOwn domainNotOwn) {
                continue;
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                object = iOException;
                Log.i((String)z[8], (String)z[6], (Throwable)iOException2);
            }
            catch (Exception exception) {
                if (Build.VERSION.SDK_INT >= 9) {
                    object = new IOException(exception);
                }
                exception.printStackTrace();
            }
            IResolver[] iResolverArray = Network.getIp();
            if (this.info != networkInfo || recordArray != null && recordArray.length != 0 || !string.equals(iResolverArray)) break;
            iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            if (this.index == n2) {
                ++this.index;
                if (this.index == this.resolvers.length) {
                    this.index = 0;
                }
            }
            // MONITOREXIT : iResolverArray
        }
        if (recordArray == null || recordArray.length == 0) {
            String[] stringArray;
            if (!domain.hostsFirst && (stringArray = this.hosts.query(domain, this.info)) != null && stringArray.length != 0) {
                return stringArray;
            }
            if (object == null) throw new UnknownHostException(domain.domain);
            throw object;
        }
        if ((recordArray = DnsManager.trimCname(recordArray)).length == 0) {
            throw new UnknownHostException(z[7]);
        }
        LruCache<String, Record[]> lruCache = this.cache;
        // MONITORENTER : lruCache
        this.cache.put(domain.domain, recordArray);
        // MONITOREXIT : lruCache
        return DnsManager.records2Ip(recordArray);
    }

    public final InetAddress[] queryInetAdress(Domain stringArray) throws IOException {
        stringArray = this.query((Domain)stringArray);
        InetAddress[] inetAddressArray = new InetAddress[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            inetAddressArray[i2] = InetAddress.getByName(stringArray[i2]);
        }
        return inetAddressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNetworkChange(NetworkInfo iResolverArray) {
        this.clearCache();
        this.info = iResolverArray == null ? NetworkInfo.normal : iResolverArray;
        iResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            this.index = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        LruCache<String, Record[]> lruCache = this.cache;
        synchronized (lruCache) {
            this.cache.clear();
            return;
        }
    }

    public final DnsManager putHosts(String string, String string2, int n2) {
        this.hosts.put(string, new Hosts.Value(string2, n2));
        return this;
    }

    public final DnsManager putHosts(String string, String string2) {
        this.hosts.put(string, string2);
        return this;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "6R4\n;?@/\t}\u0019";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 119;
                                break;
                            }
                            case 1: {
                                n9 = 33;
                                break;
                            }
                            case 2: {
                                n9 = 93;
                                break;
                            }
                            case 3: {
                                n9 = 107;
                                break;
                            }
                            default: {
                                n9 = 20;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "6R4\n;$I<\u0005s\u001f@4";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "6R4\n;\"S(\u0006e\u001e";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "6R4\n;4I2\u0005s\u0006H3\f";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0019T1\u00074\u0013N0\n}\u0019";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0012L-\u001fmWE2\u0006u\u001eO}";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u0014@3\u001f4\u0010D)Kx\u0018B<\u00074\u0013O.Kg\u0012S+\u000efY";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0019N}*4\u0005D>\u0004f\u0013R";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "3O.&u\u0019@:\u000ef";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    private static class DummySorter
    implements IpSorter {
        private AtomicInteger pos = new AtomicInteger();

        private DummySorter() {
        }

        @Override
        public String[] sort(String[] stringArray) {
            return stringArray;
        }
    }
}

