/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.http;

import cn.jmessage.support.okhttp3.Call;
import cn.jmessage.support.okhttp3.Callback;
import cn.jmessage.support.okhttp3.HttpUrl;
import cn.jmessage.support.okhttp3.Interceptor;
import cn.jmessage.support.okhttp3.MediaType;
import cn.jmessage.support.okhttp3.MultipartBody;
import cn.jmessage.support.okhttp3.OkHttpClient;
import cn.jmessage.support.okhttp3.Request;
import cn.jmessage.support.okhttp3.RequestBody;
import cn.jmessage.support.okhttp3.Response;
import cn.jmessage.support.qiniu.android.http.CancellationHandler;
import cn.jmessage.support.qiniu.android.http.CompletionHandler;
import cn.jmessage.support.qiniu.android.http.CountingRequestBody;
import cn.jmessage.support.qiniu.android.http.Dns;
import cn.jmessage.support.qiniu.android.http.PostArgs;
import cn.jmessage.support.qiniu.android.http.ProgressHandler;
import cn.jmessage.support.qiniu.android.http.ProxyConfiguration;
import cn.jmessage.support.qiniu.android.http.ResponseInfo;
import cn.jmessage.support.qiniu.android.http.UrlConverter;
import cn.jmessage.support.qiniu.android.http.UserAgent;
import cn.jmessage.support.qiniu.android.storage.UpCancellationSignal;
import cn.jmessage.support.qiniu.android.storage.UpToken;
import cn.jmessage.support.qiniu.android.utils.AsyncRun;
import cn.jmessage.support.qiniu.android.utils.StringMap;
import cn.jmessage.support.qiniu.android.utils.StringUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public final class Client {
    public static final String ContentTypeHeader;
    public static final String DefaultMime;
    public static final String JsonMime;
    public static final String FormMime;
    private final UrlConverter converter;
    private OkHttpClient httpClient;
    private static final String[] z;

    public Client() {
        this(null, 10, 30, null, null);
    }

    public Client(ProxyConfiguration proxyConfiguration, int n2, int n3, UrlConverter object, final Dns dns) {
        this.converter = object;
        object = new OkHttpClient.Builder();
        if (proxyConfiguration != null) {
            ((OkHttpClient.Builder)object).proxy(proxyConfiguration.proxy());
            if (proxyConfiguration.user != null && proxyConfiguration.password != null) {
                ((OkHttpClient.Builder)object).proxyAuthenticator(proxyConfiguration.authenticator());
            }
        }
        if (dns != null) {
            ((OkHttpClient.Builder)object).dns(new cn.jmessage.support.okhttp3.Dns(){

                @Override
                public List<InetAddress> lookup(String string) throws UnknownHostException {
                    try {
                        return dns.lookup(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return cn.jmessage.support.okhttp3.Dns.SYSTEM.lookup(string);
                    }
                }
            });
        }
        ((OkHttpClient.Builder)object).networkInterceptors().add(new Interceptor(){

            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Object object = chain.request();
                long l2 = System.currentTimeMillis();
                Response response = chain.proceed((Request)object);
                long l3 = System.currentTimeMillis();
                object = (ResponseTag)((Request)object).tag();
                String string = "";
                try {
                    string = chain.connection().socket().getRemoteSocketAddress().toString();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((ResponseTag)object).ip = string;
                ((ResponseTag)object).duration = l3 - l2;
                return response;
            }
        });
        ((OkHttpClient.Builder)object).connectTimeout(n2, TimeUnit.SECONDS);
        ((OkHttpClient.Builder)object).readTimeout(n3, TimeUnit.SECONDS);
        ((OkHttpClient.Builder)object).writeTimeout(0L, TimeUnit.SECONDS);
        this.httpClient = ((OkHttpClient.Builder)object).build();
    }

    private static String via(Response response) {
        String string = response.header(z[2], "");
        if (!string.equals("")) {
            return string;
        }
        string = response.header(z[0], "");
        if (!string.equals("")) {
            return string;
        }
        string = response.header(z[1], "");
        if (!string.equals("")) {
            return string;
        }
        return string;
    }

    private static String ctype(Response object) {
        if ((object = ((Response)object).body().contentType()) == null) {
            return "";
        }
        return ((MediaType)object).type() + "/" + ((MediaType)object).subtype();
    }

    private static JSONObject buildJsonResp(byte[] object) throws Exception {
        String string = new String((byte[])object, z[9]);
        object = string;
        if (StringUtils.isNullOrEmpty(string)) {
            return new JSONObject();
        }
        return new JSONObject((String)object);
    }

    private static ResponseInfo buildResponseInfo(Response response, String string, long l2, UpToken upToken, long l3) {
        JSONObject jSONObject;
        String string2;
        Object object;
        String string3;
        int n2;
        block7: {
            n2 = response.code();
            string3 = response.header(z[8]);
            string3 = string3 == null ? null : string3.trim().split(",")[0];
            object = null;
            string2 = null;
            try {
                object = response.body().bytes();
            }
            catch (IOException iOException) {
                string2 = iOException.getMessage();
            }
            jSONObject = null;
            if (Client.ctype(response).equals(JsonMime) && object != null) {
                try {
                    jSONObject = Client.buildJsonResp((byte[])object);
                    if (response.code() != 200) {
                        object = new String((byte[])object, z[9]);
                        string2 = jSONObject.optString(z[7], (String)object);
                    }
                    break block7;
                }
                catch (Exception exception) {
                    if (response.code() < 300) {
                        string2 = exception.getMessage();
                    }
                    break block7;
                }
            }
            string2 = object == null ? z[10] : new String((byte[])object);
        }
        object = response.request().url();
        return ResponseInfo.create(jSONObject, n2, string3, response.header(z[6]), Client.via(response), ((HttpUrl)object).host(), ((HttpUrl)object).encodedPath(), string, ((HttpUrl)object).port(), l2, Client.getContentLength(response), string2, upToken, l3);
    }

    private static long getContentLength(Response object) {
        try {
            object = ((Response)object).request().body();
            if (object == null) {
                return 0L;
            }
            return ((RequestBody)object).contentLength();
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    private static void onRet(Response object, String string, long l2, UpToken upToken, long l3, final CompletionHandler completionHandler) {
        object = Client.buildResponseInfo((Response)object, string, l2, upToken, l3);
        AsyncRun.runInMain(new Runnable((ResponseInfo)object){
            final /* synthetic */ ResponseInfo val$info;
            {
                this.val$info = responseInfo;
            }

            @Override
            public final void run() {
                completionHandler.complete(this.val$info, this.val$info.response);
            }
        });
    }

    public final void asyncSend(final Request.Builder builder, StringMap object, UpToken upToken, long l2, CompletionHandler completionHandler) {
        if (object != null) {
            ((StringMap)object).forEach(new StringMap.Consumer(){

                @Override
                public void accept(String string, Object object) {
                    builder.header(string, object.toString());
                }
            });
        }
        if (upToken != null) {
            builder.header(z[4], UserAgent.instance().getUa(upToken.accessKey));
        } else {
            builder.header(z[4], UserAgent.instance().getUa(z[3]));
        }
        object = new ResponseTag();
        this.httpClient.newCall(builder.tag(object).build()).enqueue(new Callback((ResponseTag)object, upToken, l2, completionHandler){
            final /* synthetic */ ResponseTag val$tag;
            final /* synthetic */ UpToken val$upToken;
            final /* synthetic */ long val$totalSize;
            final /* synthetic */ CompletionHandler val$complete;
            private static final String z;
            {
                this.val$tag = responseTag;
                this.val$upToken = upToken;
                this.val$totalSize = l2;
                this.val$complete = completionHandler;
            }

            @Override
            public void onFailure(Call object, IOException iOException) {
                iOException.printStackTrace();
                int n2 = -1;
                String string = iOException.getMessage();
                if (iOException instanceof CancellationHandler.CancellationException) {
                    n2 = -2;
                } else if (iOException instanceof UnknownHostException) {
                    n2 = -1003;
                } else if (string != null && string.indexOf(z) == 0) {
                    n2 = -1005;
                } else if (iOException instanceof SocketTimeoutException) {
                    n2 = -1001;
                } else if (iOException instanceof ConnectException) {
                    n2 = -1004;
                }
                object = object.request().url();
                object = ResponseInfo.create(null, n2, "", "", "", ((HttpUrl)object).host(), ((HttpUrl)object).encodedPath(), "", ((HttpUrl)object).port(), this.val$tag.duration, -1L, iOException.getMessage(), this.val$upToken, this.val$totalSize);
                this.val$complete.complete((ResponseInfo)object, null);
            }

            @Override
            public void onResponse(Call object, Response response) throws IOException {
                object = (ResponseTag)response.request().tag();
                Client.onRet(response, ((ResponseTag)object).ip, ((ResponseTag)object).duration, this.val$upToken, this.val$totalSize, this.val$complete);
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block10: {
                    int n2;
                    int n3;
                    char[] cArray2;
                    int n4;
                    block9: {
                        char[] cArray3 = "Qw+\\o}%4^zv".toCharArray();
                        n4 = 0;
                        int n5 = cArray3.length;
                        cArray2 = cArray3;
                        n3 = n5;
                        if (n5 <= 1) break block9;
                        cArray = cArray2;
                        n2 = n3;
                        if (n3 <= n4) break block10;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n6 = n4;
                        while (true) {
                            int n7;
                            char c2 = cArray4[n6];
                            switch (n4 % 5) {
                                case 0: {
                                    n7 = 19;
                                    break;
                                }
                                case 1: {
                                    n7 = 5;
                                    break;
                                }
                                case 2: {
                                    n7 = 68;
                                    break;
                                }
                                case 3: {
                                    n7 = 55;
                                    break;
                                }
                                default: {
                                    n7 = 10;
                                }
                            }
                            cArray4[n6] = (char)(c2 ^ n7);
                            ++n4;
                            cArray2 = cArray5;
                            n3 = n3;
                            if (n3 != 0) break;
                            cArray5 = cArray2;
                            n2 = n3;
                            n6 = n3;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n2 = n3;
                    } while (n3 > n4);
                }
                z = new String(cArray).intern();
            }
        });
    }

    public final void asyncPost(String string, byte[] byArray, StringMap stringMap, UpToken upToken, long l2, ProgressHandler progressHandler, CompletionHandler completionHandler, UpCancellationSignal upCancellationSignal) {
        this.asyncPost(string, byArray, 0, byArray.length, stringMap, upToken, l2, progressHandler, completionHandler, upCancellationSignal);
    }

    public final void asyncPost(String string, byte[] object, int n2, int n3, StringMap stringMap, UpToken upToken, long l2, ProgressHandler progressHandler, CompletionHandler completionHandler, CancellationHandler cancellationHandler) {
        Object object2;
        if (this.converter != null) {
            string = this.converter.convert(string);
        }
        if (object != null && ((byte[])object).length > 0) {
            Object object3;
            object2 = MediaType.parse(DefaultMime);
            if (stringMap != null && (object3 = stringMap.get(ContentTypeHeader)) != null) {
                object2 = MediaType.parse(object3.toString());
            }
            object = RequestBody.create((MediaType)object2, object, n2, n3);
        } else {
            object = RequestBody.create(null, new byte[0]);
        }
        if (progressHandler != null || cancellationHandler != null) {
            object = new CountingRequestBody((RequestBody)object, progressHandler, l2, cancellationHandler);
        }
        object2 = new Request.Builder().url(string).post((RequestBody)object);
        this.asyncSend((Request.Builder)object2, stringMap, upToken, l2, completionHandler);
    }

    public final void asyncMultipartPost(String string, PostArgs postArgs, UpToken upToken, ProgressHandler progressHandler, CompletionHandler completionHandler, CancellationHandler cancellationHandler) {
        long l2;
        RequestBody requestBody;
        if (postArgs.file != null) {
            requestBody = RequestBody.create(MediaType.parse(postArgs.mimeType), postArgs.file);
            l2 = postArgs.file.length();
        } else {
            requestBody = RequestBody.create(MediaType.parse(postArgs.mimeType), postArgs.data);
            l2 = postArgs.data.length;
        }
        this.asyncMultipartPost(string, postArgs.params, upToken, l2, progressHandler, postArgs.fileName, requestBody, completionHandler, cancellationHandler);
    }

    private void asyncMultipartPost(String object, StringMap object2, UpToken upToken, long l2, ProgressHandler progressHandler, String string, RequestBody requestBody, CompletionHandler completionHandler, CancellationHandler cancellationHandler) {
        if (this.converter != null) {
            object = this.converter.convert((String)object);
        }
        final MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.addFormDataPart(z[11], string, requestBody);
        ((StringMap)object2).forEach(new StringMap.Consumer(){

            @Override
            public void accept(String string, Object object) {
                builder.addFormDataPart(string, object.toString());
            }
        });
        builder.setType(MediaType.parse(z[12]));
        object2 = builder.build();
        if (progressHandler != null || cancellationHandler != null) {
            object2 = new CountingRequestBody((RequestBody)object2, progressHandler, l2, cancellationHandler);
        }
        object = new Request.Builder().url((String)object).post((RequestBody)object2);
        this.asyncSend((Request.Builder)object, null, upToken, l2, completionHandler);
    }

    public final void asyncGet(String object, StringMap stringMap, UpToken upToken, CompletionHandler completionHandler) {
        object = new Request.Builder().get().url((String)object);
        this.asyncSend((Request.Builder)object, stringMap, upToken, 0L, completionHandler);
    }

    public final ResponseInfo syncGet(String object, StringMap stringMap) {
        object = new Request.Builder().get().url((String)object);
        return this.send((Request.Builder)object, stringMap);
    }

    private ResponseInfo send(Request.Builder object, StringMap object2) {
        if (object2 != null) {
            ((StringMap)object2).forEach(new StringMap.Consumer((Request.Builder)object){
                final /* synthetic */ Request.Builder val$requestBuilder;
                {
                    this.val$requestBuilder = builder;
                }

                @Override
                public void accept(String string, Object object) {
                    this.val$requestBuilder.header(string, object.toString());
                }
            });
        }
        ((Request.Builder)object).header(z[4], UserAgent.instance().getUa(""));
        System.currentTimeMillis();
        object2 = new ResponseTag();
        Request request = ((Request.Builder)object).tag(object2).build();
        try {
            object = this.httpClient.newCall(request).execute();
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return ResponseInfo.create(null, -1, "", "", "", request.url().host(), request.url().encodedPath(), ((ResponseTag)object2).ip, request.url().port(), ((ResponseTag)object2).duration, -1L, ((Throwable)object).getMessage(), UpToken.NULL, 0L);
        }
        return Client.buildResponseInfo((Response)object, ((ResponseTag)object2).ip, ((ResponseTag)object2).duration, UpToken.NULL, 0L);
    }

    public final ResponseInfo syncMultipartPost(String string, PostArgs postArgs, UpToken upToken) {
        long l2;
        RequestBody requestBody;
        if (postArgs.file != null) {
            requestBody = RequestBody.create(MediaType.parse(postArgs.mimeType), postArgs.file);
            l2 = postArgs.file.length();
        } else {
            requestBody = RequestBody.create(MediaType.parse(postArgs.mimeType), postArgs.data);
            l2 = postArgs.data.length;
        }
        return this.syncMultipartPost(string, postArgs.params, upToken, l2, postArgs.fileName, requestBody);
    }

    private ResponseInfo syncMultipartPost(String object, StringMap object2, UpToken upToken, long l2, String string, RequestBody requestBody) {
        final MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.addFormDataPart(z[11], string, requestBody);
        ((StringMap)object2).forEach(new StringMap.Consumer(){

            @Override
            public void accept(String string, Object object) {
                builder.addFormDataPart(string, object.toString());
            }
        });
        builder.setType(MediaType.parse(z[12]));
        object2 = builder.build();
        object = new Request.Builder().url((String)object).post((RequestBody)object2);
        return this.syncSend((Request.Builder)object, null, upToken, l2);
    }

    public final ResponseInfo syncSend(Request.Builder object, StringMap object2, UpToken upToken, long l2) {
        if (object2 != null) {
            ((StringMap)object2).forEach(new StringMap.Consumer((Request.Builder)object){
                final /* synthetic */ Request.Builder val$requestBuilder;
                {
                    this.val$requestBuilder = builder;
                }

                @Override
                public void accept(String string, Object object) {
                    this.val$requestBuilder.header(string, object.toString());
                }
            });
        }
        ((Request.Builder)object).header(z[4], UserAgent.instance().getUa(upToken.accessKey));
        object2 = new ResponseTag();
        Object object3 = null;
        try {
            object3 = ((Request.Builder)object).tag(object2).build();
            return Client.buildResponseInfo(this.httpClient.newCall((Request)object3).execute(), ((ResponseTag)object2).ip, ((ResponseTag)object2).duration, upToken, l2);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            int n2 = -1;
            String string = ((Throwable)object).getMessage();
            if (object instanceof UnknownHostException) {
                n2 = -1003;
            } else if (string != null && string.indexOf(z[5]) == 0) {
                n2 = -1005;
            } else if (object instanceof SocketTimeoutException) {
                n2 = -1001;
            } else if (object instanceof ConnectException) {
                n2 = -1004;
            }
            object3 = ((Request)object3).url();
            return ResponseInfo.create(null, n2, "", "", "", ((HttpUrl)object3).host(), ((HttpUrl)object3).encodedPath(), "", ((HttpUrl)object3).port(), 0L, 0L, ((Throwable)object).getMessage(), upToken, l2);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\n\u001c#\u00060\b\r'\u00036\u0005C9\u00196\u0005";
        int n3 = 12;
        block24: while (true) {
            char[] cArray;
            block29: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block28: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block28;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block29;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 107;
                                break;
                            }
                            case 1: {
                                n9 = 108;
                                break;
                            }
                            case 2: {
                                n9 = 83;
                                break;
                            }
                            case 3: {
                                n9 = 106;
                                break;
                            }
                            default: {
                                n9 = 89;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 12: {
                    JsonMime = string.intern();
                    string2 = "(\u0003=\u001e<\u0005\u0018~> \u001b\t";
                    n3 = 13;
                    continue block24;
                }
                case 13: {
                    ContentTypeHeader = string.intern();
                    string2 = "\n\u001c#\u00060\b\r'\u00036\u0005C+G.\u001c\u001b~\f6\u0019\u0001~\u001f+\u0007\t=\t6\u000f\t7";
                    n3 = 14;
                    continue block24;
                }
                case 14: {
                    FormMime = string.intern();
                    string2 = "\n\u001c#\u00060\b\r'\u00036\u0005C<\t-\u000e\u0018~\u0019-\u0019\t2\u0007";
                    n3 = 15;
                    continue block24;
                }
                case 15: {
                    DefaultMime = string.intern();
                    string2 = "3A\u0003\u0012";
                    n3 = -1;
                    continue block24;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "-\u001b~<0\n";
                    n3 = 0;
                    continue block24;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "3A\u0005\u00038";
                    n3 = 1;
                    continue block24;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001b\r=\u000e6\u0019\r";
                    n3 = 2;
                    continue block24;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = ">\u001f6\u0018t*\u000b6\u0004-";
                    n3 = 3;
                    continue block24;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ")\u001e<\u0001<\u0005L#\u0003)\u000e";
                    n3 = 4;
                    continue block24;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "3A\u001f\u0005>";
                    n3 = 5;
                    continue block24;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u000e\u001e!\u0005+";
                    n3 = 6;
                    continue block24;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "3A\u0001\u000f(\u0002\b";
                    n3 = 7;
                    continue block24;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u001e\u00185Ga";
                    n3 = 8;
                    continue block24;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0005\u0019?\u0006y\t\u00037\u0013";
                    n3 = 9;
                    continue block24;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\r\u0005?\u000f";
                    n3 = 10;
                    continue block24;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u0006\u0019?\u001e0\u001b\r!\u001ev\r\u0003!\u0007t\u000f\r'\u000b";
                    n3 = 11;
                    continue block24;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    private static class ResponseTag {
        public String ip = "";
        public long duration = -1L;

        private ResponseTag() {
        }
    }
}

