/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.http;

import cn.jmessage.support.qiniu.android.collect.Config;
import cn.jmessage.support.qiniu.android.collect.UploadInfoCollector;
import cn.jmessage.support.qiniu.android.http.UserAgent;
import cn.jmessage.support.qiniu.android.storage.UpToken;
import cn.jmessage.support.qiniu.android.utils.StringUtils;
import java.util.Locale;
import org.json.JSONObject;

public final class ResponseInfo {
    public static final int ZeroSizeFile = -6;
    public static final int InvalidToken = -5;
    public static final int InvalidArgument = -4;
    public static final int InvalidFile = -3;
    public static final int Cancelled = -2;
    public static final int NetworkError = -1;
    public static final int UnknownError = 0;
    public static final int TimedOut = -1001;
    public static final int UnknownHost = -1003;
    public static final int CannotConnectToHost = -1004;
    public static final int NetworkConnectionLost = -1005;
    public final int statusCode;
    public final String reqId;
    public final String xlog;
    public final String xvia;
    public final String error;
    public final long duration;
    public final String host;
    public final String ip;
    public final int port;
    public final String path;
    public final String id;
    public final long timeStamp;
    public final long sent;
    public final UpToken upToken;
    public final long totalSize;
    public final JSONObject response;
    private static final String[] z;

    private ResponseInfo(JSONObject jSONObject, int n2, String string, String string2, String string3, String string4, String string5, String string6, int n3, long l2, long l3, String string7, UpToken upToken, long l4) {
        this.response = jSONObject;
        this.statusCode = n2;
        this.reqId = string;
        this.xlog = string2;
        this.xvia = string3;
        this.host = string4;
        this.path = string5;
        this.duration = l2;
        this.error = string7;
        this.ip = string6;
        this.port = n3;
        this.id = UserAgent.instance().id;
        this.timeStamp = System.currentTimeMillis() / 1000L;
        this.sent = l3;
        this.upToken = upToken;
        this.totalSize = l4;
    }

    public static ResponseInfo create(JSONObject object, final int n2, final String string, final String string2, String string3, final String string4, final String string5, final String string6, final int n3, final long l2, final long l3, String string7, UpToken upToken, final long l4) {
        string6 = string6.split(":")[0];
        string6 = string6.substring(Math.max(0, string6.indexOf("/") + 1));
        object = new ResponseInfo((JSONObject)object, n2, string, string2, string3, string4, string5, string6, n3, l2, l3, string7, upToken, l4);
        if (Config.isRecord || upToken != null) {
            string2 = "" + object.timeStamp;
            UploadInfoCollector.handleHttp(upToken, new UploadInfoCollector.RecordMsg(){

                @Override
                public final String toRecordMsg() {
                    return StringUtils.join(new String[]{"" + n2, string, string4, string6, "" + n3, "" + l2, string2, "" + l3, ResponseInfo.getUpType(string5), "" + l4}, ",");
                }
            });
        }
        return object;
    }

    private static String getUpType(String string) {
        if (string == null || !string.startsWith("/")) {
            return "";
        }
        if ("/".equals(string)) {
            return z[4];
        }
        int n2 = string.indexOf(47, 1);
        if (n2 <= 0) {
            return "";
        }
        return string.substring(1, n2);
    }

    public static ResponseInfo zeroSize(UpToken upToken) {
        return ResponseInfo.create(null, -6, "", "", "", "", "", "", 80, 0L, 0L, z[5], upToken, 0L);
    }

    public static ResponseInfo cancelled(UpToken upToken) {
        return ResponseInfo.create(null, -2, "", "", "", "", "", "", 80, -1L, -1L, z[0], upToken, 0L);
    }

    public static ResponseInfo invalidArgument(String string, UpToken upToken) {
        return ResponseInfo.create(null, -4, "", "", "", "", "", "", 80, 0L, 0L, string, upToken, 0L);
    }

    public static ResponseInfo invalidToken(String string) {
        return ResponseInfo.create(null, -5, "", "", "", "", "", "", 80, 0L, 0L, string, null, 0L);
    }

    public static ResponseInfo fileError(Exception exception, UpToken upToken) {
        return ResponseInfo.create(null, -3, "", "", "", "", "", "", 80, 0L, 0L, exception.getMessage(), upToken, 0L);
    }

    public static ResponseInfo networkError(int n2, UpToken upToken) {
        return ResponseInfo.create(null, n2, "", "", "", "", "", "", 80, 0L, 0L, z[1], upToken, 0L);
    }

    public static boolean isStatusCodeForBrokenNetwork(int n2) {
        return n2 == -1 || n2 == -1003 || n2 == -1004 || n2 == -1001 || n2 == -1005;
    }

    public final boolean isCancelled() {
        return this.statusCode == -2;
    }

    public final boolean isOK() {
        return this.statusCode == 200 && this.error == null && (this.hasReqId() || this.response != null);
    }

    public final boolean isNetworkBroken() {
        return this.statusCode == -1 || this.statusCode == -1003 || this.statusCode == -1004 || this.statusCode == -1001 || this.statusCode == -1005;
    }

    public final boolean isServerError() {
        return this.statusCode >= 500 && this.statusCode < 600 && this.statusCode != 579 || this.statusCode == 996;
    }

    public final boolean needSwitchServer() {
        return this.isNetworkBroken() || this.isServerError();
    }

    public final boolean needRetry() {
        return !this.isCancelled() && (this.needSwitchServer() || this.statusCode == 406 || this.statusCode == 200 && this.error != null || this.isNotQiniu() && !this.upToken.hasReturnUrl());
    }

    public final boolean isNotQiniu() {
        return this.statusCode < 500 && this.statusCode >= 200 && !this.hasReqId() && this.response == null;
    }

    public final String toString() {
        return String.format(Locale.ENGLISH, z[2], z[3], this.id, this.statusCode, this.reqId, this.xlog, this.xvia, this.host, this.path, this.ip, this.port, this.duration, this.timeStamp, this.sent, this.error);
    }

    public final boolean hasReqId() {
        return this.reqId != null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "d\u001di\u001bGk\u0010b\u001c\u0002e\u0005'\rQb\u000e";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 7;
                                break;
                            }
                            case 1: {
                                n9 = 124;
                                break;
                            }
                            case 2: {
                                n9 = 7;
                                break;
                            }
                            case 3: {
                                n9 = 120;
                                break;
                            }
                            default: {
                                n9 = 34;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "I\u0019s\u000fMu\u0017'\u001dPu\u0013uXFr\u000en\u0016E'\fu\u001dsr\u0019u\u0001";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "|\nb\n\u0018\"\u000f+*Gt\fh\u0016Qb5i\u001eM=YtTQs\u001ds\rQ=YcT\u0002u\u0019v1F=YtT\u0002\u007f\u0010h\u001f\u0018\"\u000f+XZq\u0015fB\u0007tP'\u0010Mt\b=]Q+\\w\u0019VoF\"\u000b\u000e'\u0015wB\u0007tP'\bMu\b=]F+\\c\rPf\bn\u0017L=YcXQ+\\s\u0011ObF\"\u001c\u000e'\u000fb\u0016V=YcTGu\u000eh\n\u0018\"\u000fz";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "0R4V\u00135";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "a\u0013u\u0015";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "a\u0015k\u001d\u0002h\u000e'\u001cCs\u001d'\u000bK}\u0019'\u0011Q'\u0006b\nM";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

