/*
 * Decompiled with CFR 0.152.
 */
package cn.jmessage.support.qiniu.android.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public final class FastDatePrinter {
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static final int MAX_DIGITS = 10;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final String[] z;

    public FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        this.mPattern = string;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private static void appendDigits(Appendable appendable, int n2) throws IOException {
        appendable.append((char)(n2 / 10 + 48));
        appendable.append((char)(n2 % 10 + 48));
    }

    private static void appendFullDigits(Appendable appendable, int n2, int n3) throws IOException {
        if (n2 < 10000) {
            int n4 = 4;
            if (n2 < 1000) {
                --n4;
                if (n2 < 100) {
                    --n4;
                    if (n2 < 10) {
                        --n4;
                    }
                }
            }
            for (int i2 = n3 - n4; i2 > 0; --i2) {
                appendable.append('0');
            }
            switch (n4) {
                case 4: {
                    appendable.append((char)(n2 / 1000 + 48));
                    n2 %= 1000;
                }
                case 3: {
                    if (n2 >= 100) {
                        appendable.append((char)(n2 / 100 + 48));
                        n2 %= 100;
                    } else {
                        appendable.append('0');
                    }
                }
                case 2: {
                    if (n2 >= 10) {
                        appendable.append((char)(n2 / 10 + 48));
                        n2 %= 10;
                    } else {
                        appendable.append('0');
                    }
                }
                case 1: {
                    appendable.append((char)(n2 + 48));
                }
            }
            return;
        }
        char[] cArray = new char[10];
        int n5 = 0;
        while (n2 != 0) {
            cArray[n5++] = (char)(n2 % 10 + 48);
            n2 /= 10;
        }
        while (n5 < n3) {
            appendable.append('0');
            --n3;
        }
        while (--n5 >= 0) {
            appendable.append(cArray[n5]);
        }
    }

    private void init() {
        List<Rule> list = this.parsePattern();
        this.mRules = list.toArray(new Rule[list.size()]);
        int n2 = 0;
        int n3 = this.mRules.length;
        while (--n3 >= 0) {
            n2 += this.mRules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    protected final List<Rule> parsePattern() {
        String[] stringArray = new DateFormatSymbols(this.mLocale);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        String[] stringArray2 = stringArray.getEras();
        String[] stringArray3 = stringArray.getMonths();
        String[] stringArray4 = stringArray.getShortMonths();
        String[] stringArray5 = stringArray.getWeekdays();
        String[] stringArray6 = stringArray.getShortWeekdays();
        stringArray = stringArray.getAmPmStrings();
        int n2 = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[0] = i2;
            Object object = this.parseToken(this.mPattern, nArray);
            i2 = nArray[0];
            int n3 = ((String)object).length();
            if (n3 == 0) break;
            switch (((String)object).charAt(0)) {
                case 'G': {
                    object = new TextField(0, stringArray2);
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (n3 == 2) {
                        object = TwoDigitYearField.INSTANCE;
                        break;
                    }
                    object = this.selectNumberRule(1, n3 < 4 ? 4 : n3);
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        object = new TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 3) {
                        object = new TextField(2, stringArray4);
                        break;
                    }
                    if (n3 == 2) {
                        object = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    object = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    object = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    object = new TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    object = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    object = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    object = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    object = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    object = new TextField(7, n3 < 4 ? stringArray6 : stringArray5);
                    break;
                }
                case 'u': {
                    object = new DayInWeekField(this.selectNumberRule(7, n3));
                    break;
                }
                case 'D': {
                    object = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    object = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    object = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    object = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    object = new TextField(9, stringArray);
                    break;
                }
                case 'k': {
                    object = new TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    object = this.selectNumberRule(10, n3);
                    break;
                }
                case 'X': {
                    object = Iso8601_Rule.getRule(n3);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        object = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n3 == 2) {
                        object = Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    object = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    object = ((String)object).substring(1);
                    if (((String)object).length() == 1) {
                        object = new CharacterLiteral(((String)object).charAt(0));
                        break;
                    }
                    object = new StringLiteral((String)object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(z[3] + (String)object);
                }
            }
            arrayList.add((Rule)object);
        }
        return arrayList;
    }

    protected final String parseToken(String string, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string.length();
        char c2 = string.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && string.charAt(n2 + 1) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    protected final NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new UnpaddedNumberField(n2);
            }
            case 2: {
                return new TwoDigitNumberField(n2);
            }
        }
        return new PaddedNumberField(n2, n3);
    }

    @Deprecated
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((long)((Long)object), stringBuffer);
        }
        throw new IllegalArgumentException(z[1] + (object == null ? z[2] : object.getClass().getName()));
    }

    final String format(Object object) {
        if (object instanceof Date) {
            return this.format((Date)object);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object);
        }
        if (object instanceof Long) {
            return this.format((Long)object);
        }
        throw new IllegalArgumentException(z[1] + (object == null ? z[2] : object.getClass().getName()));
    }

    public final String format(long l2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRulesToString(calendar);
    }

    private String applyRulesToString(Calendar calendar) {
        return this.applyRules(calendar, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    private Calendar newCalendar() {
        return Calendar.getInstance(this.mTimeZone, this.mLocale);
    }

    public final String format(Date date) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRulesToString(calendar);
    }

    public final String format(Calendar calendar) {
        return this.format(calendar, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    public final StringBuffer format(long l2, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    public final StringBuffer format(Date date, StringBuffer stringBuffer) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    public final StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.format(calendar.getTime(), stringBuffer);
    }

    public final <B extends Appendable> B format(long l2, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(l2);
        return this.applyRules(calendar, b2);
    }

    public final <B extends Appendable> B format(Date date, B b2) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, b2);
    }

    public final <B extends Appendable> B format(Calendar calendar, B b2) {
        if (!calendar.getTimeZone().equals(this.mTimeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return this.applyRules(calendar, b2);
    }

    @Deprecated
    protected final StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, (Appendable)stringBuffer);
    }

    private <B extends Appendable> B applyRules(Calendar calendar, B b2) {
        try {
            Rule[] ruleArray = this.mRules;
            int n2 = this.mRules.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ruleArray[i2].appendTo(b2, calendar);
            }
        }
        catch (IOException iOException) {}
        return b2;
    }

    public final String getPattern() {
        return this.mPattern;
    }

    public final TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public final Locale getLocale() {
        return this.mLocale;
    }

    public final int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof FastDatePrinter)) {
            return false;
        }
        object = (FastDatePrinter)object;
        return this.mPattern.equals(((FastDatePrinter)object).mPattern) && this.mTimeZone.equals(((FastDatePrinter)object).mTimeZone) && this.mLocale.equals(((FastDatePrinter)object).mLocale);
    }

    public final int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public final String toString() {
        return z[0] + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "&\u0015 my\u0001\u00006IO\t\u001a'|O;";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 96;
                                break;
                            }
                            case 1: {
                                n9 = 116;
                                break;
                            }
                            case 2: {
                                n9 = 83;
                                break;
                            }
                            case 3: {
                                n9 = 25;
                                break;
                            }
                            default: {
                                n9 = 61;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "5\u001a8wR\u0017\u001aszQ\u0001\u0007 #\u001d";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\\\u001a&uQ^";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ")\u0018?|Z\u0001\u0018si\\\u0014\u00006kS@\u0017<tM\u000f\u001a6wIZT";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    private static class Iso8601_Rule
    implements Rule {
        static final Iso8601_Rule ISO8601_HOURS;
        static final Iso8601_Rule ISO8601_HOURS_MINUTES;
        static final Iso8601_Rule ISO8601_HOURS_COLON_MINUTES;
        final int length;
        private static final String z;

        Iso8601_Rule(int n2) {
            this.length = n2;
        }

        static Iso8601_Rule getRule(int n2) {
            switch (n2) {
                case 1: {
                    return ISO8601_HOURS;
                }
                case 2: {
                    return ISO8601_HOURS_MINUTES;
                }
                case 3: {
                    return ISO8601_HOURS_COLON_MINUTES;
                }
            }
            throw new IllegalArgumentException(z);
        }

        @Override
        public int estimateLength() {
            return this.length;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 == 0) {
                appendable.append("Z");
                return;
            }
            if (n2 < 0) {
                appendable.append('-');
                n2 = -n2;
            } else {
                appendable.append('+');
            }
            int n3 = n2 / 3600000;
            FastDatePrinter.appendDigits(appendable, n3);
            if (this.length < 5) {
                return;
            }
            if (this.length == 6) {
                appendable.append(':');
            }
            n2 = n2 / 60000 - 60 * n3;
            FastDatePrinter.appendDigits(appendable, n2);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "%\u0003'q$%\tq~=!\u000f4bh#\u000bqH".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 76;
                                break;
                            }
                            case 1: {
                                n7 = 109;
                                break;
                            }
                            case 2: {
                                n7 = 81;
                                break;
                            }
                            case 3: {
                                n7 = 16;
                                break;
                            }
                            default: {
                                n7 = 72;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
            ISO8601_HOURS = new Iso8601_Rule(3);
            ISO8601_HOURS_MINUTES = new Iso8601_Rule(5);
            ISO8601_HOURS_COLON_MINUTES = new Iso8601_Rule(6);
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        final boolean mColon;

        TimeZoneNumberRule(boolean bl) {
            this.mColon = bl;
        }

        @Override
        public int estimateLength() {
            return 5;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 < 0) {
                appendable.append('-');
                n2 = -n2;
            } else {
                appendable.append('+');
            }
            int n3 = n2 / 3600000;
            FastDatePrinter.appendDigits(appendable, n3);
            if (this.mColon) {
                appendable.append(':');
            }
            n2 = n2 / 60000 - 60 * n3;
            FastDatePrinter.appendDigits(appendable, n2);
        }
    }

    private static class DayInWeekField
    implements NumberRule {
        private final NumberRule mRule;

        DayInWeekField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(7);
            this.mRule.appendTo(appendable, n2 != 1 ? n2 - 1 : 7);
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            this.mRule.appendTo(appendable, n2);
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwentyFourHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(11);
            if (n2 == 0) {
                n2 = calendar.getMaximum(11) + 1;
            }
            this.mRule.appendTo(appendable, n2);
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            this.mRule.appendTo(appendable, n2);
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwelveHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            int n2 = calendar.get(10);
            if (n2 == 0) {
                n2 = calendar.getLeastMaximum(10) + 1;
            }
            this.mRule.appendTo(appendable, n2);
        }

        @Override
        public void appendTo(Appendable appendable, int n2) throws IOException {
            this.mRule.appendTo(appendable, n2);
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            FastDatePrinter.appendDigits(appendable, n2);
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(1) % 100);
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            FastDatePrinter.appendDigits(appendable, n2);
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int mField;

        TwoDigitNumberField(int n2) {
            this.mField = n2;
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            if (n2 < 100) {
                FastDatePrinter.appendDigits(appendable, n2);
                return;
            }
            FastDatePrinter.appendFullDigits(appendable, n2, 2);
        }
    }

    private static class PaddedNumberField
    implements NumberRule {
        private final int mField;
        private final int mSize;

        PaddedNumberField(int n2, int n3) {
            if (n3 < 3) {
                throw new IllegalArgumentException();
            }
            this.mField = n2;
            this.mSize = n3;
        }

        @Override
        public int estimateLength() {
            return this.mSize;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            FastDatePrinter.appendFullDigits(appendable, n2, this.mSize);
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            if (n2 < 10) {
                appendable.append((char)(n2 + 48));
                return;
            }
            FastDatePrinter.appendDigits(appendable, n2);
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int mField;

        UnpaddedNumberField(int n2) {
            this.mField = n2;
        }

        @Override
        public int estimateLength() {
            return 4;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            this.appendTo(appendable, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(Appendable appendable, int n2) throws IOException {
            if (n2 < 10) {
                appendable.append((char)(n2 + 48));
                return;
            }
            if (n2 < 100) {
                FastDatePrinter.appendDigits(appendable, n2);
                return;
            }
            FastDatePrinter.appendFullDigits(appendable, n2, 1);
        }
    }

    private static class TextField
    implements Rule {
        private final int mField;
        private final String[] mValues;

        TextField(int n2, String[] stringArray) {
            this.mField = n2;
            this.mValues = stringArray;
        }

        @Override
        public int estimateLength() {
            int n2 = 0;
            int n3 = this.mValues.length;
            while (--n3 >= 0) {
                int n4 = this.mValues[n3].length();
                if (n4 <= n2) continue;
                n2 = n4;
            }
            return n2;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            appendable.append(this.mValues[calendar.get(this.mField)]);
        }
    }

    private static class StringLiteral
    implements Rule {
        private final String mValue;

        StringLiteral(String string) {
            this.mValue = string;
        }

        @Override
        public int estimateLength() {
            return this.mValue.length();
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            appendable.append(this.mValue);
        }
    }

    private static class CharacterLiteral
    implements Rule {
        private final char mValue;

        CharacterLiteral(char c2) {
            this.mValue = c2;
        }

        @Override
        public int estimateLength() {
            return 1;
        }

        @Override
        public void appendTo(Appendable appendable, Calendar calendar) throws IOException {
            appendable.append(this.mValue);
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(Appendable var1, int var2) throws IOException;
    }

    private static interface Rule {
        public int estimateLength();

        public void appendTo(Appendable var1, Calendar var2) throws IOException;
    }
}

