/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush;

import com.google.gson.jpush.JsonDeserializationContext;
import com.google.gson.jpush.JsonDeserializer;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonParseException;
import com.google.gson.jpush.JsonPrimitive;
import com.google.gson.jpush.JsonSerializationContext;
import com.google.gson.jpush.JsonSerializer;
import com.google.gson.jpush.JsonSyntaxException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class DefaultDateTypeAdapter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private final DateFormat enUsFormat;
    private final DateFormat localFormat;
    private final DateFormat iso8601Format;
    private static final String[] z;

    DefaultDateTypeAdapter() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    DefaultDateTypeAdapter(String string) {
        this(new SimpleDateFormat(string, Locale.US), new SimpleDateFormat(string));
    }

    DefaultDateTypeAdapter(int n2) {
        this(DateFormat.getDateInstance(n2, Locale.US), DateFormat.getDateInstance(n2));
    }

    public DefaultDateTypeAdapter(int n2, int n3) {
        this(DateFormat.getDateTimeInstance(n2, n3, Locale.US), DateFormat.getDateTimeInstance(n2, n3));
    }

    DefaultDateTypeAdapter(DateFormat dateFormat, DateFormat dateFormat2) {
        this.enUsFormat = dateFormat;
        this.localFormat = dateFormat2;
        this.iso8601Format = new SimpleDateFormat(z[2], Locale.US);
        this.iso8601Format.setTimeZone(TimeZone.getTimeZone(z[3]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JsonElement serialize(Date object, Type object2, JsonSerializationContext jsonSerializationContext) {
        object2 = this.localFormat;
        synchronized (object2) {
            object = this.enUsFormat.format((Date)object);
            return new JsonPrimitive((String)object);
        }
    }

    @Override
    public final Date deserialize(JsonElement object, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!(object instanceof JsonPrimitive)) {
            throw new JsonParseException(z[1]);
        }
        object = this.deserializeToDate((JsonElement)object);
        if (type == Date.class) {
            return object;
        }
        if (type == Timestamp.class) {
            return new Timestamp(((Date)object).getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(((Date)object).getTime());
        }
        throw new IllegalArgumentException(this.getClass() + z[0] + type);
    }

    private Date deserializeToDate(JsonElement jsonElement) {
        DateFormat dateFormat = this.localFormat;
        synchronized (dateFormat) {
            try {
                return this.localFormat.parse(jsonElement.getAsString());
            }
            catch (ParseException parseException) {
                try {
                    return this.enUsFormat.parse(jsonElement.getAsString());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.iso8601Format.parse(jsonElement.getAsString());
                    }
                    catch (ParseException parseException3) {
                        throw new JsonSyntaxException(jsonElement.getAsString(), parseException3);
                    }
                }
            }
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DefaultDateTypeAdapter.class.getSimpleName());
        stringBuilder.append('(').append(this.localFormat.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "sij\fG<~+\u0006L oy\u000bH?cq\u0007\t'e+";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block16: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block15: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block15;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block16;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 83;
                                break;
                            }
                            case 1: {
                                n9 = 10;
                                break;
                            }
                            case 2: {
                                n9 = 11;
                                break;
                            }
                            case 3: {
                                n9 = 98;
                                break;
                            }
                            default: {
                                n9 = 41;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0007bnBM2~nBZ;e~\u000eMshnBHsy\u007f\u0010@=m+\u0014H?\u007fn";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "*sr\u001b\u0004\u001eG&\u0006Mt^,*aigfXZ -QE";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0006^H";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

