/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush;

import com.google.gson.jpush.FieldNamingPolicy;
import com.google.gson.jpush.FieldNamingStrategy;
import com.google.gson.jpush.InstanceCreator;
import com.google.gson.jpush.JsonDeserializationContext;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonIOException;
import com.google.gson.jpush.JsonNull;
import com.google.gson.jpush.JsonParseException;
import com.google.gson.jpush.JsonSerializationContext;
import com.google.gson.jpush.JsonSyntaxException;
import com.google.gson.jpush.LongSerializationPolicy;
import com.google.gson.jpush.TypeAdapter;
import com.google.gson.jpush.TypeAdapterFactory;
import com.google.gson.jpush.internal.ConstructorConstructor;
import com.google.gson.jpush.internal.Excluder;
import com.google.gson.jpush.internal.Primitives;
import com.google.gson.jpush.internal.Streams;
import com.google.gson.jpush.internal.bind.ArrayTypeAdapter;
import com.google.gson.jpush.internal.bind.CollectionTypeAdapterFactory;
import com.google.gson.jpush.internal.bind.DateTypeAdapter;
import com.google.gson.jpush.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.jpush.internal.bind.JsonTreeReader;
import com.google.gson.jpush.internal.bind.JsonTreeWriter;
import com.google.gson.jpush.internal.bind.MapTypeAdapterFactory;
import com.google.gson.jpush.internal.bind.ObjectTypeAdapter;
import com.google.gson.jpush.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.jpush.internal.bind.SqlDateTypeAdapter;
import com.google.gson.jpush.internal.bind.TimeTypeAdapter;
import com.google.gson.jpush.internal.bind.TypeAdapters;
import com.google.gson.jpush.reflect.TypeToken;
import com.google.gson.jpush.stream.JsonReader;
import com.google.gson.jpush.stream.JsonToken;
import com.google.gson.jpush.stream.JsonWriter;
import com.google.gson.jpush.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Gson {
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    private static final String JSON_NON_EXECUTABLE_PREFIX;
    private final ThreadLocal<Map<TypeToken<?>, FutureTypeAdapter<?>>> calls = new ThreadLocal();
    private final Map<TypeToken<?>, TypeAdapter<?>> typeTokenCache = Collections.synchronizedMap(new HashMap());
    private final List<TypeAdapterFactory> factories;
    private final ConstructorConstructor constructorConstructor;
    private final boolean serializeNulls;
    private final boolean htmlSafe;
    private final boolean generateNonExecutableJson;
    private final boolean prettyPrinting;
    final JsonDeserializationContext deserializationContext = new JsonDeserializationContext(){

        @Override
        public <T> T deserialize(JsonElement jsonElement, Type type) throws JsonParseException {
            return Gson.this.fromJson(jsonElement, type);
        }
    };
    final JsonSerializationContext serializationContext = new JsonSerializationContext(){

        @Override
        public JsonElement serialize(Object object) {
            return Gson.this.toJsonTree(object);
        }

        @Override
        public JsonElement serialize(Object object, Type type) {
            return Gson.this.toJsonTree(object, type);
        }
    };
    private static final String[] z;

    public Gson() {
        this(Excluder.DEFAULT, FieldNamingPolicy.IDENTITY, Collections.emptyMap(), false, false, false, true, false, false, LongSerializationPolicy.DEFAULT, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> object, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, LongSerializationPolicy longSerializationPolicy, List<TypeAdapterFactory> list) {
        this.constructorConstructor = new ConstructorConstructor((Map<Type, InstanceCreator<?>>)object);
        this.serializeNulls = bl;
        this.generateNonExecutableJson = bl3;
        this.htmlSafe = bl4;
        this.prettyPrinting = bl5;
        object = new ArrayList<TypeAdapterFactory>();
        object.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        object.add(ObjectTypeAdapter.FACTORY);
        object.add(excluder);
        object.addAll(list);
        object.add(TypeAdapters.STRING_FACTORY);
        object.add(TypeAdapters.INTEGER_FACTORY);
        object.add(TypeAdapters.BOOLEAN_FACTORY);
        object.add(TypeAdapters.BYTE_FACTORY);
        object.add(TypeAdapters.SHORT_FACTORY);
        object.add(TypeAdapters.newFactory(Long.TYPE, Long.class, this.longAdapter(longSerializationPolicy)));
        object.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(bl6)));
        object.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(bl6)));
        object.add(TypeAdapters.NUMBER_FACTORY);
        object.add(TypeAdapters.CHARACTER_FACTORY);
        object.add(TypeAdapters.STRING_BUILDER_FACTORY);
        object.add(TypeAdapters.STRING_BUFFER_FACTORY);
        object.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        object.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        object.add(TypeAdapters.URL_FACTORY);
        object.add(TypeAdapters.URI_FACTORY);
        object.add(TypeAdapters.UUID_FACTORY);
        object.add(TypeAdapters.LOCALE_FACTORY);
        object.add(TypeAdapters.INET_ADDRESS_FACTORY);
        object.add(TypeAdapters.BIT_SET_FACTORY);
        object.add(DateTypeAdapter.FACTORY);
        object.add(TypeAdapters.CALENDAR_FACTORY);
        object.add(TimeTypeAdapter.FACTORY);
        object.add(SqlDateTypeAdapter.FACTORY);
        object.add(TypeAdapters.TIMESTAMP_FACTORY);
        object.add(ArrayTypeAdapter.FACTORY);
        object.add(TypeAdapters.CLASS_FACTORY);
        object.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        object.add(new MapTypeAdapterFactory(this.constructorConstructor, bl2));
        object.add(new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor));
        object.add(TypeAdapters.ENUM_FACTORY);
        object.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, fieldNamingStrategy, excluder));
        this.factories = Collections.unmodifiableList(object);
    }

    private TypeAdapter<Number> doubleAdapter(boolean bl) {
        if (bl) {
            return TypeAdapters.DOUBLE;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Double read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                double d2 = number.doubleValue();
                Gson.this.checkValidFloatingPoint(d2);
                jsonWriter.value(number);
            }
        };
    }

    private TypeAdapter<Number> floatAdapter(boolean bl) {
        if (bl) {
            return TypeAdapters.FLOAT;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Float read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                float f2 = number.floatValue();
                Gson.this.checkValidFloatingPoint(f2);
                jsonWriter.value(number);
            }
        };
    }

    private void checkValidFloatingPoint(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(d2 + z[2]);
        }
    }

    private TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) throws IOException {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextLong();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) throws IOException {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(number.toString());
            }
        };
    }

    public final <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        TypeAdapter typeAdapter;
        Object object = this.typeTokenCache.get(typeToken);
        if (object != null) {
            return object;
        }
        object = this.calls.get();
        boolean bl = false;
        if (object == null) {
            object = new HashMap();
            this.calls.set((Map<TypeToken<?>, FutureTypeAdapter<?>>)object);
            bl = true;
        }
        if ((typeAdapter = (FutureTypeAdapter<T>)object.get(typeToken)) != null) {
            return typeAdapter;
        }
        try {
            typeAdapter = new FutureTypeAdapter<T>();
            object.put(typeToken, typeAdapter);
            Iterator<TypeAdapterFactory> iterator = this.factories.iterator();
            while (iterator.hasNext()) {
                TypeAdapter<T> typeAdapter2 = iterator.next().create(this, typeToken);
                if (typeAdapter2 == null) continue;
                typeAdapter.setDelegate(typeAdapter2);
                this.typeTokenCache.put(typeToken, typeAdapter2);
                typeAdapter = typeAdapter2;
                return typeAdapter;
            }
            throw new IllegalArgumentException(z[0] + typeToken);
        }
        finally {
            object.remove(typeToken);
            if (bl) {
                this.calls.remove();
            }
        }
    }

    public final <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        boolean bl = false;
        if (!this.factories.contains(typeAdapterFactory)) {
            bl = true;
        }
        for (TypeAdapterFactory typeAdapterFactory2 : this.factories) {
            if (!bl) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        throw new IllegalArgumentException(z[7] + typeToken);
    }

    public final <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public final JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        return this.toJsonTree(object, object.getClass());
    }

    public final JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public final String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        return this.toJson(object, object.getClass());
    }

    public final String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    public final void toJson(Object object, Appendable appendable) throws JsonIOException {
        if (object != null) {
            this.toJson(object, object.getClass(), appendable);
            return;
        }
        this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
    }

    public final void toJson(Object object, Type type, Appendable object2) throws JsonIOException {
        try {
            object2 = this.newJsonWriter(Streams.writerForAppendable((Appendable)object2));
            this.toJson(object, type, (JsonWriter)object2);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final void toJson(Object object, Type object2, JsonWriter jsonWriter) throws JsonIOException {
        object2 = this.getAdapter(TypeToken.get((Type)object2));
        boolean bl = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl2 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            ((TypeAdapter)object2).write(jsonWriter, object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            jsonWriter.setLenient(bl);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public final String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public final void toJson(JsonElement jsonElement, Appendable object) throws JsonIOException {
        try {
            object = this.newJsonWriter(Streams.writerForAppendable((Appendable)object));
            this.toJson(jsonElement, (JsonWriter)object);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public final JsonWriter newJsonWriter(Writer closeable) throws IOException {
        if (this.generateNonExecutableJson) {
            ((Writer)closeable).write(JSON_NON_EXECUTABLE_PREFIX);
        }
        closeable = new JsonWriter((Writer)closeable);
        if (this.prettyPrinting) {
            ((JsonWriter)closeable).setIndent(z[1]);
        }
        ((JsonWriter)closeable).setSerializeNulls(this.serializeNulls);
        return closeable;
    }

    public final void toJson(JsonElement jsonElement, JsonWriter jsonWriter) throws JsonIOException {
        boolean bl = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl2 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl3 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            Streams.write(jsonElement, jsonWriter);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        finally {
            jsonWriter.setLenient(bl);
            jsonWriter.setHtmlSafe(bl2);
            jsonWriter.setSerializeNulls(bl3);
        }
    }

    public final <T> T fromJson(String string, Class<T> clazz) throws JsonSyntaxException {
        string = this.fromJson(string, (Type)clazz);
        return Primitives.wrap(clazz).cast(string);
    }

    public final <T> T fromJson(String object, Type type) throws JsonSyntaxException {
        if (object == null) {
            return null;
        }
        object = new StringReader((String)object);
        return this.fromJson((Reader)object, type);
    }

    public final <T> T fromJson(Reader closeable, Class<T> clazz) throws JsonSyntaxException, JsonIOException {
        closeable = new JsonReader((Reader)closeable);
        T t2 = this.fromJson((JsonReader)closeable, clazz);
        Gson.assertFullConsumption(t2, (JsonReader)closeable);
        return Primitives.wrap(clazz).cast(t2);
    }

    public final <T> T fromJson(Reader closeable, Type type) throws JsonIOException, JsonSyntaxException {
        closeable = new JsonReader((Reader)closeable);
        type = this.fromJson((JsonReader)closeable, type);
        Gson.assertFullConsumption(type, (JsonReader)closeable);
        return (T)type;
    }

    private static void assertFullConsumption(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException(z[3]);
            }
            return;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final <T> T fromJson(JsonReader jsonReader, Type object) throws JsonIOException, JsonSyntaxException {
        boolean bl = true;
        boolean bl2 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            jsonReader.peek();
            bl = false;
            object = TypeToken.get((Type)object);
            object = this.getAdapter((TypeToken<T>)object).read(jsonReader);
            return (T)object;
        }
        catch (EOFException eOFException) {
            if (bl) {
                return null;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        finally {
            jsonReader.setLenient(bl2);
        }
    }

    public final <T> T fromJson(JsonElement jsonElement, Class<T> clazz) throws JsonSyntaxException {
        jsonElement = this.fromJson(jsonElement, (Type)clazz);
        return Primitives.wrap(clazz).cast(jsonElement);
    }

    public final <T> T fromJson(JsonElement jsonElement, Type type) throws JsonSyntaxException {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson(new JsonTreeReader(jsonElement), type);
    }

    public final String toString() {
        return z[4] + this.serializeNulls + z[6] + this.factories + z[5] + this.constructorConstructor + "}";
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "- G\u0002.";
        int n3 = 7;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 4;
                                break;
                            }
                            case 1: {
                                n9 = 125;
                                break;
                            }
                            case 2: {
                                n9 = 58;
                                break;
                            }
                            case 3: {
                                n9 = 37;
                                break;
                            }
                            default: {
                                n9 = 36;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 7: {
                    JSON_NON_EXECUTABLE_PREFIX = string.intern();
                    string2 = "C.uk\u0004g\u001cTKKp]RDJ`\u0011_\u0005";
                    n3 = -1;
                    continue block16;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "$]";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "$\u0014I\u0005Jk\t\u001aD\u0004r\u001cVL@$\u0019UPFh\u0018\u001aSEh\b_\u0005Ew]J@V$7ijj$\u000eJ@Gm\u001bSFEp\u0014UK\n$)U\u0005Kr\u0018HWM`\u0018\u001aQLm\u000e\u001aGAl\u001cLLKvQ\u001aPWa]}VKj?OLH`\u0018H\u000bWa\u000fSDHm\u0007_vTa\u001eSDHB\u0011UDPm\u0013]uKm\u0013NsEh\b_V\f-]W@Pl\u0012^\u000b";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "N.uk\u0004`\u0012YPIa\u0013N\u0005Se\u000e\u001aKKp]\\PHh\u0004\u001aFKj\u000eOHA`S";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u007f\u000e_WMe\u0011S_AJ\bVIW>";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "(\u0014TVPe\u0013Y@gv\u0018[QKv\u000e\u0000";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "b\u001cYQKv\u0014_V\u001e";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "C.uk\u0004g\u001cTKKp]I@Vm\u001cVL^a]";
                    n3 = 6;
                    continue block16;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }

    static class FutureTypeAdapter<T>
    extends TypeAdapter<T> {
        private TypeAdapter<T> delegate;

        FutureTypeAdapter() {
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.delegate != null) {
                throw new AssertionError();
            }
            this.delegate = typeAdapter;
        }

        @Override
        public T read(JsonReader jsonReader) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            return this.delegate.read(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, T t2) throws IOException {
            if (this.delegate == null) {
                throw new IllegalStateException();
            }
            this.delegate.write(jsonWriter, t2);
        }
    }
}

