/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush;

import com.google.gson.jpush.JsonArray;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonNull;
import com.google.gson.jpush.JsonPrimitive;
import com.google.gson.jpush.internal.LinkedTreeMap;
import java.util.Map;
import java.util.Set;

public final class JsonObject
extends JsonElement {
    private final LinkedTreeMap<String, JsonElement> members = new LinkedTreeMap();

    @Override
    final JsonObject deepCopy() {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : this.members.entrySet()) {
            jsonObject.add(entry.getKey(), entry.getValue().deepCopy());
        }
        return jsonObject;
    }

    public final void add(String string, JsonElement jsonElement) {
        if (jsonElement == null) {
            jsonElement = JsonNull.INSTANCE;
        }
        this.members.put(string, jsonElement);
    }

    public final JsonElement remove(String string) {
        return this.members.remove(string);
    }

    public final void addProperty(String string, String string2) {
        this.add(string, this.createJsonElement(string2));
    }

    public final void addProperty(String string, Number number) {
        this.add(string, this.createJsonElement(number));
    }

    public final void addProperty(String string, Boolean bl) {
        this.add(string, this.createJsonElement(bl));
    }

    public final void addProperty(String string, Character c2) {
        this.add(string, this.createJsonElement(c2));
    }

    private JsonElement createJsonElement(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(object);
    }

    public final Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public final boolean has(String string) {
        return this.members.containsKey(string);
    }

    public final JsonElement get(String string) {
        return this.members.get(string);
    }

    public final JsonPrimitive getAsJsonPrimitive(String string) {
        return (JsonPrimitive)this.members.get(string);
    }

    public final JsonArray getAsJsonArray(String string) {
        return (JsonArray)this.members.get(string);
    }

    public final JsonObject getAsJsonObject(String string) {
        return (JsonObject)this.members.get(string);
    }

    public final boolean equals(Object object) {
        return object == this || object instanceof JsonObject && ((JsonObject)object).members.equals(this.members);
    }

    public final int hashCode() {
        return this.members.hashCode();
    }
}

