/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal;

import com.google.gson.jpush.ExclusionStrategy;
import com.google.gson.jpush.FieldAttributes;
import com.google.gson.jpush.Gson;
import com.google.gson.jpush.TypeAdapter;
import com.google.gson.jpush.TypeAdapterFactory;
import com.google.gson.jpush.annotations.Expose;
import com.google.gson.jpush.annotations.Since;
import com.google.gson.jpush.annotations.Until;
import com.google.gson.jpush.reflect.TypeToken;
import com.google.gson.jpush.stream.JsonReader;
import com.google.gson.jpush.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    private static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    private List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected final Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public final Excluder withVersion(double d2) {
        Excluder excluder = this.clone();
        this.clone().version = d2;
        return excluder;
    }

    public final Excluder withModifiers(int ... nArray) {
        Excluder excluder = this.clone();
        this.clone().modifiers = 0;
        for (int n2 : nArray) {
            excluder.modifiers |= n2;
        }
        return excluder;
    }

    public final Excluder disableInnerClassSerialization() {
        Excluder excluder = this.clone();
        this.clone().serializeInnerClasses = false;
        return excluder;
    }

    public final Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.clone();
        this.clone().requireExpose = true;
        return excluder;
    }

    public final Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean bl, boolean bl2) {
        Excluder excluder = this.clone();
        if (bl) {
            excluder.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (bl2) {
            excluder.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    @Override
    public final <T> TypeAdapter<T> create(final Gson gson, final TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        final boolean bl = this.excludeClass(clazz, true);
        final boolean bl2 = this.excludeClass(clazz, false);
        if (!bl && !bl2) {
            return null;
        }
        return new TypeAdapter<T>(){
            private TypeAdapter<T> delegate;

            @Override
            public T read(JsonReader jsonReader) throws IOException {
                if (bl2) {
                    jsonReader.skipValue();
                    return null;
                }
                return this.delegate().read(jsonReader);
            }

            @Override
            public void write(JsonWriter jsonWriter, T t2) throws IOException {
                if (bl) {
                    jsonWriter.nullValue();
                    return;
                }
                this.delegate().write(jsonWriter, t2);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter typeAdapter = this.delegate;
                if (typeAdapter != null) {
                    return typeAdapter;
                }
                this.delegate = gson.getDelegateAdapter(Excluder.this, typeToken);
                return this.delegate;
            }
        };
    }

    public final boolean excludeField(Field object, boolean bl) {
        List<ExclusionStrategy> list;
        if ((this.modifiers & ((Field)object).getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(((Field)object).getAnnotation(Since.class), ((Field)object).getAnnotation(Until.class))) {
            return true;
        }
        if (((Field)object).isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((list = ((Field)object).getAnnotation(Expose.class)) == null || (bl ? !list.serialize() : !list.deserialize()))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(((Field)object).getType())) {
            return true;
        }
        if (this.isAnonymousOrLocal(((Field)object).getType())) {
            return true;
        }
        list = bl ? this.serializationStrategies : this.deserializationStrategies;
        if (!list.isEmpty()) {
            object = new FieldAttributes((Field)object);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!((ExclusionStrategy)iterator.next()).shouldSkipField((FieldAttributes)object)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean excludeClass(Class<?> clazz, boolean bl) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        if (this.isAnonymousOrLocal(clazz)) {
            return true;
        }
        Iterator<ExclusionStrategy> iterator = (bl ? this.serializationStrategies : this.deserializationStrategies).iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnonymousOrLocal(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    private boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !this.isStatic(clazz);
    }

    private boolean isStatic(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since since) {
        return since == null || !(since.value() > this.version);
    }

    private boolean isValidUntil(Until until) {
        return until == null || !(until.value() <= this.version);
    }
}

