/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal.bind;

import com.google.gson.jpush.Gson;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonPrimitive;
import com.google.gson.jpush.JsonSyntaxException;
import com.google.gson.jpush.TypeAdapter;
import com.google.gson.jpush.TypeAdapterFactory;
import com.google.gson.jpush.internal.$Gson$Types;
import com.google.gson.jpush.internal.ConstructorConstructor;
import com.google.gson.jpush.internal.JsonReaderInternalAccess;
import com.google.gson.jpush.internal.ObjectConstructor;
import com.google.gson.jpush.internal.Streams;
import com.google.gson.jpush.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.jpush.internal.bind.TypeAdapters;
import com.google.gson.jpush.reflect.TypeToken;
import com.google.gson.jpush.stream.JsonReader;
import com.google.gson.jpush.stream.JsonToken;
import com.google.gson.jpush.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public final class MapTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final boolean complexMapKeySerialization;

    public MapTypeAdapterFactory(ConstructorConstructor constructorConstructor, boolean bl) {
        this.constructorConstructor = constructorConstructor;
        this.complexMapKeySerialization = bl;
    }

    @Override
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> object) {
        Type[] typeArray = ((TypeToken)object).getType();
        Class<T> clazz = ((TypeToken)object).getRawType();
        if (!Map.class.isAssignableFrom(clazz)) {
            return null;
        }
        clazz = $Gson$Types.getRawType((Type)typeArray);
        typeArray = $Gson$Types.getMapKeyAndValueTypes((Type)typeArray, clazz);
        clazz = this.getKeyAdapter(gson, typeArray[0]);
        TypeAdapter<?> typeAdapter = gson.getAdapter(TypeToken.get(typeArray[1]));
        object = this.constructorConstructor.get(object);
        return new Adapter(gson, typeArray[0], clazz, typeArray[1], typeAdapter, object);
    }

    private TypeAdapter<?> getKeyAdapter(Gson gson, Type type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return TypeAdapters.BOOLEAN_AS_STRING;
        }
        return gson.getAdapter(TypeToken.get(type));
    }

    private final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;
        private final ObjectConstructor<? extends Map<K, V>> constructor;
        private static final String[] z;

        public Adapter(Gson gson, Type type, TypeAdapter<K> typeAdapter, Type type2, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(gson, typeAdapter, type);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(gson, typeAdapter2, type2);
            this.constructor = objectConstructor;
        }

        @Override
        public final Map<K, V> read(JsonReader jsonReader) throws IOException {
            JsonToken jsonToken = jsonReader.peek();
            if (jsonToken == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            Map<JsonToken, V> map = this.constructor.construct();
            if (jsonToken == JsonToken.BEGIN_ARRAY) {
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    jsonReader.beginArray();
                    jsonToken = this.keyTypeAdapter.read(jsonReader);
                    V v2 = this.valueTypeAdapter.read(jsonReader);
                    if (map.put(jsonToken, v2) != null) {
                        throw new JsonSyntaxException(z[0] + (Object)((Object)jsonToken));
                    }
                    jsonReader.endArray();
                }
                jsonReader.endArray();
            } else {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    V v3;
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                    jsonToken = this.keyTypeAdapter.read(jsonReader);
                    if (map.put(jsonToken, v3 = this.valueTypeAdapter.read(jsonReader)) == null) continue;
                    throw new JsonSyntaxException(z[0] + (Object)((Object)jsonToken));
                }
                jsonReader.endObject();
            }
            return map;
        }

        @Override
        public final void write(JsonWriter jsonWriter, Map<K, V> object) throws IOException {
            if (object == null) {
                jsonWriter.nullValue();
                return;
            }
            if (!MapTypeAdapterFactory.this.complexMapKeySerialization) {
                jsonWriter.beginObject();
                for (Map.Entry entry : object.entrySet()) {
                    jsonWriter.name(String.valueOf(entry.getKey()));
                    this.valueTypeAdapter.write(jsonWriter, entry.getValue());
                }
                jsonWriter.endObject();
                return;
            }
            boolean bl = false;
            ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(object.size());
            ArrayList arrayList2 = new ArrayList(object.size());
            for (Map.Entry object2 : object.entrySet()) {
                JsonElement jsonElement = this.keyTypeAdapter.toJsonTree(object2.getKey());
                arrayList.add(jsonElement);
                arrayList2.add(object2.getValue());
                bl |= jsonElement.isJsonArray() || jsonElement.isJsonObject();
            }
            if (bl) {
                jsonWriter.beginArray();
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    jsonWriter.beginArray();
                    Streams.write((JsonElement)arrayList.get(i2), jsonWriter);
                    this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i2));
                    jsonWriter.endArray();
                }
                jsonWriter.endArray();
                return;
            }
            jsonWriter.beginObject();
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                JsonElement jsonElement = (JsonElement)arrayList.get(i3);
                jsonWriter.name(this.keyToString(jsonElement));
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i3));
            }
            jsonWriter.endObject();
        }

        private String keyToString(JsonElement jsonElement) {
            if (jsonElement.isJsonPrimitive()) {
                if (((JsonPrimitive)(jsonElement = jsonElement.getAsJsonPrimitive())).isNumber()) {
                    return String.valueOf(((JsonPrimitive)jsonElement).getAsNumber());
                }
                if (((JsonPrimitive)jsonElement).isBoolean()) {
                    return Boolean.toString(((JsonPrimitive)jsonElement).getAsBoolean());
                }
                if (((JsonPrimitive)jsonElement).isString()) {
                    return ((JsonPrimitive)jsonElement).getAsString();
                }
                throw new AssertionError();
            }
            if (jsonElement.isJsonNull()) {
                return z[1];
            }
            throw new AssertionError();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "[`B\u0011}\\tF\u00184TpKG4";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 63;
                                    break;
                                }
                                case 1: {
                                    n9 = 21;
                                    break;
                                }
                                case 2: {
                                    n9 = 50;
                                    break;
                                }
                                case 3: {
                                    n9 = 125;
                                    break;
                                }
                                default: {
                                    n9 = 20;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "Q`^\u0011";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    }
}

