/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.internal.bind;

import com.google.gson.jpush.Gson;
import com.google.gson.jpush.JsonArray;
import com.google.gson.jpush.JsonElement;
import com.google.gson.jpush.JsonIOException;
import com.google.gson.jpush.JsonNull;
import com.google.gson.jpush.JsonObject;
import com.google.gson.jpush.JsonPrimitive;
import com.google.gson.jpush.JsonSyntaxException;
import com.google.gson.jpush.TypeAdapter;
import com.google.gson.jpush.TypeAdapterFactory;
import com.google.gson.jpush.annotations.SerializedName;
import com.google.gson.jpush.internal.LazilyParsedNumber;
import com.google.gson.jpush.reflect.TypeToken;
import com.google.gson.jpush.stream.JsonReader;
import com.google.gson.jpush.stream.JsonToken;
import com.google.gson.jpush.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;

public final class TypeAdapters {
    public static final TypeAdapter<Class> CLASS = new TypeAdapter<Class>(){
        private static final String[] z;

        @Override
        public final void write(JsonWriter jsonWriter, Class clazz) throws IOException {
            if (clazz == null) {
                jsonWriter.nullValue();
                return;
            }
            throw new UnsupportedOperationException(z[1] + clazz.getName() + z[0]);
        }

        @Override
        public final Class read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            throw new UnsupportedOperationException(z[2]);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[3];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "<\u0004+q\u0015uK\u0019>\u0013}\u0004\u001f{\u0000{W\u0019{\u00152EMj\u001ebAM\u007f\u0003sT\u0019{\u0015-";
            int n3 = -1;
            block10: while (true) {
                char[] cArray;
                block15: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block14: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block14;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block15;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 18;
                                    break;
                                }
                                case 1: {
                                    n9 = 36;
                                    break;
                                }
                                case 2: {
                                    n9 = 109;
                                    break;
                                }
                                case 3: {
                                    n9 = 30;
                                    break;
                                }
                                default: {
                                    n9 = 103;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "SP\u0019{\nbP\bzGfKMm\u0002`M\fr\u000ehAMt\u0006dECr\u0006|CC]\u000bsW\u001e$G";
                        n3 = 0;
                        continue block10;
                    }
                    case 0: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 2;
                        string2 = "SP\u0019{\nbP\bzGfKMz\u0002aA\u001fw\u0006~M\u0017{Gs\u0004\u0007\u007f\u0011s\n\u0001\u007f\tu\n.r\u0006aWC>!}V\nq\u00132P\u0002>\u0015wC\u0004m\u0013wVM\u007fGf]\u001d{Gs@\fn\u0013wVR";
                        n3 = 1;
                        continue block10;
                    }
                    case 1: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    };
    public static final TypeAdapterFactory CLASS_FACTORY = TypeAdapters.newFactory(Class.class, CLASS);
    public static final TypeAdapter<BitSet> BIT_SET = new TypeAdapter<BitSet>(){
        private static final String[] z;

        @Override
        public final BitSet read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            BitSet bitSet = new BitSet();
            jsonReader.beginArray();
            int n2 = 0;
            JsonToken jsonToken = jsonReader.peek();
            while (jsonToken != JsonToken.END_ARRAY) {
                boolean bl;
                switch (jsonToken) {
                    case NUMBER: {
                        bl = jsonReader.nextInt() != 0;
                        break;
                    }
                    case BOOLEAN: {
                        bl = jsonReader.nextBoolean();
                        break;
                    }
                    case STRING: {
                        String string = jsonReader.nextString();
                        try {
                            bl = Integer.parseInt(string) != 0;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new JsonSyntaxException(z[0] + string);
                        }
                    }
                    default: {
                        throw new JsonSyntaxException(z[1] + (Object)((Object)jsonToken));
                    }
                }
                if (bl) {
                    bitSet.set(n2);
                }
                ++n2;
                jsonToken = jsonReader.peek();
            }
            jsonReader.endArray();
            return bitSet;
        }

        @Override
        public final void write(JsonWriter jsonWriter, BitSet bitSet) throws IOException {
            if (bitSet == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginArray();
            for (int i2 = 0; i2 < bitSet.length(); ++i2) {
                int n2 = bitSet.get(i2) ? 1 : 0;
                jsonWriter.value(n2);
            }
            jsonWriter.endArray();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n2 = 0;
            String string2 = "]#U\u001a\t\"qb\r\u000b}2S\u001c\u0015\u007fk\u0007\u0017\u0012l\"B\u0001[v$J\u0017\u001ejqQ\u0014\u0017m4\u0007]J4q\u0017\\W8\u0017H\u0000\u0015|k\u0007";
            int n3 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n4;
                    int n5;
                    char[] cArray2;
                    int n6;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n6 = 0;
                        int n7 = cArray3.length;
                        cArray2 = cArray3;
                        n5 = n7;
                        if (n7 <= 1) break block13;
                        cArray = cArray2;
                        n4 = n5;
                        if (n5 <= n6) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n8 = n6;
                        while (true) {
                            int n9;
                            char c2 = cArray4[n8];
                            switch (n6 % 5) {
                                case 0: {
                                    n9 = 24;
                                    break;
                                }
                                case 1: {
                                    n9 = 81;
                                    break;
                                }
                                case 2: {
                                    n9 = 39;
                                    break;
                                }
                                case 3: {
                                    n9 = 117;
                                    break;
                                }
                                default: {
                                    n9 = 123;
                                }
                            }
                            cArray4[n8] = (char)(c2 ^ n9);
                            ++n6;
                            cArray2 = cArray5;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray5 = cArray2;
                            n4 = n5;
                            n8 = n5;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n4 = n5;
                    } while (n5 > n6);
                }
                string = new String(cArray);
                switch (n3) {
                    default: {
                        stringArray2[n2] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n2 = 1;
                        string2 = "Q?Q\u0014\u0017q5\u0007\u0017\u0012l\"B\u0001[n0K\u0000\u001e8%^\u0005\u001e\"q";
                        n3 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n2] = string.intern();
            z = stringArray3;
        }
    };
    public static final TypeAdapterFactory BIT_SET_FACTORY = TypeAdapters.newFactory(BitSet.class, BIT_SET);
    public static final TypeAdapter<Boolean> BOOLEAN = new TypeAdapter<Boolean>(){

        @Override
        public final Boolean read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            if (jsonReader.peek() == JsonToken.STRING) {
                return Boolean.parseBoolean(jsonReader.nextString());
            }
            return jsonReader.nextBoolean();
        }

        @Override
        public final void write(JsonWriter jsonWriter, Boolean bl) throws IOException {
            if (bl == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.value(bl);
        }
    };
    public static final TypeAdapter<Boolean> BOOLEAN_AS_STRING = new TypeAdapter<Boolean>(){
        private static final String z;

        @Override
        public final Boolean read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return Boolean.valueOf(jsonReader.nextString());
        }

        @Override
        public final void write(JsonWriter jsonWriter, Boolean bl) throws IOException {
            jsonWriter.value(bl == null ? z : bl.toString());
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "S\u0011\u0011\"".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 61;
                                break;
                            }
                            case 1: {
                                n7 = 100;
                                break;
                            }
                            case 2: {
                                n7 = 125;
                                break;
                            }
                            case 3: {
                                n7 = 78;
                                break;
                            }
                            default: {
                                n7 = 61;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    };
    public static final TypeAdapterFactory BOOLEAN_FACTORY = TypeAdapters.newFactory(Boolean.TYPE, Boolean.class, BOOLEAN);
    public static final TypeAdapter<Number> BYTE = new TypeAdapter<Number>(){

        @Override
        public final Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return (byte)jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final void write(JsonWriter jsonWriter, Number number) throws IOException {
            jsonWriter.value(number);
        }
    };
    public static final TypeAdapterFactory BYTE_FACTORY = TypeAdapters.newFactory(Byte.TYPE, Byte.class, BYTE);
    public static final TypeAdapter<Number> SHORT = new TypeAdapter<Number>(){

        @Override
        public final Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return (short)jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final void write(JsonWriter jsonWriter, Number number) throws IOException {
            jsonWriter.value(number);
        }
    };
    public static final TypeAdapterFactory SHORT_FACTORY = TypeAdapters.newFactory(Short.TYPE, Short.class, SHORT);
    public static final TypeAdapter<Number> INTEGER = new TypeAdapter<Number>(){

        @Override
        public final Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final void write(JsonWriter jsonWriter, Number number) throws IOException {
            jsonWriter.value(number);
        }
    };
    public static final TypeAdapterFactory INTEGER_FACTORY = TypeAdapters.newFactory(Integer.TYPE, Integer.class, INTEGER);
    public static final TypeAdapter<Number> LONG = new TypeAdapter<Number>(){

        @Override
        public final Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return jsonReader.nextLong();
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final void write(JsonWriter jsonWriter, Number number) throws IOException {
            jsonWriter.value(number);
        }
    };
    public static final TypeAdapter<Number> FLOAT = new TypeAdapter<Number>(){

        @Override
        public final Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return Float.valueOf((float)jsonReader.nextDouble());
        }

        @Override
        public final void write(JsonWriter jsonWriter, Number number) throws IOException {
            jsonWriter.value(number);
        }
    };
    public static final TypeAdapter<Number> DOUBLE = new TypeAdapter<Number>(){

        @Override
        public final Number read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return jsonReader.nextDouble();
        }

        @Override
        public final void write(JsonWriter jsonWriter, Number number) throws IOException {
            jsonWriter.value(number);
        }
    };
    public static final TypeAdapter<Number> NUMBER = new TypeAdapter<Number>(){
        private static final String z;

        @Override
        public final Number read(JsonReader jsonReader) throws IOException {
            JsonToken jsonToken = jsonReader.peek();
            switch (jsonToken) {
                case NULL: {
                    jsonReader.nextNull();
                    return null;
                }
                case NUMBER: {
                    return new LazilyParsedNumber(jsonReader.nextString());
                }
            }
            throw new JsonSyntaxException(z + (Object)((Object)jsonToken));
        }

        @Override
        public final void write(JsonWriter jsonWriter, Number number) throws IOException {
            jsonWriter.value(number);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "S\u0003.Seb\u00120Q&x\u000e3TcdW~QibA~".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 22;
                                break;
                            }
                            case 1: {
                                n7 = 123;
                                break;
                            }
                            case 2: {
                                n7 = 94;
                                break;
                            }
                            case 3: {
                                n7 = 54;
                                break;
                            }
                            default: {
                                n7 = 6;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    };
    public static final TypeAdapterFactory NUMBER_FACTORY = TypeAdapters.newFactory(Number.class, NUMBER);
    public static final TypeAdapter<Character> CHARACTER = new TypeAdapter<Character>(){
        private static final String z;

        @Override
        public final Character read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            if (((String)(object = ((JsonReader)object).nextString())).length() != 1) {
                throw new JsonSyntaxException(z + (String)object);
            }
            return Character.valueOf(((String)object).charAt(0));
        }

        @Override
        public final void write(JsonWriter jsonWriter, Character c2) throws IOException {
            jsonWriter.value(c2 == null ? null : String.valueOf(c2));
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "\u0011[=\u0015\r J#\u0017N7K,\u0002\u000f7W(\u0002BtD\"\u0004Tt".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 84;
                                break;
                            }
                            case 1: {
                                n7 = 35;
                                break;
                            }
                            case 2: {
                                n7 = 77;
                                break;
                            }
                            case 3: {
                                n7 = 112;
                                break;
                            }
                            default: {
                                n7 = 110;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    };
    public static final TypeAdapterFactory CHARACTER_FACTORY = TypeAdapters.newFactory(Character.TYPE, Character.class, CHARACTER);
    public static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        @Override
        public final String read(JsonReader jsonReader) throws IOException {
            JsonToken jsonToken = jsonReader.peek();
            if (jsonToken == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            if (jsonToken == JsonToken.BOOLEAN) {
                return Boolean.toString(jsonReader.nextBoolean());
            }
            return jsonReader.nextString();
        }

        @Override
        public final void write(JsonWriter jsonWriter, String string) throws IOException {
            jsonWriter.value(string);
        }
    };
    public static final TypeAdapter<BigDecimal> BIG_DECIMAL = new TypeAdapter<BigDecimal>(){

        @Override
        public final BigDecimal read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return new BigDecimal(jsonReader.nextString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final void write(JsonWriter jsonWriter, BigDecimal bigDecimal) throws IOException {
            jsonWriter.value(bigDecimal);
        }
    };
    public static final TypeAdapter<BigInteger> BIG_INTEGER = new TypeAdapter<BigInteger>(){

        @Override
        public final BigInteger read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            try {
                return new BigInteger(jsonReader.nextString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonSyntaxException(numberFormatException);
            }
        }

        @Override
        public final void write(JsonWriter jsonWriter, BigInteger bigInteger) throws IOException {
            jsonWriter.value(bigInteger);
        }
    };
    public static final TypeAdapterFactory STRING_FACTORY = TypeAdapters.newFactory(String.class, STRING);
    public static final TypeAdapter<StringBuilder> STRING_BUILDER = new TypeAdapter<StringBuilder>(){

        @Override
        public final StringBuilder read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new StringBuilder(jsonReader.nextString());
        }

        @Override
        public final void write(JsonWriter jsonWriter, StringBuilder stringBuilder) throws IOException {
            jsonWriter.value(stringBuilder == null ? null : stringBuilder.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUILDER_FACTORY = TypeAdapters.newFactory(StringBuilder.class, STRING_BUILDER);
    public static final TypeAdapter<StringBuffer> STRING_BUFFER = new TypeAdapter<StringBuffer>(){

        @Override
        public final StringBuffer read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return new StringBuffer(jsonReader.nextString());
        }

        @Override
        public final void write(JsonWriter jsonWriter, StringBuffer stringBuffer) throws IOException {
            jsonWriter.value(stringBuffer == null ? null : stringBuffer.toString());
        }
    };
    public static final TypeAdapterFactory STRING_BUFFER_FACTORY = TypeAdapters.newFactory(StringBuffer.class, STRING_BUFFER);
    public static final TypeAdapter<URL> URL = new TypeAdapter<URL>(){
        private static final String z;

        @Override
        public final URL read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            if (z.equals(object = ((JsonReader)object).nextString())) {
                return null;
            }
            return new URL((String)object);
        }

        @Override
        public final void write(JsonWriter jsonWriter, URL uRL) throws IOException {
            jsonWriter.value(uRL == null ? null : uRL.toExternalForm());
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "l'\u0002_".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 2;
                                break;
                            }
                            case 1: {
                                n7 = 82;
                                break;
                            }
                            case 2: {
                                n7 = 110;
                                break;
                            }
                            case 3: {
                                n7 = 51;
                                break;
                            }
                            default: {
                                n7 = 65;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    };
    public static final TypeAdapterFactory URL_FACTORY = TypeAdapters.newFactory(URL.class, URL);
    public static final TypeAdapter<URI> URI = new TypeAdapter<URI>(){
        private static final String z;

        @Override
        public final URI read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            try {
                object = ((JsonReader)object).nextString();
                if (z.equals(object)) {
                    return null;
                }
                return new URI((String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new JsonIOException(uRISyntaxException);
            }
        }

        @Override
        public final void write(JsonWriter jsonWriter, URI uRI) throws IOException {
            jsonWriter.value(uRI == null ? null : uRI.toASCIIString());
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "u:+]".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 27;
                                break;
                            }
                            case 1: {
                                n7 = 79;
                                break;
                            }
                            case 2: {
                                n7 = 71;
                                break;
                            }
                            case 3: {
                                n7 = 49;
                                break;
                            }
                            default: {
                                n7 = 125;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    };
    public static final TypeAdapterFactory URI_FACTORY = TypeAdapters.newFactory(URI.class, URI);
    public static final TypeAdapter<InetAddress> INET_ADDRESS = new TypeAdapter<InetAddress>(){

        @Override
        public final InetAddress read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return InetAddress.getByName(jsonReader.nextString());
        }

        @Override
        public final void write(JsonWriter jsonWriter, InetAddress inetAddress) throws IOException {
            jsonWriter.value(inetAddress == null ? null : inetAddress.getHostAddress());
        }
    };
    public static final TypeAdapterFactory INET_ADDRESS_FACTORY = TypeAdapters.newTypeHierarchyFactory(InetAddress.class, INET_ADDRESS);
    public static final TypeAdapter<UUID> UUID = new TypeAdapter<UUID>(){

        @Override
        public final UUID read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return java.util.UUID.fromString(jsonReader.nextString());
        }

        @Override
        public final void write(JsonWriter jsonWriter, UUID uUID) throws IOException {
            jsonWriter.value(uUID == null ? null : uUID.toString());
        }
    };
    public static final TypeAdapterFactory UUID_FACTORY = TypeAdapters.newFactory(UUID.class, UUID);
    public static final TypeAdapterFactory TIMESTAMP_FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson object, TypeToken<T> typeToken) {
            if (typeToken.getRawType() != Timestamp.class) {
                return null;
            }
            object = ((Gson)object).getAdapter(Date.class);
            return new TypeAdapter<Timestamp>((TypeAdapter)object){
                final /* synthetic */ TypeAdapter val$dateTypeAdapter;
                {
                    this.val$dateTypeAdapter = typeAdapter;
                }

                @Override
                public Timestamp read(JsonReader object) throws IOException {
                    if ((object = (Date)this.val$dateTypeAdapter.read((JsonReader)object)) != null) {
                        return new Timestamp(((Date)object).getTime());
                    }
                    return null;
                }

                @Override
                public void write(JsonWriter jsonWriter, Timestamp timestamp) throws IOException {
                    this.val$dateTypeAdapter.write(jsonWriter, timestamp);
                }
            };
        }
    };
    public static final TypeAdapter<Calendar> CALENDAR = new TypeAdapter<Calendar>(){
        private static final String YEAR;
        private static final String MONTH;
        private static final String DAY_OF_MONTH;
        private static final String HOUR_OF_DAY;
        private static final String MINUTE;
        private static final String SECOND;

        @Override
        public final Calendar read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (jsonReader.peek() != JsonToken.END_OBJECT) {
                String string = jsonReader.nextName();
                int n8 = jsonReader.nextInt();
                if (YEAR.equals(string)) {
                    n2 = n8;
                    continue;
                }
                if (MONTH.equals(string)) {
                    n3 = n8;
                    continue;
                }
                if (DAY_OF_MONTH.equals(string)) {
                    n4 = n8;
                    continue;
                }
                if (HOUR_OF_DAY.equals(string)) {
                    n5 = n8;
                    continue;
                }
                if (MINUTE.equals(string)) {
                    n6 = n8;
                    continue;
                }
                if (!SECOND.equals(string)) continue;
                n7 = n8;
            }
            jsonReader.endObject();
            return new GregorianCalendar(n2, n3, n4, n5, n6, n7);
        }

        @Override
        public final void write(JsonWriter jsonWriter, Calendar calendar) throws IOException {
            if (calendar == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name(YEAR);
            jsonWriter.value(calendar.get(1));
            jsonWriter.name(MONTH);
            jsonWriter.value(calendar.get(2));
            jsonWriter.name(DAY_OF_MONTH);
            jsonWriter.value(calendar.get(5));
            jsonWriter.name(HOUR_OF_DAY);
            jsonWriter.value(calendar.get(11));
            jsonWriter.name(MINUTE);
            jsonWriter.value(calendar.get(12));
            jsonWriter.name(SECOND);
            jsonWriter.value(calendar.get(13));
            jsonWriter.endObject();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String string2 = "#:V\u0019\u000b\n4A\"\u0005";
            int n2 = -1;
            block13: while (true) {
                char[] cArray;
                block18: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block17: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block17;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block18;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c2 = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 71;
                                    break;
                                }
                                case 1: {
                                    n8 = 91;
                                    break;
                                }
                                case 2: {
                                    n8 = 47;
                                    break;
                                }
                                case 3: {
                                    n8 = 86;
                                    break;
                                }
                                default: {
                                    n8 = 109;
                                }
                            }
                            cArray4[n7] = (char)(c2 ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        DAY_OF_MONTH = string.intern();
                        string2 = "/4Z$\"!\u001fN/";
                        n2 = 0;
                        continue block13;
                    }
                    case 0: {
                        HOUR_OF_DAY = string.intern();
                        string2 = ">>N$";
                        n2 = 1;
                        continue block13;
                    }
                    case 1: {
                        YEAR = string.intern();
                        string2 = "4>L9\u0003#";
                        n2 = 2;
                        continue block13;
                    }
                    case 2: {
                        SECOND = string.intern();
                        string2 = "*2A#\u0019\"";
                        n2 = 3;
                        continue block13;
                    }
                    case 3: {
                        MINUTE = string.intern();
                        string2 = "*4A\"\u0005";
                        n2 = 4;
                        continue block13;
                    }
                    case 4: 
                }
                break;
            }
            MONTH = string.intern();
        }
    };
    public static final TypeAdapterFactory CALENDAR_FACTORY = TypeAdapters.newFactoryForMultipleTypes(Calendar.class, GregorianCalendar.class, CALENDAR);
    public static final TypeAdapter<Locale> LOCALE = new TypeAdapter<Locale>(){

        @Override
        public final Locale read(JsonReader object) throws IOException {
            if (((JsonReader)object).peek() == JsonToken.NULL) {
                ((JsonReader)object).nextNull();
                return null;
            }
            object = ((JsonReader)object).nextString();
            object = new StringTokenizer((String)object, "_");
            String string = null;
            String string2 = null;
            String string3 = null;
            if (((StringTokenizer)object).hasMoreElements()) {
                string = ((StringTokenizer)object).nextToken();
            }
            if (((StringTokenizer)object).hasMoreElements()) {
                string2 = ((StringTokenizer)object).nextToken();
            }
            if (((StringTokenizer)object).hasMoreElements()) {
                string3 = ((StringTokenizer)object).nextToken();
            }
            if (string2 == null && string3 == null) {
                return new Locale(string);
            }
            if (string3 == null) {
                return new Locale(string, string2);
            }
            return new Locale(string, string2, string3);
        }

        @Override
        public final void write(JsonWriter jsonWriter, Locale locale) throws IOException {
            jsonWriter.value(locale == null ? null : locale.toString());
        }
    };
    public static final TypeAdapterFactory LOCALE_FACTORY = TypeAdapters.newFactory(Locale.class, LOCALE);
    public static final TypeAdapter<JsonElement> JSON_ELEMENT = new TypeAdapter<JsonElement>(){
        private static final String z;

        @Override
        public final JsonElement read(JsonReader object) throws IOException {
            switch (((JsonReader)object).peek()) {
                case STRING: {
                    return new JsonPrimitive(((JsonReader)object).nextString());
                }
                case NUMBER: {
                    object = ((JsonReader)object).nextString();
                    return new JsonPrimitive(new LazilyParsedNumber((String)object));
                }
                case BOOLEAN: {
                    return new JsonPrimitive(((JsonReader)object).nextBoolean());
                }
                case NULL: {
                    ((JsonReader)object).nextNull();
                    return JsonNull.INSTANCE;
                }
                case BEGIN_ARRAY: {
                    JsonArray jsonArray = new JsonArray();
                    ((JsonReader)object).beginArray();
                    while (((JsonReader)object).hasNext()) {
                        jsonArray.add(this.read((JsonReader)object));
                    }
                    ((JsonReader)object).endArray();
                    return jsonArray;
                }
                case BEGIN_OBJECT: {
                    JsonObject jsonObject = new JsonObject();
                    ((JsonReader)object).beginObject();
                    while (((JsonReader)object).hasNext()) {
                        jsonObject.add(((JsonReader)object).nextName(), this.read((JsonReader)object));
                    }
                    ((JsonReader)object).endObject();
                    return jsonObject;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public final void write(JsonWriter jsonWriter, JsonElement iterator) throws IOException {
            if (iterator == null || ((JsonElement)((Object)iterator)).isJsonNull()) {
                jsonWriter.nullValue();
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonPrimitive()) {
                if (((JsonPrimitive)((Object)(iterator = ((JsonElement)((Object)iterator)).getAsJsonPrimitive()))).isNumber()) {
                    jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsNumber());
                    return;
                }
                if (((JsonPrimitive)((Object)iterator)).isBoolean()) {
                    jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsBoolean());
                    return;
                }
                jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsString());
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonArray()) {
                jsonWriter.beginArray();
                for (JsonElement jsonElement : ((JsonElement)((Object)iterator)).getAsJsonArray()) {
                    this.write(jsonWriter, jsonElement);
                }
                jsonWriter.endArray();
                return;
            }
            if (((JsonElement)((Object)iterator)).isJsonObject()) {
                jsonWriter.beginObject();
                for (Map.Entry<String, JsonElement> entry : ((JsonElement)((Object)iterator)).getAsJsonObject().entrySet()) {
                    jsonWriter.name(entry.getKey());
                    this.write(jsonWriter, entry.getValue());
                }
                jsonWriter.endObject();
                return;
            }
            throw new IllegalArgumentException(z + iterator.getClass());
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block10: {
                int n2;
                int n3;
                char[] cArray2;
                int n4;
                block9: {
                    char[] cArray3 = "q\u001e\u001d\u0002\u001d\\V\u001cN\u000e@\u0018\u001c\u000bY".toCharArray();
                    n4 = 0;
                    int n5 = cArray3.length;
                    cArray2 = cArray3;
                    n3 = n5;
                    if (n5 <= 1) break block9;
                    cArray = cArray2;
                    n2 = n3;
                    if (n3 <= n4) break block10;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n6 = n4;
                    while (true) {
                        int n7;
                        char c2 = cArray4[n6];
                        switch (n4 % 5) {
                            case 0: {
                                n7 = 50;
                                break;
                            }
                            case 1: {
                                n7 = 113;
                                break;
                            }
                            case 2: {
                                n7 = 104;
                                break;
                            }
                            case 3: {
                                n7 = 110;
                                break;
                            }
                            default: {
                                n7 = 121;
                            }
                        }
                        cArray4[n6] = (char)(c2 ^ n7);
                        ++n4;
                        cArray2 = cArray5;
                        n3 = n3;
                        if (n3 != 0) break;
                        cArray5 = cArray2;
                        n2 = n3;
                        n6 = n3;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n2 = n3;
                } while (n3 > n4);
            }
            z = new String(cArray).intern();
        }
    };
    public static final TypeAdapterFactory JSON_ELEMENT_FACTORY = TypeAdapters.newTypeHierarchyFactory(JsonElement.class, JSON_ELEMENT);
    public static final TypeAdapterFactory ENUM_FACTORY = new TypeAdapterFactory(){

        @Override
        public final <T> TypeAdapter<T> create(Gson clazz, TypeToken<T> typeToken) {
            clazz = typeToken.getRawType();
            if (!Enum.class.isAssignableFrom(clazz) || clazz == Enum.class) {
                return null;
            }
            if (!clazz.isEnum()) {
                clazz = clazz.getSuperclass();
            }
            return new EnumTypeAdapter(clazz);
        }
    };

    private TypeAdapters() {
        throw new UnsupportedOperationException();
    }

    public static <TT> TypeAdapterFactory newFactory(final TypeToken<TT> typeToken, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken2) {
                if (typeToken2.equals(typeToken)) {
                    return typeAdapter;
                }
                return null;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){
            private static final String[] z;

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (typeToken.getRawType() == clazz) {
                    return typeAdapter;
                }
                return null;
            }

            public final String toString() {
                return z[0] + clazz.getName() + z[1] + typeAdapter + "]";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "-8\u001b\u0005M\u0019 #\u0005[\u001b<E";
                int n3 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 107;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 89;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 120;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 113;
                                        break;
                                    }
                                    default: {
                                        n9 = 34;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = "G8\u001c\u0010R\u001f<\nL";
                            n3 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactory(final Class<TT> clazz, final Class<TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){
            private static final String[] z;

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.getRawType();
                if (clazz3 == clazz || clazz3 == clazz2) {
                    return typeAdapter;
                }
                return null;
            }

            public final String toString() {
                return z[1] + clazz2.getName() + "+" + clazz.getName() + z[0] + typeAdapter + "]";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "F\f\u001f\u0007\u0012\u001e\b\t[";
                int n3 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 106;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 109;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 123;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 102;
                                        break;
                                    }
                                    default: {
                                        n9 = 98;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = ",\f\u0018\u0012\r\u0018\u0014 \u0012\u001b\u001a\bF";
                            n3 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }

    public static <TT> TypeAdapterFactory newFactoryForMultipleTypes(final Class<TT> clazz, final Class<? extends TT> clazz2, final TypeAdapter<? super TT> typeAdapter) {
        return new TypeAdapterFactory(){
            private static final String[] z;

            @Override
            public final <T> TypeAdapter<T> create(Gson clazz3, TypeToken<T> typeToken) {
                clazz3 = typeToken.getRawType();
                if (clazz3 == clazz || clazz3 == clazz2) {
                    return typeAdapter;
                }
                return null;
            }

            public final String toString() {
                return z[0] + clazz.getName() + "+" + clazz2.getName() + z[1] + typeAdapter + "]";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "+Zke9\u001fBSe/\u001d^5";
                int n3 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 109;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 59;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 8;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 17;
                                        break;
                                    }
                                    default: {
                                        n9 = 86;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = "AZlp&\u0019^z,";
                            n3 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }

    public static <TT> TypeAdapterFactory newTypeHierarchyFactory(final Class<TT> clazz, final TypeAdapter<TT> typeAdapter) {
        return new TypeAdapterFactory(){
            private static final String[] z;

            @Override
            public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
                if (clazz.isAssignableFrom(typeToken.getRawType())) {
                    return typeAdapter;
                }
                return null;
            }

            public final String toString() {
                return z[0] + clazz.getName() + z[1] + typeAdapter + "]";
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                String string;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n2 = 0;
                String string2 = "\"F&Me\u0016^\u001eMs\u0014B\rPo\u0016F7Zb\u001d\u001a";
                int n3 = -1;
                block9: while (true) {
                    char[] cArray;
                    block14: {
                        int n4;
                        int n5;
                        char[] cArray2;
                        int n6;
                        block13: {
                            char[] cArray3 = string2.toCharArray();
                            n6 = 0;
                            int n7 = cArray3.length;
                            cArray2 = cArray3;
                            n5 = n7;
                            if (n7 <= 1) break block13;
                            cArray = cArray2;
                            n4 = n5;
                            if (n5 <= n6) break block14;
                        }
                        do {
                            char[] cArray4 = cArray2;
                            char[] cArray5 = cArray2;
                            int n8 = n6;
                            while (true) {
                                int n9;
                                char c2 = cArray4[n8];
                                switch (n6 % 5) {
                                    case 0: {
                                        n9 = 100;
                                        break;
                                    }
                                    case 1: {
                                        n9 = 39;
                                        break;
                                    }
                                    case 2: {
                                        n9 = 69;
                                        break;
                                    }
                                    case 3: {
                                        n9 = 57;
                                        break;
                                    }
                                    default: {
                                        n9 = 10;
                                    }
                                }
                                cArray4[n8] = (char)(c2 ^ n9);
                                ++n6;
                                cArray2 = cArray5;
                                n5 = n5;
                                if (n5 != 0) break;
                                cArray5 = cArray2;
                                n4 = n5;
                                n8 = n5;
                                cArray4 = cArray2;
                            }
                            cArray = cArray2;
                            n4 = n5;
                        } while (n5 > n6);
                    }
                    string = new String(cArray);
                    switch (n3) {
                        default: {
                            stringArray2[n2] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n2 = 1;
                            string2 = "HF!Xz\u0010B7\u0004";
                            n3 = 0;
                            continue block9;
                        }
                        case 0: 
                    }
                    break;
                }
                stringArray2[n2] = string.intern();
                z = stringArray3;
            }
        };
    }

    private static final class EnumTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final Map<String, T> nameToConstant = new HashMap<String, T>();
        private final Map<T, String> constantToName = new HashMap<T, String>();

        public EnumTypeAdapter(Class<T> clazz) {
            try {
                for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                    String string = enum_.name();
                    String[] stringArray = clazz.getField(string).getAnnotation(SerializedName.class);
                    if (stringArray != null) {
                        string = stringArray.value();
                        for (String string2 : stringArray.alternate()) {
                            this.nameToConstant.put(string2, enum_);
                        }
                    }
                    this.nameToConstant.put(string, enum_);
                    this.constantToName.put(enum_, string);
                }
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError();
            }
        }

        @Override
        public final T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            return (T)((Enum)this.nameToConstant.get(jsonReader.nextString()));
        }

        @Override
        public final void write(JsonWriter jsonWriter, T t2) throws IOException {
            jsonWriter.value(t2 == null ? null : this.constantToName.get(t2));
        }
    }
}

