/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.reflect;

import com.google.gson.jpush.internal.$Gson$Preconditions;
import com.google.gson.jpush.internal.$Gson$Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class TypeToken<T> {
    final Class<? super T> rawType;
    final Type type;
    final int hashCode;
    private static final String[] z;

    protected TypeToken() {
        this.type = TypeToken.getSuperclassTypeParameter(this.getClass());
        this.rawType = $Gson$Types.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    TypeToken(Type type) {
        this.type = $Gson$Types.canonicalize($Gson$Preconditions.checkNotNull(type));
        this.rawType = $Gson$Types.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    static Type getSuperclassTypeParameter(Class<?> type) {
        if ((type = type.getGenericSuperclass()) instanceof Class) {
            throw new RuntimeException(z[0]);
        }
        return $Gson$Types.canonicalize(((ParameterizedType)type).getActualTypeArguments()[0]);
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    @Deprecated
    public boolean isAssignableFrom(Class<?> clazz) {
        return this.isAssignableFrom((Type)clazz);
    }

    @Deprecated
    public boolean isAssignableFrom(Type type) {
        if (type == null) {
            return false;
        }
        if (this.type.equals(type)) {
            return true;
        }
        if (this.type instanceof Class) {
            return this.rawType.isAssignableFrom($Gson$Types.getRawType(type));
        }
        if (this.type instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(type, (ParameterizedType)this.type, new HashMap<String, Type>());
        }
        if (this.type instanceof GenericArrayType) {
            return this.rawType.isAssignableFrom($Gson$Types.getRawType(type)) && TypeToken.isAssignableFrom(type, (GenericArrayType)this.type);
        }
        throw TypeToken.buildUnexpectedTypeError(this.type, Class.class, ParameterizedType.class, GenericArrayType.class);
    }

    @Deprecated
    public boolean isAssignableFrom(TypeToken<?> typeToken) {
        return this.isAssignableFrom(typeToken.getType());
    }

    private static boolean isAssignableFrom(Type clazz, GenericArrayType type) {
        if ((type = type.getGenericComponentType()) instanceof ParameterizedType) {
            Class<?> clazz2 = clazz;
            if (clazz instanceof GenericArrayType) {
                clazz2 = ((GenericArrayType)((Object)clazz)).getGenericComponentType();
            } else if (clazz instanceof Class) {
                clazz = clazz;
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                clazz2 = clazz;
            }
            return TypeToken.isAssignableFrom(clazz2, (ParameterizedType)type, new HashMap<String, Type>());
        }
        return true;
    }

    private static boolean isAssignableFrom(Type object, ParameterizedType parameterizedType, Map<String, Type> map) {
        while (object != null) {
            int n2;
            if (parameterizedType.equals(object)) {
                return true;
            }
            Class<?> clazz = $Gson$Types.getRawType((Type)object);
            ParameterizedType parameterizedType2 = null;
            if (object instanceof ParameterizedType) {
                parameterizedType2 = (ParameterizedType)object;
            }
            if (parameterizedType2 != null) {
                object = parameterizedType2.getActualTypeArguments();
                TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
                for (n2 = 0; n2 < ((Type[])object).length; ++n2) {
                    Type type = object[n2];
                    TypeVariable<Class<?>> typeVariable = typeVariableArray[n2];
                    while (type instanceof TypeVariable) {
                        type = (TypeVariable)type;
                        type = map.get(type.getName());
                    }
                    map.put(typeVariable.getName(), type);
                }
                if (TypeToken.typeEquals(parameterizedType2, parameterizedType, map)) {
                    return true;
                }
            }
            object = clazz.getGenericInterfaces();
            int n3 = ((Type[])object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (!TypeToken.isAssignableFrom(object[n2], parameterizedType, new HashMap<String, Type>(map))) continue;
                return true;
            }
            map = new HashMap<String, Type>(map);
            object = clazz.getGenericSuperclass();
        }
        return false;
    }

    private static boolean typeEquals(ParameterizedType typeArray, ParameterizedType typeArray2, Map<String, Type> map) {
        if (typeArray.getRawType().equals(typeArray2.getRawType())) {
            typeArray = typeArray.getActualTypeArguments();
            typeArray2 = typeArray2.getActualTypeArguments();
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                if (TypeToken.matches(typeArray[i2], typeArray2[i2], map)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static AssertionError buildUnexpectedTypeError(Type type, Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder(z[2]);
        for (Class<?> clazz : classArray) {
            stringBuilder.append(clazz.getName()).append(z[1]);
        }
        stringBuilder.append(z[4]).append(type.getClass().getName()).append(z[3]).append(type.toString()).append('.');
        return new AssertionError((Object)stringBuilder.toString());
    }

    private static boolean matches(Type type, Type type2, Map<String, Type> map) {
        return type2.equals(type) || type instanceof TypeVariable && type2.equals(map.get(((TypeVariable)type).getName()));
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        return object instanceof TypeToken && $Gson$Types.equals(this.type, ((TypeToken)object).type);
    }

    public final String toString() {
        return $Gson$Types.typeToString(this.type);
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken(type);
    }

    public static <T> TypeToken<T> get(Class<T> clazz) {
        return new TypeToken<T>(clazz);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "t\u00185i&W\u0016fn6I\u0014fj.K\u0010+\u007f;\\\u0003h";
        int n3 = -1;
        block12: while (true) {
            char[] cArray;
            block17: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block16: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block16;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block17;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 57;
                                break;
                            }
                            case 1: {
                                n9 = 113;
                                break;
                            }
                            case 2: {
                                n9 = 70;
                                break;
                            }
                            case 3: {
                                n9 = 26;
                                break;
                            }
                            default: {
                                n9 = 79;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0015Q";
                    n3 = 0;
                    continue block12;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "l\u001f#b?\\\u00122\u007f+\u0019\u0005?j*\u0017Q\u0003b?\\\u00122\u007f+\u0019\u001e(\u007foV\u0017|:";
                    n3 = 1;
                    continue block12;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0015Q u=\u0019\u0005?j*\u0019\u0005)q*WKf";
                    n3 = 2;
                    continue block12;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "[\u00042:(V\u0005|:";
                    n3 = 3;
                    continue block12;
                }
                case 3: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

