/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.jpush.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;

public class JsonWriter
implements Closeable,
Flushable {
    private static final String[] REPLACEMENT_CHARS;
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;
    private static final String[] z;

    public JsonWriter(Writer writer) {
        this.push(6);
        this.separator = ":";
        this.serializeNulls = true;
        if (writer == null) {
            throw new NullPointerException(z[4]);
        }
        this.out = writer;
    }

    public final void setIndent(String string) {
        if (string.length() == 0) {
            this.indent = null;
            this.separator = ":";
            return;
        }
        this.indent = string;
        this.separator = z[2];
    }

    public final void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public final void setHtmlSafe(boolean bl) {
        this.htmlSafe = bl;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public final void setSerializeNulls(boolean bl) {
        this.serializeNulls = bl;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, "[");
    }

    public JsonWriter endArray() throws IOException {
        return this.close(1, 2, "]");
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, "{");
    }

    public JsonWriter endObject() throws IOException {
        return this.close(3, 5, "}");
    }

    private JsonWriter open(int n2, String string) throws IOException {
        this.beforeValue(true);
        this.push(n2);
        this.out.write(string);
        return this;
    }

    private JsonWriter close(int n2, int n3, String string) throws IOException {
        int n4 = this.peek();
        if (n4 != n3 && n4 != n2) {
            throw new IllegalStateException(z[10]);
        }
        if (this.deferredName != null) {
            throw new IllegalStateException(z[9] + this.deferredName);
        }
        --this.stackSize;
        if (n4 == n3) {
            this.newline();
        }
        this.out.write(string);
        return this;
    }

    private void push(int n2) {
        if (this.stackSize == this.stack.length) {
            int[] nArray = new int[this.stackSize * 2];
            System.arraycopy(this.stack, 0, nArray, 0, this.stackSize);
            this.stack = nArray;
        }
        this.stack[this.stackSize++] = n2;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException(z[0]);
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int n2) {
        this.stack[this.stackSize - 1] = n2;
    }

    public JsonWriter name(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException(z[1]);
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException(z[0]);
        }
        this.deferredName = string;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter value(String string) throws IOException {
        if (string == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.string(string);
        return this;
    }

    public JsonWriter jsonValue(String string) throws IOException {
        if (string == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.append(string);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue(false);
        this.out.write(z[17]);
        return this;
    }

    public JsonWriter value(boolean bl) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write(bl ? z[5] : z[6]);
        return this;
    }

    public JsonWriter value(double d2) throws IOException {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(z[13] + d2);
        }
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.append(Double.toString(d2));
        return this;
    }

    public JsonWriter value(long l2) throws IOException {
        this.writeDeferredName();
        this.beforeValue(false);
        this.out.write(Long.toString(l2));
        return this;
    }

    public JsonWriter value(Number number) throws IOException {
        if (number == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = number.toString();
        if (!this.lenient && (string.equals(z[16]) || string.equals(z[14]) || string.equals(z[15]))) {
            throw new IllegalArgumentException(z[13] + number);
        }
        this.beforeValue(false);
        this.out.append(string);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException(z[0]);
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int n2 = this.stackSize;
        if (n2 > 1 || n2 == 1 && this.stack[n2 - 1] != 7) {
            throw new IOException(z[3]);
        }
        this.stackSize = 0;
    }

    private void string(String string) throws IOException {
        String[] stringArray = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write("\"");
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            String string2;
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                string2 = stringArray[c2];
                if (string2 == null) {
                    continue;
                }
            } else if (c2 == '\u2028') {
                string2 = z[8];
            } else {
                if (c2 != '\u2029') continue;
                string2 = z[7];
            }
            if (n2 < i2) {
                this.out.write(string, n2, i2 - n2);
            }
            this.out.write(string2);
            n2 = i2 + 1;
        }
        if (n2 < n3) {
            this.out.write(string, n2, n3 - n2);
        }
        this.out.write("\"");
    }

    private void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write("\n");
        int n2 = this.stackSize;
        for (int i2 = 1; i2 < n2; ++i2) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int n2 = this.peek();
        if (n2 == 5) {
            this.out.write(44);
        } else if (n2 != 3) {
            throw new IllegalStateException(z[10]);
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue(boolean bl) throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException(z[12]);
                }
            }
            case 6: {
                if (!this.lenient && !bl) {
                    throw new IllegalStateException(z[11]);
                }
                this.replaceTop(7);
                return;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                return;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                return;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                return;
            }
        }
        throw new IllegalStateException(z[10]);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block70: {
            block69: {
                v0 = new String[18];
                v1 = v0;
                v2 = v0;
                v3 = 0;
                v4 = "r' Q\nJ=;Z/\u0018=<\u001f>T;<Z9\u0016";
                v5 = -1;
                break block69;
lbl8:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 1;
                    v4 = "V5\"Z}\u0005ioQ(T8";
                    v5 = 0;
                    break block69;
                    break;
                }
lbl16:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 2;
                    v4 = "\u0002t";
                    v5 = 1;
                    break block69;
                    break;
                }
lbl24:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 3;
                    v4 = "q:,P0H8*K8\u00180 \\(U1!K";
                    v5 = 2;
                    break block69;
                    break;
                }
lbl32:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 4;
                    v4 = "W!;\u001f`\u0005t!J1T";
                    v5 = 3;
                    break block69;
                    break;
                }
lbl40:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 5;
                    v4 = "L&:Z";
                    v5 = 4;
                    break block69;
                    break;
                }
lbl48:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 6;
                    v4 = "^5#L8";
                    v5 = 5;
                    break block69;
                    break;
                }
lbl56:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 7;
                    v4 = "d!}\u000fo\u0001";
                    v5 = 6;
                    break block69;
                    break;
                }
lbl64:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 8;
                    v4 = "d!}\u000fo\u0000";
                    v5 = 7;
                    break block69;
                    break;
                }
lbl72:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 9;
                    v4 = "|5!X1Q:(\u001f3Y9*\u0005}";
                    v5 = 8;
                    break block69;
                    break;
                }
lbl80:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 10;
                    v4 = "v1<K4V3oO/W6#Z0\u0016";
                    v5 = 9;
                    break block69;
                    break;
                }
lbl88:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 11;
                    v4 = "r\u0007\u0000q}U!<K}K .M)\u0018#&K5\u00185!\u001f<J&.F}W&o^3\u0018;-U8[ a";
                    v5 = 10;
                    break block69;
                    break;
                }
lbl96:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 12;
                    v4 = "r\u0007\u0000q}U!<K}P59Z}W:#F}W:*\u001f)W$bS8N1#\u001f+Y8:Zs";
                    v5 = 11;
                    break block69;
                    break;
                }
lbl104:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 13;
                    v4 = "v!\"Z/Q7oI<T!*L}U!<K}Z1oY4V=;Zq\u00186:K}O5<\u001f";
                    v5 = 12;
                    break block69;
                    break;
                }
lbl112:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 14;
                    v4 = "q:)V3Q 6";
                    v5 = 13;
                    break block69;
                    break;
                }
lbl120:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 15;
                    v4 = "v5\u0001";
                    v5 = 14;
                    break block69;
                    break;
                }
lbl128:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 16;
                    v4 = "\u0015\u001d!Y4V=;F";
                    v5 = 15;
                    break block69;
                    break;
                }
lbl136:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 17;
                    v4 = "V!#S";
                    v5 = 16;
                    break block69;
                    break;
                }
lbl144:
                // 1 sources

                while (true) {
                    continue;
                    break;
                }
            }
            v7 = v4.toCharArray();
            var1 = 0;
            v8 = v7.length;
            v9 = v7;
            v10 = v8;
            if (v8 > 1) ** GOTO lbl184
            do {
                v11 = v9;
                v12 = v9;
                v13 = var1;
                while (true) {
                    v14 = v11[v13];
                    switch (var1 % 5) {
                        case 0: {
                            v15 = 56;
                            break;
                        }
                        case 1: {
                            v15 = 84;
                            break;
                        }
                        case 2: {
                            v15 = 79;
                            break;
                        }
                        case 3: {
                            v15 = 63;
                            break;
                        }
                        default: {
                            v15 = 93;
                        }
                    }
                    v11[v13] = (char)(v14 ^ v15);
                    ++var1;
                    v9 = v12;
                    v10 = v10;
                    if (v10 != 0) break;
                    v12 = v9;
                    v16 = v10;
                    v13 = v10;
                    v11 = v9;
                }
lbl184:
                // 2 sources

                v17 = v9;
                v16 = v10;
            } while (v10 > var1);
            v6 = new String(v17);
            switch (v5) {
                default: {
                    ** continue;
                }
                case 0: {
                    ** continue;
                }
                case 1: {
                    ** continue;
                }
                case 2: {
                    ** continue;
                }
                case 3: {
                    ** continue;
                }
                case 4: {
                    ** continue;
                }
                case 5: {
                    ** continue;
                }
                case 6: {
                    ** continue;
                }
                case 7: {
                    ** continue;
                }
                case 8: {
                    ** continue;
                }
                case 9: {
                    ** continue;
                }
                case 10: {
                    ** continue;
                }
                case 11: {
                    ** continue;
                }
                case 12: {
                    ** continue;
                }
                case 13: {
                    ** continue;
                }
                case 14: {
                    ** continue;
                }
                case 15: {
                    ** continue;
                }
                ** case 16:
lbl225:
                // 1 sources

                ** continue;
            }
lbl226:
            // 13 sources

            while (true) {
                v18 = v19.toCharArray();
                var1 = 0;
                v20 = v18.length;
                v21 = v18;
                v22 = v20;
                if (v20 > 1) ** GOTO lbl264
                do {
                    v23 = v21;
                    v24 = v21;
                    v25 = var1;
                    while (true) {
                        v26 = v23[v25];
                        switch (var1 % 5) {
                            case 0: {
                                v27 = 56;
                                break;
                            }
                            case 1: {
                                v27 = 84;
                                break;
                            }
                            case 2: {
                                v27 = 79;
                                break;
                            }
                            case 3: {
                                v27 = 63;
                                break;
                            }
                            default: {
                                v27 = 93;
                            }
                        }
                        v23[v25] = (char)(v26 ^ v27);
                        ++var1;
                        v21 = v24;
                        v22 = v22;
                        if (v22 != 0) break;
                        v24 = v21;
                        v28 = v22;
                        v25 = v22;
                        v23 = v21;
                    }
lbl264:
                    // 2 sources

                    v29 = v21;
                    v28 = v22;
                } while (v22 > var1);
                v30 = new String(v29).intern();
                break block70;
                break;
            }
            v1[v3] = v6.intern();
            JsonWriter.z = v2;
            JsonWriter.REPLACEMENT_CHARS = new String[128];
            var0_1 = 0;
lbl274:
            // 2 sources

            while (var0_1 <= 31) {
                v31 = JsonWriter.REPLACEMENT_CHARS;
                v32 = var0_1;
                v19 = "d!j\u000fi@";
                v33 = -1;
                ** GOTO lbl226
            }
            ** GOTO lbl287
        }
        switch (v33) {
            default: {
                v31[v32] = String.format(v30, new Object[]{var0_1});
                ++var0_1;
                ** GOTO lbl274
            }
lbl287:
            // 1 sources

            v31 = JsonWriter.REPLACEMENT_CHARS;
            v32 = 34;
            v19 = "dv";
            v33 = 0;
            ** GOTO lbl226
            case 0: {
                v31[v32] = v30;
                v31 = JsonWriter.REPLACEMENT_CHARS;
                v32 = 92;
                v19 = "d\b";
                v33 = 1;
                ** GOTO lbl226
            }
            case 1: {
                v31[v32] = v30;
                v31 = JsonWriter.REPLACEMENT_CHARS;
                v32 = 9;
                v19 = "d ";
                v33 = 2;
                ** GOTO lbl226
            }
            case 2: {
                v31[v32] = v30;
                v31 = JsonWriter.REPLACEMENT_CHARS;
                v32 = 8;
                v19 = "d6";
                v33 = 3;
                ** GOTO lbl226
            }
            case 3: {
                v31[v32] = v30;
                v31 = JsonWriter.REPLACEMENT_CHARS;
                v32 = 10;
                v19 = "d:";
                v33 = 4;
                ** GOTO lbl226
            }
            case 4: {
                v31[v32] = v30;
                v31 = JsonWriter.REPLACEMENT_CHARS;
                v32 = 13;
                v19 = "d&";
                v33 = 5;
                ** GOTO lbl226
            }
            case 5: {
                v31[v32] = v30;
                v31 = JsonWriter.REPLACEMENT_CHARS;
                v32 = 12;
                v19 = "d2";
                v33 = 6;
                ** GOTO lbl226
            }
            case 6: {
                v31[v32] = v30;
                v31 = (String[])JsonWriter.REPLACEMENT_CHARS.clone();
                v32 = 60;
                v19 = "d!\u007f\u000fn[";
                v33 = 7;
                ** GOTO lbl226
            }
            case 7: {
                v31[v32] = v30;
                v31 = JsonWriter.HTML_SAFE_REPLACEMENT_CHARS;
                v32 = 62;
                v19 = "d!\u007f\u000fn]";
                v33 = 8;
                ** GOTO lbl226
            }
            case 8: {
                v31[v32] = v30;
                v31 = JsonWriter.HTML_SAFE_REPLACEMENT_CHARS;
                v32 = 38;
                v19 = "d!\u007f\u000fo\u000e";
                v33 = 9;
                ** GOTO lbl226
            }
            case 9: {
                v31[v32] = v30;
                v31 = JsonWriter.HTML_SAFE_REPLACEMENT_CHARS;
                v32 = 61;
                v19 = "d!\u007f\u000fn\\";
                v33 = 10;
                ** GOTO lbl226
            }
            case 10: {
                v31[v32] = v30;
                v31 = JsonWriter.HTML_SAFE_REPLACEMENT_CHARS;
                v32 = 39;
                v19 = "d!\u007f\u000fo\u000f";
                v33 = 11;
                ** continue;
            }
            case 11: 
        }
        v31[v32] = v30;
    }
}

