/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.jpush;

import com.google.protobuf.jpush.ByteString;
import com.google.protobuf.jpush.ExtensionRegistryLite;
import com.google.protobuf.jpush.InvalidProtocolBufferException;
import com.google.protobuf.jpush.MessageLite;
import com.google.protobuf.jpush.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public final class CodedInputStream {
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    private int recursionDepth;
    private int recursionLimit = 64;
    private int sizeLimit = 0x4000000;
    private static final int DEFAULT_RECURSION_LIMIT = 64;
    private static final int DEFAULT_SIZE_LIMIT = 0x4000000;
    private static final int BUFFER_SIZE = 4096;
    private static final String[] z;

    public static CodedInputStream newInstance(InputStream inputStream) {
        return new CodedInputStream(inputStream);
    }

    public static CodedInputStream newInstance(byte[] byArray) {
        return CodedInputStream.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInputStream newInstance(byte[] object, int n2, int n3) {
        object = new CodedInputStream((byte[])object, n2, n3);
        try {
            ((CodedInputStream)object).pushLimit(n3);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw new IllegalArgumentException(invalidProtocolBufferException);
        }
        return object;
    }

    public final int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    public final void checkLastTagWas(int n2) throws InvalidProtocolBufferException {
        if (this.lastTag != n2) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    public final boolean skipField(int n2) throws IOException {
        switch (WireFormat.getTagWireType(n2)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    public final void skipMessage() throws IOException {
        int n2;
        while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
        }
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public final long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public final long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public final int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public final long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public final int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public final boolean readBool() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public final String readString() throws IOException {
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - this.bufferPos && n2 > 0) {
            String string = new String(this.buffer, this.bufferPos, n2, z[2]);
            this.bufferPos += n2;
            return string;
        }
        return new String(this.readRawBytes(n2), z[2]);
    }

    public final void readGroup(int n2, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(WireFormat.makeTag(n2, 4));
        --this.recursionDepth;
    }

    @Deprecated
    public final void readUnknownGroup(int n2, MessageLite.Builder builder) throws IOException {
        this.readGroup(n2, builder, null);
    }

    public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        int n2 = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        n2 = this.pushLimit(n2);
        ++this.recursionDepth;
        builder.mergeFrom(this, extensionRegistryLite);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit(n2);
    }

    public final ByteString readBytes() throws IOException {
        int n2 = this.readRawVarint32();
        if (n2 == 0) {
            return ByteString.EMPTY;
        }
        if (n2 <= this.bufferSize - this.bufferPos && n2 > 0) {
            ByteString byteString = ByteString.copyFrom(this.buffer, this.bufferPos, n2);
            this.bufferPos += n2;
            return byteString;
        }
        return ByteString.copyFrom(this.readRawBytes(n2));
    }

    public final int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public final int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public final int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public final long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public final int readSInt32() throws IOException {
        return CodedInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public final long readSInt64() throws IOException {
        return CodedInputStream.decodeZigZag64(this.readRawVarint64());
    }

    public final int readRawVarint32() throws IOException {
        int n2 = this.readRawByte();
        if (n2 >= 0) {
            return n2;
        }
        int n3 = n2 & 0x7F;
        n2 = this.readRawByte();
        if (n2 >= 0) {
            n3 |= n2 << 7;
        } else {
            n3 |= (n2 & 0x7F) << 7;
            n2 = this.readRawByte();
            if (n2 >= 0) {
                n3 |= n2 << 14;
            } else {
                n3 |= (n2 & 0x7F) << 14;
                n2 = this.readRawByte();
                if (n2 >= 0) {
                    n3 |= n2 << 21;
                } else {
                    int n4 = n3 | (n2 & 0x7F) << 21;
                    n2 = this.readRawByte();
                    n3 = n4 | n2 << 28;
                    if (n2 < 0) {
                        for (n2 = 0; n2 < 5; ++n2) {
                            if (this.readRawByte() < 0) continue;
                            return n3;
                        }
                        throw InvalidProtocolBufferException.malformedVarint();
                    }
                }
            }
        }
        return n3;
    }

    static int readRawVarint32(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return CodedInputStream.readRawVarint32(n2, inputStream);
    }

    public static int readRawVarint32(int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4;
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        n2 &= 0x7F;
        for (n4 = 7; n4 < 32; n4 += 7) {
            n3 = inputStream.read();
            if (n3 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            n2 |= (n3 & 0x7F) << n4;
            if ((n3 & 0x80) != 0) continue;
            return n2;
        }
        while (n4 < 64) {
            n3 = inputStream.read();
            if (n3 == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n3 & 0x80) == 0) {
                return n2;
            }
            n4 += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public final long readRawVarint64() throws IOException {
        long l2 = 0L;
        for (int i2 = 0; i2 < 64; i2 += 7) {
            byte by = this.readRawByte();
            l2 |= (long)(by & 0x7F) << i2;
            if ((by & 0x80) != 0) continue;
            return l2;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    public final int readRawLittleEndian32() throws IOException {
        byte by = this.readRawByte();
        byte by2 = this.readRawByte();
        byte by3 = this.readRawByte();
        byte by4 = this.readRawByte();
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    public final long readRawLittleEndian64() throws IOException {
        byte by = this.readRawByte();
        byte by2 = this.readRawByte();
        byte by3 = this.readRawByte();
        byte by4 = this.readRawByte();
        byte by5 = this.readRawByte();
        byte by6 = this.readRawByte();
        byte by7 = this.readRawByte();
        byte by8 = this.readRawByte();
        return (long)by & 0xFFL | ((long)by2 & 0xFFL) << 8 | ((long)by3 & 0xFFL) << 16 | ((long)by4 & 0xFFL) << 24 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 40 | ((long)by7 & 0xFFL) << 48 | ((long)by8 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n2) {
        return n2 >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long l2) {
        return l2 >>> 1 ^ -(l2 & 1L);
    }

    private CodedInputStream(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.bufferSize = n2 + n3;
        this.bufferPos = n2;
        this.totalBytesRetired = -n2;
        this.input = null;
    }

    private CodedInputStream(InputStream inputStream) {
        this.buffer = new byte[4096];
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.totalBytesRetired = 0;
        this.input = inputStream;
    }

    public final int setRecursionLimit(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(z[0] + n2);
        }
        int n3 = this.recursionLimit;
        this.recursionLimit = n2;
        return n3;
    }

    public final int setSizeLimit(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(z[1] + n2);
        }
        int n3 = this.sizeLimit;
        this.sizeLimit = n2;
        return n3;
    }

    public final void resetSizeCounter() {
        this.totalBytesRetired = -this.bufferPos;
    }

    public final int pushLimit(int n2) throws InvalidProtocolBufferException {
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        int n3 = this.currentLimit;
        if ((n2 += this.totalBytesRetired + this.bufferPos) > n3) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = n2;
        this.recomputeBufferSizeAfterLimit();
        return n3;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int n2 = this.totalBytesRetired + this.bufferSize;
        if (n2 > this.currentLimit) {
            this.bufferSizeAfterLimit = n2 - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
            return;
        }
        this.bufferSizeAfterLimit = 0;
    }

    public final void popLimit(int n2) {
        this.currentLimit = n2;
        this.recomputeBufferSizeAfterLimit();
    }

    public final int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int n2 = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - n2;
    }

    public final boolean isAtEnd() throws IOException {
        return this.bufferPos == this.bufferSize && !this.refillBuffer(false);
    }

    public final int getTotalBytesRead() {
        return this.totalBytesRetired + this.bufferPos;
    }

    private boolean refillBuffer(boolean n2) throws IOException {
        if (this.bufferPos < this.bufferSize) {
            throw new IllegalStateException(z[5]);
        }
        if (this.totalBytesRetired + this.bufferSize == this.currentLimit) {
            if (n2 != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return false;
        }
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        int n3 = this.bufferSize = this.input == null ? -1 : this.input.read(this.buffer);
        if (this.bufferSize == 0 || this.bufferSize < -1) {
            throw new IllegalStateException(z[4] + this.bufferSize + z[3]);
        }
        if (this.bufferSize == -1) {
            this.bufferSize = 0;
            if (n2 != 0) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return false;
        }
        this.recomputeBufferSizeAfterLimit();
        n2 = this.totalBytesRetired + this.bufferSize + this.bufferSizeAfterLimit;
        if (n2 > this.sizeLimit || n2 < 0) {
            throw InvalidProtocolBufferException.sizeLimitExceeded();
        }
        return true;
    }

    public final byte readRawByte() throws IOException {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(true);
        }
        return this.buffer[this.bufferPos++];
    }

    public final byte[] readRawBytes(int n2) throws IOException {
        int n3;
        byte[] byArray;
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n2 > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n2 <= this.bufferSize - this.bufferPos) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.bufferPos, byArray2, 0, n2);
            this.bufferPos += n2;
            return byArray2;
        }
        if (n2 < 4096) {
            byte[] byArray3 = new byte[n2];
            int n4 = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, byArray3, 0, n4);
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (n2 - n4 > this.bufferSize) {
                System.arraycopy(this.buffer, 0, byArray3, n4, this.bufferSize);
                n4 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            System.arraycopy(this.buffer, 0, byArray3, n4, n2 - n4);
            this.bufferPos = n2 - n4;
            return byArray3;
        }
        int n5 = this.bufferPos;
        int n6 = this.bufferSize;
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        this.bufferSize = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i2 = n2 - (n6 - n5); i2 > 0; i2 -= byArray.length) {
            int n7;
            byArray = new byte[Math.min(i2, 4096)];
            for (n3 = 0; n3 < byArray.length; n3 += n7) {
                n7 = this.input == null ? -1 : this.input.read(byArray, n3, byArray.length - n3);
                if (n7 == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                this.totalBytesRetired += n7;
            }
            arrayList.add(byArray);
        }
        byArray = new byte[n2];
        n3 = n6 - n5;
        System.arraycopy(this.buffer, n5, byArray, 0, n3);
        for (byte[] byArray4 : arrayList) {
            System.arraycopy(byArray4, 0, byArray, n3, byArray4.length);
            n3 += byArray4.length;
        }
        return byArray;
    }

    public final void skipRawBytes(int n2) throws IOException {
        if (n2 < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n2 > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (n2 <= this.bufferSize - this.bufferPos) {
            this.bufferPos += n2;
            return;
        }
        int n3 = this.bufferSize - this.bufferPos;
        this.bufferPos = this.bufferSize;
        this.refillBuffer(true);
        while (n2 - n3 > this.bufferSize) {
            n3 += this.bufferSize;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
        }
        this.bufferPos = n2 - n3;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "k\u00026edJ\u000e:~6U\u000e8yb\u0019\u00044~xV\u0013urs\u0019\t0wwM\u000e#u,\u0019";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 57;
                                break;
                            }
                            case 1: {
                                n9 = 103;
                                break;
                            }
                            case 2: {
                                n9 = 85;
                                break;
                            }
                            case 3: {
                                n9 = 16;
                                break;
                            }
                            default: {
                                n9 = 22;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "j\u000e/u6U\u000e8yb\u0019\u00044~xV\u0013urs\u0019\t0wwM\u000e#u,\u0019";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "l3\u0013=.";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "33=u6p\t%ebj\u0013'uwTG<}fU\u00028uxM\u0006!yyWG<c6[\u00122wo\u0017";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "p\t%ebj\u0013'uwTD'uw]O7ib\\<\b96K\u0002!edW\u000210\u007fW\u00114|\u007f]G'ueL\u000b!*6";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "K\u00023yzU% vp\\\u0015}96Z\u00069|s]G\"xsWG7ep_\u0002'0aX\u0014;7b\u0019\u00028`b@I";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

