/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.jpush;

import com.google.protobuf.jpush.ByteString;
import com.google.protobuf.jpush.CodedInputStream;
import com.google.protobuf.jpush.CodedOutputStream;
import com.google.protobuf.jpush.Internal;
import com.google.protobuf.jpush.MessageLite;
import com.google.protobuf.jpush.SmallSortedMap;
import com.google.protobuf.jpush.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<FieldDescriptorType extends FieldDescriptorLite<FieldDescriptorType>> {
    private final SmallSortedMap<FieldDescriptorType, Object> fields;
    private boolean isImmutable;
    private static final FieldSet DEFAULT_INSTANCE;
    private static final String[] z;

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean bl) {
        this.fields = SmallSortedMap.newFieldMap(0);
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public final boolean isImmutable() {
        return this.isImmutable;
    }

    public final FieldSet<FieldDescriptorType> clone() {
        FieldDescriptorLite fieldDescriptorLite;
        FieldSet fieldSet = FieldSet.newFieldSet();
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldDescriptorLite, entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            fieldSet.setField(fieldDescriptorLite, entry.getValue());
        }
        return fieldSet;
    }

    public final void clear() {
        this.fields.clear();
    }

    public final Map<FieldDescriptorType, Object> getAllFields() {
        if (this.fields.isImmutable()) {
            return this.fields;
        }
        return Collections.unmodifiableMap(this.fields);
    }

    public final Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        return this.fields.entrySet().iterator();
    }

    public final boolean hasField(FieldDescriptorType FieldDescriptorType) {
        if (FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException(z[7]);
        }
        return this.fields.get(FieldDescriptorType) != null;
    }

    public final Object getField(FieldDescriptorType FieldDescriptorType) {
        return this.fields.get(FieldDescriptorType);
    }

    public final void setField(FieldDescriptorType FieldDescriptorType, Object object) {
        if (FieldDescriptorType.isRepeated()) {
            if (!(object instanceof List)) {
                throw new IllegalArgumentException(z[1]);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll((List)object);
            for (Object e2 : arrayList) {
                FieldSet.verifyType(FieldDescriptorType.getLiteType(), e2);
            }
            object = arrayList;
        } else {
            FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        }
        this.fields.put(FieldDescriptorType, object);
    }

    public final void clearField(FieldDescriptorType FieldDescriptorType) {
        this.fields.remove(FieldDescriptorType);
    }

    public final int getRepeatedFieldCount(FieldDescriptorType object) {
        if (!object.isRepeated()) {
            throw new IllegalArgumentException(z[0]);
        }
        if ((object = this.fields.get(object)) == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public final Object getRepeatedField(FieldDescriptorType object, int n2) {
        if (!object.isRepeated()) {
            throw new IllegalArgumentException(z[0]);
        }
        if ((object = this.fields.get(object)) == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(n2);
    }

    public final void setRepeatedField(FieldDescriptorType FieldDescriptorType, int n2, Object object) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException(z[0]);
        }
        Object object2 = this.fields.get(FieldDescriptorType);
        if (object2 == null) {
            throw new IndexOutOfBoundsException();
        }
        FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        ((List)object2).set(n2, object);
    }

    public final void addRepeatedField(FieldDescriptorType FieldDescriptorType, Object object) {
        if (!FieldDescriptorType.isRepeated()) {
            throw new IllegalArgumentException(z[6]);
        }
        FieldSet.verifyType(FieldDescriptorType.getLiteType(), object);
        ArrayList<Object> arrayList = this.fields.get(FieldDescriptorType);
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(FieldDescriptorType, (Object)arrayList);
        } else {
            arrayList = arrayList;
        }
        arrayList.add(object);
    }

    private static void verifyType(WireFormat.FieldType fieldType, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        switch (fieldType.getJavaType()) {
            case INT: {
                bl = object instanceof Integer;
                break;
            }
            case LONG: {
                bl = object instanceof Long;
                break;
            }
            case FLOAT: {
                bl = object instanceof Float;
                break;
            }
            case DOUBLE: {
                bl = object instanceof Double;
                break;
            }
            case BOOLEAN: {
                bl = object instanceof Boolean;
                break;
            }
            case STRING: {
                bl = object instanceof String;
                break;
            }
            case BYTE_STRING: {
                bl = object instanceof ByteString;
                break;
            }
            case ENUM: {
                bl = object instanceof Internal.EnumLite;
                break;
            }
            case MESSAGE: {
                bl = object instanceof MessageLite;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException(z[1]);
        }
    }

    public final boolean isInitialized() {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            if (this.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
            return false;
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            if (this.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitialized(Map.Entry<FieldDescriptorType, Object> object) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)object.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (fieldDescriptorLite.isRepeated()) {
                object = ((List)object.getValue()).iterator();
                while (object.hasNext()) {
                    if (((MessageLite)object.next()).isInitialized()) continue;
                    return false;
                }
            } else if (!((MessageLite)object.getValue()).isInitialized()) {
                return false;
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType fieldType, boolean bl) {
        if (bl) {
            return 2;
        }
        return fieldType.getWireType();
    }

    public final void mergeFrom(FieldSet<FieldDescriptorType> object2) {
        for (int i2 = 0; i2 < ((FieldSet)object2).fields.getNumArrayEntries(); ++i2) {
            this.mergeFromField(((FieldSet)object2).fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : ((FieldSet)object2).fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private void mergeFromField(Map.Entry<FieldDescriptorType, Object> object) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)object.getKey();
        object = object.getValue();
        if (fieldDescriptorLite.isRepeated()) {
            Object object2 = this.fields.get(fieldDescriptorLite);
            if (object2 == null) {
                this.fields.put((FieldDescriptorType)fieldDescriptorLite, (Object)new ArrayList((List)object));
                return;
            }
            ((List)object2).addAll((List)object);
            return;
        }
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object object3 = this.fields.get(fieldDescriptorLite);
            if (object3 == null) {
                this.fields.put((FieldDescriptorType)fieldDescriptorLite, object);
                return;
            }
            this.fields.put((FieldDescriptorType)fieldDescriptorLite, (Object)fieldDescriptorLite.internalMergeFrom(((MessageLite)object3).toBuilder(), (MessageLite)object).build());
            return;
        }
        this.fields.put((FieldDescriptorType)fieldDescriptorLite, object);
    }

    public static Object readPrimitiveField(CodedInputStream codedInputStream, WireFormat.FieldType fieldType) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                return codedInputStream.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(codedInputStream.readFloat());
            }
            case INT64: {
                return codedInputStream.readInt64();
            }
            case UINT64: {
                return codedInputStream.readUInt64();
            }
            case INT32: {
                return codedInputStream.readInt32();
            }
            case FIXED64: {
                return codedInputStream.readFixed64();
            }
            case FIXED32: {
                return codedInputStream.readFixed32();
            }
            case BOOL: {
                return codedInputStream.readBool();
            }
            case STRING: {
                return codedInputStream.readString();
            }
            case BYTES: {
                return codedInputStream.readBytes();
            }
            case UINT32: {
                return codedInputStream.readUInt32();
            }
            case SFIXED32: {
                return codedInputStream.readSFixed32();
            }
            case SFIXED64: {
                return codedInputStream.readSFixed64();
            }
            case SINT32: {
                return codedInputStream.readSInt32();
            }
            case SINT64: {
                return codedInputStream.readSInt64();
            }
            case GROUP: {
                throw new IllegalArgumentException(z[5]);
            }
            case MESSAGE: {
                throw new IllegalArgumentException(z[3]);
            }
            case ENUM: {
                throw new IllegalArgumentException(z[4]);
            }
        }
        throw new RuntimeException(z[2]);
    }

    public final void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), codedOutputStream);
        }
    }

    public final void writeMessageSetTo(CodedOutputStream codedOutputStream) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i2), codedOutputStream);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, codedOutputStream);
        }
    }

    private void writeMessageSetTo(Map.Entry<FieldDescriptorType, Object> entry, CodedOutputStream codedOutputStream) throws IOException {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            codedOutputStream.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)entry.getValue());
            return;
        }
        FieldSet.writeField(fieldDescriptorLite, entry.getValue(), codedOutputStream);
    }

    private static void writeElement(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, int n2, Object object) throws IOException {
        if (fieldType == WireFormat.FieldType.GROUP) {
            codedOutputStream.writeGroup(n2, (MessageLite)object);
            return;
        }
        codedOutputStream.writeTag(n2, FieldSet.getWireFormatForFieldType(fieldType, false));
        FieldSet.writeElementNoTag(codedOutputStream, fieldType, object);
    }

    private static void writeElementNoTag(CodedOutputStream codedOutputStream, WireFormat.FieldType fieldType, Object object) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                codedOutputStream.writeDoubleNoTag((Double)object);
                return;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                return;
            }
            case INT64: {
                codedOutputStream.writeInt64NoTag((Long)object);
                return;
            }
            case UINT64: {
                codedOutputStream.writeUInt64NoTag((Long)object);
                return;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag((Integer)object);
                return;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag((Long)object);
                return;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag((Integer)object);
                return;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag((Boolean)object);
                return;
            }
            case STRING: {
                codedOutputStream.writeStringNoTag((String)object);
                return;
            }
            case GROUP: {
                codedOutputStream.writeGroupNoTag((MessageLite)object);
                return;
            }
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)object);
                return;
            }
            case BYTES: {
                codedOutputStream.writeBytesNoTag((ByteString)object);
                return;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag((Integer)object);
                return;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag((Integer)object);
                return;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag((Long)object);
                return;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag((Integer)object);
                return;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((Long)object);
                return;
            }
            case ENUM: {
                codedOutputStream.writeEnumNoTag(((Internal.EnumLite)object).getNumber());
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> object, Object object2, CodedOutputStream codedOutputStream) throws IOException {
        WireFormat.FieldType fieldType = object.getLiteType();
        int n2 = object.getNumber();
        if (object.isRepeated()) {
            object2 = (List)object2;
            if (object.isPacked()) {
                codedOutputStream.writeTag(n2, 2);
                int n3 = 0;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                codedOutputStream.writeRawVarint32(n3);
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object e3 = iterator.next();
                    FieldSet.writeElementNoTag(codedOutputStream, fieldType, e3);
                }
                return;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                Object e4 = object.next();
                FieldSet.writeElement(codedOutputStream, fieldType, n2, e4);
            }
            return;
        }
        FieldSet.writeElement(codedOutputStream, fieldType, n2, object2);
    }

    public final int getSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n2;
    }

    public final int getMessageSetSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            n2 += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            n2 += this.getMessageSetSerializedSize(entry);
        }
        return n2;
    }

    private int getMessageSetSerializedSize(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)entry.getValue());
        }
        return FieldSet.computeFieldSize(fieldDescriptorLite, entry.getValue());
    }

    private static int computeElementSize(WireFormat.FieldType fieldType, int n2, Object object) {
        n2 = CodedOutputStream.computeTagSize(n2);
        if (fieldType == WireFormat.FieldType.GROUP) {
            n2 *= 2;
        }
        return n2 + FieldSet.computeElementSizeNoTag(fieldType, object);
    }

    private static int computeElementSizeNoTag(WireFormat.FieldType fieldType, Object object) {
        switch (fieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)object);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)object).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)object);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)object);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)object);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)object);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)object);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)object);
            }
            case STRING: {
                return CodedOutputStream.computeStringSizeNoTag((String)object);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)object);
            }
            case MESSAGE: {
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)object);
            }
            case BYTES: {
                return CodedOutputStream.computeBytesSizeNoTag((ByteString)object);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)object);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)object);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)object);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)object);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)object);
            }
            case ENUM: {
                return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)object).getNumber());
            }
        }
        throw new RuntimeException(z[2]);
    }

    public static int computeFieldSize(FieldDescriptorLite<?> fieldDescriptorLite, Object iterator) {
        WireFormat.FieldType fieldType = fieldDescriptorLite.getLiteType();
        int n2 = fieldDescriptorLite.getNumber();
        if (fieldDescriptorLite.isRepeated()) {
            if (fieldDescriptorLite.isPacked()) {
                int n3 = 0;
                for (Object e2 : (List)((Object)iterator)) {
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                return n3 + CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeRawVarint32Size(n3);
            }
            int n4 = 0;
            for (Object e3 : (List)((Object)iterator)) {
                n4 += FieldSet.computeElementSize(fieldType, n2, e3);
            }
            return n4;
        }
        return FieldSet.computeElementSize(fieldType, n2, iterator);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "cni^^tn|x^`MtiW`#4,Xee=cUhr=n^$h|`Wao=cU$yx|^e\u007fxh\u001bbbx`_w%";
        int n3 = -1;
        block15: while (true) {
            char[] cArray;
            block20: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block19: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block19;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block20;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 4;
                                break;
                            }
                            case 1: {
                                n9 = 11;
                                break;
                            }
                            case 2: {
                                n9 = 29;
                                break;
                            }
                            case 3: {
                                n9 = 12;
                                break;
                            }
                            default: {
                                n9 = 59;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Syrb\\$d\u007ff^g\u007f=xBtn=yHao={Rpc=|Ik\u007froTh+piHwjzi\u001bvn{`^g\u007ftcU*";
                    n3 = 0;
                    continue block15;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Pcx~^$bn,Uk+jmB$\u007fr,\\a\u007f=d^vn1,Yq\u007f=xSa+~cVtbqiI$\u007fueUox=cOlno{Rwn3";
                    n3 = 1;
                    continue block15;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "vn|hkvbpeOm}xJRagy$\u0012$h|bUk\u007f=dZjoqi\u001baf\u007fi_`ny,Vaxnm\\ax3";
                    n3 = 2;
                    continue block15;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "vn|hkvbpeOm}xJRagy$\u0012$h|bUk\u007f=dZjoqi\u001baehaH*";
                    n3 = 3;
                    continue block15;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "vn|hkvbpeOm}xJRagy$\u0012$h|bUk\u007f=dZjoqi\u001bjnnx^`+z~Tq{n\"";
                    n3 = 4;
                    continue block15;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "eoy^^tn|x^`MtiW`#4,Xee=cUhr=n^$h|`Wao=cU$yx|^e\u007fxh\u001bbbx`_w%";
                    n3 = 5;
                    continue block15;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "ljnJRagy$\u0012$h|b\u001bkequ\u001bfn=oZhgxh\u001bke=bTj&oiKajii_$mtiW`x3";
                    n3 = 6;
                    continue block15;
                }
                case 6: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        DEFAULT_INSTANCE = new FieldSet(true);
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

