/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.jpush;

import com.google.protobuf.jpush.ByteString;
import com.google.protobuf.jpush.Internal;
import com.google.protobuf.jpush.LazyStringList;
import com.google.protobuf.jpush.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractList<String>
implements LazyStringList,
RandomAccess {
    public static final LazyStringList EMPTY = new UnmodifiableLazyStringList(new LazyStringArrayList());
    private final List<Object> list;

    public LazyStringArrayList() {
        this.list = new ArrayList<Object>();
    }

    public LazyStringArrayList(List<String> list) {
        this.list = new ArrayList<String>(list);
    }

    @Override
    public String get(int n2) {
        Object object = this.list.get(n2);
        if (object instanceof String) {
            return (String)object;
        }
        object = (ByteString)object;
        String string = ((ByteString)object).toStringUtf8();
        if (Internal.isValidUtf8((ByteString)object)) {
            this.list.set(n2, string);
        }
        return string;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int n2, String string) {
        Object object = this.list.set(n2, string);
        return this.asString(object);
    }

    @Override
    public void add(int n2, String string) {
        this.list.add(n2, string);
        ++this.modCount;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends String> collection) {
        n2 = this.list.addAll(n2, collection) ? 1 : 0;
        ++this.modCount;
        return n2 != 0;
    }

    @Override
    public String remove(int n2) {
        Object object = this.list.remove(n2);
        ++this.modCount;
        return this.asString(object);
    }

    @Override
    public void clear() {
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString byteString) {
        this.list.add(byteString);
        ++this.modCount;
    }

    @Override
    public ByteString getByteString(int n2) {
        Object object = this.list.get(n2);
        if (object instanceof String) {
            object = ByteString.copyFromUtf8((String)object);
            this.list.set(n2, object);
            return object;
        }
        return (ByteString)object;
    }

    private String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return ((ByteString)object).toStringUtf8();
    }
}

