/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jpush.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.jpush.http.entity.mime.FormBodyPart;
import org.apache.jpush.http.entity.mime.Header;
import org.apache.jpush.http.entity.mime.HttpMultipartMode;
import org.apache.jpush.http.entity.mime.MIME;
import org.apache.jpush.http.entity.mime.MinimalField;

public class HttpMultipart {
    private static final ByteArrayBuffer FIELD_SEP;
    private static final ByteArrayBuffer CR_LF;
    private static final ByteArrayBuffer TWO_DASHES;
    private final String subType;
    private final Charset charset;
    private final String boundary;
    private final List<FormBodyPart> parts;
    private final HttpMultipartMode mode;
    private static final String[] z;

    private static ByteArrayBuffer encode(Charset comparable, String string) {
        comparable = ((Charset)comparable).encode(CharBuffer.wrap(string));
        string = new ByteArrayBuffer(((Buffer)((Object)comparable)).remaining());
        string.append(((ByteBuffer)comparable).array(), ((Buffer)((Object)comparable)).position(), ((Buffer)((Object)comparable)).remaining());
        return string;
    }

    private static void writeBytes(ByteArrayBuffer byteArrayBuffer, OutputStream outputStream) throws IOException {
        outputStream.write(byteArrayBuffer.buffer(), 0, byteArrayBuffer.length());
    }

    private static void writeBytes(String string, Charset charset, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(HttpMultipart.encode(charset, string), outputStream);
    }

    private static void writeBytes(String string, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(HttpMultipart.encode(MIME.DEFAULT_CHARSET, string), outputStream);
    }

    private static void writeField(MinimalField minimalField, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), outputStream);
        HttpMultipart.writeBytes(FIELD_SEP, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    private static void writeField(MinimalField minimalField, Charset charset, OutputStream outputStream) throws IOException {
        HttpMultipart.writeBytes(minimalField.getName(), charset, outputStream);
        HttpMultipart.writeBytes(FIELD_SEP, outputStream);
        HttpMultipart.writeBytes(minimalField.getBody(), charset, outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    public HttpMultipart(String string, Charset charset, String string2, HttpMultipartMode httpMultipartMode) {
        if (string == null) {
            throw new IllegalArgumentException(z[0]);
        }
        if (string2 == null) {
            throw new IllegalArgumentException(z[1]);
        }
        this.subType = string;
        this.charset = charset != null ? charset : MIME.DEFAULT_CHARSET;
        this.boundary = string2;
        this.parts = new ArrayList<FormBodyPart>();
        this.mode = httpMultipartMode;
    }

    public HttpMultipart(String string, Charset charset, String string2) {
        this(string, charset, string2, HttpMultipartMode.STRICT);
    }

    public HttpMultipart(String string, String string2) {
        this(string, null, string2);
    }

    public String getSubType() {
        return this.subType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public HttpMultipartMode getMode() {
        return this.mode;
    }

    public List<FormBodyPart> getBodyParts() {
        return this.parts;
    }

    public void addBodyPart(FormBodyPart formBodyPart) {
        if (formBodyPart == null) {
            return;
        }
        this.parts.add(formBodyPart);
    }

    public String getBoundary() {
        return this.boundary;
    }

    private void doWriteTo(HttpMultipartMode httpMultipartMode, OutputStream outputStream, boolean bl) throws IOException {
        ByteArrayBuffer byteArrayBuffer = HttpMultipart.encode(this.charset, this.getBoundary());
        for (FormBodyPart formBodyPart : this.parts) {
            HttpMultipart.writeBytes(TWO_DASHES, outputStream);
            HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
            HttpMultipart.writeBytes(CR_LF, outputStream);
            Object object = formBodyPart.getHeader();
            switch (httpMultipartMode) {
                case STRICT: {
                    object = ((Header)object).iterator();
                    while (object.hasNext()) {
                        HttpMultipart.writeField((MinimalField)object.next(), outputStream);
                    }
                    break;
                }
                case BROWSER_COMPATIBLE: {
                    HttpMultipart.writeField(formBodyPart.getHeader().getField(z[3]), this.charset, outputStream);
                    if (formBodyPart.getBody().getFilename() == null) break;
                    HttpMultipart.writeField(formBodyPart.getHeader().getField(z[2]), this.charset, outputStream);
                }
            }
            HttpMultipart.writeBytes(CR_LF, outputStream);
            if (bl) {
                formBodyPart.getBody().writeTo(outputStream);
            }
            HttpMultipart.writeBytes(CR_LF, outputStream);
        }
        HttpMultipart.writeBytes(TWO_DASHES, outputStream);
        HttpMultipart.writeBytes(byteArrayBuffer, outputStream);
        HttpMultipart.writeBytes(TWO_DASHES, outputStream);
        HttpMultipart.writeBytes(CR_LF, outputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.doWriteTo(this.mode, outputStream, true);
    }

    public long getTotalLength() {
        long l2 = 0L;
        Object object = this.parts.iterator();
        while (object.hasNext()) {
            long l3 = object.next().getBody().getContentLength();
            if (l3 >= 0L) {
                l2 += l3;
                continue;
            }
            return -1L;
        }
        object = new ByteArrayOutputStream();
        try {
            this.doWriteTo(this.mode, (OutputStream)object, false);
            object = ((ByteArrayOutputStream)object).toByteArray();
            return l2 + (long)((Object)object).length;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String string2;
        int n2;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n3 = 0;
        String string3 = "7.\\\u0011\u0017\n:B\u0011^\t.R\u0011\u0007\n>\u0010\b\u001f\u0003{^\n\nZ9UE\u0010\u000f7\\";
        int n4 = -1;
        block21: while (true) {
            char[] cArray;
            block30: {
                int n5;
                int n6;
                char[] cArray2;
                block29: {
                    char[] cArray3 = string3.toCharArray();
                    n2 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n6 = n7;
                    if (n7 <= 1) break block29;
                    cArray = cArray2;
                    n5 = n6;
                    if (n6 <= n2) break block30;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n2;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n9 = 122;
                                break;
                            }
                            case 1: {
                                n9 = 91;
                                break;
                            }
                            case 2: {
                                n9 = 48;
                                break;
                            }
                            case 3: {
                                n9 = 101;
                                break;
                            }
                            default: {
                                n9 = 126;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n2;
                        cArray2 = cArray5;
                        n6 = n6;
                        if (n6 != 0) break;
                        cArray5 = cArray2;
                        n5 = n6;
                        n8 = n6;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n5 = n6;
                } while (n6 > n2);
            }
            string2 = new String(cArray);
            switch (n4) {
                default: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 1;
                    string3 = "7.\\\u0011\u0017\n:B\u0011^\u00184E\u000b\u001a\u001b)IE\u0013\u001b\"\u0010\u000b\u0011\u000e{R\u0000^\u0014.\\\t";
                    n4 = 0;
                    continue block21;
                }
                case 0: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 2;
                    string3 = "94^\u0011\u001b\u0014/\u001d1\u0007\n>";
                    n4 = 1;
                    continue block21;
                }
                case 1: {
                    stringArray2[n3] = string2.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n3 = 3;
                    string3 = "94^\u0011\u001b\u0014/\u001d!\u0017\t+_\u0016\u0017\u000e2_\u000b";
                    n4 = 2;
                    continue block21;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n3] = string2.intern();
        z = stringArray3;
        Charset charset = MIME.DEFAULT_CHARSET;
        String string4 = "@{";
        int n10 = -1;
        block24: while (true) {
            char[] cArray;
            block32: {
                int n11;
                int n12;
                char[] cArray6;
                block31: {
                    char[] cArray7 = string4.toCharArray();
                    n2 = 0;
                    int n13 = cArray7.length;
                    cArray6 = cArray7;
                    n12 = n13;
                    if (n13 <= 1) break block31;
                    cArray = cArray6;
                    n11 = n12;
                    if (n12 <= n2) break block32;
                }
                do {
                    char[] cArray8 = cArray6;
                    char[] cArray9 = cArray6;
                    int n14 = n2;
                    while (true) {
                        int n15;
                        char c3 = cArray8[n14];
                        switch (n2 % 5) {
                            case 0: {
                                n15 = 122;
                                break;
                            }
                            case 1: {
                                n15 = 91;
                                break;
                            }
                            case 2: {
                                n15 = 48;
                                break;
                            }
                            case 3: {
                                n15 = 101;
                                break;
                            }
                            default: {
                                n15 = 126;
                            }
                        }
                        cArray8[n14] = (char)(c3 ^ n15);
                        ++n2;
                        cArray6 = cArray9;
                        n12 = n12;
                        if (n12 != 0) break;
                        cArray9 = cArray6;
                        n11 = n12;
                        n14 = n12;
                        cArray8 = cArray6;
                    }
                    cArray = cArray6;
                    n11 = n12;
                } while (n12 > n2);
            }
            string = new String(cArray).intern();
            switch (n10) {
                default: {
                    FIELD_SEP = HttpMultipart.encode(charset, string);
                    charset = MIME.DEFAULT_CHARSET;
                    string4 = "wQ";
                    n10 = 0;
                    continue block24;
                }
                case 0: {
                    CR_LF = HttpMultipart.encode(charset, string);
                    charset = MIME.DEFAULT_CHARSET;
                    string4 = "Wv";
                    n10 = 1;
                    continue block24;
                }
                case 1: 
            }
            break;
        }
        TWO_DASHES = HttpMultipart.encode(charset, string);
    }
}

