/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.aidl;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.baidu.speech.EventListener;
import com.baidu.speech.EventManagerFactory;
import com.baidu.speech.aidl.EventManager;
import com.baidu.speech.aidl.EventManagerFactory;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class EventRecognitionService
extends Service {
    private static final String TAG = "EventRecognitionService";
    private long startTime = 0L;
    private boolean asrUsing = false;
    private boolean wpUsing = false;
    private int RESTART_TIME = 3600000;
    private IBinder iBinder = new EventManagerFactory.Stub(){

        public EventManager create(final String string) throws RemoteException {
            EventManager.Stub stub = new EventManager.Stub(){
                public ArrayList<EventListenerProxy> usingLis = new ArrayList();
                com.baidu.speech.EventManager impl;
                {
                    this.impl = EventManagerFactory.create(EventRecognitionService.this.getApplicationContext(), string, false);
                }

                public void send(String string3, String string2, byte[] byArray, int n, int n2) throws RemoteException {
                    if ("asr.start".equals(string3) || "asr.kws.load".equals(string3)) {
                        EventRecognitionService.this.asrUsing = true;
                    } else if ("wp.start".equals(string3)) {
                        EventRecognitionService.this.wpUsing = true;
                    }
                    this.impl.send(string3, string2, byArray, n, n2);
                }

                public void registerListener(com.baidu.speech.aidl.EventListener eventListener) throws RemoteException {
                    EventListenerProxy eventListenerProxy = new EventListenerProxy(eventListener);
                    this.unregisterListener(eventListener);
                    this.usingLis.add(eventListenerProxy);
                    this.impl.registerListener(eventListenerProxy);
                }

                public void unregisterListener(com.baidu.speech.aidl.EventListener eventListener) throws RemoteException {
                    for (EventListenerProxy eventListenerProxy : this.usingLis) {
                        this.impl.unregisterListener(eventListenerProxy);
                    }
                    this.usingLis.clear();
                }
            };
            EventRecognitionService.this.startTime = System.currentTimeMillis();
            return stub;
        }
    };

    public EventRecognitionService() {
        new Handler().postDelayed(new Runnable(){

            public void run() {
            }
        }, 5000L);
    }

    public IBinder onBind(Intent intent) {
        return this.iBinder;
    }

    class EventListenerProxy
    implements EventListener {
        private com.baidu.speech.aidl.EventListener listener;

        public EventListenerProxy(com.baidu.speech.aidl.EventListener eventListener) {
            this.listener = eventListener;
        }

        public void onEvent(String string, String string2, byte[] byArray, int n, int n2) {
            block10: {
                try {
                    long l = System.currentTimeMillis() - EventRecognitionService.this.startTime;
                    if (null == byArray) {
                        byArray = new byte[]{};
                    }
                    if ("asr.exit".equals(string)) {
                        EventRecognitionService.this.asrUsing = false;
                    } else if ("wp.exit".equals(string)) {
                        EventRecognitionService.this.wpUsing = false;
                    }
                    if (!EventRecognitionService.this.asrUsing && !EventRecognitionService.this.wpUsing) {
                        boolean bl = l > (long)EventRecognitionService.this.RESTART_TIME;
                        try {
                            JSONObject jSONObject = new JSONObject(string2 == null ? "{}" : string2);
                            jSONObject.put("_free", bl);
                            string2 = jSONObject.toString();
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                        this.listener.onEvent(string, string2, byArray, n, n2);
                        if (bl) {
                            Log.d((String)EventRecognitionService.TAG, (String)"wake up idle, exit!");
                            System.exit(0);
                        }
                        break block10;
                    }
                    this.listener.onEvent(string, string2, byArray, n, n2);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }
}

