/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.asr;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.baidu.speech.EventListener;
import com.baidu.speech.EventManager;
import com.baidu.speech.asr.AnalysisInterceptor;
import com.baidu.speech.asr.WakeUpControl;
import com.baidu.speech.utils.LogUtil;
import java.util.ArrayList;

public class EventManagerWp
implements EventManager {
    private static final String version = "1.1.0.20161226";
    private static final String TAG = "EventManagerWp";
    private Context mContext;
    private ArrayList<EventListener> listeners = new ArrayList();
    private WakeUpControl mEnginer;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Exception initException = null;

    public EventManagerWp(Context context) {
        this.mContext = context;
        try {
            this.mEnginer = new WakeUpControl(context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.initException = exception;
        }
    }

    public void send(String string, String string2, byte[] byArray, int n, int n2) {
        LogUtil.v(TAG, "send cmd : " + string + " send params : " + string2);
        AnalysisInterceptor.getInstance(this.mContext).send(string, string2, byArray, n, n2);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if ("wp.start".equals(string) && this.initException != null) {
            for (final EventListener eventListener : this.listeners) {
                this.mHandler.post(new Runnable(){

                    public void run() {
                        if (eventListener != null) {
                            LogUtil.v(EventManagerWp.TAG, "onEvent mCommand : wp.error and wp.exit  onEvent mParam : " + EventManagerWp.this.initException.getMessage());
                            eventListener.onEvent("wp.error", EventManagerWp.this.initException.getMessage(), null, 0, 0);
                            eventListener.onEvent("wp.exit", EventManagerWp.this.initException.getMessage(), null, 0, 0);
                        }
                    }
                });
            }
        }
        if (this.mEnginer != null && string != null) {
            this.mEnginer.setListener(new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(final String string, final String string2, final byte[] byArray, final int n, final int n2) {
                    ArrayList arrayList = EventManagerWp.this.listeners;
                    synchronized (arrayList) {
                        for (final EventListener eventListener : EventManagerWp.this.listeners) {
                            EventManagerWp.this.mHandler.post(new Runnable(){

                                public void run() {
                                    if (eventListener != null) {
                                        LogUtil.v(EventManagerWp.TAG, "onEvent mCommand : " + string + " onEvent mParam : " + string2);
                                        eventListener.onEvent(string, string2, byArray, n, n2);
                                        AnalysisInterceptor.getInstance(EventManagerWp.this.mContext).onEvent(string, string2, byArray, n, n2, false);
                                    }
                                }
                            });
                        }
                    }
                }
            });
            this.mEnginer.postEvent(string, string2);
        }
    }

    public void registerListener(EventListener eventListener) {
        if (eventListener != null && !this.listeners.contains(eventListener)) {
            this.listeners.add(eventListener);
        }
    }

    public void unregisterListener(EventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public static final String getSDKVersion() {
        return version;
    }
}

