/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.speech.asr.ASRListener;
import com.baidu.speech.asr.EventContext;
import com.baidu.speech.asr.SpeechConstant;
import com.baidu.speech.audio.MicrophoneServer;
import com.baidu.speech.core.BDSErrorDescription;
import com.baidu.speech.core.BDSMessage;
import com.baidu.speech.core.BDSParamBase;
import com.baidu.speech.core.BDSSDKLoader;
import com.baidu.speech.utils.AsrError;
import com.baidu.speech.utils.CommonParam;
import com.baidu.speech.utils.LogUtil;
import com.baidu.speech.utils.Policy;
import com.baidu.speech.utils.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ASREngine
implements BDSSDKLoader.BDSCoreEventListener {
    public static final int ERROR_NETWORK_TIMEOUT = 1;
    public static final int ERROR_NETWORK = 2;
    public static final int ERROR_AUDIO = 3;
    public static final int ERROR_SERVER = 4;
    public static final int ERROR_CLIENT = 5;
    public static final int ERROR_SPEECH_TIMEOUT = 6;
    public static final int ERROR_NO_MATCH = 7;
    public static final int ERROR_RECOGNIZER_BUSY = 8;
    public static final int ERROR_INSUFFICIENT_PERMISSIONS = 9;
    private static final String TAG = "ASREngine";
    private static final boolean DEBUG = true;
    private static final int EVoiceRecognitionClientWorkStatusStartWorkIng = 0;
    private static final int EVoiceRecognitionClientWorkStatusStart = 1;
    private static final int EVoiceRecognitionClientWorkStatusEnd = 2;
    private static final int EVoiceRecognitionClientWorkStatusNewRecordData = 3;
    private static final int EVoiceRecognitionClientWorkStatusFlushData = 4;
    private static final int EVoiceRecognitionClientWorkStatusFinish = 5;
    private static final int EVoiceRecognitionClientWorkStatusMeterLevel = 6;
    private static final int EVoiceRecognitionClientWorkStatusCancel = 7;
    private static final int EVoiceRecognitionClientWorkStatusError = 8;
    private static final int EVoiceRecognitionClientWorkStatusLoaded = 9;
    private static final int EVoiceRecognitionClientWorkStatusUnLoaded = 10;
    private static final int EVoiceRecognitionClientWorkStatusLOG = 11;
    private static final int EVoiceRecognitionClientWorkStatusChunkThirdData = 12;
    private static final int EVoiceRecognitionClientWorkStatusChunkNlu = 13;
    private static final int EVoiceRecognitionClientWorkStatusChunkEnd = 14;
    private static final int EVoiceRecognitionClientWorkStatusLongSpeechEnd = 17;
    private static final int EVoiceRecognitionClientWorkStatusExit = 18;
    private static final int EVoiceRecognitionClientWorkStatusChunkTtsData = 19;
    private static String ASR_CMD_CONFIG = "asr.config";
    private static String ASR_CMD_START = "asr.start";
    private static String ASR_CMD_STOP = "asr.stop";
    private static String ASR_CMD_CANCEL = "asr.cancel";
    private static String ASR_CMD_LOAD_ENGINE = "asr.kws.load";
    private static String ASR_CMD_UNLOAD_ENGINE = "asr.kws.unload";
    private static String ASR_CMD_UPLOAD_CONTRACT = "asr.upload.contract";
    private static String ASR_CMD_UPLOAD_WORDS = "asr.upload.words";
    private static String ASR_CMD_UPLOAD_CANCEL = "asr.upload.cancel";
    private static String ASR_PARAM_KEY_SDK_VERSION = "asr_param_key_sdk_version.string";
    private static String ASR_PARAM_KEY_START_TONE = "asr_param_key_start_tone.int";
    private static String ASR_PARAM_KEY_SAMPLE_RATE = "asr_param_key_sample_rate.int";
    private static String MIC_PARAM_KEY_SOCKET_PORT = "mic_param_key_socket_port.int";
    private static String ASR_PARAM_KEY_AUDIO_FILE_PATH = "mic_audio_file_path.string";
    private static String ASR_PARAM_KEY_DEV = "asr_param_key_dev.string";
    private static String ASR_PARAM_KEY_ACCEPT_AUDIO_DATA = "asr_param_key_accept_audio_data.bool";
    private static String ASR_PARAM_KEY_AUDIO_mills = "mic_audio_mills.string";
    private static String ASR_PARAM_KEY_MAX_WAIT_DURATION = "asr_param_key_max_wait_duration.int";
    private static String ASR_PARAM_KEY_VAD_ENABLE_LONG_PRESS = "vad_enable_long_press.bool";
    private static String ASR_PARAM_KEY_DISABLE_PUNCTUATION = "asr_param_key_disable_punctuation.bool";
    private static String ASR_PARAM_KEY_PUNCTUATION_EXT_MODE = "asr_param_key_punctuation_ext_mode.int";
    private static String ASR_PARAM_KEY_ENABLE_SERVER_VAD = "asr_param_key_enable_server_vad.bool";
    private static String ASR_PARAM_KEY_ENABLE_CONTACTS = "asr_param_key_enable_contacts.bool";
    private static String ASR_PARAM_KEY_ENABLE_EARLY_RETURN = "asr_param_key_enable_early_return.bool";
    private static String ASR_PARAM_KEY_API_SECRET_KEYS = "asr_param_key_api_secret_key.vector<string>";
    private static String ASR_PARAM_KEY_SERVER_URL = "asr_param_key_server_url.string";
    private static String ASR_PARAM_KEY_BROWSER_USER_AGENT = "asr_param_key_browser_user_agent.string";
    private static String ASR_PARAM_KEY_SERVER_AGENT_URL = "asr_param_key_server_agent_url.string";
    private static String ASR_PARAM_KEY_PROPERTY_LIST = "asr_param_key_property_list.vector<int>";
    private static String ASR_PARAM_KEY_PRODUCT_ID = "asr_param_key_product_id.string";
    private static String ASR_PARAM_KEY_CITY_ID = "asr_param_key_city_id.int";
    private static String ASR_PARAM_KEY_PROTOCOL = "asr_param_key_protocol.int";
    private static String ASR_PARAM_KEY_KWS_PROTOCOL = "asr_param_key_kws_protocol.int";
    private static String ASR_PARAM_KEY_LANGUAGE = "asr_param_key_language.int";
    private static String ASR_PARAM_KEY_ENABLE_NLU = "asr_param_key_enable_nlu.bool";
    private static String ASR_PARAM_KEY_ENABLE_LOCAL_VAD = "asr_param_key_enable_local_vad.bool";
    private static String ASR_PARAM_KEY_COMPRESSION_TYPE = "asr_param_key_compression_type.int";
    private static String ASR_PARAM_KEY_ENABLE_DRC = "asr_param_key_enable_drc.bool";
    private static String ASR_PARAM_KEY_PAM = "asr_param_key_pam.string";
    private static String ASR_PARAM_KEY_STC = "asr_param_key_stc.string";
    private static String ASR_PARAM_KEY_LTP = "asr_param_key_ltp.string";
    private static String ASR_PARAM_KEY_TXT = "asr_param_key_txt.string";
    private static String ASR_PARAM_KEY_NETWORK_STATUS = "asr_param_key_network_status.int";
    private static String ASR_PARAM_KEY_APP = "asr_param_key_app.string";
    private static String ASR_PARAM_KEY_PLATFORM = "asr_param_key_platform.string";
    private static String ASR_PARAM_KEY_BUA = "asr_param_key_bua.string";
    private static String ASR_PARAM_KEY_COK = "asr_param_key_cok.string";
    private static String ASR_PARAM_KEY_PU = "asr_param_key_pu.string";
    private static String ASR_PARAM_KEY_FRM = "asr_param_key_frm.string";
    private static String ASR_PARAM_KEY_RSV = "asr_param_key_rsv.map<string,string>";
    private static String ASR_PARAM_KEY_GLB = "asr_param_key_glb.string";
    private static String ASR_PARAM_KEY_MODEL_VAD_DAT_FILE = "asr_param_key_model_vad_dat_file.string";
    private static String ASR_PARAM_KEY_ENABLE_MODEL_VAD = "asr_param_key_enable_model_vad.int";
    private static String ASR_PARAM_KEY_VAD_ENDPOINT_TIMEOUT = "asr_param_key_vad_endpoint_timeout.int";
    private static String BDS_ASR_OFFLINE_ENGINE_TRIGGERED_WAKEUP_WORD = "kws_param_key_triggered_wakeup_word.string";
    private static String ASR_PARAM_KEY_DNN_SPEECH_THRESHOLD = "asr_param_key_dnn_speech_threshold.float";
    private static String ASR_PARAM_KEY_DNN_MIN_SP_DURATION = "asr_param_key_dnn_min_sp_duration.int";
    private static String ASR_PARAM_KEY_DNN_HEAD_SIL_DURATION = "asr_param_key_dnn_head_sil_duration.int";
    private static String ASR_PARAM_KEY_DNN_SIL_THRESHOLD = "asr_param_key_dnn_sil_threshold.float";
    private static String ASR_PARAM_KEY_OFFLINE_ENGINE_TYPE = "kws_param_key_type.int";
    private static String ASR_PARAM_KEY_STRATEGY = "asr_param_key_strategy.int";
    private static String ASR_PARAM_KEY_OFFLINE_APP_CODE = "offline_param_key_app_code.string";
    private static String ASR_PARAM_KEY_OFFLINE_ENGINE_DAT_FILE_PATH = "kws_param_key_dat_filepath.string";
    private static String ASR_PARAM_KEY_OFFLINE_ENGINE_GRAMMER_FILE_PATH = "kws_param_key_grammer_filepath.string";
    private static String OFFLINE_PARAM_KEY_LICENSE_FILE_PATH = "offline_param_key_license_filepath.string";
    private static String BDS_ASR_OFFLINE_ENGINE_GRAMMER_SLOT = "kws_param_key_slot.string";
    private static String COMMON_PARAM_KEY_DEBUG_LOG_LEVEL = "common_param_key_debug_log_level.int";
    private static String ASR_PARAM_KEY_UID_STRING = "uid.string";
    private static String ASR_PARAM_KEY_CHUNK_KEY = "asr_param_key_chunk_key.string";
    private static String ASR_PARAM_KEY_CHUNK_PARAM = "asr_param_key_chunk_param.string";
    private static String ASR_PARAM_KEY_CHUNK_TTS = "asr_param_key_chunk_tts.string";
    private static String ASR_PARAM_KEY_CHUNK_ENABLE = "asr_param_key_chunk_enable.bool";
    private static String ASR_PARAM_KEY_REALTIME_DATA = "asr_param_key_realtime_data.string";
    private static String ASR_PARAM_KEY_ENABLE_LONG_SPEECH = "asr_param_key_enable_long_speech.bool";
    private static String ASR_PARAM_KEY_MULTI_START_AND_END = "asr_param_key_multi_start_and_end.bool";
    private static String ASR_PARAM_KEY_ENABLE_HTTPDNS = "asr_param_key_enable_httpdns.bool";
    private static String UNIT_PARAM_BOT_SESSION_LIST = "bot_session_list.string";
    private Context mContext = null;
    private String mSerialNumber = "";
    private String mOutFile = null;
    private BDSSDKLoader.BDSSDKInterface m_ASRcore;
    private ASRListener mListener;
    private JSONObject mParams;
    private int mVolumeFeedbackCount = 0;
    private int mVolumeFreq = 5;
    private String mUserData = null;
    private boolean mFeedBackAudio = false;
    private boolean mEnableChunk = false;
    private boolean mEnableLogFeedBack = true;
    private boolean mEnableLongPress = false;
    private String mPlatform;
    private String mVersion;
    private String mApp;
    private boolean mExceptioned = false;
    private boolean mIsWorking = false;
    private boolean mCalledStop = false;
    private String mLastRecognitionResult = "";
    private int mStreamType = -1;
    private int decodertemp = 0;
    private boolean isOfflineLast = false;
    private boolean enableLongSpeech = false;
    private static boolean hasPartialResult = false;
    private static boolean hasBegin = false;
    private static boolean hasEnd = false;
    private boolean isUnitFirstPackage = true;
    private StringBuffer unitThirdBufferData;
    private EventContext mEventContext;
    private JSONObject usingSimpleNlp;
    private ExecutorService nluBuilderThread = Executors.newSingleThreadExecutor();
    private Future<JSONObject> nlpFeature;
    private Map<String, JSONObject> mOriginNlp = new HashMap<String, JSONObject>();
    static final MediaPlayer player = new MediaPlayer();

    public ASREngine(Context context) throws Exception {
        this.mContext = context;
        this.mEventContext = new EventContext(context);
        try {
            BDSSDKLoader.loadLibraries();
        }
        catch (Throwable throwable) {
            throw new Exception(this.generateErrorResult(5001));
        }
        try {
            this.m_ASRcore = BDSSDKLoader.getSDKObjectForSDKType("ASRCore", this.mContext);
            if (null == this.m_ASRcore) {
                throw new Exception("ASR core support is not linked in package");
            }
            if (!this.m_ASRcore.instanceInitialized()) {
                throw new Exception("Failed initialize ASR Core native layer");
            }
            this.m_ASRcore.setListener(this);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Exception("Can't found ASR Core native method");
        }
    }

    private void loadGrammar(String string) {
        boolean bl = false;
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject != null && ("enable".equals(jSONObject.optString("nlu")) || "enable-all".equals(jSONObject.optString("nlu")))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            try {
                this.initGrammer(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public BDSErrorDescription postEvent(String string, String string2) {
        Object object;
        BDSErrorDescription bDSErrorDescription = null;
        Object var4_4 = null;
        LogUtil.v(TAG, " postEvent params: cmd:" + string + " params:" + string2);
        if (string == null || string.equals("")) {
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -1;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "ASR param can not empty!";
            return bDSErrorDescription;
        }
        if (string.equals(ASR_CMD_START)) {
            int n;
            if (this.mIsWorking) {
                try {
                    this.mListener.onEvent("asr.finish", this.generateErrorResult(8001), null, 0, 0);
                    return bDSErrorDescription;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((n = this.parseDecoder(string2)) == 0 && Utility.getWifiOr2gOr3G(this.mContext) == 0) {
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    if (jSONObject != null) {
                        this.play(this.mContext, jSONObject.optInt("sound_error", -1), false);
                    }
                    this.mListener.onEvent("asr.finish", this.generateErrorResult(2100), null, 0, 0);
                    this.mListener.onEvent("asr.exit", this.generateErrorResult(2100), null, 0, 0);
                    this.mIsWorking = false;
                    return bDSErrorDescription;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!Utility.checkPermission(this.mContext, "android.permission.INTERNET")) {
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    if (jSONObject != null) {
                        this.play(this.mContext, jSONObject.optInt("sound_error", -1), false);
                    }
                    this.mListener.onEvent("asr.finish", this.generateErrorResult(2101), null, 0, 0);
                    this.mListener.onEvent("asr.exit", this.generateErrorResult(2101), null, 0, 0);
                    this.mIsWorking = false;
                    return bDSErrorDescription;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!Utility.checkPermission(this.mContext, "android.permission.RECORD_AUDIO")) {
                try {
                    object = new JSONObject(string2);
                    if (object != null) {
                        this.play(this.mContext, object.optInt("sound_error", -1), false);
                    }
                    this.mListener.onEvent("asr.finish", this.generateErrorResult(9001), null, 0, 0);
                    this.mListener.onEvent("asr.exit", this.generateErrorResult(9001), null, 0, 0);
                    this.mIsWorking = false;
                    return bDSErrorDescription;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.loadGrammar(string2);
        }
        if (string.equals(ASR_CMD_START)) {
            this.mCalledStop = false;
        }
        if (string.equals(ASR_CMD_STOP)) {
            this.updateUserData(string2);
            this.mCalledStop = true;
        }
        if (string.equals(ASR_CMD_START) || string.equals(ASR_CMD_STOP) || string.equals(ASR_CMD_CANCEL)) {
            this.updateUserData(string2);
        }
        if (string.equals(ASR_CMD_START) || string.equals(ASR_CMD_LOAD_ENGINE)) {
            try {
                this.mParams = new JSONObject(string2);
            }
            catch (Exception exception) {
                this.mParams = new JSONObject();
            }
            if (string.equals(ASR_CMD_START)) {
                boolean bl = this.mParams.optBoolean("audio.sound-sync", true);
                this.play(this.mContext, this.mParams.optInt("sound_start", -1), bl);
                try {
                    if (!this.mParams.has("audio.socketport")) {
                        object = this.mParams.optString("infile");
                        int n = 1;
                        if (this.mParams.has("audio.source")) {
                            n = this.mParams.optInt("audio.source");
                        }
                        int n2 = MicrophoneServer.create((String)object, n);
                        this.mParams.put("audio.socketport", n2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.loadGrammar(string2);
            }
            try {
                bDSErrorDescription = this.initConfig(bDSErrorDescription, this.mParams);
                if (string.equals(ASR_CMD_START)) {
                    this.clearOutFile();
                }
                if (this.mExceptioned) {
                    return bDSErrorDescription;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bDSErrorDescription != null) {
                return bDSErrorDescription;
            }
        }
        if (string.equals(ASR_CMD_CONFIG)) {
            JSONObject jSONObject;
            try {
                jSONObject = string2 == null || string2.equals("") ? new JSONObject() : new JSONObject(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                jSONObject = new JSONObject();
            }
            if (jSONObject.has("vad_enable_long_press.bool")) {
                this.mEnableLongPress = jSONObject.optBoolean("vad_enable_long_press.bool", true);
            }
        }
        return this.postEvent(bDSErrorDescription, string);
    }

    private BDSErrorDescription postEvent(BDSErrorDescription bDSErrorDescription, String string) {
        BDSMessage bDSMessage = new BDSMessage();
        bDSMessage.m_messageName = string;
        bDSMessage.m_messageParams = new HashMap();
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PLATFORM, BDSParamBase.objectParam(this.mPlatform, "java.lang.String"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SDK_VERSION, BDSParamBase.objectParam(this.mVersion, "java.lang.String"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_APP, BDSParamBase.objectParam(this.mApp, "java.lang.String"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_NETWORK_STATUS, BDSParamBase.intParam(Utility.getWifiOr2gOr3G(this.mContext)));
        if ((string.equals(ASR_CMD_START) || string.equals(ASR_CMD_STOP) || string.equals(ASR_CMD_CANCEL)) && this.mUserData != null) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_REALTIME_DATA, BDSParamBase.objectParam(this.mUserData, "java.lang.String"));
            this.mUserData = null;
        }
        if (string.equals(ASR_CMD_CONFIG)) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_VAD_ENABLE_LONG_PRESS, BDSParamBase.boolParam(this.mEnableLongPress));
        }
        LogUtil.v(TAG, " cmd:" + string + " msg:" + bDSMessage.toString());
        try {
            int n = this.m_ASRcore.postMessage(bDSMessage);
            if (n != 0) {
                bDSErrorDescription = new BDSErrorDescription();
                bDSErrorDescription.errorCode = -2;
                bDSErrorDescription.errorDomain = 1;
                bDSErrorDescription.errorDescription = "JNI: readyParamsAsrStart Call to Native layer returned error! err( " + n + " )";
                return bDSErrorDescription;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -2;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: readyParamsAsrStart Call to Native layer returned error! err";
            return bDSErrorDescription;
        }
        if (string.equals(ASR_CMD_START)) {
            this.mIsWorking = true;
        }
        if (string.equals(ASR_CMD_CANCEL)) {
            this.mIsWorking = false;
        }
        return bDSErrorDescription;
    }

    public void setListener(ASRListener aSRListener) {
        this.mListener = aSRListener;
    }

    public void receiveCoreEvent(BDSMessage bDSMessage, BDSSDKLoader.BDSSDKInterface bDSSDKInterface) {
        if (this.mListener != null && bDSMessage != null) {
            this.asrCallBack(bDSMessage, this.mListener);
        }
    }

    private BDSErrorDescription initConfig(BDSErrorDescription bDSErrorDescription, JSONObject jSONObject) throws Exception {
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        String string2;
        String string3;
        String string4;
        String string5;
        BDSMessage bDSMessage = new BDSMessage();
        bDSMessage.m_messageName = ASR_CMD_CONFIG;
        bDSMessage.m_messageParams = new HashMap();
        ApplicationInfo applicationInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
        String string6 = jSONObject.optString("decoder-server.pdt", jSONObject.optString("pid"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PRODUCT_ID, BDSParamBase.objectParam(string6, "java.lang.String"));
        String string7 = jSONObject.optString(UNIT_PARAM_BOT_SESSION_LIST, jSONObject.optString("bot_session_list"));
        bDSMessage.m_messageParams.put(UNIT_PARAM_BOT_SESSION_LIST, BDSParamBase.objectParam(string7, "java.lang.String"));
        String string8 = jSONObject.optString("decoder-server.agent.url", jSONObject.optString("agent.url", ""));
        if (TextUtils.isEmpty((CharSequence)string6)) {
            string5 = null == applicationInfo.metaData ? null : applicationInfo.metaData.getString("com.baidu.speech.API_KEY");
            string4 = null == applicationInfo.metaData ? "" : applicationInfo.metaData.getString("com.baidu.speech.SECRET_KEY");
            string3 = jSONObject.optString("key", jSONObject.optString("apikey", string5));
            string2 = jSONObject.optString("secret", string4);
            if (string3 != null && string2 != null) {
                object = new Vector<String>();
                ((Vector)object).add(string3);
                ((Vector)object).add(string2);
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_API_SECRET_KEYS, BDSParamBase.objectParam(object, "java.util.Vector;"));
            }
        }
        string5 = jSONObject.optString("decoder-server.fix-app", "");
        string4 = jSONObject.optString("decoder-server.app", Policy.app(this.mContext));
        this.mApp = (null == string5 || "".equals(string5) ? "" : string5 + "/") + string4;
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_APP, BDSParamBase.objectParam(this.mApp, "java.lang.String"));
        if (!jSONObject.has("key")) {
            String string9 = string3 = null == applicationInfo.metaData ? null : applicationInfo.metaData.getString("com.baidu.speech.API_KEY") + "";
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("key", (Object)string3);
            }
        }
        string3 = jSONObject.optString("decoder-server.key", jSONObject.optString("key", ""));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_CHUNK_KEY, BDSParamBase.objectParam(string3, "java.lang.String"));
        string2 = null == applicationInfo.metaData ? null : applicationInfo.metaData.getInt("com.baidu.speech.APP_ID") + "";
        object = jSONObject.optString("appid", string2);
        if (object != null) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_OFFLINE_APP_CODE, BDSParamBase.objectParam(object, "java.lang.String"));
        }
        int n5 = jSONObject.optInt("log_level", -1);
        if (Log.isLoggable((String)"BDSPEECH", (int)3)) {
            n5 = 5;
        } else if (Log.isLoggable((String)"BDSPEECH", (int)2)) {
            n5 = 6;
        }
        if (n5 != -1) {
            bDSMessage.m_messageParams.put(COMMON_PARAM_KEY_DEBUG_LOG_LEVEL, BDSParamBase.intParam(n5));
        }
        this.decodertemp = n4 = jSONObject.optInt("basic.decoder", jSONObject.optInt("decoder", 0));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_STRATEGY, BDSParamBase.intParam(n4));
        int n6 = jSONObject.optInt("audio.sample", jSONObject.optInt("sample", 16000));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SAMPLE_RATE, BDSParamBase.intParam(this.getSampleRateFlag(n6)));
        String string10 = jSONObject.optString("decoder-offline.language", jSONObject.optString("language", "cmn-Hans-CN"));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_LANGUAGE, BDSParamBase.intParam(this.getLanguageFlag(string10)));
        String string11 = jSONObject.optString("vad", jSONObject.optString("vad", "dnn"));
        if (!Log.isLoggable((String)TAG, (int)3)) {
            // empty if block
        }
        Log.e((String)TAG, (String)("VAD Model=" + string11));
        String string12 = String.format("%s/%s", this.mContext.getApplicationInfo().nativeLibraryDir, "libbd_easr_s1_merge_normal_20151216.dat.so");
        String string13 = jSONObject.optString("vad.res-file", jSONObject.optString("res-file", string12));
        if (string11.equals("touch")) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_LOCAL_VAD, BDSParamBase.boolParam(false));
        } else if (string11.equals("input")) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_LOCAL_VAD, BDSParamBase.boolParam(true));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_MODEL_VAD, BDSParamBase.intParam(0));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_MODEL_VAD_DAT_FILE, BDSParamBase.objectParam(this.loadSourceFromUri(string13), "java.lang.String"));
            n3 = jSONObject.optInt("vad.endpoint-timeout", jSONObject.optInt("vad.end-frame", 2500));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_VAD_ENDPOINT_TIMEOUT, BDSParamBase.intParam(n3));
        } else if (string11.equals("model-vad") || string11.equals("model_vad")) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_LOCAL_VAD, BDSParamBase.boolParam(true));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_MODEL_VAD, BDSParamBase.intParam(1));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_MODEL_VAD_DAT_FILE, BDSParamBase.objectParam(this.loadSourceFromUri(string13), "java.lang.String"));
            n3 = jSONObject.optInt("vad.endpoint-timeout", jSONObject.optInt("vad.end-frame", 0));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_VAD_ENDPOINT_TIMEOUT, BDSParamBase.intParam(n3));
        } else if (string11.equals("dnn")) {
            float f;
            int n7;
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_LOCAL_VAD, BDSParamBase.boolParam(true));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_MODEL_VAD, BDSParamBase.intParam(2));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_MODEL_VAD_DAT_FILE, BDSParamBase.objectParam(this.mContext.getApplicationInfo().nativeLibraryDir, "java.lang.String"));
            n3 = jSONObject.optInt("vad.endpoint-timeout", jSONObject.optInt("vad.end-frame", 0));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_VAD_ENDPOINT_TIMEOUT, BDSParamBase.intParam(n3));
            float f2 = (float)jSONObject.optDouble("vad.speech-threshold", 0.0);
            if (f2 > 0.0f) {
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_DNN_SPEECH_THRESHOLD, BDSParamBase.floatParam(f2));
            }
            if ((n7 = jSONObject.optInt("vad.min-speech-duration", 0)) > 0) {
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_DNN_MIN_SP_DURATION, BDSParamBase.intParam(n7));
            }
            if ((n2 = jSONObject.optInt("vad.head-sil-duration", 0)) > 0) {
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_DNN_HEAD_SIL_DURATION, BDSParamBase.intParam(n2));
            }
            if ((n = jSONObject.optInt("vad.max-wait-duration", 0)) > 0) {
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_MAX_WAIT_DURATION, BDSParamBase.intParam(n));
            }
            if ((f = (float)jSONObject.optDouble("vad.sil-threshold", 0.0)) > 0.0f) {
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_DNN_SIL_THRESHOLD, BDSParamBase.floatParam(f));
            }
        } else if (string11.equals("search")) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_LOCAL_VAD, BDSParamBase.boolParam(true));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_MODEL_VAD, BDSParamBase.intParam(0));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_MODEL_VAD_DAT_FILE, BDSParamBase.objectParam(this.loadSourceFromUri(string13), "java.lang.String"));
            n3 = jSONObject.optInt("vad.endpoint-timeout", 1000);
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_VAD_ENDPOINT_TIMEOUT, BDSParamBase.intParam(n3));
        } else if ("mfe".equals(string11)) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_LOCAL_VAD, BDSParamBase.boolParam(true));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_MODEL_VAD, BDSParamBase.intParam(0));
        }
        if (jSONObject.has("audio.source")) {
            // empty if block
        }
        this.mVolumeFreq = jSONObject.optInt("mic.volume-freq", 5);
        if (this.mVolumeFreq <= 0) {
            this.mVolumeFreq = 1;
        }
        if (string8 != "") {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SERVER_AGENT_URL, BDSParamBase.objectParam(string8, "java.lang.String"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = jSONObject.optString("dev", "")))) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_DEV, BDSParamBase.objectParam(string, "java.lang.String"));
        }
        String string14 = jSONObject.optString("audio.file", jSONObject.optString("infile", ""));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_AUDIO_FILE_PATH, BDSParamBase.objectParam(string14, "java.lang.String"));
        String string15 = jSONObject.optString("audio.mills", "");
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_AUDIO_mills, BDSParamBase.objectParam(string15, "java.lang.String"));
        n2 = jSONObject.optInt("audio.socketport");
        bDSMessage.m_messageParams.put(MIC_PARAM_KEY_SOCKET_PORT, BDSParamBase.intParam(n2));
        if (jSONObject.has("audio.stream-type")) {
            this.mStreamType = jSONObject.optInt("audio.stream-type");
            if (!Log.isLoggable((String)TAG, (int)3)) {
                // empty if block
            }
            Log.d((String)TAG, (String)("audio stream type = " + this.mStreamType));
        }
        n = jSONObject.optBoolean("accept-audio-volume", true);
        bDSMessage.m_messageParams.put("mic_accept_audio_volume.bool", BDSParamBase.boolParam(n != 0));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_NETWORK_STATUS, BDSParamBase.intParam(Utility.getWifiOr2gOr3G(this.mContext)));
        String string16 = jSONObject.optString("decoder-server.url", jSONObject.optString("url", "http://vop.baidu.com/v2"));
        try {
            CommonParam.REQUEST_URL = new URL(string16).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        CommonParam.AGENT_URL = string8;
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SERVER_URL, BDSParamBase.objectParam(string16, "java.lang.String"));
        String string17 = jSONObject.optString("decoder-server.uid", Policy.uid(this.mContext));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_UID_STRING, BDSParamBase.objectParam(string17, "java.lang.String"));
        String string18 = jSONObject.optString("decoder-server.glb", UUID.randomUUID().toString());
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_GLB, BDSParamBase.objectParam(string18, "java.lang.String"));
        String string19 = jSONObject.optString("decoder-server.stc");
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_STC, BDSParamBase.objectParam(string19, "java.lang.String"));
        this.mPlatform = jSONObject.optString("decoder-server.pfm", Policy.pfm(this.mContext));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PLATFORM, BDSParamBase.objectParam(this.mPlatform, "java.lang.String"));
        this.mVersion = jSONObject.optString("decoder-server.ver", Policy.ver(this.mContext));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_SDK_VERSION, BDSParamBase.objectParam(this.mVersion, "java.lang.String"));
        JSONArray jSONArray = jSONObject.optJSONArray("prop");
        Vector<Integer> vector = new Vector<Integer>();
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    vector.add(jSONArray.getInt(i));
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        if (string11.equals("input")) {
            Vector<Integer> vector2 = new Vector<Integer>();
            vector2.add(20000);
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PROPERTY_LIST, BDSParamBase.objectParam(vector2, "java.util.Vector;"));
        } else if (vector.size() > 0) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PROPERTY_LIST, BDSParamBase.objectParam(vector, "java.util.Vector;"));
        } else {
            Vector<Integer> vector3 = new Vector<Integer>();
            vector3.add(10005);
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PROPERTY_LIST, BDSParamBase.objectParam(vector3, "java.util.Vector;"));
        }
        boolean bl = jSONObject.optBoolean("decoder-server-fun.disable-punctuation", jSONObject.optBoolean("disable-punctuation", false));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_DISABLE_PUNCTUATION, BDSParamBase.boolParam(bl));
        int n8 = jSONObject.optInt("punctuation-mode", 0);
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PUNCTUATION_EXT_MODE, BDSParamBase.intParam(n8));
        boolean bl2 = jSONObject.optBoolean("server-vad", true);
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_SERVER_VAD, BDSParamBase.boolParam(bl2));
        boolean bl3 = jSONObject.optBoolean("decoder-server-fun.contact", jSONObject.optBoolean("contact", false));
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_CONTACTS, BDSParamBase.boolParam(bl3));
        boolean bl4 = jSONObject.optBoolean("enable-early-return", false);
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_EARLY_RETURN, BDSParamBase.boolParam(bl4));
        int n9 = jSONObject.optInt("cid");
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_CITY_ID, BDSParamBase.intParam(n9));
        int n10 = jSONObject.optInt("decoder-server.tts", jSONObject.optInt("tts", -1));
        if (n10 != -1) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_CHUNK_TTS, BDSParamBase.objectParam(n10 + "", "java.lang.String"));
        }
        String string20 = jSONObject.optString("decoder-server.pam", "");
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_CHUNK_PARAM, BDSParamBase.objectParam(string20, "java.lang.String"));
        int n11 = jSONObject.optInt("dec-type", jSONObject.optInt("basic.dec-type", 1));
        this.mEnableChunk = 1 == n11;
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_CHUNK_ENABLE, BDSParamBase.boolParam(this.mEnableChunk));
        boolean bl5 = jSONObject.optString("nlu", "disable").equals("enable");
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_NLU, BDSParamBase.boolParam(bl5));
        int n12 = jSONObject.optInt("decoder-server.ptc", bl5 ? 305 : 1);
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_PROTOCOL, BDSParamBase.intParam(n12));
        int n13 = jSONObject.optInt("decoder-offline.ptc", 0);
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_KWS_PROTOCOL, BDSParamBase.intParam(n13));
        this.enableLongSpeech = jSONObject.optInt("vad.endpoint-timeout", 1000) == 0;
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_LONG_SPEECH, BDSParamBase.boolParam(this.enableLongSpeech));
        boolean bl6 = jSONObject.optBoolean("long-speech.multi-start-end", false);
        if (bl6) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_MULTI_START_AND_END, BDSParamBase.boolParam(bl6));
        }
        boolean bl7 = jSONObject.optBoolean("enable-httpdns", true);
        bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ENABLE_HTTPDNS, BDSParamBase.boolParam(bl7));
        String string21 = jSONObject.optString("keyword");
        if (string21 != null && !string21.equals("")) {
            bDSMessage.m_messageParams.put(BDS_ASR_OFFLINE_ENGINE_TRIGGERED_WAKEUP_WORD, BDSParamBase.objectParam(string21, "java.lang.String"));
        }
        String string22 = jSONObject.optString("grammar");
        String string23 = jSONObject.optString("decoder-offline.asr-base-file-path", jSONObject.optString("asr-base-file-path", jSONObject.optString("kws.res-file", jSONObject.optString("res-file", string12))));
        String string24 = jSONObject.optString("decoder-offline.license-file-path", jSONObject.optString("license-file-path", jSONObject.optString("license")));
        String string25 = jSONObject.optString("decoder-offline.slot-data", jSONObject.optString("slot-data"));
        int n14 = 0;
        if (!TextUtils.isEmpty((CharSequence)string22)) {
            n14 = 2;
        }
        if (n4 != 0) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_OFFLINE_ENGINE_TYPE, BDSParamBase.intParam(n14));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_OFFLINE_ENGINE_GRAMMER_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string22), "java.lang.String"));
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_OFFLINE_ENGINE_DAT_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string23), "java.lang.String"));
            bDSMessage.m_messageParams.put(OFFLINE_PARAM_KEY_LICENSE_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string24), "java.lang.String"));
            bDSMessage.m_messageParams.put(BDS_ASR_OFFLINE_ENGINE_GRAMMER_SLOT, BDSParamBase.objectParam(string25, "java.lang.String"));
        }
        if (SpeechConstant.PUBLIC_DECODER) {
            if (string22 != null && !string22.equals("")) {
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_STRATEGY, BDSParamBase.intParam(n4));
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_OFFLINE_ENGINE_DAT_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string23), "java.lang.String"));
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_OFFLINE_ENGINE_GRAMMER_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string22), "java.lang.String"));
                bDSMessage.m_messageParams.put(OFFLINE_PARAM_KEY_LICENSE_FILE_PATH, BDSParamBase.objectParam(this.loadSourceFromUri(string24), "java.lang.String"));
                bDSMessage.m_messageParams.put(BDS_ASR_OFFLINE_ENGINE_GRAMMER_SLOT, BDSParamBase.objectParam(string25, "java.lang.String"));
            } else {
                bDSMessage.m_messageParams.put(ASR_PARAM_KEY_STRATEGY, BDSParamBase.intParam(n4));
            }
        }
        this.mOutFile = jSONObject.optString("audio.outfile", jSONObject.optString("outfile"));
        this.mEnableLogFeedBack = jSONObject.optBoolean("feedback-log", false);
        this.mFeedBackAudio = jSONObject.optBoolean("accept-audio-data", false);
        if (this.mFeedBackAudio) {
            bDSMessage.m_messageParams.put(ASR_PARAM_KEY_ACCEPT_AUDIO_DATA, BDSParamBase.boolParam(this.mFeedBackAudio));
        }
        try {
            int n15 = this.m_ASRcore.postMessage(bDSMessage);
            if (n15 != 0) {
                bDSErrorDescription = new BDSErrorDescription();
                bDSErrorDescription.errorCode = -2;
                bDSErrorDescription.errorDomain = 1;
                bDSErrorDescription.errorDescription = "JNI: initConfig Call to Native layer returned error! err( " + n15 + " )";
                return bDSErrorDescription;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bDSErrorDescription = new BDSErrorDescription();
            bDSErrorDescription.errorCode = -2;
            bDSErrorDescription.errorDomain = 1;
            bDSErrorDescription.errorDescription = "JNI: initConfig Call to Native layer returned error! err";
            return bDSErrorDescription;
        }
        return bDSErrorDescription;
    }

    private void asrCallBack(BDSMessage bDSMessage, ASRListener aSRListener) {
        if (!bDSMessage.m_messageName.equals("ASR.callback")) {
            return;
        }
        LogUtil.v(TAG, "ASRCallBack :" + bDSMessage.toString());
        int n = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.asr.status.int")).iValue;
        Log.v((String)TAG, (String)("ASRCallBack :" + n));
        switch (n) {
            case 0: {
                hasBegin = false;
                hasPartialResult = false;
                hasEnd = false;
                String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.asr.result.string")).iValue;
                aSRListener.onEvent("asr.ready", string, null, 0, 0);
                break;
            }
            case 1: {
                String string;
                this.mSerialNumber = string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.asr.result.string")).iValue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("sn", this.mSerialNumber);
                aSRListener.onEvent("asr.sn", new JSONObject(hashMap).toString(), null, 0, 0);
                if (hasBegin) break;
                aSRListener.onEvent("asr.begin", null, null, 0, 0);
                hasBegin = true;
                break;
            }
            case 2: {
                if (hasEnd) break;
                this.play(this.mContext, this.mParams.optInt("sound_end", -1), false);
                try {
                    String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.asr.result.string")).iValue;
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("vad_silent_start", (Object)string);
                    aSRListener.onEvent("asr.end", jSONObject.toString(), null, 0, 0);
                    hasEnd = true;
                    hasBegin = true;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                break;
            }
            case 3: {
                byte[] byArray = bDSMessage.m_messageData;
                if (this.mFeedBackAudio && byArray != null) {
                    aSRListener.onEvent("asr.audio", null, byArray, 0, byArray.length);
                }
                this.saveOutFile(byArray);
                break;
            }
            case 4: {
                String string;
                hasPartialResult = true;
                if (!hasBegin) {
                    aSRListener.onEvent("asr.begin", null, null, 0, 0);
                    hasBegin = true;
                }
                this.mLastRecognitionResult = string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.asr.result.string")).iValue;
                string = this.adaptiveOfflineResult(string);
                String string2 = this.generateChunkPartialResult(string);
                aSRListener.onEvent("asr.partial", string2, null, 0, 0);
                break;
            }
            case 5: {
                if (!hasEnd) {
                    this.play(this.mContext, this.mParams.optInt("sound_end", -1), false);
                    aSRListener.onEvent("asr.end", null, null, 0, 0);
                    hasEnd = true;
                }
                this.play(this.mContext, this.mParams.optInt("sound_success", -1), false);
                this.mLastRecognitionResult = "";
                String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.asr.result.string")).iValue;
                string = this.adaptiveOfflineResult(string);
                boolean bl = false;
                try {
                    bl = new JSONObject(string).optJSONArray("results_recognition").length() == 0;
                }
                catch (JSONException jSONException) {
                    bl = true;
                }
                if (bl) {
                    this.play(this.mContext, this.mParams.optInt("sound_error", -1), false);
                    try {
                        JSONObject jSONObject = new JSONObject();
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put("sn", (Object)this.mSerialNumber);
                        jSONObject2.put("error", 7);
                        jSONObject.put("desc", (Object)"Speech Quality Problem");
                        jSONObject.put("origin_result", (Object)jSONObject2);
                        jSONObject.put("error", 7);
                        jSONObject.put("desc", (Object)"Speech Quality Problem");
                        aSRListener.onEvent("asr.finish", jSONObject.toString(), null, 0, 0, true);
                        this.mIsWorking = false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                String string3 = this.generateChunkFinalResult(string);
                if (this.mEnableChunk) {
                    aSRListener.onEvent("asr.partial", string3, null, 0, 0, true);
                    if (this.isOfflineLast) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("error", 0);
                        hashMap.put("desc", "Speech Recognize success.");
                        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                        hashMap2.put("err_no", 0);
                        hashMap2.put("error", "Speech Recognize success.");
                        hashMap.put("origin_result", new JSONObject(hashMap2));
                        aSRListener.onEvent("asr.finish", new JSONObject(hashMap).toString(), null, 0, 0);
                        this.mIsWorking = false;
                        this.isOfflineLast = false;
                    } else if (this.enableLongSpeech) {
                        String string4 = string3.replaceAll("^.*\"sn\": ?\"(.+)\".*$", "$1");
                        String string5 = this.generateEndResult(string4);
                        aSRListener.onEvent("asr.finish", string5, null, 0, 0);
                    }
                } else {
                    JSONObject jSONObject = null;
                    try {
                        jSONObject = new JSONObject(string3);
                        jSONObject.put("desc", (Object)"success");
                        jSONObject.put("error", 0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        jSONObject = new JSONObject();
                    }
                    aSRListener.onEvent("asr.finish", jSONObject.toString(), null, 0, 0, true);
                    this.mIsWorking = false;
                }
                hasPartialResult = false;
                break;
            }
            case 6: {
                ++this.mVolumeFeedbackCount;
                if (this.mVolumeFeedbackCount % this.mVolumeFreq != 0) {
                    return;
                }
                int n2 = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.asr.level.int")).iValue / 100;
                int n3 = (int)(Math.min(5000.0f, (float)n2) / 50.0f);
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put("volume", n2);
                hashMap.put("volume-percent", n3);
                aSRListener.onEvent("asr.volume", new JSONObject(hashMap).toString(), null, 0, 0);
                break;
            }
            case 7: {
                this.play(this.mContext, this.mParams.optInt("sound_cancel", -1), false);
                aSRListener.onEvent("asr.cancel", null, null, 0, 0);
                hasBegin = false;
                break;
            }
            case 8: {
                this.play(this.mContext, this.mParams.optInt("sound_error", -1), false);
                hasBegin = false;
                int n4 = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.error.domain.int16_t")).iValue;
                String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.error.desc.string")).iValue;
                int n5 = ((BDSParamBase.BDSIntParam)bDSMessage.m_messageParams.get((Object)"cb.error.code.int16_t")).iValue;
                String string6 = "";
                if (!Log.isLoggable((String)TAG, (int)3)) {
                    // empty if block
                }
                Log.e((String)TAG, (String)("EVoiceRecognitionClientWorkStatusError errorDomain : " + n4 + " errorCode : " + n5 + " desc : " + string + " mLastRecognitionResult: " + this.mLastRecognitionResult));
                if (!this.mLastRecognitionResult.isEmpty() && n4 == 20 && n5 != 1 && hasPartialResult) {
                    this.play(this.mContext, this.mParams.optInt("sound_end", -1), false);
                    aSRListener.onEvent("asr.end", null, null, 0, 0);
                    if (this.mEnableChunk) {
                        String string7 = this.generateChunkFinalResult(this.mLastRecognitionResult);
                        aSRListener.onEvent("asr.partial", string7, null, 0, 0, true);
                        this.play(this.mContext, this.mParams.optInt("sound_success", -1), false);
                        String string8 = this.generateEndResult(this.mSerialNumber);
                        aSRListener.onEvent("asr.finish", string8, null, 0, 0);
                    } else {
                        this.play(this.mContext, this.mParams.optInt("sound_success", -1), false);
                        aSRListener.onEvent("asr.finish", this.mLastRecognitionResult, null, 0, 0);
                    }
                    this.mIsWorking = false;
                    break;
                }
                try {
                    string6 = this.generateErrorResult(n4, n5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                aSRListener.onEvent("asr.finish", string6, null, 0, 0);
                this.mIsWorking = false;
                break;
            }
            case 9: {
                aSRListener.onEvent("asr.loaded", null, null, 0, 0);
                break;
            }
            case 10: {
                aSRListener.onEvent("asr.unloaded", null, null, 0, 0);
                break;
            }
            case 12: {
                if (!this.mEnableChunk) break;
                String string = this.generateThirdResult();
                byte[] byArray = bDSMessage.m_messageData;
                byte[] byArray2 = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    byArray2[i] = byArray[4 + i];
                }
                String string9 = new String(byArray2);
                if (this.checkThirdDataUnit(string9)) {
                    LogUtil.d(TAG, "unit data");
                    string = this.getUnitString(byArray, string);
                    if (byArray.length > 12) break;
                    aSRListener.onEvent("unit.finish", string, byArray, 0, byArray.length);
                    break;
                }
                if (byArray == null) break;
                aSRListener.onEvent("asr.partial", string, byArray, 0, byArray.length);
                break;
            }
            case 19: {
                if (!this.mEnableChunk) break;
                String string = this.generateTtsResult();
                byte[] byArray = bDSMessage.m_messageData;
                if (byArray == null) break;
                aSRListener.onEvent("asr.partial", string, byArray, 0, byArray.length);
                break;
            }
            case 13: {
                if (!this.mEnableChunk) break;
                String string = this.generateNluResult();
                byte[] byArray = bDSMessage.m_messageData;
                if (byArray == null) break;
                aSRListener.onEvent("asr.partial", string, byArray, 0, byArray.length);
                break;
            }
            case 14: {
                if (!this.enableLongSpeech) {
                    aSRListener.onEvent("asr.finish", this.generateEndResult(this.mSerialNumber), null, 0, 0);
                    this.mIsWorking = false;
                    this.play(this.mContext, this.mParams.optInt("sound_success", -1), false);
                    break;
                }
                if (!this.mCalledStop) break;
                break;
            }
            case 11: {
                if (!this.mEnableLogFeedBack) {
                    return;
                }
                String string = (String)((BDSParamBase.BDSObjectParam)bDSMessage.m_messageParams.get((Object)"cb.asr.result.string")).iValue;
                aSRListener.onEvent("asr.log", string, null, 0, 0);
                break;
            }
            case 17: {
                aSRListener.onEvent("asr.long-speech.finish", null, null, 0, 0);
                this.mIsWorking = false;
                break;
            }
            case 18: {
                aSRListener.onEvent("asr.exit", null, null, 0, 0);
            }
        }
    }

    private int getSampleRateFlag(int n) {
        if (n == 8000) {
            return 1;
        }
        if (n == 16000) {
            return 2;
        }
        return 0;
    }

    private int getLanguageFlag(String string) {
        if (string == null || string.equals("")) {
            return 0;
        }
        if (string.equals("cmn-Hans-CN")) {
            return 0;
        }
        if (string.equals("yue-Hans-CN")) {
            return 1;
        }
        if (string.equals("en-GB")) {
            return 2;
        }
        if (string.equals("sichuan-Hans-CN")) {
            return 3;
        }
        return 0;
    }

    private void play(Context context, Object object, boolean bl) {
        block11: {
            Object object2;
            if (null == object) {
                return;
            }
            if (object instanceof Integer && (null == (object2 = (Integer)object) || (Integer)object2 <= 0)) {
                return;
            }
            try {
                object2 = "" + object;
                if (((String)object2).matches("^(0x)?\\d+$")) {
                    player.reset();
                    AssetFileDescriptor assetFileDescriptor = context.getResources().openRawResourceFd(Integer.parseInt((String)object2));
                    player.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
                    assetFileDescriptor.close();
                    if (this.mStreamType >= 0) {
                        player.setAudioStreamType(this.mStreamType);
                    }
                    player.prepare();
                } else {
                    player.reset();
                    player.setDataSource(context, Uri.parse((String)object2));
                    if (this.mStreamType >= 0) {
                        player.setAudioStreamType(this.mStreamType);
                    }
                    player.prepare();
                }
                player.start();
                if (!bl) break block11;
                try {
                    while (player.isPlaying()) {
                        Thread.sleep(1L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOutFile(byte[] byArray) {
        if (this.mOutFile != null && !this.mOutFile.equals("") && byArray != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.mOutFile, true);
                ((OutputStream)fileOutputStream).write(byArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    fileOutputStream = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOutFile() {
        if (this.mOutFile != null && !this.mOutFile.equals("")) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.mOutFile);
                ((OutputStream)fileOutputStream).write("".getBytes());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    fileOutputStream = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadSourceFromUri(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        if (new File(string).exists()) {
            return string;
        }
        InputStream inputStream = null;
        RandomAccessFile randomAccessFile = null;
        try {
            Pattern pattern = Pattern.compile("(.*?)://(.*)");
            Matcher matcher = pattern.matcher(string);
            String string2 = null;
            if (matcher.find()) {
                Object object;
                String string3 = matcher.group(1);
                string2 = matcher.group(2);
                if (string3.equalsIgnoreCase("file")) {
                    inputStream = new FileInputStream(string2);
                } else if (string3.equalsIgnoreCase("asset") || string3.equalsIgnoreCase("assets")) {
                    object = string2.startsWith("/") ? "" : "/";
                    inputStream = this.getClass().getResourceAsStream("/assets" + (String)object + string2);
                } else if (string3.equalsIgnoreCase("res")) {
                    inputStream = this.getClass().getResourceAsStream(string2);
                }
                if (null == inputStream) {
                    throw new IOException("bad data source");
                }
                object = new byte[1024];
                String string4 = this.mContext.getFilesDir().getAbsolutePath() + string2;
                File file = new File(string4);
                randomAccessFile = new RandomAccessFile(file, "rw");
                int n = 0;
                while ((n = inputStream.read((byte[])object)) > 0) {
                    randomAccessFile.write((byte[])object, 0, n);
                }
                String string5 = file.getAbsolutePath();
                return string5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    inputStream = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private String generateEndResult(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("error", 0);
        hashMap.put("desc", "Speech Recognize success.");
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("sn", string);
        hashMap2.put("err_no", 0);
        hashMap2.put("error", "Speech Recognize success.");
        hashMap.put("origin_result", new JSONObject(hashMap2));
        return new JSONObject(hashMap).toString();
    }

    private boolean isIllegalResult(String string) {
        return string != null && string.contains("1\u300200\u3002");
    }

    private String generateChunkPartialResult(String string) {
        String string2 = "";
        String string3 = "";
        try {
            Object object;
            string = string != null ? string : "";
            JSONObject jSONObject = new JSONObject(string).optJSONObject("origin_result");
            String string4 = "";
            if (jSONObject != null) {
                if (jSONObject.optJSONObject("result") != null) {
                    if (jSONObject.optJSONObject("result").optJSONArray("word") != null) {
                        string4 = jSONObject.optJSONObject("result").optJSONArray("word").optString(0);
                    } else if (jSONObject.optJSONObject("content") != null && jSONObject.optJSONObject("content").optJSONArray("item") != null) {
                        string4 = jSONObject.optJSONObject("content").optJSONArray("item").optString(0);
                    }
                }
                if (jSONObject.has("raw_text")) {
                    string4 = jSONObject.optString("raw_text");
                    if (this.isIllegalResult(string4)) {
                        string4 = string4.replace("1\u300200\u3002", "");
                    }
                } else if (jSONObject.optJSONObject("result") != null && jSONObject.optJSONObject("result").optString("raw_text") != null && "KWS".equals(jSONObject.optJSONObject("result").optString("sn"))) {
                    string4 = jSONObject.optJSONObject("result").optString("raw_text");
                }
            }
            if (this.mParams != null && "enable-all".equals(this.mParams.optString("nlu"))) {
                object = this.mParams.optString("keyword");
                string3 = this.getNlpResult((String)object, new JSONObject(string));
            }
            string4 = string4 != null ? string4 : "";
            object = new HashMap<String, String>();
            ((HashMap)object).put("result_type", "partial_result");
            ((HashMap)object).put("best_result", string4);
            ((HashMap)object).put("origin_result", jSONObject);
            ((HashMap)object).put("error", 0);
            ((HashMap)object).put("results_recognition", new JSONArray().put((Object)string4));
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                ((HashMap)object).put("results_nlu", string3);
            }
            string2 = new JSONObject((Map)object).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String generateChunkFinalResult(String string) {
        String string2 = "";
        String string3 = "";
        try {
            Object object;
            string = string != null ? string : "";
            JSONObject jSONObject = new JSONObject(string).optJSONObject("origin_result");
            String string4 = "";
            if (jSONObject != null) {
                if (jSONObject.optJSONObject("result") != null) {
                    if (jSONObject.optJSONObject("result").optJSONArray("word") != null) {
                        string4 = jSONObject.optJSONObject("result").optJSONArray("word").optString(0);
                    } else if (jSONObject.optJSONObject("content") != null && jSONObject.optJSONObject("content").optJSONArray("item") != null) {
                        string4 = jSONObject.optJSONObject("content").optJSONArray("item").optString(0);
                    }
                }
                if (jSONObject.has("raw_text")) {
                    string4 = jSONObject.optString("raw_text");
                    if (this.isIllegalResult(string4)) {
                        string4 = string4.replace("1\u300200\u3002", "");
                    }
                    this.isOfflineLast = true;
                } else if (jSONObject.optJSONObject("result") != null && jSONObject.optJSONObject("result").optString("raw_text") != null && "KWS".equals(jSONObject.optJSONObject("result").optString("sn"))) {
                    string4 = jSONObject.optJSONObject("result").optString("raw_text");
                    this.isOfflineLast = true;
                }
                if (this.mParams != null && ("enable".equals(this.mParams.optString("nlu")) || "enable-all".equals(this.mParams.optString("nlu")))) {
                    object = this.mParams.optString("keyword");
                    string3 = this.getNlpResult((String)object, new JSONObject(string));
                }
            }
            string4 = string4 != null ? string4 : "";
            object = new HashMap<String, Object>();
            ((HashMap)object).put("result_type", "final_result");
            ((HashMap)object).put("best_result", string4);
            ((HashMap)object).put("origin_result", jSONObject);
            ((HashMap)object).put("error", 0);
            ((HashMap)object).put("results_recognition", new JSONArray().put((Object)string4));
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                ((HashMap)object).put("results_nlu", string3);
            }
            string2 = new JSONObject((Map)object).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String generateThirdResult() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("result_type", "third_result");
        hashMap.put("best_result", "");
        hashMap.put("origin_result", "");
        return new JSONObject(hashMap).toString();
    }

    private String generateTtsResult() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("result_type", "tts_result");
        hashMap.put("best_result", "");
        hashMap.put("origin_result", "");
        return new JSONObject(hashMap).toString();
    }

    private String generateNluResult() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("result_type", "nlu_result");
        hashMap.put("best_result", "");
        hashMap.put("origin_result", "");
        return new JSONObject(hashMap).toString();
    }

    private String generateErrorResult(int n) throws Exception {
        String string = AsrError.getDescFromCode(n);
        int n2 = n / 1000;
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("sn", (Object)this.mSerialNumber);
        jSONObject2.put("error", n2);
        jSONObject2.put("desc", (Object)string);
        jSONObject2.put("sub_error", n);
        jSONObject.put("origin_result", (Object)jSONObject2);
        jSONObject.put("error", n2);
        jSONObject.put("desc", (Object)string);
        jSONObject.put("sub_error", n);
        return jSONObject.toString();
    }

    private String generateErrorResult(int n, int n2) throws Exception {
        if (!Log.isLoggable((String)TAG, (int)3)) {
            // empty if block
        }
        Log.d((String)TAG, (String)("generateErrorResult errDomain = " + n + " errCode = " + n2));
        if (Utility.getWifiOr2gOr3G(this.mContext) == 0 && this.decodertemp == 0) {
            return this.generateErrorResult(2100);
        }
        int n3 = -1;
        String string = "";
        if (AsrError.getDescFromCode(n2) != null) {
            n3 = n2;
        } else if (n == 10) {
            n3 = n2;
        } else if (n == 20) {
            if (1 == n2) {
                n3 = 3100;
            } else if (2 == n2 && !hasPartialResult) {
                n3 = 3101;
            } else if (3 == n2 && !hasPartialResult) {
                n3 = 3102;
            }
        } else if (n == 30) {
            if (n2 == 1) {
                n3 = 8001;
            } else if (n2 == 2) {
                n3 = 2100;
            } else if (n2 == 3) {
                n3 = 5003;
            } else if (n2 == 4) {
                n3 = 5004;
            }
        } else {
            n3 = n == 31 ? 2100 : (n == 32 ? n2 : (n == 33 ? (n2 == -3001 ? 4001 : (n2 == -3002 ? 4002 : (n2 == -3003 ? 4003 : (n2 == -3004 ? 4004 : (n2 == -3005 ? 7001 : (n2 == -3006 ? 6001 : n2)))))) : (n == 34 ? (n2 == 1 ? 10001 : (n2 == 2 ? 10002 : (n2 == 3 ? 10003 : (n2 == 4 ? 10004 : (n2 == 5 ? 10005 : (n2 == 6 ? (this.decodertemp == 4 ? n2 : 10006) : (n2 == 7 ? 10007 : (n2 == 8 ? 10008 : (n2 == 9 ? 10009 : (n2 == 10 ? 10010 : (n2 == 11 ? 10011 : (n2 == 12 && !hasPartialResult ? 10012 : n2)))))))))))) : 7001)));
        }
        return this.generateErrorResult(n3);
    }

    private int parseDecoder(String string) {
        int n = 0;
        try {
            JSONObject jSONObject = new JSONObject(string);
            n = jSONObject.optInt("basic.decoder", jSONObject.optInt("decoder"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    private String adaptiveOfflineResult(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string).getJSONObject("origin_result");
            if (jSONObject.has("raw_text")) {
                String string2 = jSONObject.getString("raw_text");
                string = new JSONObject(string).put("results_recognition", (Object)new JSONArray().put((Object)string2)).toString();
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return string;
    }

    private void updateUserData(String string) {
        JSONObject jSONObject = null;
        try {
            if (string == null || string.equals("")) {
                this.mUserData = null;
            } else {
                jSONObject = new JSONObject(string);
                this.mUserData = jSONObject.optString("realtime-data");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mUserData = null;
        }
    }

    private void initGrammer(String string) throws Exception {
        JSONObject jSONObject = new JSONObject(string);
        String string2 = jSONObject.optString("grammar");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        JSONObject jSONObject2 = null;
        jSONObject2 = this.mOriginNlp.get(string2);
        if (null == jSONObject2) {
            try {
                jSONObject2 = this.mEventContext.loadJsonFromUri(string2, false, true);
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)("bad grammar(as base64): " + string2));
            }
        }
        if (null == jSONObject2) {
            try {
                jSONObject2 = this.mEventContext.loadJsonFromUri(string2, false, false);
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)("bad grammar(as text): " + string2));
            }
        }
        if (jSONObject2 != null && this.mOriginNlp.get(string2) == null) {
            this.mOriginNlp.put(string2, jSONObject2);
        }
        if (null != jSONObject2) {
            Object object;
            JSONObject jSONObject3 = jSONObject.optJSONObject("slot-data");
            if (null == jSONObject3 && !TextUtils.isEmpty((CharSequence)(object = jSONObject.optString("slot-data")))) {
                jSONObject3 = new JSONObject((String)object);
            }
            object = jSONObject3;
            final JSONObject jSONObject4 = jSONObject2;
            this.nlpFeature = this.nluBuilderThread.submit(new Callable<JSONObject>(){

                @Override
                public JSONObject call() throws Exception {
                    ASREngine.resetNlpGrammar(ASREngine.this.mEventContext, jSONObject4, object);
                    return jSONObject4;
                }
            });
        }
    }

    private void fillNlpResult(String string, JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        Object object;
        String string2;
        if (null != this.nlpFeature) {
            this.usingSimpleNlp = this.nlpFeature.get();
            this.nlpFeature = null;
        }
        if (this.usingSimpleNlp == null) {
            return;
        }
        if (jSONObject.optInt("error", 0) != 0) {
            return;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("results_recognition");
        if (null == jSONArray || jSONArray.length() == 0) {
            return;
        }
        String string3 = jSONArray.optString(0);
        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string) && string3.length() > string.length()) {
            string3 = string3.substring(string.length());
        }
        JSONArray jSONArray2 = new JSONArray();
        JSONObject jSONObject4 = this.usingSimpleNlp.getJSONObject("rules");
        Object object2 = jSONObject4.keys();
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            object = jSONObject4.getJSONArray(string2);
            for (int i = 0; i < object.length(); ++i) {
                jSONObject3 = object.getJSONObject(i);
                String string4 = jSONObject3.getString("pattern");
                JSONArray jSONArray3 = jSONObject3.getJSONArray("groups");
                Pattern pattern = Pattern.compile(string4);
                Matcher matcher = pattern.matcher(string3);
                while (matcher.find()) {
                    JSONObject jSONObject5 = new JSONObject();
                    String string5 = string2;
                    String string6 = string2;
                    String[] stringArray = string2.split("\\.");
                    if (stringArray.length >= 2) {
                        string5 = stringArray[0];
                        string6 = stringArray[1];
                    }
                    jSONObject5.put("domain", (Object)string5);
                    jSONObject5.put("intent", (Object)string6);
                    jSONObject5.put("parser", (Object)"bsg");
                    JSONObject jSONObject6 = new JSONObject();
                    jSONObject5.put("object", (Object)jSONObject6);
                    int n = matcher.groupCount();
                    for (int j = 0; j < n; ++j) {
                        String string7 = jSONArray3.getString(j);
                        jSONObject6.put(string7, (Object)matcher.group(j + 1));
                    }
                    jSONArray2.put((Object)jSONObject5);
                }
            }
        }
        object2 = jSONObject.optString("origin_result");
        string2 = new JSONObject((String)object2);
        object = (String)this.mEventContext.searchItemFromJson((JSONObject)string2, "json_res");
        if (!TextUtils.isEmpty((CharSequence)object) && null != (jSONObject3 = (jSONObject2 = new JSONObject((String)object)).optJSONArray("results"))) {
            for (int i = 0; i < jSONObject3.length(); ++i) {
                jSONArray2.put((Object)jSONObject3.getJSONObject(i));
            }
        }
        object2 = new JSONObject();
        object2.put("raw_text", (Object)string3);
        object2.put("results", (Object)jSONArray2);
        jSONObject.put("results_nlu", object2);
    }

    private String getNlpResult(String string, JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        Object object;
        String string2;
        if (null != this.nlpFeature) {
            this.usingSimpleNlp = this.nlpFeature.get();
            this.nlpFeature = null;
        }
        if (this.usingSimpleNlp == null) {
            return null;
        }
        if (jSONObject.optInt("error", 0) != 0) {
            return null;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("results_recognition");
        if (null == jSONArray || jSONArray.length() == 0) {
            return null;
        }
        String string3 = jSONArray.optString(0);
        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string) && string3.length() > string.length()) {
            string3 = string3.substring(string.length());
        }
        JSONArray jSONArray2 = new JSONArray();
        JSONObject jSONObject4 = this.usingSimpleNlp.getJSONObject("rules");
        Object object2 = jSONObject4.keys();
        while (object2.hasNext()) {
            string2 = (String)object2.next();
            object = jSONObject4.getJSONArray(string2);
            for (int i = 0; i < object.length(); ++i) {
                jSONObject3 = object.getJSONObject(i);
                String string4 = jSONObject3.getString("pattern");
                JSONArray jSONArray3 = jSONObject3.getJSONArray("groups");
                Pattern pattern = Pattern.compile(string4);
                Matcher matcher = pattern.matcher(string3);
                while (matcher.find()) {
                    JSONObject jSONObject5 = new JSONObject();
                    String string5 = string2;
                    String string6 = string2;
                    String[] stringArray = string2.split("\\.");
                    if (stringArray.length >= 2) {
                        string5 = stringArray[0];
                        string6 = stringArray[1];
                    }
                    jSONObject5.put("domain", (Object)string5);
                    jSONObject5.put("intent", (Object)string6);
                    jSONObject5.put("parser", (Object)"bsg");
                    JSONObject jSONObject6 = new JSONObject();
                    jSONObject5.put("object", (Object)jSONObject6);
                    int n = matcher.groupCount();
                    for (int j = 0; j < n; ++j) {
                        String string7 = jSONArray3.getString(j);
                        jSONObject6.put(string7, (Object)matcher.group(j + 1));
                    }
                    jSONArray2.put((Object)jSONObject5);
                }
            }
        }
        object2 = jSONObject.optString("origin_result");
        string2 = new JSONObject((String)object2);
        object = (String)this.mEventContext.searchItemFromJson((JSONObject)string2, "json_res");
        if (!TextUtils.isEmpty((CharSequence)object) && null != (jSONObject3 = (JSONArray)this.mEventContext.searchItemFromJson(jSONObject2 = new JSONObject((String)object), "results"))) {
            for (int i = 0; i < jSONObject3.length(); ++i) {
                jSONArray2.put((Object)jSONObject3.getJSONObject(i));
            }
        }
        object2 = new JSONObject();
        object2.put("raw_text", (Object)string3);
        object2.put("results", (Object)jSONArray2);
        return object2.toString();
    }

    private static void resetNlpGrammar(EventContext eventContext, JSONObject jSONObject, JSONObject jSONObject2) throws JSONException {
        String string;
        JSONArray jSONArray;
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        long l = System.currentTimeMillis();
        if (jSONObject2 != null) {
            object4 = jSONObject.getJSONObject("slots");
            iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = jSONObject2.getJSONArray((String)object3);
                object4.put((String)object3, object2);
            }
        }
        object4 = new HashMap();
        iterator = jSONObject.getJSONObject("slots");
        object3 = iterator.keys();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = iterator.getJSONArray((String)object2);
            jSONArray = new ArrayList();
            for (int i = 0; i < object.length(); ++i) {
                string = object.getString(i);
                if (string.equals(".+")) {
                    jSONArray.add(string);
                    continue;
                }
                jSONArray.add(string.replaceAll("[\u0000-/]|[:-@]|[\\[-`]|[{-\u00ad]", ""));
            }
            String string2 = eventContext.join((List<String>)jSONArray, "|");
            ((HashMap)object4).put(String.format("<%s>", object2), String.format("(%s)", string2));
        }
        object3 = jSONObject.getJSONObject("rules");
        object2 = object3.keys();
        while (object2.hasNext()) {
            object = (String)object2.next();
            jSONArray = object3.getJSONArray((String)object);
            for (int i = 0; i < jSONArray.length(); ++i) {
                string = jSONArray.getJSONObject(i);
                String string3 = string.getString("origin");
                for (Map.Entry entry : ((HashMap)object4).entrySet()) {
                    string3 = string3.replaceAll((String)entry.getKey(), (String)entry.getValue());
                }
                string.put("pattern", (Object)("^" + string3 + "$"));
            }
        }
    }

    private boolean checkThirdDataUnit(String string) {
        if (string.contains("unit")) {
            LogUtil.d(TAG, "unit data");
            return true;
        }
        return false;
    }

    private String getUnitString(byte[] byArray, String string) {
        if (!this.isUnitFirstPackage) {
            string = new String(byArray);
            if (string.length() > 0) {
                string = string.substring(12, string.length());
            }
            this.unitThirdBufferData.append(string);
        }
        if (this.isUnitFirstPackage && byArray.length > 12) {
            this.isUnitFirstPackage = false;
            string = new String(byArray);
            string = string.substring(12, string.length());
            this.unitThirdBufferData = new StringBuffer(string);
        }
        if (byArray.length <= 12) {
            this.isUnitFirstPackage = true;
            string = this.unitThirdBufferData.toString();
        }
        return string;
    }
}

