/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.core;

import android.util.Log;
import com.baidu.speech.core.BDSMessage;
import com.baidu.speech.core.BDSSDKLoader;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class BDSCoreJniInterface
implements BDSSDKLoader.BDSSDKInterface {
    private WeakReference<BDSSDKLoader.BDSCoreEventListener> m_observer;
    private String m_sdkHandle;
    private static HashMap<String, WeakReference<BDSCoreJniInterface>> s_sdkInstances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInstance(String string, BDSCoreJniInterface bDSCoreJniInterface) {
        WeakReference<BDSCoreJniInterface> weakReference = new WeakReference<BDSCoreJniInterface>(bDSCoreJniInterface);
        HashMap<String, WeakReference<BDSCoreJniInterface>> hashMap = s_sdkInstances;
        synchronized (hashMap) {
            s_sdkInstances.put(string, weakReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String string) {
        HashMap<String, WeakReference<BDSCoreJniInterface>> hashMap = s_sdkInstances;
        synchronized (hashMap) {
            s_sdkInstances.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BDSCoreJniInterface findInstance(String string) {
        HashMap<String, WeakReference<BDSCoreJniInterface>> hashMap = s_sdkInstances;
        synchronized (hashMap) {
            WeakReference<BDSCoreJniInterface> weakReference = s_sdkInstances.get(string);
            if (weakReference == null) {
                return null;
            }
            BDSCoreJniInterface bDSCoreJniInterface = (BDSCoreJniInterface)weakReference.get();
            if (bDSCoreJniInterface == null) {
                BDSCoreJniInterface.removeInstance(string);
            }
            return bDSCoreJniInterface;
        }
    }

    public static BDSCoreJniInterface getNewSDK(String string) {
        String string2 = BDSCoreJniInterface.initCoreSDK(string);
        BDSCoreJniInterface bDSCoreJniInterface = null;
        if (string2 != null && string2.length() > 0) {
            bDSCoreJniInterface = new BDSCoreJniInterface();
            bDSCoreJniInterface.m_sdkHandle = string2;
            BDSCoreJniInterface.addInstance(string2, bDSCoreJniInterface);
        }
        return bDSCoreJniInterface;
    }

    public boolean instanceInitialized() {
        return this.m_sdkHandle != null && this.m_sdkHandle.length() > 0;
    }

    public void release() {
        if (this.instanceInitialized()) {
            this.ReleaseInstance(this.m_sdkHandle);
        }
        BDSCoreJniInterface.removeInstance(this.m_sdkHandle);
    }

    public int postMessage(BDSMessage bDSMessage) {
        return this.Post(bDSMessage, this.m_sdkHandle);
    }

    public void EchoMessage(BDSMessage bDSMessage) {
        this.EchoMessage(bDSMessage, this.m_sdkHandle);
    }

    public void setListener(BDSSDKLoader.BDSCoreEventListener bDSCoreEventListener) {
        this.m_observer = new WeakReference<BDSSDKLoader.BDSCoreEventListener>(bDSCoreEventListener);
    }

    private static void receiveCoreEvent(String string, BDSMessage bDSMessage) {
        BDSCoreJniInterface bDSCoreJniInterface = BDSCoreJniInterface.findInstance(string);
        if (bDSCoreJniInterface != null) {
            BDSSDKLoader.BDSCoreEventListener bDSCoreEventListener = (BDSSDKLoader.BDSCoreEventListener)bDSCoreJniInterface.m_observer.get();
            if (bDSCoreEventListener != null) {
                bDSCoreEventListener.receiveCoreEvent(bDSMessage, bDSCoreJniInterface);
            } else {
                Log.e((String)"core event", (String)("Listener is null for instance id " + string));
            }
        } else {
            Log.e((String)"core event", (String)("Can't find instance for id " + string));
        }
    }

    private static native String initCoreSDK(String var0);

    private native int Post(BDSMessage var1, String var2);

    private native void ReleaseInstance(String var1);

    private native void EchoMessage(BDSMessage var1, String var2);
}

