/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.speech.utils.AESUtil;
import com.baidu.speech.utils.Base64;
import com.baidu.speech.utils.CuidCertStore;
import com.baidu.speech.utils.MD5Util;
import com.baidu.speech.utils.SHA1Util;
import com.baidu.speech.utils.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Cipher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeviceId {
    private static final String TAG = "DeviceId";
    private static final boolean DEBUG = false;
    private static final String KEY_DEVICE_ID = "com.baidu.deviceid";
    private static final String KEY_DEVICE_ID_V2 = "com.baidu.deviceid.v2";
    private static final String AES_KEY;
    private static final String OLD_EXT_DIR = "baidu";
    private static final String EXT_DIR = "backups/.SystemConfig";
    private static final String EXT_FILE = ".cuid";
    private static final String EXT_FILE_V2 = ".cuid2";
    private final Context mContext;
    private int mSaveMask = 0;
    private static final String RSA_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private PublicKey mPublicKey;
    private static final int STORAGE_SYSTEM_SETTING_V1 = 1;
    private static final int STORAGE_SYSTEM_SETTING_V2 = 2;
    private static final int STORAGE_SDCARD_V1 = 4;
    private static final int STORAGE_SDCARD_V2 = 8;
    private static final int STORAGE_SELF_FILE = 16;
    private static final String SELF_CUID_FILE = "libcuid.so";
    private static CUIDInfo sCachedCuidInfo;
    private static final String KEY_IMEI = "bd_setting_i";
    private static final String DEFAULT_TM_DEVICEID = "";
    private static final int SDK_ANDROID_M = 23;
    private static final String ACTION_GLAXY_CUID = "com.baidu.intent.action.GALAXY";
    private static final String META_KEY_GLAXY_DATA = "galaxy_data";
    private static final String META_KEY_GALAXY_SF = "galaxy_sf";

    private DeviceId(Context context) {
        this.mContext = context.getApplicationContext();
        this.initPublicKey();
    }

    private static String byte2hex(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String string = DEFAULT_TM_DEVICEID;
        String string2 = DEFAULT_TM_DEVICEID;
        for (int i = 0; i < byArray.length; ++i) {
            string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string2.length() == 1 ? string + "0" + string2 : string + string2;
        }
        return string.toLowerCase();
    }

    private String[] formatAndroidSigArray(Signature[] signatureArray) {
        String[] stringArray = new String[signatureArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = DeviceId.byte2hex(SHA1Util.sha1(signatureArray[i].toByteArray()));
        }
        return stringArray;
    }

    private static byte[] decryptByPublicKey(byte[] byArray, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(2, publicKey);
        return cipher.doFinal(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initPublicKey() {
        ByteArrayInputStream byteArrayInputStream = null;
        byteArrayInputStream = new ByteArrayInputStream(CuidCertStore.getCertBytes());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        this.mPublicKey = certificate.getPublicKey();
        Object var5_5 = null;
        if (byteArrayInputStream == null) return;
        try {
            byteArrayInputStream.close();
            return;
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return;
        {
            catch (Exception exception) {
                Object var5_6 = null;
                if (byteArrayInputStream == null) return;
                try {
                    byteArrayInputStream.close();
                    return;
                }
                catch (Exception exception2) {
                    DeviceId.handleThrowable(exception2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (byteArrayInputStream == null) throw throwable;
            try {
                byteArrayInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                DeviceId.handleThrowable(exception);
            }
            throw throwable;
        }
    }

    private List<CUIDBuddyInfo> collectBuddyInfos(Intent intent, boolean bl) {
        ArrayList<CUIDBuddyInfo> arrayList = new ArrayList<CUIDBuddyInfo>();
        PackageManager packageManager = this.mContext.getPackageManager();
        List list = packageManager.queryBroadcastReceivers(intent, 0);
        if (list != null) {
            for (ResolveInfo resolveInfo : list) {
                if (resolveInfo.activityInfo == null || resolveInfo.activityInfo.applicationInfo == null) continue;
                try {
                    String string;
                    String string2;
                    ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name), 128);
                    Bundle bundle = activityInfo.metaData;
                    if (bundle == null || TextUtils.isEmpty((CharSequence)(string2 = bundle.getString(META_KEY_GLAXY_DATA)))) continue;
                    byte[] byArray = Base64.decode(string2.getBytes("utf-8"));
                    String string3 = new String(byArray);
                    JSONObject jSONObject = new JSONObject(string3);
                    CUIDBuddyInfo cUIDBuddyInfo = new CUIDBuddyInfo();
                    cUIDBuddyInfo.priority = jSONObject.getInt("priority");
                    cUIDBuddyInfo.appInfo = resolveInfo.activityInfo.applicationInfo;
                    if (this.mContext.getPackageName().equals(resolveInfo.activityInfo.applicationInfo.packageName)) {
                        cUIDBuddyInfo.isSelf = true;
                    }
                    if (bl && !TextUtils.isEmpty((CharSequence)(string = bundle.getString(META_KEY_GALAXY_SF)))) {
                        PackageInfo packageInfo = packageManager.getPackageInfo(resolveInfo.activityInfo.applicationInfo.packageName, 64);
                        JSONArray jSONArray = jSONObject.getJSONArray("sigs");
                        String[] stringArray = new String[jSONArray.length()];
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = jSONArray.getString(i);
                        }
                        String[] stringArray2 = this.formatAndroidSigArray(packageInfo.signatures);
                        if (this.isSigsEqual(stringArray, stringArray2)) {
                            boolean bl2;
                            byte[] byArray2 = DeviceId.decryptByPublicKey(Base64.decode(string.getBytes()), this.mPublicKey);
                            byte[] byArray3 = SHA1Util.sha1(byArray);
                            boolean bl3 = bl2 = byArray2 != null && Arrays.equals(byArray2, byArray3);
                            if (bl2) {
                                cUIDBuddyInfo.sigMatched = true;
                            }
                        }
                    }
                    arrayList.add(cUIDBuddyInfo);
                }
                catch (Exception exception) {}
            }
        }
        Collections.sort(arrayList, new Comparator<CUIDBuddyInfo>(){

            @Override
            public int compare(CUIDBuddyInfo cUIDBuddyInfo, CUIDBuddyInfo cUIDBuddyInfo2) {
                int n = cUIDBuddyInfo2.priority - cUIDBuddyInfo.priority;
                if (n == 0) {
                    if (cUIDBuddyInfo.isSelf && cUIDBuddyInfo2.isSelf) {
                        return 0;
                    }
                    if (cUIDBuddyInfo.isSelf) {
                        return -1;
                    }
                    if (cUIDBuddyInfo2.isSelf) {
                        return 1;
                    }
                }
                return n;
            }
        });
        return arrayList;
    }

    private boolean isSigsEqual(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null && stringArray.length == stringArray2.length) {
            Object object;
            int n;
            HashSet<Object> hashSet = new HashSet<Object>();
            String[] stringArray3 = stringArray;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                object = stringArray3[n];
                hashSet.add(object);
            }
            object = new HashSet();
            String[] stringArray4 = stringArray2;
            n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray4[i];
                ((HashSet)object).add(string);
            }
            return hashSet.equals(object);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeToCuidFile(String string) {
        boolean bl;
        FileOutputStream fileOutputStream = null;
        fileOutputStream = this.mContext.openFileOutput(SELF_CUID_FILE, 1);
        fileOutputStream.write(string.getBytes());
        fileOutputStream.flush();
        boolean bl2 = bl = true;
        Object var6_6 = null;
        if (fileOutputStream == null) return bl2;
        try {
            fileOutputStream.close();
            return bl2;
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return bl2;
        catch (Exception exception) {
            try {
                DeviceId.handleThrowable(exception);
                Object var6_7 = null;
                if (fileOutputStream == null) return false;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {
                    DeviceId.handleThrowable(exception2);
                }
                throw throwable;
            }
            try {
                fileOutputStream.close();
                return false;
            }
            catch (Exception exception3) {
                DeviceId.handleThrowable(exception3);
            }
            return false;
        }
    }

    private String getSystemSettingValue(String string) {
        try {
            return Settings.System.getString((ContentResolver)this.mContext.getContentResolver(), (String)string);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return null;
        }
    }

    private boolean tryPutSystemSettingValue(String string, String string2) {
        try {
            return Settings.System.putString((ContentResolver)this.mContext.getContentResolver(), (String)string, (String)string2);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return false;
        }
    }

    private static void handleThrowable(Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeToFile(File file, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        Object var5_3 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            DeviceId.handleThrowable(iOException);
        }
        return;
        {
            catch (IOException iOException) {
                DeviceId.handleThrowable(iOException);
                Object var5_4 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    DeviceId.handleThrowable(iOException2);
                }
                return;
            }
            catch (SecurityException securityException) {
                DeviceId.handleThrowable(securityException);
                Object var5_5 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    DeviceId.handleThrowable(iOException);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                DeviceId.handleThrowable(iOException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFileContent(File file) {
        String string;
        int n;
        FileReader fileReader = null;
        fileReader = new FileReader(file);
        char[] cArray = new char[8192];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        while ((n = fileReader.read(cArray)) > 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        String string2 = string = charArrayWriter.toString();
        Object var8_8 = null;
        if (fileReader == null) return string2;
        try {
            fileReader.close();
            return string2;
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return string2;
        catch (Exception exception) {
            try {
                DeviceId.handleThrowable(exception);
                Object var8_9 = null;
                if (fileReader == null) return null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (fileReader == null) throw throwable;
                try {
                    fileReader.close();
                    throw throwable;
                }
                catch (Exception exception2) {
                    DeviceId.handleThrowable(exception2);
                }
                throw throwable;
            }
            try {
                fileReader.close();
                return null;
            }
            catch (Exception exception3) {
                DeviceId.handleThrowable(exception3);
            }
            return null;
        }
    }

    public static String getCUID(Context context) {
        return DeviceId.getOrCreateCUIDInfo(context).getFinalCUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CUIDInfo getOrCreateCUIDInfo(Context context) {
        Class<CUIDInfo> clazz = CUIDInfo.class;
        synchronized (CUIDInfo.class) {
            if (sCachedCuidInfo == null) {
                long l = SystemClock.uptimeMillis();
                sCachedCuidInfo = new DeviceId(context).getCUIDInfo();
                long l2 = SystemClock.uptimeMillis();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sCachedCuidInfo;
        }
    }

    public static String getDevID(Context context) {
        return DeviceId.getOrCreateCUIDInfo((Context)context).deviceId;
    }

    public static String getIntlMobEqId(Context context) {
        return DeviceId.getOrCreateCUIDInfo((Context)context).imei;
    }

    private static String getDroidName() {
        return "android";
    }

    public static String getDroidId(Context context) {
        String string = DEFAULT_TM_DEVICEID;
        string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)(DeviceId.getDroidName() + "_id"));
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = DEFAULT_TM_DEVICEID;
        }
        return string;
    }

    private CUIDInfo getCUIDInfo() {
        boolean bl;
        Object object2;
        String string;
        int n;
        boolean bl2;
        Object object3;
        CUIDInfo cUIDInfo = null;
        String string2 = null;
        List<CUIDBuddyInfo> list = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID).setPackage(this.mContext.getPackageName()), true);
        if (list != null && list.size() != 0) {
            object3 = list.get(0);
            bl2 = ((CUIDBuddyInfo)object3).sigMatched;
            if (!((CUIDBuddyInfo)object3).sigMatched) {
                for (n = 0; n < 3; ++n) {
                    Log.w((String)TAG, (String)"galaxy config err, In the release version of the signature should be matched");
                }
            }
        } else {
            bl2 = false;
            for (int i = 0; i < 3; ++i) {
                Log.w((String)TAG, (String)"galaxy lib host missing meta-data,make sure you know the right way to integrate galaxy");
            }
        }
        if (((File)(object3 = new File(this.mContext.getFilesDir(), SELF_CUID_FILE))).exists()) {
            cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent((File)object3)));
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 0x10;
            List<CUIDBuddyInfo> list2 = this.collectBuddyInfos(new Intent(ACTION_GLAXY_CUID), bl2);
            if (list2 != null) {
                string = "files";
                object2 = this.mContext.getFilesDir();
                if (!string.equals(((File)object2).getName())) {
                    Log.e((String)TAG, (String)("fetal error:: app files dir name is unexpectedly :: " + ((File)object2).getAbsolutePath()));
                    string = ((File)object2).getName();
                }
                for (CUIDBuddyInfo object4 : list2) {
                    File file;
                    if (object4.isSelf || !(file = new File(new File(object4.appInfo.dataDir, string), SELF_CUID_FILE)).exists() || (cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(DeviceId.getFileContent(file)))) == null) continue;
                    break;
                }
            }
        }
        if (cUIDInfo == null) {
            cUIDInfo = CUIDInfo.createFromJson(DeviceId.decryptCUIDInfo(this.getSystemSettingValue(KEY_DEVICE_ID_V2)));
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 2;
            cUIDInfo = this.getCuidInfoFromDataFileV2(this.mContext);
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 8;
            cUIDInfo = this.getCUidInfoFromSystemSettingV1();
        }
        n = 0;
        if (cUIDInfo == null) {
            this.mSaveMask |= 1;
            string2 = this.getIntlMobEqIdFromSystem(DEFAULT_TM_DEVICEID);
            n = 1;
            cUIDInfo = this.getDataFileV1DeviceId(this.mContext, string2);
        }
        if (cUIDInfo == null) {
            this.mSaveMask |= 4;
            if (n == 0) {
                string2 = this.getIntlMobEqIdFromSystem(DEFAULT_TM_DEVICEID);
            }
            cUIDInfo = new CUIDInfo();
            string = DeviceId.getDroidId(this.mContext);
            if (Build.VERSION.SDK_INT < 23) {
                String string3 = UUID.randomUUID().toString();
                object2 = string2 + string + (String)string3;
            } else {
                object2 = "com.baidu" + string;
            }
            cUIDInfo.deviceId = MD5Util.toMd5(((String)object2).getBytes(), true);
            cUIDInfo.imei = string2;
        }
        string = null;
        object2 = new File(this.mContext.getFilesDir(), SELF_CUID_FILE);
        if ((this.mSaveMask & 0x10) != 0 || !((File)object2).exists()) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = DeviceId.encryptCUIDInfo(cUIDInfo.toPersitString());
            }
            this.writeToCuidFile(string);
        }
        if ((bl = this.hasWriteSettingsPermission()) && ((this.mSaveMask & 2) != 0 || TextUtils.isEmpty((CharSequence)this.getSystemSettingValue(KEY_DEVICE_ID_V2)))) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = DeviceId.encryptCUIDInfo(cUIDInfo.toPersitString());
            }
            this.tryPutSystemSettingValue(KEY_DEVICE_ID_V2, string);
        }
        File file = new File(this.mContext.getFilesDir(), "backups/.SystemConfig/.cuid2");
        if ((this.mSaveMask & 8) != 0 || !file.exists()) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = DeviceId.encryptCUIDInfo(cUIDInfo.toPersitString());
            }
            DeviceId.setDataFileV2DeviceId(this.mContext, string);
        }
        if (bl && ((this.mSaveMask & 1) != 0 || TextUtils.isEmpty((CharSequence)this.getSystemSettingValue(KEY_DEVICE_ID)))) {
            this.tryPutSystemSettingValue(KEY_DEVICE_ID, cUIDInfo.deviceId);
            this.tryPutSystemSettingValue(KEY_IMEI, cUIDInfo.imei);
        }
        if (bl && !TextUtils.isEmpty((CharSequence)cUIDInfo.imei)) {
            File file2 = new File(this.mContext.getFilesDir(), "backups/.SystemConfig/.cuid");
            if ((this.mSaveMask & 2) != 0 || !file2.exists()) {
                DeviceId.setDataFileDeviceId(this.mContext, cUIDInfo.imei, cUIDInfo.deviceId);
            }
        }
        return cUIDInfo;
    }

    private boolean hasWriteSettingsPermission() {
        return this.checkSelfPermission("android.permission.WRITE_SETTINGS");
    }

    private boolean hasReadImeiPermission() {
        return this.checkSelfPermission("android.permission.READ_PHONE_STATE");
    }

    private boolean checkSelfPermission(String string) {
        return this.mContext.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
    }

    private CUIDInfo getCUidInfoFromSystemSettingV1() {
        Object object;
        String string = this.getSystemSettingValue(KEY_DEVICE_ID);
        String string2 = this.getSystemSettingValue(KEY_IMEI);
        if (TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)(string2 = this.getIntlMobEqIdFromSystem(DEFAULT_TM_DEVICEID)))) {
            this.tryPutSystemSettingValue(KEY_IMEI, string2);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            object = DeviceId.getDroidId(this.mContext);
            String string3 = MD5Util.toMd5(("com.baidu" + string2 + (String)object).getBytes(), true);
            string = this.getSystemSettingValue(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            object = new CUIDInfo();
            ((CUIDInfo)object).deviceId = string;
            ((CUIDInfo)object).imei = string2;
            return object;
        }
        return null;
    }

    private CUIDInfo getCuidInfoFromDataFileV2(Context context) {
        String string;
        File file = new File(context.getFilesDir(), "backups/.SystemConfig/.cuid2");
        if (file.exists() && !TextUtils.isEmpty((CharSequence)(string = DeviceId.getFileContent(file)))) {
            try {
                return CUIDInfo.createFromJson(new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(string.getBytes()))));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private CUIDInfo getDataFileV1DeviceId(Context context, String string) {
        Object object;
        boolean bl;
        boolean bl2 = bl = Build.VERSION.SDK_INT < 23;
        if (bl && TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        boolean bl3 = false;
        String string2 = DEFAULT_TM_DEVICEID;
        File file = new File(context.getFilesDir(), "baidu/.cuid");
        if (!file.exists()) {
            file = new File(context.getFilesDir(), "backups/.SystemConfig/.cuid");
            bl3 = true;
        }
        try {
            object = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3);
                stringBuilder.append("\r\n");
            }
            bufferedReader.close();
            String string4 = new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(stringBuilder.toString().getBytes())));
            String[] stringArray = string4.split("=");
            if (stringArray != null && stringArray.length == 2) {
                if (bl && string.equals(stringArray[0])) {
                    string2 = stringArray[1];
                } else if (!bl) {
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string = stringArray[1];
                    }
                    string2 = stringArray[1];
                }
            }
            if (!bl3) {
                DeviceId.setDataFileDeviceId(context, string, string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            object = new CUIDInfo();
            ((CUIDInfo)object).deviceId = string2;
            ((CUIDInfo)object).imei = string;
            return object;
        }
        return null;
    }

    private static String encryptCUIDInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, string.getBytes()), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DeviceId.handleThrowable(unsupportedEncodingException);
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
        }
        return DEFAULT_TM_DEVICEID;
    }

    private static String decryptCUIDInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            return new String(AESUtil.decrypt(AES_KEY, AES_KEY, Base64.decode(string.getBytes())));
        }
        catch (Exception exception) {
            DeviceId.handleThrowable(exception);
            return DEFAULT_TM_DEVICEID;
        }
    }

    private static void setDataFileV2DeviceId(Context context, String string) {
        File file = new File(context.getFilesDir(), EXT_DIR);
        File file2 = new File(file, EXT_FILE_V2);
        try {
            Object object;
            if (file.exists() && !file.isDirectory()) {
                object = new Random();
                File file3 = null;
                File file4 = file.getParentFile();
                String string2 = file.getName();
                while ((file3 = new File(file4, string2 + ((Random)object).nextInt() + ".tmp")).exists()) {
                }
                file.renameTo(file3);
                file3.delete();
            }
            file.mkdirs();
            object = new FileWriter(file2, false);
            ((Writer)object).write(string);
            ((OutputStreamWriter)object).flush();
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setDataFileDeviceId(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(string2);
            File file = new File(context.getFilesDir(), EXT_DIR);
            File file2 = new File(file, EXT_FILE);
            try {
                Object object;
                Object object2;
                if (file.exists() && !file.isDirectory()) {
                    object2 = new Random();
                    object = null;
                    File file3 = file.getParentFile();
                    String string3 = file.getName();
                    while (((File)(object = new File(file3, string3 + ((Random)object2).nextInt() + ".tmp"))).exists()) {
                    }
                    file.renameTo((File)object);
                    ((File)object).delete();
                }
                file.mkdirs();
                object2 = new FileWriter(file2, false);
                object = Base64.encode(AESUtil.encrypt(AES_KEY, AES_KEY, stringBuilder.toString().getBytes()), "utf-8");
                ((Writer)object2).write((String)object);
                ((OutputStreamWriter)object2).flush();
                ((OutputStreamWriter)object2).close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getIntlMobEqIdFromSystem(String string) {
        String string2 = null;
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            if (telephonyManager != null) {
                string2 = Util.getDevId(telephonyManager);
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Read IntlMobEqId failed", (Throwable)exception);
        }
        string2 = DeviceId.imeiCheck(string2);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = string;
        }
        return string2;
    }

    private static String imeiCheck(String string) {
        return null != string && string.contains(":") ? DEFAULT_TM_DEVICEID : string;
    }

    static {
        String string = new String(Base64.decode(new byte[]{77, 122, 65, 121, 77, 84, 73, 120, 77, 68, 73, 61}));
        String string2 = new String(Base64.decode(new byte[]{90, 71, 108, 106, 100, 87, 82, 112, 89, 87, 73, 61}));
        AES_KEY = string + string2;
    }

    private static class CUIDBuddyInfo {
        public ApplicationInfo appInfo;
        public int priority = 0;
        public boolean sigMatched = false;
        public boolean isSelf = false;

        private CUIDBuddyInfo() {
        }
    }

    private static class CUIDInfo {
        public String deviceId;
        public String imei;
        public int version = 2;
        private static final int VERSION = 2;

        private CUIDInfo() {
        }

        public static CUIDInfo createFromJson(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            try {
                JSONObject jSONObject = new JSONObject(string);
                String string2 = jSONObject.getString("deviceid");
                String string3 = jSONObject.getString("imei");
                int n = jSONObject.getInt("ver");
                if (!TextUtils.isEmpty((CharSequence)string2) && string3 != null) {
                    CUIDInfo cUIDInfo = new CUIDInfo();
                    cUIDInfo.deviceId = string2;
                    cUIDInfo.imei = string3;
                    cUIDInfo.version = n;
                    return cUIDInfo;
                }
            }
            catch (JSONException jSONException) {
                DeviceId.handleThrowable(jSONException);
            }
            return null;
        }

        public String toPersitString() {
            try {
                return new JSONObject().put("deviceid", (Object)this.deviceId).put("imei", (Object)this.imei).put("ver", this.version).toString();
            }
            catch (JSONException jSONException) {
                DeviceId.handleThrowable(jSONException);
                return null;
            }
        }

        public String getFinalCUID() {
            String string = this.imei;
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = "0";
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            string = stringBuffer.reverse().toString();
            String string2 = this.deviceId + "|" + string;
            return string2;
        }
    }
}

