/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;

public final class Utility {
    private static final int THOUSAND_DIV = 1000;
    private static final int BYTES_PER_SAMPLE_8BIT = 1;
    private static final int BYTES_PER_SAMPLE_16BIT = 2;
    private static final int BYTES_PER_SHORT = 2;
    private static int maxCpuFreq = 0;
    private static int EVR_NETWORK_TYPE_NO = 0;
    private static int EVR_NETWORK_TYPE_2G = 1;
    private static int EVR_NETWORK_TYPE_3G = 2;
    private static int EVR_NETWORK_TYPE_4G = 3;
    private static int EVR_NETWORK_TYPE_WIFI = 4;
    private static final String TAG = "Utility";
    private static ConnectivityManager mConnManager = null;

    private Utility() {
    }

    static void init(Context context) {
        if (context != null) {
            mConnManager = (ConnectivityManager)context.getSystemService("connectivity");
        }
    }

    public static int getVoiceDataSizeInShort(int n, int n2, int n3) {
        if (n3 != 2 && n3 != 3) {
            throw new IllegalArgumentException("audio format invalid");
        }
        int n4 = n3 == 3 ? 1 : 2;
        int n5 = n * n2 * n4 / 1000;
        int n6 = n5 / 2;
        return n6;
    }

    static String generatePlatformString() {
        StringBuilder stringBuilder = new StringBuilder("Android");
        stringBuilder.append('&');
        try {
            stringBuilder.append(URLEncoder.encode(Build.MODEL, "utf-8"));
            stringBuilder.append('&');
            stringBuilder.append(URLEncoder.encode(Build.VERSION.RELEASE, "utf-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        stringBuilder.append('&');
        stringBuilder.append(Build.VERSION.SDK_INT);
        String string = stringBuilder.toString();
        return string;
    }

    static int getStatusType(int n) {
        return n & 0xFFFF0000;
    }

    private static boolean isRunningEmulator() {
        return Build.MODEL.equals("sdk") || Build.MODEL.equals("google_sdk");
    }

    public static int getMaxCpuFreq() {
        try {
            Object object;
            Object object2;
            String string = "";
            if (0 != maxCpuFreq) {
                return maxCpuFreq;
            }
            if (Utility.isRunningEmulator()) {
                object2 = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"};
                object = new ProcessBuilder((String[])object2);
                Process process = ((ProcessBuilder)object).start();
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[24];
                while (inputStream.read(byArray) != -1) {
                    string = string + new String(byArray);
                }
                inputStream.close();
                process.destroy();
            } else {
                object = null;
                object2 = null;
                String string2 = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq";
                object = new FileReader(string2);
                object2 = new BufferedReader((Reader)object);
                string = ((BufferedReader)object2).readLine();
                ((BufferedReader)object2).close();
                ((InputStreamReader)object).close();
            }
            int n = Utility.getCpuInfo();
            if (TextUtils.isEmpty((CharSequence)string)) {
                return n;
            }
            int n2 = Integer.parseInt(string = string.trim());
            maxCpuFreq = n2 >= n ? n2 : n;
            return maxCpuFreq;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static int getCpuInfo() {
        try {
            String string = "/proc/cpuinfo";
            String string2 = "";
            String string3 = "";
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader, 1024);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("BogoMIPS") == -1) continue;
                String[] stringArray = string2.split("\\s+");
                string3 = stringArray[2];
                break;
            }
            bufferedReader.close();
            string3 = string3.trim();
            return (int)(Float.parseFloat(string3) * 1000.0f);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    static boolean isUsingWifi() {
        NetworkInfo networkInfo;
        boolean bl = false;
        if (mConnManager != null && (networkInfo = mConnManager.getActiveNetworkInfo()) != null) {
            bl = "wifi".equals(networkInfo.getTypeName().toLowerCase());
        }
        return bl;
    }

    public static boolean is2G(Context context) {
        try {
            String string = "";
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (!Utility.isNetworkPerission(context)) {
                return false;
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
                string = networkInfo.getTypeName().toLowerCase();
                if (string.equals("wifi")) {
                    return false;
                }
                int n = networkInfo.getSubtype();
                switch (n) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static boolean isNetworkPerission(Context context) {
        try {
            boolean bl = 0 == context.getPackageManager().checkPermission("android.permission.ACCESS_NETWORK_STATE", context.getPackageName());
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    static boolean isUsingWifi(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            if (!Utility.isNetworkPerission(context)) {
                return false;
            }
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && "wifi".equals(networkInfo.getTypeName().toLowerCase(Locale.US))) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static int getWifiOr2gOr3G(Context context) {
        int n = EVR_NETWORK_TYPE_NO;
        try {
            if (context != null) {
                ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
                if (!Utility.isNetworkPerission(context)) {
                    return n;
                }
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnectedOrConnecting()) {
                    String string = networkInfo.getTypeName().toLowerCase();
                    if (string.equals("wifi")) {
                        n = EVR_NETWORK_TYPE_WIFI;
                    } else {
                        n = EVR_NETWORK_TYPE_2G;
                        int n2 = networkInfo.getSubtype();
                        switch (n2) {
                            case 7: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 4: {
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 5: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 6: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 8: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 10: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 9: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 3: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 14: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 12: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 15: {
                                n = EVR_NETWORK_TYPE_3G;
                                break;
                            }
                            case 11: {
                                break;
                            }
                            case 13: {
                                n = EVR_NETWORK_TYPE_4G;
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static String urlEncode(String string, String string2) {
        try {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                string = URLEncoder.encode(string, string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static boolean checkPermission(Context context, String string) {
        int n = context.checkCallingOrSelfPermission(string);
        return n == 0;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = Utility.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }

    public static boolean isWifiConnected(Context context) {
        NetworkInfo networkInfo = Utility.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected() && networkInfo.getType() == 1;
    }

    public static String getLineNumber(Exception exception) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return null;
        }
        return stackTraceElementArray[0].getFileName() + ":" + stackTraceElementArray[0].getLineNumber();
    }

    public static String getFileName(Exception exception) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return null;
        }
        return stackTraceElementArray[0].getFileName();
    }

    public static String fun(Exception exception) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray == null) {
            return "";
        }
        return stackTraceElementArray[0].getMethodName() + "()";
    }
}

