/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.speech.utils.analysis;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Base64;
import android.util.DisplayMetrics;
import com.baidu.speech.VoiceRecognitionService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.zip.GZIPOutputStream;

public class Utility {
    private static final String SHARED_PREFERENCE_NAME = "tts";
    private static final String KEY_LSAT_UPLOAD_STAT_TIME = "last_upload_stat_time";
    private static final String KEY_LSAT_DOWNLOAD_STAT_PERIOD = "last_download_stat_period";
    private static final String SDK_VERSION_NAME = "1.0.0-20140804";

    public static void setLastUploadStatTime(Context context, long l) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(KEY_LSAT_UPLOAD_STAT_TIME, l);
        editor.commit();
    }

    public static long getLastUploadStatTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        long l = sharedPreferences.getLong(KEY_LSAT_UPLOAD_STAT_TIME, 0L);
        return l;
    }

    public static void setLastDownloadStatPeriod(Context context, int n) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(KEY_LSAT_DOWNLOAD_STAT_PERIOD, n);
        editor.commit();
    }

    public static int getLastDownloadStatPeriod(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREFERENCE_NAME, 0);
        int n = sharedPreferences.getInt(KEY_LSAT_DOWNLOAD_STAT_PERIOD, 0);
        return n;
    }

    public static String encryptBASE64(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes("utf-8");
            return new String(Base64.encode((byte[])byArray, (int)0, (int)byArray.length, (int)0), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String encryptBASE64(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return new String(Base64.encode((byte[])byArray, (int)0, (int)byArray.length, (int)0), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptGZIP(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string.getBytes("utf-8"));
            gZIPOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static String getSdkVersion() {
        return VoiceRecognitionService.getSdkVersion();
    }

    public static String getAppName(Context context) {
        return Utility.getApplicationName(context);
    }

    public static String getPlatform(Context context) {
        return Utility.getOS() + "&" + Build.MODEL + "&" + Build.VERSION.RELEASE + "&" + Build.VERSION.SDK_INT + "&" + Utility.getNetType(context);
    }

    public static String getOS() {
        return "Android";
    }

    @SuppressLint(value={"DefaultLocale"})
    public static int getNetType(Context context) {
        int n = 3;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && "wifi".equals(networkInfo.getTypeName().toLowerCase())) {
            n = 1;
        }
        return n;
    }

    public static String getScreen(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        return n + "*" + n2;
    }

    public static String getSdkName() {
        return "\u79bb\u7ebfTTS SDK";
    }

    public static String getPackageName(Context context) {
        String string = context.getPackageName();
        return string;
    }

    public static String getSignatureMD5(Context context) {
        String string = null;
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature[] signatureArray = packageInfo.signatures;
            Signature signature = signatureArray[0];
            string = Utility.parseSignature(signature.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private static String parseSignature(byte[] byArray) {
        String string = null;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(x509Certificate.getEncoded());
            string = Utility.toHexString(messageDigest.digest());
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return string;
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(0xFF & byArray[i]);
            if (string.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static String getApplicationName(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            applicationInfo = null;
        }
        String string = (String)packageManager.getApplicationLabel(applicationInfo);
        return string;
    }

    public static boolean checkPermission(Context context, String string) {
        int n = context.checkCallingOrSelfPermission(string);
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getLicenseDataFromFile(String string, byte[] byArray) {
        int n;
        block14: {
            FileInputStream fileInputStream = null;
            n = -1;
            fileInputStream = new FileInputStream(string);
            n = fileInputStream.read(byArray);
            Object var6_4 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block14;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    Object var6_5 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var6_6 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        return n;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager.getActiveNetworkInfo();
    }

    public static boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = Utility.getNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }
}

