<?php
class Checkpost{

	/**
	 * 验证是否为指定长度的字母/数字组合
	 * @param number $num1  最少多少个
	 * @param number $num2  最长多少个
	 * @param string $str  验证字符串
	 * @return boolean true 或 false
	 * */
	function Ctext1($num1,$num2,$str){
	     Return (preg_match("/^[a-zA-Z0-9]{".$num1.",".$num2."}$/",$str))?true:false;
	}
	
	/**
	 * 验证是否指定长度的数字
	 * @param number $num1 最少多少个
	 * @param number $num2 最多多少个
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Ctext2($num1,$num2,$str){
	    return (preg_match("/^[0-9]{".$num1.",".$num2."}$/i",$str))?true:false;
	}
	
	/**
	 * 验证是否为指定长度汉字
	 * @param number $num1 最少多少个
	 * @param number $num2 最多多少个
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Cfont($num1,$num2,$str){
	// preg_match("/^[\xa0-\xff]{1,4}$/", $string);    
	    return (preg_match("/^([\x81-\xfe][\x40-\xfe]){".$num1.",".$num2."}$/",$str))?true:false;
	}
	
	/**
	 * 验证字符串长度是否符合指定长度
	 * @param number $num1 最少多少个
	 * @param number $num2 最多多少个,不填为无限
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Cstrlen($num1,$num2,$str){
		return !empty($num2) ? (strlen($str)>$num1 && strlen($str)<$num2 ?true:false):(strlen($str)>$num1 ?true:false);
	}
	
	/**
	 * 验证两次输入的密码是否相同,不检查空
	 * @param string $pw1 第一次输入的密码
	 * @param string $pw2 第二次输入的密码
	 * @return string true 或 false
	 * */
	function Cpassword($pw1,$pw2){
		return   trim($pw1)==trim($pw2) ? true:false;
	}
	
	/**
	 * 验证utf-8的中文 中间可以包括中文
	 * @param number $num1 最少多少个
	 * @param number $num2 最多多少个
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Cfont_utf($num1,$num2,$str){
		return (preg_match("/^([0-9]|[a-z]|[A-Z]|[\x{4e00}-\x{9fa5}]|[^\s]*\s[^\s]){".$num1.",".$num2."}$/u",$str))?true:false;
	}

	/**
	 * 验证身份证号码
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Cstatus($str){
	    return (preg_match('/(^([\d]{15}|[\d]{18}|[\d]{17}x)$)/',$str))?true:false;
	}

	/**
	 * 验证邮箱地址
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Cemail($str){    
	    return (preg_match('/^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,4}$/',$str))?true:false;
	}

	/**
	 * 验证电话号码
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Ctel($str){
	  return (preg_match("/^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$/",$str))?true:false;
	}
	
	/**
	 * 验证手机号码，不包括＋81在内
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Cmobel($str){
	  return (preg_match("/^(?:13\d|15[89]|18[89])-?\d{5}(\d{3}|\*{3})$/",$str))?true:false;
	}
	

	/**
	 * 验证邮编
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Czip($str){
	  return (preg_match("/^[1-9]\d{5}$/",$str))?true:false;
	}

	/**
	 * 验证url地址
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Curl($str){
	  return (preg_match("/^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/",$str))?true:false;
	}

	/**
	 * 验证日期
	 * @param string $str 验证字符串
	 * @return boolean true 或 false
	 * */
	function Cdate($str){
	  return (preg_match('/^(?:(?!0000)[0-9]{4}([-\/.]?)(?:(?:0?[1-9]|1[0-2])\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\1(?:29|30)|(?:0?[13578]|1[02])\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-\/.]?)0?2\2(?:29))$/',$str))?true:false;
	}

}
?>