NewsClassPanel=Ext.extend(EasyJF.Ext.CrudPanel,{
    id:"newsClassPanel",
    title:"新闻分类管理",
    baseUrl:"newsClass.php",
    entityIdName:"id",
    createForm:function(){
        var formPanel=new Ext.form.FormPanel({
            frame:true,
            labelWidth:70,
            labelAlign:'right',
            defaultType:'textfield',
            defaults:{
                anchor:"-20"
            },
            items:[{
                xtype:"hidden",
                name:this.entityIdName
                },

                {
                xtype:"hidden",
                fieldLabel:'fid',
                name:'fid'
            },
{
                fieldLabel:'分类名称',
                name:'name'
            }
            ]
        });

        return formPanel;
    },
    createWin:function(){
        return this.initWin(438,300,"新闻分类管理");
    },
    storeMapping:["id","fid","name"    	],
    initComponent : function(){
        this.cm=new Ext.grid.ColumnModel([
            new Ext.grid.RowNumberer(),
            {
                header: "分类名称",
                sortable:true,
                width: 300,
                dataIndex:"name"
            }
            ]);
        NewsClassPanel.superclass.initComponent.call(this);
    }
});