NewsInfoPanel=Ext.extend(EasyJF.Ext.CrudPanel,{
	id:"newsInfoPanel",
	title:"新闻管理",
	baseUrl:"newsInfo.php",
	entityIdName:"id",
	createForm:function(){
	var formPanel=new Ext.form.FormPanel({
		frame:true,
		labelWidth:70,
		labelAlign:'right',
		defaultType:'textfield',
                        defaults:{anchor:"-20"},
                        items:[{xtype:"hidden",name:this.entityIdName},
new Ext.form.ComboBox({
                        hiddenName:'newsid',
                        value:'请选择新闻分类',
                        store:new Ext.data.JsonStore({
                                autoLoad:true,
                                root:'result',
                                url: 'newsClass.php?cmd=list',
                                //url:'test.php',
                                fields : [{name : 'id'}, {name : 'name'}]
                            }),
                        fieldLabel:'新闻分类',
                        valueField:"id",
                        displayField:"name",
                        editable:false,
                        triggerAction:"all",
                        typeAhead:true,
                        mode : 'local'
                    }),
{ fieldLabel:'标题',name:'title'  },
{ xtype : "StarHtmleditor",
    name : "content",
    fieldLabel : "内容",
    anchor : "98%"},
{ xtype:"hidden",fieldLabel:'posttime',name:'posttime'  },
{ xtype:"hidden",fieldLabel:'userid',name:'userid'  },
{ fieldLabel:'关键词',name:'keywords'  }
	]
	});

		return formPanel;
    },
    createWin:function(){
    	return this.initWin(800,500,"新闻管理");
    },
    storeMapping:["id","newsid","title","content","posttime","userid","keywords","username","newsclassname"    	],
	initComponent : function(){
    this.cm=new Ext.grid.ColumnModel([
 new Ext.grid.RowNumberer(),
{header: "标题", sortable:true,width: 300, dataIndex:"title"},
{header: "新闻分类", sortable:true,width: 300, dataIndex:"newsclassname"},
{header: "内容", sortable:true,width: 300, dataIndex:"content",hidden:true},
{header: "发布时间", sortable:true,width: 300, dataIndex:"posttime"},
{header: "作者", sortable:true,width: 300, dataIndex:"username"},
{header: "关键词", sortable:true,width: 300, dataIndex:"keywords"}
        ]);
	NewsInfoPanel.superclass.initComponent.call(this);
}
});
/*
combStore = new Ext.data.JsonStore({
    autoLoad:true,
    url: 'gameClass.php?cmd=list',
    fields : [{name : 'id'}, {name : 'name'}]
});

*/

/**
 * 重载EXTJS-HTML编辑器
 *
 * @class HTMLEditor
 * @extends Ext.form.HtmlEditor
 * @author wuliangbo
 */
HTMLEditor = Ext.extend(Ext.form.HtmlEditor, {
	addImage : function() {
		var editor = this;
		var imgform = new Ext.FormPanel({
			region : 'center',
			labelWidth : 55,
			frame : true,
			bodyStyle : 'padding:5px 5px 0',
			autoScroll : true,
			border : false,
			fileUpload : true,
			items : [{
						xtype : 'textfield',
						fieldLabel : '选择文件',
						name : 'upfile',
						inputType : 'file',
						allowBlank : false,
						blankText : '文件不能为空',
						height : 25,
						anchor : '90%'
					}],
			buttons : [{
				text : '上传',
				type : 'submit',
				handler : function() {
					if (!imgform.form.isValid()) {return;}
					imgform.form.submit({
						waitMsg : '正在上传......',
						url : '../upload.php',
						success : function(form, action) {
							var element = document.createElement("img");
							element.src = action.result.fileURL;
							if (Ext.isIE) {
								editor.insertAtCursor(element.outerHTML);
							} else {
								var selection = editor.win.getSelection();
								if (!selection.isCollapsed) {
									selection.deleteFromDocument();
								}
								selection.getRangeAt(0).insertNode(element);
							}
							win.hide();
						},
						failure : function(form, action) {
							form.reset();
							if (action.failureType == Ext.form.Action.SERVER_INVALID)
								Ext.MessageBox.alert('警告',
										action.result.errors.msg);
						}
					});
				}
			}, {
				text : '关闭',
				type : 'submit',
				handler : function() {
					win.close(this);
				}
			}]
		})

		var win = new Ext.Window({
					title : "上传图片",
					width : 300,
					height : 200,
					modal : true,
					border : false,
					iconCls : "images/icons/picture.png",
					layout : "fit",
					items : imgform

				});
		win.show();
	},
	createToolbar : function(editor) {
		HTMLEditor.superclass.createToolbar.call(this, editor);
		this.tb.insertButton(16, {
					cls : "x-btn-icon",
					icon : "images/icons/picture.png",
					handler : this.addImage,
					scope : this
				});
	}
});
Ext.reg('StarHtmleditor', HTMLEditor);