Ext.apply(Ext.form.VTypes, {
			password : function(val, field) {
				if (field.initialPassField) {
					var pwd = Ext.getCmp(field.initialPassField);
					return (val == pwd.getValue());
				}
				return true;
			},
			passwordText : '两次输入的密码不一致，请重新输入',

			emailvalidator : function(val, field) {
				if (field.initialField) {
					var em = Ext.getCmp(field.initialField);
					return (val == em.getValue());
				}
				return true;
			},
			emailvalidatorText : '两次输入的邮箱地址不一致，请重新输入'
		});

	Ext.QuickTips.init();
	Ext.form.Field.prototype.msgTarget = 'qtip';	

	var form = new Ext.FormPanel({
		title : '新会员注册',
		width : 700,
		autoHeight : true,
		//renderTo : 'form-ct',
		bodyStyle : "padding:2px",
		border : false,
		frame : true,
		items : [{
			autoHeight : true,
			xtype : 'fieldset',
			title : '必填注册信息',
			items : [{// 用户名信息
				layout : 'column',
				defaults : {
					columnWidth : '.5'
				},
				items : [{
							layout : 'form',
							items : {
								fieldLabel : '用户名',
								xtype : 'textfield',
								name : 'userName',
								allowBlank : false,
								blankText : '用户名不能为空',
								minLength : 4,
								minLengthText : '用户名长度不得小于4个字符的长度',
								maxLength : 20,
								maxLengthText : '用户名长度不得大于20个字符的长度',
								anchor : '95%'
							}
						}, {
							xtype : 'label',
							html : '<font color="red">*</font>&nbsp;长度限制为4－20小写字母数字'
						}]
			}, {	// 密码信息
						layout : 'column',
						items : [{
									columnWidth : '.4',
									layout : 'form',
									items : {
										fieldLabel : '密码',
										xtype : 'textfield',
										inputType : 'password',
										allowBlank : false,
										blankText : '密码不能为空',
										minLength : 6,
										minLengthText : '密码长度不得小于6个字符长度',
										name : 'pass',
										id : 'pass',
										anchor : '95%'
									}
								}, {
									columnWidth : '.6',
									layout : 'form',
									xtype : 'label',
									html : '<font color="red">*</font>&nbsp;至少6位，区分大小写'
								}]
					}, {// 重复密码信息
						layout : 'column',
						items : [{
									columnWidth : '.4',
									layout : 'form',
									items : {
										fieldLabel : '重复密码',
										xtype : 'textfield',
										name:'repass',
										inputType : 'password',
										anchor : '95%',
										vtype : 'password',
										initialPassField : 'pass'
									}
								}, {
									columnWidth : '.6',
									layout : 'form',
									xtype : 'label',
									html : '<font color="red">*</font>&nbsp;至少6位，区分大小写，并且和初始密码一致'
								}]
					}, {// 邮箱信息
						layout : 'column',
						items : [{
									columnWidth : '.5',
									layout : 'form',
									items : {
										fieldLabel : '邮箱',
										xtype : 'textfield',
										allowBlank : false,
										blankText : 'email地址不能为空',
										vtype : 'email',
										emailText : '邮箱格式不匹配(user@domain.com)',
										name : 'email',
										id : 'email',
										anchor : '95%'
									}
								},{
									columnWidth : '.11',
									defaultType : 'checkbox',
									defaults : {
										layout : 'form'
									}
								}, {
									columnWidth : '.05',
									layout : 'form',
									xtype : 'label',
									html : '<font color="red">*</font>&nbsp;'
								}]
					}, {// 确认邮箱信息
						layout : 'column',
						defaults : {
							layout : 'form',
							columnWidth : '.5'
						},
						items : [{
									items : {
										fieldLabel : '确认邮箱',
										xtype : 'textfield',
										name:'reemail',
										vtype : 'emailvalidator',
										initialField : 'email',
										anchor : '95%'
									}
								}, {
									xtype : 'label',
									html : '<font color="red">*</font>'
								}]
					}]
		}],
		buttons : [{
					text : '提交',
					scope:this,
					handler:function(){
						if (form.getForm().isValid()) {
                                                    this.disabled = true;
                                                    form.getForm().doAction('submit', {
                                                        url: 'admin/user.php?cmd=register',
                                                        method: 'post',
                                                        success: function(form, action) {
                                                            Ext.MessageBox.alert('注册', "注册成功！");
                                                            window.location="index.php";
                                                            regWin.hide();                                                            
                                                        },
                                                        failure: function(form, action) {
                                                            Ext.MessageBox.alert('错误', action.result.info);
                                                            regWin.hide();
                                                            window.location="index.php";
                                                        }
                                                    })
                                                }
					}
				}, {
					text : '重置',
					handler:function(){
						form.form.reset();
					}
				}]
	});
        regWin = new Ext.Window({
                    width:700,
                    height:300,
                    title:'蓝色动力网络-游戏卡领取系统',
                    plain:true,
                    resizable:false,
                    frame:true,
                    layout:'fit',
                    border:false,
                    modal:true,
                    bodyStyle: 'padding: 5px',
                    maximizable: false,
                    collasible: true,
                    buttonAlign: 'center',
                    items:[form]                    
               });
                

