<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.com
// This is not a free software, please to pay for more functions
// $Id: 2010-3-21 version 3.3 $
///////////////////////////////////////////////////////////////////
if(!defined('STCMS_ROOT')) {
	define('STCMS_ROOT', str_replace('\\', '/', dirname(dirname(__FILE__)).'/'));
}
define('UC_CLIENT_VERSION', '1.5.0');	//note UCenter 版本标识
define('UC_CLIENT_RELEASE', '20081031');

define('API_DELETEUSER', 1);		//note 用户删除 API 接口开关
define('API_RENAMEUSER', 1);		//note 用户改名 API 接口开关
define('API_GETTAG', 1);		//note 获取标签 API 接口开关
define('API_SYNLOGIN', 1);		//note 同步登录 API 接口开关
define('API_SYNLOGOUT', 1);		//note 同步登出 API 接口开关
define('API_UPDATEPW', 1);		//note 更改用户密码 开关
define('API_UPDATEBADWORDS', 1);	//note 更新关键字列表 开关
define('API_UPDATEHOSTS', 1);		//note 更新域名解析缓存 开关
define('API_UPDATEAPPS', 1);		//note 更新应用列表 开关
define('API_UPDATECLIENT', 1);		//note 更新客户端缓存 开关
define('API_UPDATECREDIT', 1);		//note 更新用户积分 开关
define('API_GETCREDITSETTINGS', 1);	//note 向 UCenter 提供积分设置 开关
define('API_GETCREDIT', 1);		//note 获取用户的某项积分 开关
define('API_UPDATECREDITSETTINGS', 1);	//note 更新应用积分设置 开关

define('API_RETURN_SUCCEED', '1');
define('API_RETURN_FAILED', '-1');
define('API_RETURN_FORBIDDEN', '-2');

//note 普通的 http 通知方式
if(!defined('IN_UC')) {

	@error_reporting(E_ALL ^E_NOTICE);
	@set_magic_quotes_runtime(0);

	defined('MAGIC_QUOTES_GPC') || define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc());
	require_once STCMS_ROOT.'plugins/uc/config.uc.php';		//调入UC配置文档
	defined('UC_COOKIE_PATH') or define('UC_COOKIE_PATH', '/');
	defined('UC_COOKIE_DOMAIN') or define('UC_COOKIE_DOMAIN', '');
	$_DCACHE = $get = $post = array();

	$code = @$_GET['code'];
	parse_str(_authcode($code, 'DECODE', UC_KEY), $get);
	if(MAGIC_QUOTES_GPC) {
		$get = _stripslashes($get);
	}
	$timestamp = time();
	if($timestamp - $get['time'] > 3600) {
		exit('Authracation has expiried');
	}
	if(empty($get)) {
		exit('Invalid Request');
	}
	$action = $get['action'];
	require_once STCMS_ROOT.'plugins/uc/uc_client/lib/xml.class.php';
	$post = xml_unserialize(file_get_contents('php://input'));

	if(in_array($get['action'], array('test', 'deleteuser', 'renameuser', 'gettag', 'synlogin', 'synlogout', 'updatepw', 'updatebadwords', 'updatehosts', 'updateapps', 'updateclient', 'updatecredit', 'getcreditsettings', 'updatecreditsettings'))) {
		$get = uc2stcms($get); $post = uc2stcms($post);
		require_once STCMS_ROOT.'config.inc.php'; 	//调入STCMS配置文档
		require_once STCMS_ROOT.'include/mysql.class.php';	//调入STCMS mysql处理类
		$GLOBALS['db'] = new mysql();	//初始化STCMS mysql
		$uc_note = new uc_note();
		exit($uc_note->$get['action']($get, $post));
	} else {
		exit(API_RETURN_FAILED);
	}

//note include 通知方式
} else {

	error_reporting(E_ALL ^E_NOTICE);
	require_once STCMS_ROOT.'plugins/uc/config.uc.php';		//调入UC配置文档
	require_once STCMS_ROOT.'config.inc.php'; 	//调入STCMS配置文档
	defined('UC_COOKIE_PATH') or define('UC_COOKIE_PATH', '/');
	defined('UC_COOKIE_DOMAIN') or define('UC_COOKIE_DOMAIN', false);
	require_once STCMS_ROOT.'include/mysql.class.php';	//调入STCMS mysql处理类
	$GLOBALS['db'] = new mysql();	//初始化STCMS mysql
}

class uc_note {

	var $dbconfig = '';
	var $db = '';
	var $tablepre = '';
	var $appdir = '';

	function _serialize($arr, $htmlon = 0) {
		if(!function_exists('xml_serialize')) {
			include_once STCMS_ROOT.'plugins/uc/uc_client/lib/xml.class.php';
		}
		return xml_serialize($arr, $htmlon);
	}

	function uc_note() {
		$this->appdir = STCMS_ROOT.'plugins/uc/';	// 初始化应用地址 STCMS_ROOT/plugnis/uc/
		$this->dbconfig = $this->appdir.'config.uc.php';	// 初始化应用配置文档地址 STCMS_ROOT/plugnis/uc/config.uc.php
		$this->db = $GLOBALS['db'];
	}

	function test($get, $post) {
		return API_RETURN_SUCCEED;
	}

	function deleteuser($get, $post) {
		!API_DELETEUSER && exit(API_RETURN_FORBIDDEN);
		$uids = $get['ids'];
		$this->db->query("DELETE FROM ".DB_PREFIX."member WHERE id IN ($uids)");
		$this->db->query("DELETE FROM ".DB_PREFIX."member_favourite WHERE uid IN ($uids)");
		return API_RETURN_SUCCEED;
	}

	function renameuser($get, $post) {
		if(!API_RENAMEUSER) {
			return API_RETURN_FORBIDDEN;
		}
		$uid = $get['uid'];
		$usernameold = $get['oldusername'];
		$usernamenew = $get['newusername'];
		$this->db->query("UPDATE ".DB_PREFIX."member SET name='{$usernamenew}' WHERE name='{$usernameold}'");
		return API_RETURN_SUCCEED;
	}
	
	function synlogin($get, $post) {
		if(!API_SYNLOGIN) {
			return API_RETURN_FORBIDDEN;
		}
		$username = $get['username'];
		header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
		if($member = $this->db->fetch($this->db->query("SELECT id, name, typeid, money, lastlogin, status FROM ".DB_PREFIX."member WHERE name='{$username}'"))) {
			$member['loginAt'] = time();
			$member['loginTime'] = 24*3600;
			require(STCMS_ROOT.'model/cookie.model.php');
			$COOKIE_MODEL = new cookieModel();
			$cookieStr = $COOKIE_MODEL->encode($member);
			setcookie('STCMS_member', $cookieStr, 24*3600+time(), UC_COOKIE_PATH, UC_COOKIE_DOMAIN);
		}
	}

	function synlogout($get, $post) {
		if(!API_SYNLOGOUT) {
			return API_RETURN_FORBIDDEN;
		}
		header('P3P: CP="CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR"');
		setcookie('STCMS_member', '', time()-86400*365, UC_COOKIE_PATH, UC_COOKIE_DOMAIN);
	}

	function updatepw($get, $post) {
		if(!API_UPDATEPW) {
			return API_RETURN_FORBIDDEN;
		}
		$username = $get['username'];
		$password = md5(time().rand(100000, 999999));
		$this->db->query("UPDATE ".DB_PREFIX."member SET pwd='{$password}' WHERE name='{$username}'");
		return API_RETURN_SUCCEED;
	}

	function gettag($get, $post) {
		$name = $get['id'];
		if(!API_GETTAG) {
			return API_RETURN_FORBIDDEN;
		}

		require $this->dbconfig;
		require_once $this->appdir.'./include/db_'.UC_CONNECT.'.class.php';

		$db = new dbstuff;
		$this->db->connect(UC_DBHOST, UC_DBUSER, UC_DBPW, UC_DBNAME, UC_DBCONNECT, true, UC_DBCHARSET);

		$name = trim($name);
		if(empty($name) || !preg_match('/^([\x7f-\xff_-]|\w|\s)+$/', $name) || strlen($name) > 20) {
			return API_RETURN_FAILED;
		}

		require_once $this->appdir.'./include/misc.func.php';

		$tag = $this->db->fetch_first("SELECT * FROM ".$this->tablepre."tags WHERE tagname='$name'");
		if($tag['closed']) {
			return API_RETURN_FAILED;
		}

		$tpp = 10;
		$PHP_SELF = $_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME'];
		$boardurl = 'http://'.$_SERVER['HTTP_HOST'].preg_replace("/\/+(api)?\/*$/i", '', substr($PHP_SELF, 0, strrpos($PHP_SELF, '/'))).'/';
		$query = $this->db->query("SELECT t.* FROM ".$this->tablepre."threadtags tt LEFT JOIN ".$this->tablepre."threads t ON t.tid=tt.tid AND t.displayorder>='0' WHERE tt.tagname='$name' ORDER BY tt.tid DESC LIMIT $tpp");
		$threadlist = array();
		while($tagthread = $this->db->fetch_array($query)) {
			if($tagthread['tid']) {
				$threadlist[] = array(
					'subject' => $tagthread['subject'],
					'uid' => $tagthread['authorid'],
					'username' => $tagthread['author'],
					'dateline' => $tagthread['dateline'],
					'url' => $boardurl.'viewthread.php?tid='.$tagthread['tid'],
				);
			}
		}

		$return = array($name, $threadlist);
		return $this->_serialize($return, 1);
	}

	function updatebadwords($get, $post) {
		if(!API_UPDATEBADWORDS) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = $cachefile.'plugins/uc/uc_client/data/cache/badwords.php';
		$fp = fopen($cachefile, 'w');
		$data = array();
		if(is_array($post)) {
			foreach($post as $k => $v) {
				$data['findpattern'][$k] = $v['findpattern'];
				$data['replace'][$k] = $v['replacement'];
			}
		}
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'badwords\'] = '.var_export($data, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	function updatehosts($get, $post) {
		if(!API_UPDATEHOSTS) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = STCMS_ROOT.'plugins/uc/uc_client/data/cache/hosts.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'hosts\'] = '.var_export($post, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	function updateapps($get, $post) {
		if(!API_UPDATEAPPS) {
			return API_RETURN_FORBIDDEN;
		}
		$UC_API = $post['UC_API'];
		$cachefile = STCMS_ROOT.'plugins/uc/uc_client/data/cache/apps.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'apps\'] = '.var_export($post, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		if(is_writeable(STCMS_ROOT.'plugins/uc/config.uc.php')) {
			$configfile = trim(file_get_contents(STCMS_ROOT.'plugins/uc/config.uc.php'));
			$configfile = substr($configfile, -2) == '?>' ? substr($configfile, 0, -2) : $configfile;
			$configfile = preg_replace("/define\('UC_API',\s*'.*?'\);/i", "define('UC_API', '$UC_API');", $configfile);
			if($fp = @fopen(STCMS_ROOT.'plugins/uc/config.uc.php', 'w')) {
				@fwrite($fp, trim($configfile));
				@fclose($fp);
			}
		}
		return API_RETURN_SUCCEED;
	}

	function updateclient($get, $post) {
		if(!API_UPDATECLIENT) {
			return API_RETURN_FORBIDDEN;
		}
		$cachefile = STCMS_ROOT.'plugins/uc/uc_client/data/cache/settings.php';
		$fp = fopen($cachefile, 'w');
		$s = "<?php\r\n";
		$s .= '$_CACHE[\'settings\'] = '.var_export($post, TRUE).";\r\n";
		fwrite($fp, $s);
		fclose($fp);
		return API_RETURN_SUCCEED;
	}

	function updatecredit($get, $post) {
		if(!API_UPDATECREDIT) {
			return API_RETURN_FORBIDDEN;
		}
		$amount = intval($get['amount']);
		$uid = intval($get['uid']);
		$this->db->query("UPDATE ".DB_PREFIX."member SET money=money+'$amount' WHERE id='{$uid}'");
		return API_RETURN_SUCCEED;
	}

	function getcredit($get, $post) {
		if(!API_GETCREDIT) {
			return API_RETURN_FORBIDDEN;
		}
		$uid = intval($get['uid']);
		$money = $this->db->fetch($this->db->query("SELECT money FROM ".DB_PREFIX."member WHERE id='{$uid}'"));
		echo $money ? $money['money'] : 0;
	}

	function getcreditsettings($get, $post) {
		if(!API_GETCREDITSETTINGS) {
			return API_RETURN_FORBIDDEN;
		}
		$credits[1] = array('积分','个');
		return $this->_serialize($credits);
	}

	function updatecreditsettings($get, $post) {
		if(!API_UPDATECREDITSETTINGS) {
			return API_RETURN_FORBIDDEN;
		}
		return API_RETURN_SUCCEED;
	}
}

function _authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {
	$ckey_length = 4;

	$key = md5($key ? $key : UC_KEY);
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
				return '';
			}
	} else {
		return $keyc.str_replace('=', '', base64_encode($result));
	}

}

function _stripslashes($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = _stripslashes($val);
		}
	} else {
		$string = stripslashes($string);
	}
	return $string;
}
function uc2stcms($data) {
	if($data && !in_array(strtolower(UC_CHARSET), array('utf8', 'utf-8'))) {
		if(is_array($data)) {
			foreach($data as $k => $v) {
				$data[$k] = uc2stcms($v);
			}
		} else {
			$data = iconv(UC_CHARSET, 'UTF-8', $data);
		}
	}
	return $data;
}
?>