<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.com
// This is not a free software, please to pay for more functions
// $Id: 2010-3-21 version 3.3 $
///////////////////////////////////////////////////////////////////
define("UPLOAD_EXT", $CONFIG['uploadExt']);
class upload
{
	/*
	*the tmp_name of the ouploading file
	* 临时文件路径
	*/
    var $file;
	
	/*
	* the name ot the uploading file
	* 文件名
	*/
    var $fileName;
	
	/*
	* the size of the oploading file
	* 文件大小
	*/
    var $fileSize;
	
	/*
	* the type of the uploading file
	* 文件类型
	*/
    var $fileExt;
	
    /*
	* the name of the file you want to save as
	* 保存名
	*/
    var $saveName;

    /*
	* the path you want to save the file to
	* 保存路径
	*/
    var $savePath = UPLOAD_PATH;
	
	/*
	* the last save address of the file
	* 保存地址 
	*/
	var $saveTo;
	
	/**
	* the url of the file 
	* 上传文件地址
	*/
	var $fileURL='';
    
	/*
	* the file format allowed
	* 文件格式限定，多个后缀之间用 | 隔开
	*/
    var $fileExtArray = UPLOAD_EXT;
    
	/*
	* the model of the file overwriting
	* 覆盖模式 
	*/
    var $overWrite = 0;
    
	/*
	* the allowed maxsize of the ouploading file
	* 文件最大字节 
	*/
    var $maxSize= 0;
    	
    /**
     * 构造函数
     * @param array 文件信息数组 'file' 临时文件所在路径及文件名
                                 'name' 上传文件名
                                 'size' 上传文件大小
                                 'type' 上传文件类型
     * @param string 文件保存名
     * @param string 文件保存路径
     * @param string 文件格式限制，例如 jpg|gif|bmp|png|rar|zip|doc|txt
     * @param bool 是否覆盖 1 允许覆盖 0 禁止覆盖
     * @param int 文件最大尺寸
     */
    function upload($fileArr=array(), $saveName='', $savePath='', $fileExt='', $overWrite= 0, $maxSize= 0) {
        $this->file = $fileArr['tmp_name'];
        $this->fileName = $fileArr['name'];
        $this->fileSize = $fileArr['size'];
        $this->fileExt = $fileExt ? $fileExt : $this->getExt($this->fileName);
		$this->fileError = $fileArr['error'];
        $this->savePath = $savePath ? $this->setSavePath($savePath) : $this->setSavePath($this->savePath);
        $this->saveName = $this->setSaveName($saveName);
		$this->saveTo = $this->savePath . $this->saveName . "." .$this->fileExt;
		$this->fileURL = str_replace(STCMS_ROOT, WEB_URL, $this->saveTo);
        $this->overWrite = $overWrite;
        $this->maxSize = $maxSize ? intval($maxSize) : 0;
    }

    /**
	* 上传文件
	*/
    function up()
    {
		global $mysql,$CONFIG;
        switch($this->fileError)
		{
			case 1:
				die("上传的文件超过了 php.ini 中 upload_max_filesize 选项限制的值！");
			break;
			case 2:
				die("上传文件的大小超过了 HTML 表单中 MAX_FILE_SIZE 选项指定的值！");
			break;
			case 3:
				die("未知原因文件只有部分被上传！");
			break;
			case 4:
				die("没有文件被上传！");
			break;
			case 6:
				die("找不到临时文件夹！");
			break;
			case 7:
				die("文件写入失败！");
			break;
		}
		if ($this->maxSize > 0 && $this->fileSize > $this->maxSize)
        {
             die("文件大小超出限定值！");
        }
        if (!in_array($this->fileExt, explode("|",$this->fileExtArray)))
        {
            die("文件格式不允许！".$this->fileExt.$this->fileExtArray);
        }
        if(!@is_writable($this->savePath))
        {
            die("目录不可写！");
        }
        if($this->overWrite == 0 && @file_exists($this->saveTo))
        {
            die("文件已经存在！");
        }
        $this->uploadFile($this->file, $this->saveTo);
		@chmod($this->saveTo, 0777);
		if(($CONFIG['enableWatermark']=="1") && in_array($this->fileExt,array('gif','bmp','jpg','jpeg','png')))
		{
			require_once(INCLUDE_PATH."watermark.class.php");
			$watermark = new watermark($this->saveTo);
			if($CONFIG['watermarkType'] == "1")
			{
				$watermark->image($CONFIG['watermarkPath']);
			}
			elseif($CONFIG['watermarkType'] == "0")
			{
				$watermark->text($CONFIG['watermarkText']);
			}
		}
		$mysql->insert("upload",array("name"=>$this->fileName,"ext"=>$this->fileExt,"size"=>$this->fileSize,"path"=>$this->saveTo,"url"=>$this->fileURL,"time"=>NOW));
        if(in_array($this->fileExt, array('gif','bmp','jpg','jpeg','png')))
		{
			$CACHE_MODEL = importModel('cache');
			$CACHE_MODEL->initNewPic();
		}
		return true;
    }

	/**
	*上传文件
	*/
	function uploadFile($file='', $saveTo='')
	{
		if(is_uploaded_file($this->file))
		{
			@move_uploaded_file($file, $saveTo);
		}
		else
		{
			die("禁止非法上传文件！");
		}
	}

    /**
     * 获取文件扩展名
     */
    function getExt($file)
    {
        return strtolower(trim(substr(strrchr($file, '.'), 1)));
    }

    /**
     * 设置保存路径
     * @param string 文件保存路径：以 "/" 结尾
     */
    function setSavePath($savePath = '')
    {
		if($savePath == UPLOAD_PATH)
		{
			if(in_array($this->fileExt, array('bmp', 'jpg', 'gif', 'png', 'ico', 'jpeg'))) {
				$path = UPLOAD_PATH.'images/';
			} elseif(in_array($this->fileExt, array('mp3', 'wma', 'flv', 'swf', 'avi', 'wmv', 'rm','ram', 'rmvb', 'mp4', '3gp', 'rm', 'wav'))) {
				$path = UPLOAD_PATH.'medias/';
			} else {
				$path = UPLOAD_PATH.'others/';
			}
			$now = time();
			$year = date('Y', $now);
			$month = date('m', $now);
			$day = date('d', $now);
			$str = checkPath($year.'/'.$month.'/'.$day.'/');
			$savePath = $path.$str;
		}
		if(!is_dir($savePath))
		{
			mkdirs($savePath);
			chmod($savePath, 0777);
		}
		$savePath = str_replace("\\", "/", $savePath);
	    return substr($savePath,-1) == "/" ? $savePath : $savePath."/";
    }

    /**
     * 设置文件保存名
     * @param string 保存名，如果为空，则系统自动生成一个随机的文件名
     */
    function setSaveName($saveName='')
    {
        if (!$saveName)  // 如果未设置文件名，则生成一个随机文件名
        {
           $saveName = date('his').rand(100, 999);
        } 
		return $saveName;
    }
}
?>