DROP TABLE IF EXISTS `DB_PREFIX_admin` <{|}>
CREATE TABLE `DB_PREFIX_admin` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) NOT NULL,
  `pwd` varchar(255) NOT NULL,
  `group` smallint(6) NOT NULL,
  `categoryid` varchar(255) NOT NULL DEFAULT '0',
  `lastlogin` datetime NOT NULL,
  `lastip` varchar(15) NOT NULL,
  `times` int(11) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_admin_group` <{|}>
CREATE TABLE `DB_PREFIX_admin_group` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `intro` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_ads` <{|}>
CREATE TABLE `DB_PREFIX_ads` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `from` date NOT NULL,
  `to` date NOT NULL,
  `display` enum('0','1') NOT NULL DEFAULT '0',
  `code` longtext NOT NULL,
  `time` datetime NOT NULL,
  `typeid` smallint(6) NOT NULL DEFAULT '0',
  `typename` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_ads_type` <{|}>
CREATE TABLE `DB_PREFIX_ads_type` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `display` enum('0','1') NOT NULL,
  `adder` varchar(16) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_artist` <{|}>
CREATE TABLE `DB_PREFIX_artist` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `typeid` smallint(6) NOT NULL DEFAULT '0',
  `categoryid` smallint(6) NOT NULL DEFAULT '0',
  `catname` varchar(255) NOT NULL,
  `sort` varchar(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  `picture` tinytext NOT NULL,
  `birthday` varchar(255) NOT NULL,
  `hit` int(11) NOT NULL DEFAULT '0',
  `week_hit` mediumint(9) NOT NULL DEFAULT '0',
  `month_hit` mediumint(9) NOT NULL DEFAULT '0',
  `today_hit` mediumint(9) NOT NULL DEFAULT '0',
  `from` varchar(255) NOT NULL,
  `fromid` smallint(6) NOT NULL DEFAULT '0',
  `intro` mediumtext NOT NULL,
  `adder` varchar(16) NOT NULL,
  `time` datetime NOT NULL,
  `file_url` tinytext NOT NULL,
  `iscreate` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `categoryid` (`categoryid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_artist_from` <{|}>
CREATE TABLE `DB_PREFIX_artist_from` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `adder` varchar(16) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_artist_type` <{|}>
CREATE TABLE `DB_PREFIX_artist_type` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `adder` varchar(16) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_category` <{|}>
CREATE TABLE `DB_PREFIX_category` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `hit` int(11) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  `comment` longtext NOT NULL,
  `order` int(255) NOT NULL DEFAULT '0',
  `file_url` tinytext NOT NULL,
  `iscreate` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_channel` <{|}>
CREATE TABLE `DB_PREFIX_channel` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` enum('0','1') NOT NULL DEFAULT '0',
  `display` enum('0','1') NOT NULL DEFAULT '0',
  `url` mediumtext NOT NULL,
  `page` mediumtext NOT NULL,
  `order` tinyint(4) NOT NULL,
  `time` datetime NOT NULL,
  `file_url` tinytext NOT NULL,
  `iscreate` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_comment` <{|}>
CREATE TABLE `DB_PREFIX_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(1) NOT NULL DEFAULT '0',
  `typeid` int(255) NOT NULL DEFAULT '0',
  `guest` varchar(255) NOT NULL,
  `from` varchar(255) DEFAULT NULL,
  `mail` varchar(255) DEFAULT NULL,
  `qq` int(255) DEFAULT '0',
  `ip` varchar(255) DEFAULT NULL,
  `content` longtext NOT NULL,
  `reply` longtext,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_data` <{|}>
CREATE TABLE `DB_PREFIX_data` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `size` int(255) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  `comment` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_link` <{|}>
CREATE TABLE `DB_PREFIX_link` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `intro` varchar(255) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_log` <{|}>
CREATE TABLE `DB_PREFIX_log` (
  `id` mediumint(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `time` datetime NOT NULL,
  `msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_lyric`<{|}>
CREATE TABLE `DB_PREFIX_lyric` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` mediumint(9) NOT NULL,
  `mname` varchar(255) NOT NULL,
  `artistid` smallint(6) NOT NULL,
  `artist` varchar(255) NOT NULL,
  `uid` mediumint(9) NOT NULL,
  `uname` varchar(16) NOT NULL,
  `islrc` enum('0','1') NOT NULL DEFAULT '0',
  `istake` enum('0','1') NOT NULL DEFAULT '0',
  `url` mediumtext NOT NULL,
  `content` mediumtext NOT NULL,
  `title` varchar(255) NOT NULL,
  `down` smallint(6) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mid` (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_member` <{|}>
CREATE TABLE `DB_PREFIX_member` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `typeid` smallint(6) NOT NULL,
  `name` varchar(16) NOT NULL,
  `pwd` varchar(32) NOT NULL,
  `money` int(11) NOT NULL DEFAULT '0',
  `host` varchar(255) NOT NULL,
  `picture` mediumtext NOT NULL,
  `provience` varchar(8) NOT NULL,
  `city` varchar(8) NOT NULL,
  `birthday` varchar(16) NOT NULL,
  `sex` varchar(8) NOT NULL,
  `mail` varchar(255) NOT NULL,
  `qq` int(11) NOT NULL,
  `intro` mediumtext NOT NULL,
  `msn` varchar(255) NOT NULL,
  `time` datetime NOT NULL,
  `lastlogin` datetime NOT NULL,
  `lastip` varchar(255) NOT NULL,
  `logintimes` mediumint(9) NOT NULL DEFAULT '0',
  `status` enum('0','1') NOT NULL DEFAULT '0',
  `code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_member_favourite` <{|}>
CREATE TABLE `DB_PREFIX_member_favourite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(9) NOT NULL,
  `type` enum('1','2') NOT NULL,
  `typeid` int(11) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `type` (`type`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_member_type` <{|}>
CREATE TABLE `DB_PREFIX_member_type` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `money` int(11) NOT NULL DEFAULT '0',
  `mark` varchar(255) NOT NULL,
  `comment` mediumtext NOT NULL,
  `access` varchar(255) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_music` <{|}>
CREATE TABLE `DB_PREFIX_music` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `categoryid` smallint(6) NOT NULL DEFAULT '0',
  `catname` varchar(255) NOT NULL,
  `specialid` int(255) NOT NULL DEFAULT '0',
  `specialname` varchar(255) NOT NULL DEFAULT '单曲',
  `artistid` smallint(11) NOT NULL DEFAULT '0',
  `artist` varchar(255) NOT NULL,
  `uid` mediumint(9) NOT NULL DEFAULT '0',
  `uname` varchar(16) NOT NULL,
  `listengroupid` smallint(6) NOT NULL DEFAULT '0',
  `listengroupname` varchar(255) NOT NULL,
  `listenmoney` mediumint(9) NOT NULL DEFAULT '0',
  `downgroupid` smallint(6) NOT NULL DEFAULT '0',
  `downgroupname` varchar(255) NOT NULL,
  `downmoney` mediumint(9) NOT NULL DEFAULT '0',
  `class` varchar(10) NOT NULL,
  `order` tinyint(4) NOT NULL DEFAULT '0',
  `mediatype` varchar(255) NOT NULL,
  `hit` mediumint(9) NOT NULL DEFAULT '0',
  `week_hit` smallint(6) NOT NULL DEFAULT '0',
  `month_hit` smallint(6) NOT NULL DEFAULT '0',
  `today_hit` smallint(6) NOT NULL DEFAULT '0',
  `error` smallint(6) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  `lyric` text NOT NULL,
  `lyric_id` int(11) NOT NULL,
  `lyric_uid` mediumint(9) NOT NULL,
  `lyric_uname` varchar(16) NOT NULL,
  `url` text NOT NULL,
  `recommend` enum('0','1') NOT NULL DEFAULT '0',
  `top` enum('0','1') NOT NULL DEFAULT '0',
  `outrcmd` smallint(6) NOT NULL DEFAULT '0',
  `download` smallint(6) NOT NULL DEFAULT '0',
  `server` smallint(6) NOT NULL DEFAULT '0',
  `adder` varchar(16) NOT NULL,
  `check` enum('0','1') NOT NULL DEFAULT '0',
  `file_url` tinytext NOT NULL,
  `iscreate` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `categoryid` (`categoryid`),
  KEY `specialid` (`specialid`),
  KEY `artistid` (`artistid`),
  KEY `uid` (`uid`),
  KEY `hit` (`hit`),
  KEY `today_hit` (`today_hit`),
  KEY `week_hit` (`week_hit`),
  KEY `month_hit` (`month_hit`),
  KEY `check` (`check`),
  KEY `recommend` (`recommend`),
  KEY `iscreate` (`iscreate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_server` <{|}>
CREATE TABLE `DB_PREFIX_server` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `url` mediumtext NOT NULL,
  `time` datetime NOT NULL,
  `adder` varchar(16) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_setting` <{|}>
CREATE TABLE `DB_PREFIX_setting` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(4) NOT NULL,
  `typename` varchar(255) NOT NULL,
  `comment` mediumtext NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `adder` varchar(16) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_setting_group` <{|}>
CREATE TABLE `DB_PREFIX_setting_group` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `adder` varchar(16) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_special` <{|}>
CREATE TABLE `DB_PREFIX_special` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `categoryid` tinyint(4) NOT NULL DEFAULT '0',
  `catname` varchar(255) NOT NULL,
  `uid` mediumint(9) NOT NULL DEFAULT '0',
  `uname` varchar(16) NOT NULL,
  `sort` varchar(5) NOT NULL,
  `name` varchar(255) NOT NULL,
  `artistid` smallint(6) NOT NULL DEFAULT '0',
  `artist` varchar(255) NOT NULL,
  `company` varchar(255) NOT NULL,
  `language` varchar(15) NOT NULL,
  `introduction` mediumtext NOT NULL,
  `picture` mediumtext NOT NULL,
  `pubtime` varchar(255) NOT NULL,
  `listengroupid` tinyint(4) NOT NULL DEFAULT '0',
  `listengroupname` varchar(255) NOT NULL,
  `listenmoney` mediumint(9) NOT NULL DEFAULT '0',
  `downgroupid` tinyint(4) NOT NULL DEFAULT '0',
  `downgroupname` varchar(255) NOT NULL,
  `downmoney` mediumint(9) NOT NULL DEFAULT '0',
  `top` enum('0','1') NOT NULL DEFAULT '0',
  `recommend` enum('0','1') NOT NULL DEFAULT '0',
  `outrmd` smallint(6) NOT NULL DEFAULT '0',
  `hit` smallint(6) NOT NULL DEFAULT '0',
  `week_hit` smallint(6) NOT NULL DEFAULT '0',
  `month_hit` smallint(6) NOT NULL DEFAULT '0',
  `today_hit` smallint(6) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  `check` enum('0','1') NOT NULL DEFAULT '0',
  `file_url` tinytext NOT NULL,
  `iscreate` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `categoryid` (`categoryid`),
  KEY `artistid` (`artistid`),
  KEY `uid` (`uid`),
  KEY `hit` (`hit`),
  KEY `today_hit` (`today_hit`),
  KEY `week_hit` (`week_hit`),
  KEY `month_hit` (`month_hit`),
  KEY `check` (`check`),
  KEY `recommend` (`recommend`),
  KEY `iscreate` (`iscreate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_tpl` <{|}>
CREATE TABLE `DB_PREFIX_tpl` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_upload` <{|}>
CREATE TABLE `DB_PREFIX_upload` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `ext` varchar(5) NOT NULL,
  `size` mediumint(9) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8<{|}>

TRUNCATE TABLE DB_PREFIX_admin<{|}>
INSERT INTO `DB_PREFIX_admin` (`id`,`name`,`pwd`,`group`,`categoryid`,`lastlogin`,`lastip`,`times`,`time`) VALUES ('1','admin','c3284d0f94606de1fd2af172aba15bf3','0','0','2009-00-00 00:00:00','127.0.0.1','0','0000-00-00 00:00:00')<{|}>
TRUNCATE TABLE DB_PREFIX_admin_group<{|}>
INSERT INTO `DB_PREFIX_admin_group` (`id`,`name`,`comment`,`intro`) VALUES ('1','superAdmin','超级管理员','所有权限')<{|}>
INSERT INTO `DB_PREFIX_admin_group` (`id`,`name`,`comment`,`intro`) VALUES ('2','categoryAdmin','分类管理员','在该分类内有相应权限')<{|}>
TRUNCATE TABLE DB_PREFIX_ads<{|}>
INSERT INTO `DB_PREFIX_ads` (`id`,`name`,`from`,`to`,`display`,`code`,`time`,`typeid`,`typename`) VALUES ('1','STCMS音乐系统','2009-10-01','2010-10-31','0','<a href=\"http://www.phpstcms.com\" title=\"STCMS音乐系统\" target=\"_blank\"><img src=\"http://www.phpstcms.com/images/wind/logo.png\"></a>','2009-10-05 11:19:57','1','歌曲页面广告位')<{|}>
INSERT INTO `DB_PREFIX_ads` (`id`,`name`,`from`,`to`,`display`,`code`,`time`,`typeid`,`typename`) VALUES ('2','STCMS音乐系统','2009-10-01','2013-10-31','0','<a href=\"http://www.phpstcms.com\" title=\"STCMS音乐系统\" target=\"_blank\"><img src=\"http://www.phpstcms.com/images/wind/logo.png\"></a>','2009-10-05 11:20:23','2','连播页面广告位')<{|}>
TRUNCATE TABLE DB_PREFIX_ads_type<{|}>
INSERT INTO `DB_PREFIX_ads_type` (`id`,`name`,`display`,`adder`,`time`) VALUES ('1','歌曲页面广告位','0','admin','2009-10-05 11:01:01')<{|}>
INSERT INTO `DB_PREFIX_ads_type` (`id`,`name`,`display`,`adder`,`time`) VALUES ('2','连播页面广告位','0','admin','2009-10-05 11:01:25')<{|}>
TRUNCATE TABLE DB_PREFIX_artist<{|}>
TRUNCATE TABLE DB_PREFIX_artist_from<{|}>
INSERT INTO `DB_PREFIX_artist_from` (`id`,`name`,`adder`,`time`) VALUES ('1','内地','','0000-00-00 00:00:00')<{|}>
INSERT INTO `DB_PREFIX_artist_from` (`id`,`name`,`adder`,`time`) VALUES ('2','港台','','0000-00-00 00:00:00')<{|}>
INSERT INTO `DB_PREFIX_artist_from` (`id`,`name`,`adder`,`time`) VALUES ('3','日韩','','0000-00-00 00:00:00')<{|}>
INSERT INTO `DB_PREFIX_artist_from` (`id`,`name`,`adder`,`time`) VALUES ('4','欧美','','0000-00-00 00:00:00')<{|}>
TRUNCATE TABLE DB_PREFIX_artist_type<{|}>
INSERT INTO `DB_PREFIX_artist_type` (`id`,`name`,`adder`,`time`) VALUES ('1','男歌手','','0000-00-00 00:00:00')<{|}>
INSERT INTO `DB_PREFIX_artist_type` (`id`,`name`,`adder`,`time`) VALUES ('2','女歌手','','0000-00-00 00:00:00')<{|}>
INSERT INTO `DB_PREFIX_artist_type` (`id`,`name`,`adder`,`time`) VALUES ('3','乐团','','0000-00-00 00:00:00')<{|}>
TRUNCATE TABLE DB_PREFIX_category<{|}>
INSERT INTO `DB_PREFIX_category` (`id`,`name`,`hit`,`time`,`comment`,`order`) VALUES ('1','流行音乐','0','2009-04-27 04:22:45','流行音乐','0')<{|}>
INSERT INTO `DB_PREFIX_category` (`id`,`name`,`hit`,`time`,`comment`,`order`) VALUES ('2','民族音乐','0','2009-04-27 04:22:27','民族音乐','2')<{|}>
INSERT INTO `DB_PREFIX_category` (`id`,`name`,`hit`,`time`,`comment`,`order`) VALUES ('3','DJ舞曲','0','2009-04-27 04:21:17','暂无介绍','3')<{|}>
INSERT INTO `DB_PREFIX_category` (`id`,`name`,`hit`,`time`,`comment`,`order`) VALUES ('4','轻音乐','0','2009-04-27 04:20:51','暂无介绍','4')<{|}>
INSERT INTO `DB_PREFIX_category` (`id`,`name`,`hit`,`time`,`comment`,`order`) VALUES ('5','宗教音乐','0','2009-02-28 08:43:06','宗教音乐','5')<{|}>

TRUNCATE TABLE DB_PREFIX_channel<{|}>
INSERT INTO `DB_PREFIX_channel` (`id`,`name`,`type`,`display`,`url`,`page`,`order`,`time`) VALUES ('1','流行音乐','0','1','/category/id/1.html','','1','2009-10-05 11:56:19')<{|}>
INSERT INTO `DB_PREFIX_channel` (`id`,`name`,`type`,`display`,`url`,`page`,`order`,`time`) VALUES ('2','民族音乐','0','1','/category/id/2.html','','2','2009-10-05 11:56:38')<{|}>
INSERT INTO `DB_PREFIX_channel` (`id`,`name`,`type`,`display`,`url`,`page`,`order`,`time`) VALUES ('3','DJ舞曲','0','1','/category/id/3.html','','3','2009-10-05 11:57:13')<{|}>
INSERT INTO `DB_PREFIX_channel` (`id`,`name`,`type`,`display`,`url`,`page`,`order`,`time`) VALUES ('4','轻音乐','0','1','/category/id/4.html','','4','2009-10-05 11:58:37')<{|}>
INSERT INTO `DB_PREFIX_channel` (`id`,`name`,`type`,`display`,`url`,`page`,`order`,`time`) VALUES ('5','宗教音乐','0','1','/category/id/5.html','','5','2009-10-05 11:59:54')<{|}>

INSERT INTO `DB_PREFIX_member_type` (`id`,`name`,`money`,`mark`,`comment`,`access`,`time`) VALUES ('1','游客','0','游客','未登陆用户','listen,viewinfo','2009-07-17 10:24:06')<{|}>
INSERT INTO `DB_PREFIX_member_type` (`id`,`name`,`money`,`mark`,`comment`,`access`,`time`) VALUES ('2','普通用户','0','普通用户','普通用户','listen,down,viewinfo,upload','2009-07-19 05:38:11')<{|}>
INSERT INTO `DB_PREFIX_member_type` (`id`,`name`,`money`,`mark`,`comment`,`access`,`time`) VALUES ('3','VIP用户','0','VIP','VIP用户','listen,down,viewinfo,upload,delSelfUpload','0000-00-00 00:00:00')<{|}>

TRUNCATE TABLE DB_PREFIX_setting_group<{|}>
INSERT INTO `DB_PREFIX_setting_group` (`id`,`name`,`comment`,`adder`,`time`) VALUES ('2','webCnf','网站相关参数组','admin','2010-01-20 22:35:38')<{|}>
INSERT INTO `DB_PREFIX_setting_group` (`id`,`name`,`comment`,`adder`,`time`) VALUES ('3','cookieCnf','网站COOKIE参数组。','admin','2010-01-20 22:47:47')<{|}>
INSERT INTO `DB_PREFIX_setting_group` (`id`,`name`,`comment`,`adder`,`time`) VALUES ('4','UCCnf','UC整合参数。','admin','2010-01-20 22:51:32')<{|}>
INSERT INTO `DB_PREFIX_setting_group` (`id`,`name`,`comment`,`adder`,`time`) VALUES ('5','memberUploadCnf','会员上传参数组。','admin','2010-01-20 22:54:20')<{|}>
INSERT INTO `DB_PREFIX_setting_group` (`id`,`name`,`comment`,`adder`,`time`) VALUES ('6','moneyCnf','积分相关参数组。','admin','2010-01-20 23:04:27')<{|}>
INSERT INTO `DB_PREFIX_setting_group` (`id`,`name`,`comment`,`adder`,`time`) VALUES ('7','mailCnf','发邮件参数','admin','2010-01-20 23:07:00')<{|}>
INSERT INTO `DB_PREFIX_setting_group` (`id`,`name`,`comment`,`adder`,`time`) VALUES ('8','registerCnf','注册相关参数组。','admin','2010-01-21 07:18:57')<{|}>


TRUNCATE TABLE DB_PREFIX_setting<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('28','2','webCnf','网站的SEO说明，即meta中的description。','webDescription','STCMS音乐系统,STCMS,PHP音乐系统,功能最强大的音乐系统','admin','2010-01-20 22:38:21')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('29','2','webCnf','网站SEO关键词，即meta中的keywords。','webKeywords','STCMS音乐系统,STCMS,PHP音乐系统,功能最强大的音乐系统,phpstcms.com','admin','2010-01-20 22:40:56')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('30','2','webCnf','网站作者，即网站所有者。','webAuthor','Dahongy','admin','2010-01-20 22:42:49')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('31','2','webCnf','网站联系邮件。','webMail','dahongy@gmail.com','admin','2010-01-20 22:43:55')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('32','2','webCnf','网站管理员。','webAdmin','Dahongy','admin','2010-01-20 22:44:36')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('33','2','webCnf','网站的ICP备案号。','webCIP','整站备案中','admin','2010-01-20 22:45:13')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('34','2','webCnf','网站的版权信息。','webCopyright','版权所有© 2009 PHPSTCMS.COM. All Rights Reserved！','admin','2010-01-20 22:46:12')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('35','2','webCnf','网站关闭时，显示的关闭信息。','webCloseMsg','本站升级中……','admin','2010-01-20 22:46:55')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('36','3','cookieCnf','cookies作用的有效文件夹路径，不建议修改。','cookiePath','/','admin','2010-01-20 22:48:50')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('38','4','UCCnf','是否整合UC开关，0表示关闭整合UC，1表示开启整合UC。','enableUC','0','admin','2010-01-20 22:52:51')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('37','3','cookieCnf','建议为空，如果要使网站的cookies在一个域名下的多个子网站生效，则设置该参数。具体设置方法，请参考Cookies设置方面的知识。','cookieDomain','','admin','2010-01-20 22:50:59')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('39','5','memberUploadCnf','是否开启会员上传功能，0表示关闭，1表示开启。','enableMemberUpload','1','admin','2010-01-20 22:55:49')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('40','5','memberUploadCnf','会员上传歌曲的路劲，其中{STCMS_ROOT}表示本程序的根路径，且是以“/”结尾的，所以后面跟文件夹不用加“/”。','memberUploadPath','{STCMS_ROOT}mupfile','admin','2010-01-20 22:58:45')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('41','5','memberUploadCnf','会员上传歌曲文件的访问路径，其中{WEB_URL}表示网站的首页路径，且是以“/”结尾的，所以后面加文件夹名称不用加“/”。','memberUploadURL','{WEB_URL}mupfile/','admin','2010-01-20 23:01:22')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('42','5','memberUploadCnf','会员上传的音乐文件的类型，以“|”隔开。','memberUploadExt','mp3|wma|rm|wmv|asf|mid|midi','admin','2010-01-20 23:03:25')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('45','6','moneyCnf','会员上传一首音乐 ，系统增加其积分数目。','uploadMusicMoney','10','admin','2010-01-20 23:06:28')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('54','8','registerCnf','注册邮件内容，可以包含四个参数webName, webURL, username, password。分别表示网站名称，网站地址，用户名，密码。调用时必须用{}。','registerMailContent','亲爱的{username}，您好！<br>
欢迎注册{webName}，您的注册信息如下：<br>
用户名：{username}<br>
注册密码：{password}<br>
我们的网址是<a href=\"{webURL}\" target=\"_blank\">{webURL}</a>，欢迎常来！','admin','2010-01-21 07:32:14')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('50','7','mailCnf','smtp主机地址。','smtpHost','smtp.126.com','admin','2010-01-20 23:13:55')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('51','7','mailCnf','smtp用户名。','smtpUser','ydh******31','admin','2010-01-20 23:14:29')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('52','7','mailCnf','smtp用户名所对应的密码。','smtpPwd','*******','admin','2010-01-20 23:16:28')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('44','6','moneyCnf','会员添加一个专辑，系统增加其分数数目。','uploadSpecialMoney','20','admin','2010-01-20 23:05:41')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('43','6','moneyCnf','会员登录系统，系统增加会员积分数。','loginMoney','5','admin','2010-01-20 23:04:57')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('27','2','webCnf','网站域名，也即该网站的首页地址，以http开头。','webDomain','http://www.phpstcms.com','admin','2010-01-20 22:36:33')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('46','7','mailCnf','发送邮件的方式，可以是三种，smtp、localsmtp和mail。该值只能在以上三个范围内。','mailMode','smtp','admin','2010-01-20 23:08:25')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('47','7','mailCnf','是否需要验证身份后才能发送邮件，0表示不需要验证，1表示需要验证。','smtpIsAuth','1','admin','2010-01-20 23:09:36')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('48','7','mailCnf','发件人邮件地址，一般需要真实填写，否则发不出邮件。','smtpFromMail','ydh4428231@126.com','admin','2010-01-20 23:11:14')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('49','7','mailCnf','发件人名称。','mailFromName','STCMS音乐系统','admin','2010-01-20 23:12:23')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('53','8','registerCnf','是否发送注册邮件，0表示不发送，1表示发送。需要配置好发送邮件参数后才能顺利发送。','enableRegisterMail','1','admin','2010-01-21 07:20:07')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('55','7','mailCnf','发送邮件端口。','smtpPort','25','admin','2010-01-21 07:47:15')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('56','6','moneyCnf','上传歌词可以获得的积分数','uploadLyricMoney','5','admin','2010-01-21 21:37:07')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`typeid`,`typename`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('57','6','moneyCnf','采用歌词可获得的积分','takeUploadLyric','10','admin','2010-01-21 21:37:37')<{|}>

TRUNCATE TABLE DB_PREFIX_tpl<{|}>
INSERT INTO `DB_PREFIX_tpl` (`id`,`name`,`time`) VALUES ('12','default','2008-12-25 10:30:37')<{|}>