<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.com
// This is not a free software, please to pay for more functions
// $Id: 2010-3-21 version 3.3 $
///////////////////////////////////////////////////////////////////
class cacheModel {
	function updateCache($type, $data) {
		if($type) {
			$cachePath = CACHE_PATH.strtolower(str_replace('_','',$type)).".cache.php";
			if(data) {
				$content = "<?php\n// cache file for PHPSTCMS.COM\n// please not to edit this file!\n\${$type}_CACHE = {$data};\ndefine('{$type}_UPDATE_DATE','".NOW."');\n?>";
				writeFile($cachePath, $content,"w");
			}
		}
	}
	function initSetting() {
		global $mysql;
		$settingGroup = $mysql->select('setting_group', 'id, name');
		if($settingGroup) {
			foreach($settingGroup as $tmp) {
				$settings = $mysql->select("setting","name, value", array('typeid'=>$tmp['id']));
				if($settings) {
					foreach($settings as $temp) {
						$SETTING[$temp['name']] = $temp['value'];
					}
				}
				$SETTING_GROUP[$tmp['name']] = $SETTING;
				unset($SETTING);
			}
		}
		$data = var_export((array)$SETTING_GROUP, true);
		$this->updateCache('SETTING', $data);
	}
	function initTableStruct() {
		global $mysql, $CONFIG;
		$tables = $mysql->fetchAll("SHOW TABLE STATUS LIKE '{$CONFIG['dbPrefix']}%'");
		foreach($tables as $temp) {
			$fields = $mysql->fetchAll("SHOW FIELDS FROM `{$temp['Name']}`"); 
			foreach ($fields as $t){
				$tmp[] = $t['Field'];
			}
			$TABLE[$temp['Name']] = $tmp;
			unset($tmp);
		}
		$this->updateCache('TABLE_STRUCT',var_export((array)$TABLE, true));
	}
	function initHit() {
		global $mysql;
		$HIT_CACHE = importCache('HIT');
		$hit_now = strtotime(NOW);
		foreach($HIT_CACHE as $key => $value) {
			$hit_time[$key] = strtotime($value);
		}
		if($hit_now - $hit_time['today_hit']>3600*24) {
			$this->initTodayMusic();
			$this->initTodaySpecial(); $this->initHitMusic();
			$this->initHotArtist(); $this->initCatMusic();
			$this->initWeekMusic(); $this->initWeekSpecial();
			$this->initMonthMusic(); $this->initMonthSpecial();
			$mysql->update("member", "money='0'", "money<0");
			$mysql->update("music",array('today_hit'=>0));
			$mysql->update("special",array('today_hit'=>0));
			$mysql->update("artist",array('today_hit'=>0));
			$data=array();
			$data['today_hit'] = NOW;
			$data['week_hit'] = $HIT_CACHE['week_hit'];
			$data['month_hit'] = $HIT_CACHE['month_hit'];
			$data = var_export((array)$data, true);
			$this->updateCache('HIT', $data);
		}
		if($hit_now-$hit_time['week_hit']>3600*24*7) {
			$this->initWeekMusic(); $this->initWeekSpecial(); $this->initNSMusic();
			$mysql->update("music",array('week_hit'=>0));
			$mysql->update("special",array('week_hit'=>0));
			$mysql->update("artist",array('week_hit'=>0));
			$data=array();
			$data['today_hit'] = $HIT_CACHE['today_hit'];
			$data['week_hit'] = NOW;
			$data['month_hit'] = $HIT_CACHE['month_hit'];
			$data = var_export((array)$data, true);
			$this->updateCache('HIT', $data);
		}
		if($hit_now-$hit_time['month_hit']>3600*24*30) {
			$this->initMonthMusic(); $this->initMonthSpecial();
			$mysql->update("music",array('month_hit'=>0));
			$mysql->update("special",array('month_hit'=>0));
			$mysql->update("artist",array('month_hit'=>0));
			$data=array();
			$data['today_hit'] = $HIT_CACHE['today_hit'];
			$data['week_hit'] = $HIT_CACHE['week_hit'];
			$data['month_hit'] = NOW;
			$data = var_export((array)$data, true);
			$this->updateCache('HIT', $data);
		}
	}
	function initWebMenu() {
		global $mysql;
		$channels = $mysql->select("channel","id,name,url,type",array('display'=>'1'),array('`order` ASC'));
		$data = var_export((array)$channels,true);
		$this->updateCache('WEB_MENU',$data);
	}
	function initCategory() {
		global $mysql;
		$categorys = $mysql->select("category","*",false,array('`order` ASC'));
		$data = var_export((array)$categorys,true);
		$this->updateCache('CATEGORY', $data);
	}
	function initCatMusic() {
		global $mysql;
		$categorys = importCache('CATEGORY');
		if(!$categorys) $categorys = $mysql->select('category', '*', false, array('`order` ASC'));
		if($categorys) {
			foreach($categorys as $temp) {
				$musics = $mysql->select('music', 'id,name, artistid, artist, specialid, specialname, categoryid, catname', array('categoryid'=>$temp['id'], 'check'=>'1'), 'id DESC', array('0','40'));
				$CAT_MUSIC[$temp['id']] = $musics;
			}
		}
		$data = var_export((array)$CAT_MUSIC,true);
		$this->updateCache('CAT_MUSIC', $data);
		if($categorys) {
			$this->initCatHotMusic($categorys);
			$this->initCatRmdMusic($categorys);
			$this->initCatSpecial($categorys);
		}
	}
	function initCatHotMusic($categorys=false) {
		global $mysql;
		if(!$categorys) {
			$categorys = importCache('CATEGORY');
		}
		if(!$categorys) $categorys = $mysql->select('category', '*', false, array('`order` ASC'));
		if($categorys) {
			foreach($categorys as $temp) {
				$musics = $mysql->select('music', 'id, name, artistid, artist', array('categoryid'=>$temp['id'], 'check'=>'1'), 'hit DESC, id DESC', array('0','10'));
				$CAT_HOT_MUSIC[$temp['id']] = $musics;
			}
		}
		$data = var_export((array)$CAT_HOT_MUSIC, true);
		$this->updateCache('CAT_HOT_MUSIC', $data);
	}
	function initCatRmdMusic($categorys=false) {
		global $mysql;
		if(!$categorys) {
			$categorys = importCache('CATEGORY');
		}
		if(!$categorys) $categorys = $mysql->select('category', '*', false, array('`order` ASC'));
		if($categorys) {
			foreach($categorys as $temp) {
				$musics = $mysql->select('music', 'id, name, artistid, artist', array('check'=>'1', 'categoryid'=>$temp['id'],'recommend'=>'1'), 'id DESC', array('0','10'));
				$CAT_RMD_MUSIC[$temp['id']] = $musics;
			}
		}
		$data = var_export((array)$CAT_RMD_MUSIC, true);
		$this->updateCache('CAT_RMD_MUSIC', $data);
	}
	function initCatSpecial($categorys=false) {
		global $mysql;
		if(!$categorys) {
			$categorys = importCache('CATEGORY');
		}
		if(!$categorys) $categorys = $mysql->select('category', '*', false, array('`order` ASC'));
		if($categorys) {
			foreach($categorys as $temp) {
				$specials = $mysql->select('special', 'id,name, artistid, artist, hit, uid, uname, picture, time', array('categoryid'=>$temp['id'], 'check'=>'1'), 'id DESC', array('0','8'));
				$CAT_SPECIAL[$temp['id']] = $specials;
			}
		}
		$data = var_export((array)$CAT_SPECIAL, true);
		$this->updateCache('CAT_SPECIAL', $data);
	}
	function initNewMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id, name, artistid, artist, specialid, specialname, categoryid, catname', array('check'=>'1'), 'id DESC', array('0','10'));
		$data = var_export((array)$musics,true);
		$this->updateCache('NEW_MUSIC',$data);
		$this->initNSMusic();
	}
	function initHitMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id, name, artistid, artist, specialid, specialname, categoryid, catname', array('check'=>'1'), 'hit DESC, id DESC', array('0','10'));
		$data = var_export((array)$musics,true);
		$this->updateCache('HIT_MUSIC',$data);
	}
	function initTodayMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id, name, artistid, artist, specialid, specialname, categoryid, catname', array('check'=>'1'), 'today_hit DESC, id DESC', array('0','10'));
		$data = var_export((array)$musics,true);
		$this->updateCache('TODAY_MUSIC',$data);
	}
	
	function initWeekMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id, name, artistid, artist, specialid, specialname, categoryid, catname', array('check'=>'1'), 'week_hit DESC, id DESC', array('0','10'));
		$data = var_export((array)$musics,true);
		$this->updateCache('WEEK_MUSIC',$data);
	}
	function initMonthMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id,name, artistid, artist, specialid, specialname, categoryid, catname', array('check'=>'1'), 'month_hit DESC, id DESC', array('0','10'));
		$data = var_export((array)$musics,true);
		$this->updateCache('MONTH_MUSIC',$data);
	}
	function initNewSpecial() {
		global $mysql;
		$specials = $mysql->select('special', 'id, name, artistid, artist, categoryid, catname, picture, uid, uname, time', array('check'=>'1') , 'id DESC', array('0','6'));
		$data = var_export((array)$specials,true);
		$this->updateCache('NEW_SPECIAL',$data);
	}
	function initHitSpecial() {
		global $mysql;
		$specials = $mysql->select('special', 'id, name, artistid, artist, categoryid, catname, picture, uid, uname, time', array('check'=>'1') , 'hit DESC,id DESC', array('0','11'));
		$data = var_export((array)$specials,true);
		$this->updateCache('HIT_SPECIAL',$data);
	}
	function initTodaySpecial() {
		global $mysql;
		$specials = $mysql->select('special', 'id, name, artistid, artist, categoryid, catname, picture, uid, uname, time', array('check'=>'1') , 'today_hit DESC,id DESC', array('0','11'));
		$data = var_export((array)$specials,true);
		$this->updateCache('TODAY_SPECIAL',$data);
	}
	function initWeekSpecial() {
		global $mysql;
		$specials = $mysql->select('special', 'id, name, artistid, artist, categoryid, catname, picture, uid, uname, time', array('check'=>'1') , 'week_hit DESC,id DESC', array('0','11'));
		$data = var_export((array)$specials,true);
		$this->updateCache('WEEK_SPECIAL',$data);
	}
	function initMonthSpecial() {
		global $mysql;
		$specials = $mysql->select('special', 'id, name, artistid, artist, categoryid, catname, picture, uid, uname, time', array('check'=>'1') , 'month_hit DESC,id DESC', array('0','11'));
		$data = var_export((array)$specials,true);
		$this->updateCache('MONTH_SPECIAL',$data);
	}
	function initNRMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id, name, artistid, artist, specialid, specialname, categoryid, catname', array('recommend'=>'1', 'check'=>'1'), 'id DESC', array('0','10'));
		$data = var_export((array)$musics,true);
		$this->updateCache('NR_MUSIC',$data);
	}
	function initNRSpecial() {
		global $mysql;
		$specials = $mysql->select('special', 'id, name, artistid, artist, picture, categoryid, catname, pubtime, time', array('recommend'=>'1', 'check'=>'1') , 'id DESC', array('0','6'));
		$data = var_export((array)$specials,true);
		$this->updateCache('NR_SPECIAL',$data);
	}
	function initNewComment() {
		global $mysql;
		$comments = $mysql->select('comment','id,guest,content,typeid,type',false,'id DESC',array('0','8'));
		$data = var_export((array)$comments,true);
		$this->updateCache('NEW_COMMENT',$data);
	}
	function initNewPic() {
		global $mysql;
		$files = $mysql->select("special","id, name, picture", false, array('RAND()'), array('0','5'));
		if($files) {
			foreach($files as $temp) {
				$obj['pic'][] = $temp['picture'];
				$obj['link'][] = WEB_URL."special/id/{$temp['id']}.html";
				$obj['text'][] = $temp['name'];
			}
		}
		$data = var_export( (array)$obj, true);
		$this->updateCache('NEW_PIC', $data);
	}
	function initHotArtist() {
		global $mysql;
		$topArtist = $mysql->fetch($mysql->query('select id, name, picture from '.DB_PREFIX.'artist order by month_hit desc'));
		$topArtistMusic = $mysql->selectOne('music', 'id, name', array('artistid'=>$topArtist['id']), 'hit DESC', array('0','1'));
		$topArtistSpecail = $mysql->selectOne('special', 'id, name', array('artistid'=>$topArtist['id']), 'hit DESC', array('0','1'));
		$topArtist['sname'] = $topArtistSpecail['name']; $topArtist['sid'] = $topArtistSpecail['id'];
		$topArtist['mid'] = $topArtistMusic['id']; $topArtist['mname'] = $topArtistMusic['name'];
		$artists = $mysql->select("artist", 'id, name', "id != '{$topArtist['id']}'", array('month_hit DESC'), array('0','20'));
		$data = array('top'=>$topArtist, 'other'=>$artists); unset($topArtist, $artists);
		$data = var_export((array)$data, true);
		$this->updateCache('HOT_ARTIST', $data);
	}
	function initNSMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id, name, artistid, artist, categoryid, catname', array('specialid'=>'0', 'check'=>'1'), array('id DESC', 'week_hit DESC'), array('0','10'));
		$data = var_export((array)$musics, true);
		$this->updateCache('NS_MUSIC', $data);
	}
	function initNews() {
		global $mysql;
		$news = $mysql->select('channel', 'id, name, url, type, time', array('display'=>'0'), array('id DESC'), array('0','8'));
		$data = var_export((array)$news, true);
		$this->updateCache('NEWS', $data);
	}
	function initNUMusic() {
		global $mysql;
		$musics = $mysql->select('music', 'id, name, uid, uname, artistid, artist', 'uid>0', 'id DESC', array('0','40'));
		$data = var_export((array)$musics, true);
		$this->updateCache('NU_MUSIC', $data);
	}
	function initNewMember() {
		global $mysql;
		$members = $mysql->select("member", 'id,name,picture,time,money,provience,city', false, array("id DESC"), array('0','8'));
		$data = var_export((array)$members, true);
		$this->updateCache('NEW_MEMBER', $data);
	}
	function initRankMember() {
		global $mysql;
		$members = $mysql->select("member", 'id,name,time,money', false, array("money DESC", "id DESC"), array('0','10'));
		$data = var_export((array)$members, true);
		$this->updateCache('RANK_MEMBER', $data);
	}
	function initMemberInfo() {
		global $mysql;
		$mNum = $mysql->numTable('member');
		$mNew = $mysql->select('member', 'id, name, picture', false, array("id DESC"), array('0','1'));
		$mInfo['num'] = $mNum;
		$mInfo['new'] = $mNew[0];
		$data = var_export((array)$mInfo, true);
		$this->updateCache('MEMBER_INFO', $data);
	}
	function initNUSpecial() {
		global $mysql;
		$musics = $mysql->select('special', 'id, name, uid, uname, artistid, artist, picture, time', 'uid>0', 'id DESC', array('0','6'));
		$data = var_export((array)$musics, true);
		$this->updateCache('NU_SPECIAL', $data);
	}
	function initMemberType(){
		global $mysql;
		$memberTypes = $mysql->select('member_type');
		if($memberTypes) {
			foreach($memberTypes as $tmp) {
				$data[$tmp['id']] = $tmp;
			}
		}
		$data = var_export((array)$data, true);
		$this->updateCache('MEMBER_TYPE', $data);
	}
	function initArtistFrom() {
		global $mysql;
		$artistFrom = $mysql->select('artist_from');
		$data = var_export((array)$artistFrom, true);
		$this->updateCache('ARTIST_FROM', $data);
	}
	function initArtistType() {
		global $mysql;
		$artistType = $mysql->select('artist_type');
		$data = var_export((array)$artistType, true);
		$this->updateCache('ARTIST_TYPE', $data);
	}
	function initLink() {
		global $mysql;
		$textLinks = $mysql->select('link', '*', "logo=''", 'id DESC');
		$logoLinks = $mysql->select('link', '*', "logo!=''", 'id DESC');
		$links['textLink'] = $textLinks;
		$links['logoLink'] = $logoLinks;
		$data = var_export((array)$links, true);
		$this->updateCache('LINK', $data);
	}
	function initAds() {
		global $mysql;
		$ads_type = $mysql->select('ads_type');
		if($ads_type) {
			foreach($ads_type as $tmp) {
				$ads = $mysql->select('ads', '*', array('typeid'=>$tmp['id']));
				$ADS[$tmp['id']] = $ads;
			}
		}
		$data = var_export((array)$ADS, true);
		$this->updateCache('ADS', $data);
	}
	function initWebInfo() {
		$WEB_INFO = array(
						  'about'=>array('desc'=>'关于本站', 'value'=>'关于本站'),
						  'ads'=>array('desc'=>'广告联系', 'value'=>'广告联系'),
						  'private'=>array('desc'=>'隐私申明', 'value'=>'隐私申明'),
						  'sitemap'=>array('desc'=>'网站地图', 'value'=>'网站地图')
					);
		$this->updateCache('WEB_INFO', var_export($WEB_INFO, true));
	}
	function initServer() {
		global $mysql;
		$lsnServer = $mysql->select('server', 'id, type, name, url', array('type'=>'0'));
		$downServer = $mysql->select('server', 'id, type, name, url', array('type'=>'1'));
		$SERVER = array('listen'=>$lsnServer, 'down'=>$downServer);
		$this->updateCache('SERVER', var_export($SERVER, true));
	}
}
?>