<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.com
// This is not a free software, please to pay for more functions
// $Id: 2010-3-21 version 3.3 $
///////////////////////////////////////////////////////////////////
class htmlModel {
	function htmlModel() {
		global $CONFIG, $mysql;
		$config = $CONFIG;
		$this->TPL = new Smarty();
		$this->TPL->template_dir = STCMS_ROOT.'template/'.$config['template'];
		$this->TPL->compile_dir = STCMS_ROOT.'template/template_c';
		$this->TPL->force_compile = false;
		$config = @array_merge($config, $GLOBALS['setting']['webCnf']);
		$tpl = array(
			'css' => array(
				WEB_URL."template/".$config['template']."/css/style.css",
			),
			'js' => array(
				WEB_URL."js/jquery.js",
				WEB_URL."js/jquery.form.js",
				WEB_URL."js/common.js",
			),
		);
		$webMenu = importCache('WEB_MENU');
		$webLink = importCache('LINK');
		$this->TPL->assign('config', $config);
		$this->TPL->assign('tpl', $tpl);
		$this->TPL->assign('webMenu', $webMenu);
		$this->TPL->assign('webLink', $webLink);
		unset($webMenu, $webLink);
	}
	function getPath($type, $arg) {
		$str = "";
		if($arg) {
			foreach($arg as $k => $v) {
				$rs[] = $k.'/'.$v;
			}
			$str = implode("/", $rs);
		}
		return $type.'/'.$str.'.html';
	}
		
	function write($path, $content)
	{
		return writeFile($path, $content, "w+");
	}
	
	function index() {
		global $mysql, $CONFIG;
		$ARTIST_FROM = importCache('ARTIST_FROM');
		$ARTIST_TYPE = importCache('ARTIST_TYPE');
		if($ARTIST_FROM && $ARTIST_TYPE) {
			foreach($ARTIST_FROM as $tmp) {
				foreach($ARTIST_TYPE as $tmp1) {
					$singerIndex[] = array('index'=>$tmp['name'].$tmp1['name'], 'from'=>$tmp['id'], 'type'=>$tmp1['id']);
				}
			}
		}
		$newSpecial = importCache('NEW_SPECIAL');
		$newMusic = importCache('NEW_MUSIC');
		$rmdMusic = importCache('NR_MUSIC');
		$topMusic = importCache('HIT_MUSIC');
		$news = importCache('NEWS');
		$weekSpecial = importCache('WEEK_SPECIAL');
		$monthSpecial = importCache('MONTH_SPECIAL');
		$todayMusic = importCache('TODAY_MUSIC');
		$weekMusic = importCache('WEEK_MUSIC');
		$monthMusic = importCache('MONTH_MUSIC');
		$rmdSpecial = importCache('NR_SPECIAL');
		$hotArtist = importCache('HOT_ARTIST');
		$NSMusic = importCache('NS_MUSIC');
		$this->TPL->assign("todayMusic",$todayMusic);
		$this->TPL->assign("weekMusic",$weekMusic);
		$this->TPL->assign("monthMusic",$monthMusic);
		$this->TPL->assign("weekSpecial",$weekSpecial);
		$this->TPL->assign("monthSpecial", $monthSpecial);
		$this->TPL->assign("newSpecial",$newSpecial);
		$this->TPL->assign("newMusic",$newMusic);
		$this->TPL->assign("rmdMusic",$rmdMusic);
		$this->TPL->assign("rmdSpecial",$rmdSpecial);
		$this->TPL->assign("topMusic",$topMusic);
		$this->TPL->assign("news",$news);
		$this->TPL->assign('singerIndex', $singerIndex);
		$this->TPL->assign('hotArtist', $hotArtist);
		$this->TPL->assign('NSMusic', $NSMusic);
		$this->TPL->assign("webTitle","首页");
		$this->content = $this->TPL->fetch("index.html");
		$this->path = STCMS_ROOT.'index.html';
		$this->write($this->path, $this->content);
	}
	
	function music($arg) {
		global $mysql, $CONFIG;
		@extract($arg, EXTR_OVERWRITE);
		$action = $action ? $action : "view";
		if(!in_array($action, array("view","new","rank","recommend","hot","nospecial"))) {
			return false;
		}
		$categoryWhere = intval($category);
		$specialWhere = intval($special);
		$artistWhere = trim($artist);
		$artistIdWhere = intval($artistid);
		$page = intval($page);
		$id = intval($id);
		switch($action) {
			case "view":
				if(empty($id) || !$music=$mysql->selectOne("music","*",array('id'=>$id))) {
					$this->error='该音乐不存在！'; return false;
				}
				$music['specialname'] = $music['specialname'] ? $music['specialname'] : '单曲';
		
				$rmdMusic = importCache('NR_MUSIC');
				$topMusic = importCache('HIT_MUSIC');
				
				$SERVERS = importCache('SERVER');
				$downServers = $SERVERS['down'];
				$listenServers = $SERVERS['listen'];
				$lyric = $mysql->select('lyric', 'id, title', array('mid'=>$id), array('istake DESC', 'id DESC'));
				$this->TPL->assign("music",$music);
				$this->TPL->assign("topMusic",$topMusic);
				$this->TPL->assign("rmdMusic",$rmdMusic);
				$this->TPL->assign('lsnServer', $listenServers);
				$this->TPL->assign('downServer', $downServers);
				$this->TPL->assign('lyric', $lyric);
				$this->TPL->assign("webTitle",'歌曲 '.$music['name']." MP3，在线试听，下载 < ".$music['artist']);
				$this->content = $this->TPL->fetch("music.html");
				$this->path = $this->getPath('music', $arg);
				$this->write(STCMS_ROOT.$this->path, $this->content);
				$mysql->update('music', array('file_url'=>$this->path, 'iscreate'=>'1'), array('id'=>$id));
				return true;
			break;
			case "new":
				if($categoryWhere) {
					$where['categoryid'] = $categoryWhere;
					$CATEGORY = $mysql->selectOne("category","name",array('id'=>$categoryWhere));
					$title = $CATEGORY['name'] .' >> ';
				}
				if($artistWhere) {
					$where['artist'] = $artistWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('name'=>$artistWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if($artistIdWhere) {
					$where['artistid'] = $artistIdWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('id'=>$artistIdWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				$title .= '最新歌曲';
				$order = array("id DESC");
			break;
			case "recommend":
				if($categoryWhere) {
					$where['categoryid'] = $categoryWhere;
					$CATEGORY = $mysql->selectOne("category","name",array('id'=>$categoryWhere));
					$title = $CATEGORY['name'] .' >> ';
				}
				if($artistWhere) {
					$where['artist'] = $artistWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('name'=>$artistWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if($artistIdWhere) {
					$where['artistid'] = $artistIdWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('id'=>$artistIdWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				$where['recommend'] = '1';
				$order = array("id DESC");
				$title .= '推荐歌曲';
			break;
			case "rank":
				if($categoryWhere) {
					$where['categoryid'] = $categoryWhere;
					$CATEGORY = $mysql->selectOne("category","name",array('id'=>$categoryWhere));
					$title = $CATEGORY['name'] .' >> ';
				}
				if($artistWhere) {
					$where['artist'] = $artistWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('name'=>$artistWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if($artistIdWhere) {
					$where['artistid'] = $artistIdWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('id'=>$artistIdWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if(empty($rank_type)) {
					$rank_type = "hit";
				}
				if(!in_array($rank_type,array('hit','today_hit','month_hit','week_hit'))) {
					$this->error='排行参数错误';
					return false;
				}
				if(empty($rank_type)) {
					$order = "`hit` DESC,`id` DESC";
				} else {
					$order = "`$rank_type` DESC,`id` DESC";
				}
				$title .= "歌曲";
				switch($rank_type) {
					case 'hit':
						$title .= "总排行";
					break;
					case 'today_hit':
						$title .= "日排行";
					break;
					case 'week_hit':
						$title .= '周排行';
					break;
					case 'month_hit':
						$title .= '月排行';
					break;
					default:
						$title .= "排行";
					break;
				}
			break;
			case "nospecial":
				if($categoryWhere) {
					$where['categoryid'] = $categoryWhere;
					$CATEGORY = $mysql->selectOne("category","name",array('id'=>$categoryWhere));
					$title = $CATEGORY['name'].' >> ';
				}
				if($artistWhere) {
					$where['artist'] = $artistWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('name'=>$artistWhere));
					$title = $ARTIST['name'].' >> ';
				}
				if($artistIdWhere) {
					$where['artistid'] = $artistIdWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('id'=>$artistIdWhere));
					$title = $ARTIST['name'].' >> ';
				}
				$where['specialid'] = '0';
				$order = array("id DESC");
				$title .= '最新单曲';
			break;
		}
		$where['check'] = 1;
		$totalNum = $mysql->numTable("music", $where);
		$pageNum = 40;
		$totalPage = intval($totalNum/$pageNum) == $totalNum/$pageNum ? $totalNum/$pageNum : intval($totalNum/$pageNum)+1;
		$page = $page ? $page : 1;
		$page = $page>$totalPage ? $totalPage : $page;
		$page = $page<1 ? 1 : $page;
		$music = $mysql->select("music","*",$where,$order,array(($page-1)*$pageNum,$pageNum));
		require_once(INCLUDE_PATH."page.class.php");
		$url = WEB_URL."music/action/{$action}".($rank_type ? "/rank_type/{$rank_type}" : "").($categoryWhere ? "/category/".intval($categoryWhere) : "").($where['artistid'] ? "/artistid/".$where['artistid'] : "");
		$pageClass = new page($page,$totalNum,$pageNum,$url,true);
		$pageCode = $pageClass->getCodeHtml();
		
		$urlStr = ($where['categoryid'] ? "/category/".$where['categoryid'] : "").($where['artistid'] ? "/artistid/".$where['artistid'] : "");
		$tags[] = array('url'=>WEB_URL.'music/action/new'.$urlStr.'/page/1.html', 'name'=>'全部歌曲', 'action'=>'new');
		$tags[] = array('url'=>WEB_URL.'music/action/recommend'.$urlStr.'/page/1.html', 'name'=>'推荐歌曲', 'action'=>'recommend');
		$tags[] = array('url'=>WEB_URL.'music/action/rank/rank_type/hit'.$urlStr.'/page/1.html', 'name'=>'总排行', 'action'=>'rank', 'rank_type'=>'hit');
		$tags[] = array('url'=>WEB_URL.'music/action/rank/rank_type/today_hit'.$urlStr.'/page/1.html', 'name'=>'日排行', 'action'=>'rank', 'rank_type'=>'today_hit');
		$tags[] = array('url'=>WEB_URL.'music/action/rank/rank_type/week_hit'.$urlStr.'/page/1.html', 'name'=>'周排行', 'action'=>'rank', 'rank_type'=>'week_hit');
		$tags[] = array('url'=>WEB_URL.'music/action/rank/rank_type/month_hit'.$urlStr.'/page/1.html', 'name'=>'月排行','action'=>'rank', 'rank_type'=>'month_hit');
		$tags[] = array('url'=>WEB_URL.'music/action/nospecial'.$urlStr.'/page/1.html', 'name'=>'最新单曲','action'=>'nospecial');
		
		$this->TPL->assign("pageCode",$pageCode);
		$this->TPL->assign("webTitle",$title);
		$this->TPL->assign("music",$music);
		$this->TPL->assign('tags', $tags);
		$this->TPL->assign('action', $action);
		$this->TPL->assign('rank_type', $rank_type);
		$this->content = $this->TPL->fetch("music_list.html");
		$this->path = $this->getPath('music', $arg);
		$this->write(STCMS_ROOT.$this->path, $this->content);
		return true;
	}
	
	function special($arg) {
		global $mysql,$CONFIG;
		@extract($arg, EXTR_OVERWRITE);
		$action = $action ? $action : "view";
		$categoryWhere = intval($category);
		$artistWhere  = trim($artist);
		$artistIdWhere = intval($artistid);
		$page = intval($page);
		if(!in_array($action,array("view","new","rank","recommend"))) {
			$this->error='参数错误！'; return false;
		}
		switch($action) {
			case "view":
				if(empty($id) || !$special=$mysql->selectOne("special","*",array('id'=>$id))) {
					$this->error = '专辑不存在！';
					return false;
				}
				if($special['uid']>0 && $special['check']==0 && $special['uid'] != $cMember['id']) {
					$this->error='专辑尚未通过审核！';
					return false;
				}
				if($special['uid'] ==0 && $special['check']==0) {
					$this->error='专辑已被禁止浏览！';
					return false;
				}
				$music = $mysql->select("music","*",array('specialid'=>$id),array("`order` ASC","id DESC"));
				$otherSpecial = $mysql->select('special', 'id, name, hit', array('artistid'=>$special['artistid']), array('id DESC'), array('0', '10'));
		
				$rmdMusic = $mysql->select("music","id, name, hit", array('specialid'=>$special['id']),array('outrcmd DESC','id DESC'),array('0','10'));
				$topMusic = $mysql->select("music","id, name, hit", array('specialid'=>$special['id']), array('id DESC','hit DESC'),array('0','10'));
				
				$this->TPL->assign("special",$special);
				$this->TPL->assign("music",$music);
				$this->TPL->assign('otherSpecial', $otherSpecial);
				$this->TPL->assign("rmdMusic",$rmdMusic);
				$this->TPL->assign("topMusic",$topMusic);
				$this->TPL->assign("webTitle","专辑 {$special['name']} 在线试听，下载 < {$special['artist']} < {$special['categoryName']}");
				$this->content = $this->TPL->fetch("special.html");
				$this->path = $this->getPath('special', $arg);
				$this->write(STCMS_ROOT.$this->path, $this->content);
				$mysql->update('special', array('file_url'=>$this->path, 'iscreate'=>'1'), array('id'=>$id));
				return true;
			break;
			case "new":
				if($categoryWhere) {
					$where['categoryid'] = intval($categoryWhere);
					$CATEGORY = $mysql->selectOne('category', 'id, name', array('id'=>$categoryWhere));
					$title = $CATEGORY['name'] .' >> ';
				}
				if($artistWhere) {
					$where['artist'] = $artistWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('name'=>$artistWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if($artistIdWhere) {
					$where['artistid'] = $artistIdWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('id'=>$artistIdWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				$title .= "最新专辑";
				$order = array("id DESC");
			break;
			case "recommend":
				$where['recommend'] = "1";
				if($categoryWhere) {
					$where['categoryid'] = intval($categoryWhere);
					$CATEGORY = $mysql->selectOne('category', 'id, name', array('id'=>$categoryWhere));
					$title = $CATEGORY['name'] .' >> ';
				}
				if($artistWhere) {
					$where['artist'] = $artistWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('name'=>$artistWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if($artistIdWhere) {
					$where['artistid'] = $artistIdWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('id'=>$artistIdWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				$order = array("id DESC");
				$title .= "推荐专辑";
			break;
			case "rank":
				if($categoryWhere) {
					$where['categoryid'] = intval($categoryWhere);
					$CATEGORY = $mysql->selectOne('category', 'id, name', array('id'=>$categoryWhere));
					$title = $CATEGORY['name'] .' >> ';
				}
				if($artistWhere) {
					$where['artist'] = $artistWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('name'=>$artistWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if($artistIdWhere) {
					$where['artistid'] = $artistIdWhere;
					$ARTIST = $mysql->selectOne('artist', 'id, name', array('id'=>$artistIdWhere));
					$title = $ARTIST['name'] .' >> ';
				}
				if(!$rank_type || !in_array($rank_type, array('hit', 'today_hit', 'month_hit', 'week_hit'))) {
					$order = array("hit DESC", 'id DESC');
				} else {
					$order = array("{$rank_type} DESC", 'id DESC');
				}
				$title .= "专辑";
				switch($rank_type) {
					case 'hit':
						$title .= "总排行";
					break;
					case 'today_hit':
						$title .= "日排行";
					break;
					case 'week_hit':
						$title .= '周排行';
					break;
					case 'month_hit':
						$title .= '月排行';
					break;
					default:
						$title .= "排行";
					break;
				}
			break;
		}
		
		$urlStr = ($where['categoryid'] ? "/category/".$where['categoryid'] : "").($where['artistid'] ? "/artistid/".$where['artistid'] : '');
		$tags[] = array('url'=>WEB_URL.'special/action/new'.$urlStr.'/page/1.html', 'name'=>'全部专辑', 'action'=>'new');
		$tags[] = array('url'=>WEB_URL.'special/action/recommend'.$urlStr.'/page/1.html', 'name'=>'推荐专辑', 'action'=>'recommend');
		$tags[] = array('url'=>WEB_URL.'special/action/rank/rank_type/hit'.$urlStr.'/page/1.html', 'name'=>'总排行', 'action'=>'rank', 'rank_type'=>'hit');
		$tags[] = array('url'=>WEB_URL.'special/action/rank/rank_type/today_hit'.$urlStr.'/page/1.html', 'name'=>'日排行', 'action'=>'rank', 'rank_type'=>'today_hit');
		$tags[] = array('url'=>WEB_URL.'special/action/rank/rank_type/week_hit'.$urlStr.'/page/1.html', 'name'=>'周排行', 'action'=>'rank', 'rank_type'=>'week_hit');
		$tags[] = array('url'=>WEB_URL.'special/action/rank/rank_type/month_hit'.$urlStr.'/page/1.html', 'name'=>'月排行','action'=>'rank', 'rank_type'=>'month_hit');
		$where['check'] = 1;
		$totalNum = $mysql->numTable("special",$where);
		$pageNum = 20;
		$totalPage = intval($totalNum/$pageNum) == $totalNum/$pageNum ? $totalNum/$pageNum : intval($totalNum/$pageNum)+1;
		$page = $page ? $page : 1;
		$page = $page>$totalPage ? $totalPage : $page;
		$page = $page<1 ? 1 : $page;
		$special = $mysql->select("special","*",$where,$order,array(($page-1)*$pageNum,$pageNum));
		require_once(INCLUDE_PATH."page.class.php");
		$url = WEB_URL."special/action/{$action}".($rank_type ? "/rank_type/{$rank_type}" : "").($where['categoryid'] ? "/category/".$where['categoryid'] : "").($where['artistid'] ? "/artistid/".$where['artistid'] : '');
		$pageClass = new page($page,$totalNum,$pageNum,$url,true);
		$pageCode = $pageClass->getCodeHtml();
		
		$this->TPL->assign("tags",$tags);
		$this->TPL->assign("pageCode",$pageCode);
		$this->TPL->assign("special",$special);
		$this->TPL->assign('action', $action);
		$this->TPL->assign('rank_type', $rank_type);
		$this->TPL->assign("webTitle", $title);
		
		$this->content = $this->TPL->fetch("special_list.html");
		$this->path = $this->getPath('special', $arg);
		$this->write(STCMS_ROOT.$this->path, $this->content);
		return true;
	}
	
	function artist($arg) {
		global $mysql,$CONFIG;
		@extract($arg, EXTR_OVERWRITE);
		$id = intval($id); $name = trim($name); $action = trim($action);
		if(empty($id) && empty($name) && empty($action)) {
			$this->error = '歌手不存在!';
			return false;
		}
		if(empty($action)) {
			if($id) $where['id'] = intval($id);
			if($name) $where['name'] = trim($name);
			if(!$artist = $mysql->selectOne("artist","*",$where)) {
				$this->error = '歌手不存在!';
				return false;
			}
			$topSpecial = $mysql->select("special","id, name, artist, artistid", array('artistid'=>$artist['id']), array("hit DESC",'id DESC'), array('0','10'));
			$topMusic = $mysql->select("music", "id, name, artist, artistid", array('artistid'=>$artist['id']), array("hit DESC",'id DESC'), array('0','10'));
			
			$this->TPL->assign("artist", $artist);
			$this->TPL->assign("topSpecial",$topSpecial);
			$this->TPL->assign("topMusic", $topMusic);
			$this->TPL->assign("webTitle","{$artist['name']} < 歌手信息");
			$this->content = $this->TPL->fetch("artist.html");
			$this->path = $this->getPath('artist', $arg);
			$this->write(STCMS_ROOT.$this->path, $this->content);
			$mysql->update('artist', array('file_url'=>$this->path, 'iscreate'=>'1'), array('id'=>$id));
			return true;
		} elseif($action=="list") {
			$tagSort = trim($sort);
			$singerIndex[] = array('index'=>'全部歌手', 'fromid'=>'', 'typeid'=>'', 'sort'=>$tagSort);
			$ARTIST_FROM = importCache('ARTIST_FROM');
			$ARTIST_TYPE = importCache('ARTIST_TYPE');
			if($ARTIST_FROM && $ARTIST_TYPE) {
				foreach($ARTIST_FROM as $tmp) {
					foreach($ARTIST_TYPE as $tmp1) {
						$singerIndex[] = array('index'=>$tmp['name'].$tmp1['name'], 'from'=>$tmp['id'], 'type'=>$tmp1['id']);
					}
				}
			}
			if($fromid) $where['fromid'] = intval($fromid);
			if($typeid) $where['typeid'] = intval($typeid);
			if($category) $where['categoryid'] = intval($category);
			if($rank_type && in_array($rank_type, array('hit', 'today_hit', 'week_hit', 'month_hit'))) $order[] = "{$rank_type} DESC";
			if($tagSort == '') {
				$sort = $mysql->select("artist","DISTINCT sort", $where, array("sort ASC"));
			} elseif($tagSort == 'other') {
				$sort = $mysql->select('artist', 'DISTINCT sort', "sort NOT IN ('".implode("','", range("A", "Z"))."')", array('sort ASC'));
			} else {
				$sort = array(array('sort'=>$tagSort));
			}
			if($sort) {
				foreach($sort as $temp) {
					$where['sort'] = $temp['sort'];
					$temp['artist'] = $mysql->select("artist","id,name", $where, 'name ASC');
					if($temp['sort'] == "") {
						$temp['sort'] = "其它";
					}
					$temp['num'] = count($temp['artist']);
					$sorts[] = $temp;
				}
			}
			unset($sort, $tagSort);
			$sortRange = range('A','Z');
			foreach($sortRange as $tmp) {
				$sortIndex[] = array('sort'=>$tmp, 'display'=>$tmp);
			}
			$sortIndex[] = array('sort'=>'other', 'display'=>'其他');
			
			$tags[] = array('url'=>WEB_URL.'artist/action/list.html', 'name'=>'全部歌手');
			$tags[] = array('url'=>WEB_URL.'artist/action/list/rank_type/hit.html', 'name'=>'总排行');
			$tags[] = array('url'=>WEB_URL.'artist/action/list/rank_type/today_hit.html', 'name'=>'日排行');
			$tags[] = array('url'=>WEB_URL.'artist/action/list/rank_type/week_hit.html', 'name'=>'周排行');
			$tags[] = array('url'=>WEB_URL.'artist/action/list/rank_type/month_hit.html', 'name'=>'月排行');
			$this->TPL->assign("sort",$sorts);
			$this->TPL->assign('sortIndex', $sortIndex);
			$this->TPL->assign('singerIndex', $singerIndex);
			$this->TPL->assign('tags', $tags);
			$this->TPL->assign("webTitle","歌手列表");
			$this->content = $this->TPL->fetch("artist_list.html");
			$this->path = $this->getPath('artist', $arg);
			$this->write(STCMS_ROOT.$this->path, $this->content);
			return true;
		} else {
			$this->error = '参数错误!';
			return false;
		}
	}
	
	function category($arg) {
		global $mysql, $CONFIG;
		@extract($arg, EXTR_OVERWRITE);
		$id = intval($id);
		if(empty($id) || !$category=$mysql->selectOne("category","*",array('id'=>$id))) {
			$this->error='该分类不存在!'; return false;
		} else {
			$CAT_SPECIAL = importCache('CAT_SPECIAL'); 
			$newSpecial = $CAT_SPECIAL[$id]; unset($CAT_SPECIAL);
			$CAT_MUSIC = importCache('CAT_MUSIC');
			$music = $CAT_MUSIC[$id]; unset($CAT_MUSIC);
			$CAT_HOT_MUSIC = importCache('CAT_HOT_MUSIC');
			$hotMusic = $CAT_HOT_MUSIC[$id]; unset($CAT_HOT_MUSIC);
			$CAT_RMD_MUSIC = importCache('CAT_RMD_MUSIC');
			$rmdMusic = $CAT_RMD_MUSIC[$id]; unset($CAT_RMD_MUSIC);
			
			$this->TPL->assign("category", $category);
			$this->TPL->assign("rmdMusic", $rmdMusic);
			$this->TPL->assign("hotMusic", $hotMusic);
			$this->TPL->assign("newSpecial", $newSpecial);
			$this->TPL->assign("music", $music);
			$this->TPL->assign("webTitle","{$category['name']}");
			$this->content = $this->TPL->fetch("category.html");
			$this->path = $this->getPath('category', $arg);
			$this->write(STCMS_ROOT.$this->path, $this->content);
			$mysql->update('category', array('file_url'=>$this->path, 'iscreate'=>'1'), array('id'=>$id));
			return true;
		}
	}
	
	function page($arg) {
		global $mysql, $CONFIG;
		@extract($arg, EXTR_OVERWRITE);
		if(empty($id) || !$page=$mysql->selectOne("channel","*",array('id'=>$id))) {
			$this->error='该页面不存在!'; return false;
		} else {
			$otherPage = $mysql->select("channel","*",array('type'=>'1'),"`order` DESC",array('0','20'));
			$this->TPL->assign("webTitle", $page['name']);
			$this->TPL->assign("page", $page);
			$this->TPL->assign("otherPage", $otherPage);
			$this->content = $this->TPL->fetch("page.html");
			$this->path = $this->getPath('page', $arg);
			$this->write(STCMS_ROOT.$this->path, $this->content);
			$mysql->update('channel', array('file_url'=>$this->path, 'iscreate'=>'1'), array('id'=>$id));
			return true;
		}
	}
	
	function listArtistMusic($id) {
		global $mysql, $CONFIG;
		$musicNum = $mysql->numTable('music', array('artistid'=>$id));
		$musicPage = intval($musicNum/40)==$musicNum/40 ? $musicNum/40 : intval($musicNum/40)+1;
		if($musicPage<1) $musicPage = 1;
		for($i=1; $i<=$musicPage; $i++) {
			foreach(array('new','recommend','nospecial') as $tmp) {
				$this->music(array('action'=>$tmp, 'artistid'=>$id, 'page'=>$i));
			}
			foreach(array('hit', 'today_hit', 'week_hit', 'month_hit') as $tmp) {
				$this->music(array('action'=>'rank', 'rank_type'=>$tmp, 'artistid'=>$id, 'page'=>$i));
			}
		}
	}
	
	function listArtistSpecial($id) {
		global $mysql, $CONFIG;
		$specialNum = $mysql->numTable('special', array('artistid'=>$id));
		$specialPage = intval($specialNum/20)==$specialNum/20 ? $specialNum/20 : intval($specialNum/20)+1;
		if($specialPage<1) $specialPage=1;
		for($i=1; $i<=$specialPage; $i++) {
			foreach(array('new','recommend',) as $tmp) {
				$this->special(array('action'=>$tmp, 'artistid'=>$id, 'page'=>$i));
			}
			foreach(array('hit', 'today_hit', 'week_hit', 'month_hit') as $tmp) {
				$this->special(array('action'=>'rank', 'rank_type'=>$tmp, 'artistid'=>$id, 'page'=>$i));
			}
		}
	}
	
	function listCategoryMusic($id) {
		global $mysql, $CONFIG;
		$musicNum = $mysql->numTable('music', array('categoryid'=>$id));
		$musicPage = intval($musicNum/40)==$musicNum/40 ? $musicNum/40 : intval($musicNum/40)+1;
		if($musicPage<1) $musicPage = 1;
		for($i=1; $i<=$musicPage; $i++) {
			foreach(array('new','recommend','nospecial') as $tmp) {
				$this->music(array('action'=>$tmp, 'category'=>$id, 'page'=>$i));
			}
			foreach(array('hit', 'today_hit', 'week_hit', 'month_hit') as $tmp) {
				$this->music(array('action'=>'rank', 'rank_type'=>$tmp, 'category'=>$id, 'page'=>$i));
			}
		}
	}
	
	function listCategorySpecial($id) {
		global $mysql, $CONFIG;
		$specialNum = $mysql->numTable('special', array('categoryid'=>$id));
		$specialPage = intval($specialNum/20)==$specialNum/20 ? $specialNum/20 : intval($specialNum/20)+1;
		if($specialPage<1) $specialPage=1;
		for($i=1; $i<=$specialPage; $i++) {
			foreach(array('new','recommend',) as $tmp) {
				$this->special(array('action'=>$tmp, 'category'=>$id, 'page'=>$i));
			}
			foreach(array('hit', 'today_hit', 'week_hit', 'month_hit') as $tmp) {
				$this->special(array('action'=>'rank', 'rank_type'=>$tmp, 'category'=>$id, 'page'=>$i));
			}
		}
	}
}
?>