DROP TABLE IF EXISTS `DB_PREFIX_artist`<{|}>
CREATE TABLE `DB_PREFIX_artist` (
  `id` int(11) NOT NULL auto_increment,
  `type` int(1) default NULL,
  `sort` varchar(5) NOT NULL,
  `name` varchar(255) NOT NULL,
  `from` varchar(255) default NULL,
  `intro` longtext,
  `adder` varchar(255) default NULL,
  `time` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>

ALTER TABLE `DB_PREFIX_special` ADD `sort` varchar(5) NOT NULL<{|}>

ALTER TABLE `DB_PREFIX_music` ADD `categoryid` int NULL default '0'<{|}>
ALTER TABLE `DB_PREFIX_music` ADD `week_hit` int NULL default '0'<{|}>
ALTER TABLE `DB_PREFIX_music` ADD `month_hit` int NULL default '0'<{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `categoryid` int NULL default '0'<{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `hit` int NULL default '0'<{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `week_hit` int NULL default '0'<{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `month_hit` int NULL default '0'<{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `picture` longtext default NULL<{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `birthday` varchar(255) default NULL<{|}>

ALTER TABLE `DB_PREFIX_artist` ADD `today_hit` INT NULL DEFAULT '0' AFTER `hit`<{|}>
ALTER TABLE `DB_PREFIX_music` ADD `today_hit` INT NULL DEFAULT '0' AFTER `hit<{|}>
ALTER TABLE `DB_PREFIX_special` ADD `today_hit` INT NULL DEFAULT '0' AFTER `hit`<{|}>
ALTER TABLE `DB_PREFIX_special` ADD `week_hit` INT NULL DEFAULT '0' AFTER `today_hit`<{|}>
ALTER TABLE `DB_PREFIX_special` ADD `month_hit` INT NULL DEFAULT '0' AFTER `week_hit`<{|}>

DROP TABLE IF EXISTS `DB_PREFIX_setting`<{|}>
CREATE TABLE `DB_PREFIX_setting` (
  `id` int(255) NOT NULL auto_increment,
  `comment` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` longtext NOT NULL,
  `adder` varchar(255) default NULL,
  `time` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM<{|}>
ALTER TABLE `DB_PREFIX_special` ADD `pubtime` varchar(255) DEFAULT NULL AFTER `picture`<{|}>
TRUNCATE TABLE DB_PREFIX_member_type<{|}>
INSERT INTO `DB_PREFIX_member_type` (`id`,`name`,`money`,`mark`,`comment`,`time`) VALUES ('1','普通用户','0','普通用户','普通用户','2009-07-11 10:00:18')<{|}>
INSERT INTO `DB_PREFIX_member_type` (`id`,`name`,`money`,`mark`,`comment`,`time`) VALUES ('2','VIP会员','100','VIP会员','VIP会员','2009-07-11 10:30:16')<{|}>
TRUNCATE TABLE DB_PREFIX_setting<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('2','网站域名','webDomain','http://localhost/music','admin','2009-07-05 02:30:25')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('3','SEO网站描述','webDescription','STCMS 音乐系统 www.phpstcms.cn','admin','2009-07-11 12:19:13')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('4','SEO网站关键词','webKeywords','STCMS 音乐系统 www.phpstcms.cn','admin','2009-07-11 12:19:54')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('5','网站作者','webAuthor','dahongy | dahongy@gmail.com','admin','2009-07-11 12:20:32')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('6','网站邮件','webMail','dahongy@gmail.com','admin','2009-07-11 12:21:10')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('7','网站管理员','webAdmin','dahongy','admin','2009-07-11 12:21:49')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('8','网站CIP备案号','webCIP','正在备案中','admin','2009-07-11 12:22:23')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('9','网站版权信息','webCopyright','版权所有&copy Dahongy','admin','2009-07-11 12:23:23')<{|}>
INSERT INTO `DB_PREFIX_setting` (`id`,`comment`,`name`,`value`,`adder`,`time`) VALUES ('10','关闭时显示的信息','webCloseMsg','本站升级中……','admin','2009-07-11 12:24:24')<{|}>

ALTER TABLE `DB_PREFIX_artist` CHANGE `type` `type` varchar(15) DEFAULT NULL<{|}>

ALTER TABLE `DB_PREFIX_artist` ADD INDEX (`name`)<{|}>
ALTER TABLE `DB_PREFIX_music` ADD INDEX (`artist`)<{|}>
ALTER TABLE `DB_PREFIX_special` ADD INDEX (`artist`)<{|}>
ALTER TABLE `DB_PREFIX_member` ADD `birthday` varchar(16) AFTER `nickname`<{|}>
ALTER TABLE `DB_PREFIX_member` ADD `xingbie` varchar(4) AFTER `birthday`<{|}>
ALTER TABLE `DB_PREFIX_member_favourite` CHANGE `memberid` `uid` int default '0'<{|}>
ALTER TABLE `DB_PREFIX_member_favourite` CHANGE `id` `id` int(11) NOT NULL auto_increment<{|}>
DROP TABLE IF EXISTS `DB_PREFIX_member_upload`<{|}>
CREATE TABLE `DB_PREFIX_member_upload` (
  `id` int(11) NOT NULL auto_increment,
  `uid` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `artist` varchar(255) default NULL,
  `url` longtext,
  `lyric` longtext,
  `hit` int(11) default '0',
  `special` varchar(255) default NULL,
  `time` datetime default NULL,
  `ischeck` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('网站cookie路径','cookiePath','/','admin','2009-08-15 08:46:41')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('是否整合UC','enableUC','0','admin','2009-08-15 09:29:10')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('cookie域名','cookieDomain','','admin','2009-08-15 09:30:01')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('是否允许会员上传音乐','enableMemberUpload','1','admin','2009-08-16 13:57:44')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('会员上传音乐的物理路径','memberUploadPath','{STCMS_ROOT}mupfile/','admin','2009-08-16 14:00:07')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('会员上传音乐的URL路径','memberUploadURL','{WEB_URL}mupfile/','admin','2009-08-16 14:02:14')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('会员上传音乐文件的格式','memberUploadExt','mp3|wma|rm|wmv|asf|mid|midi','admin','2009-08-16 17:24:52')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('会员上传音乐获得的积分数','memberUploadMoney','5','admin','2009-08-16 17:28:33')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('完成注册是否发邮件','enableMail','1','admin','2009-08-18 08:27:20')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('完成注册的内容','registerMailContent','您好，欢迎您注册{webName}，以下是您的注册信息，请您妥善保管好！<br>用户名：{username}<br>密  码：{password}密码提示问题：{pwd_question}答  案：{pwd_answer}本网站的地址是<a href=\'http://{webURL}\'>{webURL}</a>，欢迎您常来！','admin','2009-08-18 08:32:40')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('smtp服务器地址','smtpHost','smtp.126.com','admin','2009-08-18 08:34:05')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('smtp服务器用户名','stmpUser','phpstcms_mail','admin','2009-08-18 08:34:48')<{|}>
INSERT INTO `DB_PREFIX_setting` (`comment`,`name`,`value`,`adder`,`time`) VALUES ('smtp密码','smtpPwd','phpstcms_mail','admin','2009-08-18 08:35:18')<{|}>


ALTER TABLE `DB_PREFIX_special` ADD `uid` INT NULL DEFAULT '0' AFTER `categoryid` ,ADD `uname` VARCHAR( 255 ) NULL AFTER `uid` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `outrmd` INT NULL DEFAULT '0' AFTER `recommend` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `catname` VARCHAR( 255 ) NOT NULL AFTER `categoryid` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `artistid` INT NULL DEFAULT '0' AFTER `name` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `check` ENUM( '0', '1' ) NOT NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_special` CHANGE `recommend` `recommend` ENUM( '0', '1' ) NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_special` CHANGE `top` `top` ENUM( '0', '1' ) NOT NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `language` VARCHAR( 15 ) NULL AFTER `company` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `listenmoney` INT NULL DEFAULT '0' AFTER `pubtime` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `listengroupid` INT NULL DEFAULT '0' AFTER `pubtime` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `listengroupname` VARCHAR( 255 ) NULL AFTER `listengroupid` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `downgroupid` INT NULL DEFAULT '0' AFTER `listenmoney` ,ADD `downgroupname` VARCHAR( 255 ) NULL AFTER `downgroupid` <{|}>
ALTER TABLE `DB_PREFIX_special` ADD `downmoney` INT NULL DEFAULT '0' AFTER `downgroupname` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `catname` VARCHAR( 255 ) NOT NULL AFTER `categoryid` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `specialname` VARCHAR( 255 ) NULL DEFAULT '单曲' AFTER `specialid` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `artistid` INT NULL DEFAULT '0' AFTER `specialname` <{|}>
ALTER TABLE `DB_PREFIX_music` CHANGE `recommend` `recommend` ENUM( '0', '1' ) NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_music` CHANGE `top` `top` ENUM( '0', '1' ) NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `uid` INT NULL DEFAULT '0' AFTER `artist` ,ADD `uname` VARCHAR( 255 ) NULL AFTER `uid` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `listengroupid` INT NULL DEFAULT '0' AFTER `uname` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `listengroupname` VARCHAR( 255 ) NULL AFTER `listengroupid` ,ADD `listenmoney` INT NULL DEFAULT '0' AFTER `listengroupname` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `downgroupid` INT NULL DEFAULT '0' AFTER `listenmoney` ,ADD `downgroupname` VARCHAR( 255 ) NULL AFTER `downgroupid` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `downmoney` INT NULL DEFAULT '0' AFTER `downgroupname` <{|}>
ALTER TABLE `DB_PREFIX_music` ADD `check` ENUM( '0', '1' ) NOT NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `catname` VARCHAR( 255 ) NOT NULL AFTER `categoryid` <{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `typeid` INT NULL DEFAULT '0' AFTER `type` <{|}>
ALTER TABLE `DB_PREFIX_artist` ADD `fromid` INT NULL DEFAULT '0' AFTER `from` <{|}>
ALTER TABLE `DB_PREFIX_artist` CHANGE `type` `type` varchar(255) NULL <{|}>
ALTER TABLE `DB_PREFIX_artist` CHANGE `from` `from` varchar(255) NULL <{|}>
ALTER TABLE `DB_PREFIX_member_type` ADD `access` VARCHAR( 255 ) NULL AFTER `comment` <{|}>
DROP TABLE IF EXISTS `DB_PREFIX_artist_type` <{|}>
CREATE TABLE `DB_PREFIX_artist_type` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`name` VARCHAR( 255 ) NOT NULL ,
`adder` VARCHAR( 16 ) NULL ,
`time` DATETIME NULL 
) ENGINE = MYISAM DEFAULT CHARSET=utf8<{|}>
DROP TABLE IF EXISTS `DB_PREFIX_artist_from` <{|}>
CREATE TABLE `DB_PREFIX_artist_from` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`name` VARCHAR( 255 ) NOT NULL ,
`adder` VARCHAR( 16 ) NULL ,
`time` DATETIME NULL 
) ENGINE = MYISAM DEFAULT CHARSET=utf8 <{|}>
DROP TABLE IF EXISTS `DB_PREFIX_link` <{|}>
CREATE TABLE `DB_PREFIX_link` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`name` VARCHAR( 255 ) NOT NULL ,
`url` VARCHAR( 255 ) NOT NULL ,
`logo` VARCHAR( 255 ) NULL ,
`intro` VARCHAR( 255 ) NULL ,
`time` DATETIME NULL 
) ENGINE = MYISAM DEFAULT CHARSET=utf8 <{|}>
DROP TABLE IF EXISTS `DB_PREFIX_ads` <{|}>
CREATE TABLE `DB_PREFIX_ads` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL,
  `from` date default NULL,
  `to` date default NULL,
  `display` enum('0','1') default '0',
  `code` longtext NOT NULL,
  `time` datetime default NULL,
  `typeid` int(11) default NULL,
  `typename` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 <{|}>
DROP TABLE IF EXISTS `DB_PREFIX_ads_type` <{|}>
CREATE TABLE `DB_PREFIX_ads_type` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`name` VARCHAR( 255 ) NOT NULL ,
`display` ENUM( '0', '1' ) NULL ,
`adder` VARCHAR( 255 ) NULL ,
`time` DATETIME NULL 
) ENGINE = MYISAM DEFAULT CHARSET=utf8 <{|}>
INSERT INTO `DB_PREFIX_music` (uid, name, artist, url, lyric, hit, time) (SELECT uid, name, artist, url, lyric, hit, time FROM `DB_PREFIX_member_upload`) <{|}> 
INSERT INTO `DB_PREFIX_artist_from` (`name`) (SELECT DISTINCT `from` FROM `DB_PREFIX_artist`) <{|}>
INSERT INTO `DB_PREFIX_artist_type` (`name`) (SELECT DISTINCT `type` FROM `DB_PREFIX_artist`) <{|}>
UPDATE `DB_PREFIX_setting` SET `name`='uploadMusicMoney' WHERE `name`='memberUploadMoney' <{|}>
INSERT INTO `DB_PREFIX_setting` (`name`,`value`,`comment`) VALUES ('uploadSpecialMoney','20','上传专辑的奖励分数') <{|}>UPDATE `DB_PREFIX_special` s SET `catname`=(SELECT `name` FROM `DB_PREFIX_category` c WHERE s.categoryid=c.id) <{|}>
UPDATE `DB_PREFIX_special` s SET `artistid`=(SELECT `id` FROM `DB_PREFIX_artist` a WHERE s.artist=a.name) <{|}>
UPDATE `DB_PREFIX_special` s SET `catname`=(SELECT `name` FROM `DB_PREFIX_category` c WHERE s.categoryid=c.id) <{|}>
UPDATE `DB_PREFIX_music` m SET `catname`=(SELECT `name` FROM `DB_PREFIX_category` c WHERE m.categoryid=c.id) <{|}>
UPDATE `DB_PREFIX_music` m SET `artistid`=(SELECT `id` FROM `DB_PREFIX_artist` a WHERE m.artist=a.name) <{|}>
UPDATE `DB_PREFIX_music` m SET `specialname`=(SELECT `name` FROM `DB_PREFIX_special` s WHERE m.specialid=s.id) <{|}>
UPDATE `DB_PREFIX_artist` a SET `catname`=(SELECT `name` FROM `DB_PREFIX_category` c WHERE a.categoryid=c.id) <{|}>
UPDATE `DB_PREFIX_artist` a SET `fromid`=(SELECT `id` FROM `DB_PREFIX_artist_from` f WHERE a.from=f.name) <{|}>
UPDATE `DB_PREFIX_artist` a SET `typeid`=(SELECT `id` FROM `DB_PREFIX_artist_type` t WHERE a.type=t.name) <{|}>
UPDATE `DB_PREFIX_admin` SET pwd=md5(md5(pwd)) <{|}>
UPDATE `DB_PREFIX_member_type` SET name='游客' WHERE id='1' <{|}>
UPDATE `DB_PREFIX_member_type` SET name='普通用户' WHERE id='2' <{|}>
UPDATE `DB_PREFIX_music` m SET `uname`=(SELECT `name` FROM `DB_PREFIX_member` u WHERE u.id=m.uid) <{|}>
UPDATE `DB_PREFIX_music` SET `check`='1' WHERE `uid`='0' <{|}>
INSERT INTO `DB_PREFIX_member_type` (`name`,`mark`,`comment`) VALUES ('VIP用户','VIP','VIP用户') <{|}>
TRUNCATE TABLE `DB_PREFIX_ads_type` <{|}>
INSERT INTO `DB_PREFIX_ads_type` (`id`,`name`,`display`,`adder`,`time`) VALUES ('1','歌曲页面广告位','0','admin','2009-10-05 11:01:01')<{|}>
INSERT INTO `DB_PREFIX_ads_type` (`id`,`name`,`display`,`adder`,`time`) VALUES ('2','连播页面广告位','0','admin','2009-10-05 11:01:25')<{|}>
TRUNCATE TABLE `DB_PREFIX_ads` <{|}>
INSERT INTO `DB_PREFIX_ads` (`id`,`name`,`from`,`to`,`display`,`code`,`time`,`typeid`,`typename`) VALUES ('1','STCMS音乐系统','2009-10-01','2010-10-31','0','<a href=\"http://www.phpstcms.cn\" title=\"STCMS音乐系统\" target=\"_blank\"><img src=\"http://www.phpstcms.cn/images/wind/logo.png\"></a>','2009-10-05 11:19:57','1','歌曲页面广告位')<{|}>
INSERT INTO `DB_PREFIX_ads` (`id`,`name`,`from`,`to`,`display`,`code`,`time`,`typeid`,`typename`) VALUES ('2','STCMS音乐系统','2009-10-01','2013-10-31','0','<a href=\"http://www.phpstcms.cn\" title=\"STCMS音乐系统\" target=\"_blank\"><img src=\"http://www.phpstcms.cn/images/wind/logo.png\"></a>','2009-10-05 11:20:23','2','连播页面广告位')<{|}>


ALTER TABLE `DB_PREFIX_artist` ADD `file_url` tinytext NOT NULL, ADD `iscreate` enum('0','1') NOT NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_category` ADD `file_url` tinytext NOT NULL, ADD `iscreate` enum('0','1') NOT NULL DEFAULT '0' <{|}>
ALTER TABLE `DB_PREFIX_channel` ADD `file_url` tinytext NOT NULL, ADD `iscreate` enum('0','1') NOT NULL DEFAULT '0'<{|}>
ALTER TABLE `DB_PREFIX_music` ADD `file_url` tinytext NOT NULL, ADD `iscreate` enum('0','1') NOT NULL DEFAULT '0'<{|}>
ALTER TABLE `DB_PREFIX_special` ADD `file_url` tinytext NOT NULL, ADD `iscreate` enum('0','1') NOT NULL DEFAULT '0' <{|}>

