<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.cn
// This is not a free software, please to pay for more functions
// $Id: 2009-08-18 version V3.0beta $
///////////////////////////////////////////////////////////////////
define("DB_CHARSET",$CONFIG['dbCharset']);
define("DB_PREFIX",$CONFIG['dbPrefix']);
define("SAVE_PATH",STCMS_ROOT."data/data.sql");
class data {
	/*
	* the db_prefix
	* 数据库前缀
	*/
	var $db_prefix = DB_PREFIX;
	
	/**
	* the delimiter
	* 导入数据时的分割符
	*/
	var $delimiter = '<{|}>';
	
	/*
	* the charset of the data
	* 字符处理
	*/
	var $charset = DB_CHARSET;
	
	/**
	* database engine
	* 数据引擎
	*/
	var $engine = 'MyISAM';
	
	/**
	* whether to drop table if exits before the table structure
	* 是否在表数据前添加drop table if exits
	*/
	var $dropTable = false;
	
	/**
	* the prefix of the tables
	* 数据表的前缀
	*/
	var $dbPrefix = DB_PREFIX;
	
	/**
	* the savepath
	* 保持路径
	*/
	var $savePath=SAVE_PATH;
	
	/**
	* the content of the file
	* 数据和结构
	*/
	var $content='';
	
	/*
	* the file to import
	* 将要导入的数据库备份文件
	*/
	var $filePath = SAVE_PATH;
	
	/**
	* to truncate the table
	* 是否清空表
	*/
	var $truncate=true;
	
	function backUp($tables, $isData=true, $istruct=false)
	{
		global $mysql;
		if($tables)
		{
			$code = "";
			if(is_array($tables))
			{
				foreach($tables as $temp)
				{
					
					if($istruct) $code .= $this->tblStruct((is_array($temp) ? $temp['Name'] : $temp));
					if($isData) $code .= $this->tblData((is_array($temp) ? $temp['Name'] : $temp));
				}
			}
			elseif(is_string($tables) && trim($tables))
			{
					if($istruct) $code .= $this->tblStruct($tables);
					if($isData) $code .= $this->tblData($tables);
			}
		}
		$this->content = $code;
		$this->saveBackUp();
		return true;
	}
	
	/**
	* return the sql structure of the table
	* 返回表的结构，sql结构
	*/
	function tblStruct($table)
	{
		global $mysql;
		$result = $mysql->fetch($mysql->query("SHOW CREATE TABLE $table"));
		if($this->dropTable)
		{
			$code = "DROP TABLE IF EXISTS $table".$this->delimiter."\n";
		}
		$code .= $result['Create Table'].$this->delimiter."\n";
		return $code;
	}
	
	/**
	* return the sql data of the table
	* 返回数据表的数据,以sql返回
	*/
	function tblData($table)
	{
		global $mysql;
		$fields = $mysql->fetchAll("SHOW FIELDS FROM $table");
		$data = $mysql->fetchAll("SELECT * FROM $table");
		$code = "";
		if($this->truncate)
		{
			$code .= "TRUNCATE TABLE {$table}".$this->delimiter."\n";
		}
		if($data){
			foreach($data as $temp)
			{
				$code .= "INSERT INTO `".$table."` (";
				foreach($fields as $k => $v)
				{
					if($k<count($fields)-1)
					{
						$code .= "`".$v['Field']."`,";
					}
					else
					{
						$code .= "`".$v['Field']."`";
					}
				}
				$code .= ") VALUES (";
				foreach($fields as $k => $v)
				{
					if($k<count($fields)-1)
					{
						$code .= "'".addslashes($temp[$v['Field']])."',";
					}
					else
					{
						$code .= "'".addslashes($temp[$v['Field']])."'";
					}
				}
				$code .= ")".$this->delimiter."\n";
			}
		}
		return $code;
	}
	
	/**
	* save the back up file
	* 生保存为backup.sql文件
	*/
	function saveBackUp()
	{
		if(!is_dir(STCMS_ROOT.'/data')) mkdir(STCMS_ROOOT.'/data');
		if(file_exists($this->savePath)) $this->savePath = STCMS_ROOT."data/data".rand(100,999).".sql";
		$fp = fopen($this->savePath,'w+');
		fwrite($fp,$this->content);
		unset($fp);
		return true;
	}
	
	/**
	* inport the backup.sql file
	* 将备份backup.sql文件导入
	*/
	function import($filePath='')
	{
		global $mysql;
		$this->filePath = $filePath ? $filePath : $this->filePath;
		$fp = fopen($this->filePath,'r');
		$content = fread($fp,filesize($this->filePath));
		$sqls = explode($this->delimiter,$content);
		foreach($sqls as $temp)
		{
			if(trim($temp)) $mysql->query($temp);
			unset($temp);
		}
		return true;
	}
	
	/*
	* repair the tables
	* 修复表
	*/
	function repair()
	{
		global $mysql;
		$tables = $mysql->fetchAll("SHOW TABLE STATUS LIKE '{$CONFIG['dbPrefix']}%'");
		foreach($tables as $temp)
		{
			$mysql->query("REPAIR TABLE ".(is_array($temp) ? $temp['Name'] : $temp)."");
		}
		return true;
	}
	
	/*
	* OPTIMIZE TABLE
	* 优化表
	*/
	function optimize()
	{
		global $mysql;
		$tables = $mysql->fetchAll("SHOW TABLE STATUS LIKE '{$CONFIG['dbPrefix']}%'");
		foreach($tables as $temp)
		{
			$mysql->query("OPTIMIZE TABLE  ".(is_array($temp) ? $temp['Name'] : $temp)."");
		}
		return true;
	}
	
	/*
	* alter table
	* 整理表
	*/
	function alter()
	{
		global $mysql;
		$tables = $mysql->fetchAll("SHOW TABLE STATUS LIKE '{$CONFIG['dbPrefix']}%'");
		foreach($tables as $temp)
		{
			$mysql->query("ALTER TABLE  ".(is_array($temp) ? $temp['Name'] : $temp)." ENGINE = ".$this->engine);
		}
		return true;
	}
	
	/**
	* show the backup file
	* 显示备份文件
	*/
	function show()
	{
		if($this->savePath)
		{
			header('Content-type:text/sql; Charset='.$this->charset);
			@readfile($this->savePath);
		}
	}
}
?>