$(function(){
    //顶部条悬浮效果
	$(".hasSubitem").mouseover(function(){
		$(this).addClass("active").find(".subitem").show();
	});
	$(".hasSubitem").mouseout(function(){
		$(this).removeClass("active").find(".subitem").hide();
	});
    //滑动门效果
	$(".tabs .tabs_pos").each(function(i){
		$(this).hover(function(){
			$(this).addClass("active").siblings().removeClass("active");
			$(".tabs_item:eq("+i+")").show().siblings(".tabs_item").hide();
		});
	});
	//阅读记录
	$.getJSON("/app/json/read_history.php?callback=?", function(data){
		if(data == null){
			$('.read_history').html('<div>暂无阅读记录</div>')
			return;
		}
		var html = '';
		$.each(data, function(i,book){
			if(i > 4)
				return;
			var ch_url = '/book/' + book.bk_id + '/' + book.ch_id + '.html';
			if(book.ch_vip == 1)
				ch_url = '/vip/read/' + book.bk_id + '/' + book.ch_id;
			if(book.unread == 0)
				ch_url = '/book/'+book.bk_id+'.html';
			html += '<div><a href="javascript:void(0)" class="unread fr">未读</a><a href="'+ch_url+'" class="fr">'+book.unread+'章</a><a href="/book/'+book.bk_id+'.html" class="tit">《'+book.bk_name+'》</a></div>';
		});
		
		$('.read_history').html(html);
		

	});

	//搜索效果
	$(".search_key").focus(function(){
        var v = $(this).val();   
        var h = $(".hid_search_key").val();
        if (v==h){
            $(".search_key").val("");
            $(this).css("color","#333");
        }
    })
    $(".search_key").blur(function(){
        var v = $(this).val();    
        var h = $(".hid_search_key").val();       
        if (v=="" || v==null){
            $(".search_key").val(h);
            $(this).css("color","#999");
        }
    })


	load_vipfeed();

});

;(function ($) {
    //扩展首页幻灯片事件
    $.fn.extend({
        "iBanner": function (con) {
            var $this = $(this), $nav = $this.find('.banner_pos'), t = (con && con.t) || 3000, a = (con && con.a) || 500, i = 0, autoChange = function () {
                $nav.find('li:eq(' + (i === 5 ? 0 : i) + ')').addClass("current").siblings().removeClass("current");
                $this.find('.banner_txt li:eq(' + (i === 5 ? 0 : i) + ')').show().siblings().hide();
                $this.find('.event-item:eq(' + i + ')').css('display', 'none').end().find('.event-item:eq(' + (i + 1 === 5 ? 0 : i) + ')').css({
                    display: 'block',
                    opacity: 0
                }).animate({
                    opacity: 1
                }, a, function () {
                    i = i + 1 === 4 ? 0 : i + 1;
                }).siblings('.event-item').css({
                    display: 'none',
                    opacity: 0
                });
            }, st = setInterval(autoChange, t);
            $this.hover(function () {
                clearInterval(st);
                return false;
            }, function () {
                st = setInterval(autoChange, t);
                return false;
            }).find('.banner_pos li').bind('click', function () {
                i = $(this).index();
                autoChange();
                return false;
            });
            return $this;
        }
    });


	$.fn.countDown = function (options) {
		config = {};
		$.extend(config, options);
		diffSecs = this.setCountDown(config);
		if (config.onComplete){
			$.data($(this)[0], 'callback', config.onComplete);
		}
		if (config.omitWeeks){
			$.data($(this)[0], 'omitWeeks', config.omitWeeks);
		}
		$.data($(this)[0], 'pre', config.targetDate.pre);
		$.data($(this)[0], 'app', config.targetDate.app);

		//$('#' + $(this).attr('id') + ' .digit').html('<div class="top"></div><div class="bottom"></div>');
		$(this).doCountDown($(this).attr('id'), diffSecs, 500);

		return this;
	};

	$.fn.stopCountDown = function () {
		clearTimeout($.data(this[0], 'timer'));
	};

	$.fn.startCountDown = function () {
		this.doCountDown($(this).attr('id'),$.data(this[0], 'diffSecs'), 500);
	};

	$.fn.setCountDown = function (options) {
		var targetTime = new Date();
		if (options.targetDate){
			targetTime = new Date(options.targetDate.month + '/' + options.targetDate.day + '/' + options.targetDate.year + ' ' + options.targetDate.hour + ':' + options.targetDate.min + ':' + options.targetDate.sec + (options.targetDate.utc ? ' UTC' : ''));
		} else if (options.targetOffset){
			targetTime.setFullYear(options.targetOffset.year + targetTime.getFullYear());
			targetTime.setMonth(options.targetOffset.month + targetTime.getMonth());
			targetTime.setDate(options.targetOffset.day + targetTime.getDate());
			targetTime.setHours(options.targetOffset.hour + targetTime.getHours());
			targetTime.setMinutes(options.targetOffset.min + targetTime.getMinutes());
			targetTime.setSeconds(options.targetOffset.sec + targetTime.getSeconds());
		}
		
		var nowTime = new Date();   
		
		
		diffSecs = Math.floor((targetTime.valueOf()-nowTime.valueOf())/1000);
		$.data(this[0], 'diffSecs', diffSecs);
		return diffSecs;
	};

	$.fn.doCountDown = function (id, diffSecs, duration) {
		$this = $('#' + id);
		if (diffSecs <= 0)
		{
			diffSecs = 0;
			if ($.data($this[0], 'timer'))
			{
				clearTimeout($.data($this[0], 'timer'));
			}
		}

		secs = diffSecs % 60;
		mins = Math.floor(diffSecs/60)%60;
		hours = Math.floor(diffSecs/60/60)%24;
		//if ($.data($this[0], 'omitWeeks') == true)
		//{
			days = Math.floor(diffSecs/60/60/24);
			weeks = Math.floor(diffSecs/60/60/24/7);
		//}
		//else 
		//{
		//	days = Math.floor(diffSecs/60/60/24)%7;
		//	weeks = Math.floor(diffSecs/60/60/24/7);
		//}

		/*
		$this.dashChangeTo(id, 'seconds_dash', secs, duration ? duration : 800);
		$this.dashChangeTo(id, 'minutes_dash', mins, duration ? duration : 1200);
		$this.dashChangeTo(id, 'hours_dash', hours, duration ? duration : 1200);
		$this.dashChangeTo(id, 'days_dash', days, duration ? duration : 1200);
		$this.dashChangeTo(id, 'weeks_dash', weeks, duration ? duration : 1200);
		*/
		$('#' + id).html($.data($this[0], 'pre') + days + "天" + $this.dashChange(hours) + "小时" + $this.dashChange(mins) + "分" + $this.dashChange(secs) + "秒" + $.data($this[0], 'app'));

		$.data($this[0], 'diffSecs', diffSecs);
		if (diffSecs > 0)
		{
			e = $this;
			t = setTimeout(function() { e.doCountDown(id, diffSecs-1) } , 1000);
			$.data(e[0], 'timer', t);
		} 
		else if (cb = $.data($this[0], 'callback')) 
		{
			$.data($this[0], 'callback')();
		}

	};
	$.fn.dashChange = function(n) {
		  var r = "";
		  for (var i=1; i>=0; i--){
				var d = n%10;
				n = (n - d) / 10;
				r = d + r;
		  }
		  return r;
	};
	
}(jQuery));

function load_userinfo(){
	$.getJSON('/pp/uc_service.php?method=newpm&callback=?',function(data){
		if(data.newpm > 0)
			$(".logined_email").addClass("logined_has_email").attr('title', data.newpm + '条新消息');
		//$(".upic").attr('src', "/bbs.1001p.com/uc_server/avatar.php?uid=" + data.uc_id + "&size=small");
	});
}

function load_vipfeed(){
	if(!$('.js_notice_marquee'))
		return;
	$.getJSON('/app/json/vip_feed.php?callback=?',function(data){
		$('.js_notice_marquee').html('');
		for(var i in data){
			$('.js_notice_marquee').append('<a href="/book/' + data[i].bk_id + '.html" class="con"><span class="spirit"></span>' + data[i].user_name + ': 订阅了《' + data[i].bk_name + '》</a>');
		}
	});
}
