﻿var IllegalArgumentException = function(msg, number) {
	this.msg = msg;
	this.number = number;
}

IllegalArgumentException.prototype.toString = function() {
	return this.msg;
}

var Metadata = function(descript) {
	this.parse(descript);
}

Metadata.prototype.parse = function(descript) {
	this.name = null;
	this.items = new Array();

	var idx = 0;
	var ch = descript.charAt(idx);
	// 找到下一个非空格/tab符的位置
	for (; idx < descript.length; idx++) {
		ch = descript.charAt(idx);
		if (' ' != ch && '\t' != ch)
			break;
	}
	// 找到“{”的位置
	var next = descript.indexOf('{', idx);
	if (-1 == next)
		throw new IllegalArgumentException("bad format 2.");

	// 去除后导的空格
	var end;
	for (end = next - 1; end > idx; end--) {
		ch = descript.charAt(end);
		if (' ' != ch && '\t' != ch)
			break;
	}
	// 取得此Metadata的name
	this.name = descript.substring(idx, end + 1);
	idx = next + 1;
	do {
		// 找到下一个非空格/tab符的位置
		for (; idx < descript.length; idx++) {
			ch = descript.charAt(idx);
			if (' ' != ch || '\t' != ch)
				break;
		}
		// 跳过当前行注释
		if ('/' == ch && '/' == ch) {
			idx = descript.indexOf('\n', idx + 1);
			if (-1 == idx)
				throw new IllegalArgumentException(
						"bad format(notfind char '\\n')");

			++idx;
			// 找到下一个非空格/tab符的位置
			for (; idx < descript.length; idx++) {
				ch = descript.charAt(idx);
				if (' ' != ch && '\t' != ch)
					break;
			}
		}
		// 跳过/*...*/注释
		if ('/' == ch && (idx + 1) < descript.length
				&& '*' == descript.charAt(idx + 1)) {
			do {
				idx = descript.indexOf('/', idx + 1);
				if (-1 == idx)
					throw new IllegalArgumentException(
							"bad format('\' expected)");
			} while ('*' != descript.charAt(idx - 1));
			++idx;
			// 找到下一个非空格/tab符的位置
			for (; idx < descript.length; idx++) {
				ch = descript.charAt(idx);
				if (' ' != ch && '\t' != ch)
					break;
			}
		}
		// 结束符
		if ('}' == ch)
			break;
		// 找到空格符或tab符
		for (next = idx + 1; next < descript.length; next++) {
			ch = descript.charAt(next);
			if (' ' == ch || '\t' == ch)
				break;
		}
		// 取得项类型
		var typeName = descript.substring(idx, next);
		if (0 == typeName.length)
			throw new IllegalArgumentException("bad format(type name expected)");

		idx = next + 1;
		// 找到下一个非空格非tab符的位置
		for (; idx < descript.length; idx++) {
			ch = descript.charAt(idx);
			if (' ' != ch && '\t' != ch)
				break;
		}
		// 找到“;”的位置
		next = descript.indexOf(';', idx);
		if (-1 == next)
			throw new IllegalArgumentException("bad format(';' expected) at "
					+ idx);
		// 去除后导的空格
		for (end = next - 1; end >= idx; end--) {
			ch = descript.charAt(end);
			if (' ' != ch && '\t' != ch)
				break;
		}
		// 取得名称
		var item = {
			type : typeName,
			name : descript.substring(idx, end + 1)
		};
		this.items[this.items.length] = item;
		idx = next + 1;
	} while (idx < descript.length);
}

Metadata.prototype.toString = function() {
	var str = this.name + '{';
	for ( var i = 0; i < this.items.length; i++) {
		str += this.items[i].type;
		str += ' ';
		str += this.items[i].name;
		if ((1 + i) < this.items.length)
			str += ',';
	}
	str += '}';
	return str;
}

// 把一个十六进制字符转换为byte
function hexToByte(hex) {
	// -'A' or -'0'
	var ch = ((hex >= 0x41) ? (hex + 10 - 0x41) : (hex - 0x30));
	return ch;
}

var UnserializerHex = function(hexData) {
	this.markChar = '';
	this.data = hexData;
	this.pointer = 0;
}

UnserializerHex.prototype.readChar = function() {
	if (this.pointer < this.data.length) {
		// this.lastChar=this.data.charAt(this.pointer);
		return this.data.charCodeAt(this.pointer++);
	}
	// throw ("unexpected EOF!");
	return -1;
}

// 标示单元读取完
UnserializerHex.prototype.finishUnit = function() {
	this.markChar = 0;
	this.unitEnd = this.pointer; // 最后读取单元结束位
}

UnserializerHex.prototype.readMark = function() {
	this.markChar = this.readChar();
	return (-1 != this.markChar);
}

var MARK_0 = '0'.charCodeAt(0);
var MARK_9 = '9'.charCodeAt(0);
var MARK_A = 'A'.charCodeAt(0);
var MARK_F = 'F'.charCodeAt(0);
var MARK_i = 'i'.charCodeAt(0);
var MARK_j = 'j'.charCodeAt(0);
var MARK_k = 'k'.charCodeAt(0);
var MARK_l = 'l'.charCodeAt(0);
var MARK_m = 'm'.charCodeAt(0);
var MARK_n = 'n'.charCodeAt(0);
var MARK_o = 'o'.charCodeAt(0);
var MARK_p = 'p'.charCodeAt(0);
var MARK_q = 'q'.charCodeAt(0);
var MARK_r = 'r'.charCodeAt(0);
var MARK_s = 's'.charCodeAt(0);
var MARK_t = 't'.charCodeAt(0);
var MARK_u = 'u'.charCodeAt(0);
var MARK_v = 'v'.charCodeAt(0);
var MARK_w = 'w'.charCodeAt(0);
var MARK_x = 'x'.charCodeAt(0);
var MARK_y = 'y'.charCodeAt(0);
var MARK_z = 'z'.charCodeAt(0);
var MARK_X = 'X'.charCodeAt(0);
var MARK_N = 'N'.charCodeAt(0);
var MARK_T = 'T'.charCodeAt(0);
var MARK_P = 'P'.charCodeAt(0);
var MARK_M = 'M'.charCodeAt(0);

// 转到下一单元开始位置，参数isAlways=true时忽略当前mark char的值
UnserializerHex.prototype.nextUnit = function(isAlways) {
	if (0 != this.markChar && !isAlways)
		return;

	this.unitBegin = this.pointer; // 最后读取单元开始位
	// this.current=this.data.substr(this.pointer);
	var ignoreTimes = 0;
	while (this.readMark()) {
		// 检查字符是否：0-9,A-F,i-x,T,X,N,P
		if ((this.markChar >= MARK_0 && this.markChar <= MARK_9)
				|| (this.markChar >= MARK_A && this.markChar <= MARK_F)
				|| (this.markChar >= MARK_i && this.markChar <= MARK_x)
				|| MARK_X == this.markChar || MARK_N == this.markChar
				|| MARK_T == this.markChar || MARK_P == this.markChar
				|| MARK_M == this.markChar)
			break;

		// 其它字符忽略它:)
		if ((++ignoreTimes) > 2048) {
			// 这么多的无效字符，有问题
			throw ("Too much invalid chars!");
		}
	}
}

// 检查一下项是否为空
UnserializerHex.prototype.isNull = function() {
	this.nextUnit(false);
	if (MARK_N == this.markChar) {
		// 是空的，结束此项，返回true
		this.finishUnit();
		return true;
	}
	return false;
}

UnserializerHex.prototype.readDate = function() {
	return parseDate(readString());
}

UnserializerHex.prototype.readDouble = function() {
	return parseFloat(readString());
}

UnserializerHex.prototype._readString = function() {
	// 首先读取字串长度（字节长度）
	var len = this.readHEX();
	// 由于字串已经转为unicode，所以只好一个个字符计算回字节长度
	var ch;
	for ( var i = 0; i < len; i++) {
		ch = this.data.charCodeAt(this.pointer + i);
		++len;
		len -= getBytesUTF8(ch);
	}
	// len=i;
	// if(len+this.pointer<this.data.length){
	var str = this.data.substr(this.pointer, len);
	this.pointer += len;
	this.finishUnit();
	return str;
	// }
	// return null;
}

UnserializerHex.prototype.readString = function() {
	this.nextUnit(false);
	if (MARK_N == this.markChar) {
		// 是空字串:)
		this.finishUnit();
		return null;
	}
	if (MARK_T != this.markChar) {
		// 不是字串，尝试取数值
		var val = this.readHEX();
		// 转换为字串:)
		return String(val);
	}
	// 读取字串
	this.finishUnit();
	return this._readString();
}

UnserializerHex.prototype.readHEX = function() {
	this.nextUnit(false);
	var val = 0;
	if ((this.markChar >= MARK_0 && this.markChar <= MARK_9)
			|| (this.markChar >= MARK_A && this.markChar <= MARK_F)) {
		// 4位的数
		val |= hexToByte(this.markChar);
	} else if (MARK_i == this.markChar) {
		// 4位的数
		val |= hexToByte(this.readChar());
	} else if (MARK_j == this.markChar) {
		// 8位的整数
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_k == this.markChar) {
		// 12位的整数
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_l == this.markChar) {
		// 16位的整数
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_m == this.markChar) {
		// 22位的整数
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_n == this.markChar) {
		// 24位的整数
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_o == this.markChar) {
		// 28位的整数
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_p == this.markChar) {
		// 32位的整数
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());

	} else if (MARK_N == this.markChar) {
		// 空，也就是0了
	} else {
		// throw ("Invalid format of HEX stream!");
	}
	// 完成单元
	this.finishUnit();
	return val;
}

UnserializerHex.prototype.readInt64 = function() {
	this.nextUnit(false);
	var val = 0;
	if (MARK_q == markChar) {
		// 36位的整数
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_r == markChar) {
		// 40位的整数
		val |= hexToByte(this.readChar()) << 36;
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_s == markChar) {
		// 44位的整数
		val |= hexToByte(this.readChar()) << 40;
		val |= hexToByte(this.readChar()) << 36;
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_t == markChar) {
		// 48位的整数
		val |= hexToByte(this.readChar()) << 44;
		val |= hexToByte(this.readChar()) << 40;
		val |= hexToByte(this.readChar()) << 36;
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_u == markChar) {
		// 52位的整数
		streamRead(m_Buffer, 13);
		val |= hexToByte(this.readChar()) << 48;
		val |= hexToByte(this.readChar()) << 44;
		val |= hexToByte(this.readChar()) << 40;
		val |= hexToByte(this.readChar()) << 36;
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_v == markChar) {
		// 56位的整数
		streamRead(m_Buffer, 14);
		val |= hexToByte(this.readChar()) << 52;
		val |= hexToByte(this.readChar()) << 48;
		val |= hexToByte(this.readChar()) << 44;
		val |= hexToByte(this.readChar()) << 40;
		val |= hexToByte(this.readChar()) << 36;
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_w == markChar) {
		// 60位的整数
		streamRead(m_Buffer, 15);
		val |= hexToByte(this.readChar()) << 56;
		val |= hexToByte(this.readChar()) << 52;
		val |= hexToByte(this.readChar()) << 48;
		val |= hexToByte(this.readChar()) << 44;
		val |= hexToByte(this.readChar()) << 40;
		val |= hexToByte(this.readChar()) << 36;
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else if (MARK_x == markChar) {
		// 64位的整数
		streamRead(m_Buffer, 16);
		val |= hexToByte(this.readChar()) << 60;
		val |= hexToByte(this.readChar()) << 56;
		val |= hexToByte(this.readChar()) << 52;
		val |= hexToByte(this.readChar()) << 48;
		val |= hexToByte(this.readChar()) << 44;
		val |= hexToByte(this.readChar()) << 40;
		val |= hexToByte(this.readChar()) << 36;
		val |= hexToByte(this.readChar()) << 32;
		val |= hexToByte(this.readChar()) << 28;
		val |= hexToByte(this.readChar()) << 24;
		val |= hexToByte(this.readChar()) << 20;
		val |= hexToByte(this.readChar()) << 16;
		val |= hexToByte(this.readChar()) << 12;
		val |= hexToByte(this.readChar()) << 8;
		val |= hexToByte(this.readChar()) << 4;
		val |= hexToByte(this.readChar());
	} else {
		return this.readHEX();
	}
	return val;
}

// 读取Metadata
UnserializerHex.prototype.readMetadata = function() {
	this.nextUnit(false);
	if (MARK_N == this.markChar) {
		// 是空的:)
		this.finishUnit();
		return null;
	}
	if (MARK_M != this.markChar) {
		// 不是Metadata
		return null;
	}
	// 读取字串
	this.finishUnit();
	return new Metadata(this._readString());
}

var OmniObject = function(hexString) {
	if (null == hexString || 0 == hexString.length)
		return;
	// 执行反序列化
	this.unpacker = new UnserializerHex(hexString);
	// 先读取Metadata描述
	this.mds = new Array();
	try {
		while (true) {
			var md = this.unpacker.readMetadata();
			if (null == md)
				break;

			if ("array" == md.name) {
				// 数组项，忽略
			} else {
				this.mds[this.mds.length] = md;
			}
		}
		// 取得根
		var name = this.unpacker.readString();
		var root = this.getMetadata(name);
		if (null == root) {
			return;
		}
		// 开始解析内容
		this.unmapping(root, this);
	} catch (e) {
		alert(e.message + " 错误发生在解析 ---> "
				+ this.unpacker.data.substr(this.unpacker.unitBegin));
	}
	delete this.mds;
	delete this.unpacker;
}

OmniObject.prototype.unmapping = function(md, obj) {
	for ( var i = 0; i < md.items.length; i++) {
		var item = md.items[i];
		switch (item.type) {
		case "int32":
		case "int16":
			eval('obj.' + item.name + '=' + this.unpacker.readHEX());
			break;
		case "int64":
			eval('obj.' + item.name + '=' + this.unpacker.readInt64());
			break;
		case "string":
			eval('obj.' + item.name + '="'
					+ escapeJs(this.unpacker.readString()) + '"');
			break;
		case "date":
			var val = this.unpacker.readString();
			if (null == val) {
				eval('obj.' + item.name + '=null');
			} else {
				// ie. 20100604T055900919
				var date = new Date();
				var y, m, d, h, mm, s, ss;
				y = parseInt(val.substr(0, 4), 10);
				m = parseInt(val.substr(4, 2), 10);
				d = parseInt(val.substr(6, 2), 10);
				date.setUTCFullYear(y, m - 1, d);
				if (val.length > 8 && 'T' == val.charAt(8)) {
					h = parseInt(val.substr(9, 2), 10);
					mm = parseInt(val.substr(11, 2), 10);
					s = parseInt(val.substr(13, 2), 10);
					ss = parseInt(val.substr(15), 10);
					date.setUTCHours(h, mm, s, ss);
				} else {
					date.setUTCHours(0, 0, 0, 0);
				}
				eval('obj.' + item.name + '=date');
			}
			break;
		case "double":
			eval('obj.' + item.name + '=' + this.unpacker.readString());
			break;
		case "array.string":
			var len = this.unpacker.readHEX(); // 取size
			var array = new Array(len);
			eval('obj.' + item.name + '=array');
			for ( var j = 0; j < len; j++) {
				array[j] = this.unpacker.readString();// string
			}
			break;
		case "array": // 数组
			var len = this.unpacker.readHEX(); // 取size
			var array = new Array(len);
			eval('obj.' + item.name + '=array');
			for ( var j = 0; j < len; j++) {
				var name = this.unpacker.readString(); // name
				if ("string" == name) {
					array[j] = this.unpacker.readString();// string
				} else {
					var nextMd = this.getMetadata(name);
					if (nextMd) {
						var nextObj = new Object();
						array[j] = nextObj;
						this.unmapping(nextMd, nextObj);
					}
				}
			}
			break;
		default: // 子对象
			// 首先取得子对象名
			var name = this.unpacker.readString(); // name
			if (null == name) {
				// 若名称是null，表示子对象为null
			} else {
				if ("*" == name) {
					// 若名称为“*”表示使用type的指定
					name = item.type;
				}
				var nextMd = this.getMetadata(name);
				if (nextMd) {
					var nextObj = new Object();
					eval('obj.' + item.name + '=nextObj');
					this.unmapping(nextMd, nextObj);
				}
			}
			break;
		}
	}
	obj.metadata = md;
	obj.toString = function() {
		var str = this.metadata.toString();
		str += '\n';
		for ( var i = 0; i < this.metadata.items.length; i++) {
			var mi = this.metadata.items[i];
			eval('str+=String(this.' + mi.name + ')');
			str += '\n';
		}
		return str;
	}
}

OmniObject.prototype.getMetadata = function(name) {
	for ( var i = 0; i < this.mds.length; i++) {
		if (name == this.mds[i].name)
			return this.mds[i];
	}
	return null;
}

function escapeJs(str) {
	if (null == str || 0 == str.length)
		return '';
	str = str.replace(/[\\,\',\"]/g, "\\$&");
	str = str.replace(/\r/g, "\\r");
	str = str.replace(/\n/g, "\\n");
	return str;
}

// UNICODE编码规则：
// 0x00000000 - 0x0000007F 0xxxxxxx ANSI码（英文,数字符号）占一个byte
// 0x00000080 - 0x000007FF 110xxxxx 10xxxxxx
// 0x00000800 - 0x0000FFFF 1110xxxx 10xxxxxx 10xxxxxx 中日韩文等编码占三个byte
// 0x00010000 - 0x001FFFFF 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx
// 0x00200000 - 0x03FFFFFF 111110xx 10xxxxxx 10xxxxxx 10xxxxxx

// 若转换为UTF8编码占用的字节数据
function getBytesUTF8(utf16) {
	if (utf16 < 0x80)
		return 1;
	if (utf16 >= 0x80 && utf16 < 0x07ff)
		return 2;
	// if(utf16>=0x0800)
	return 3;
}

// XML HTTP对象，若指定url则使用GET方法直接提交请求，且成功时回调onSucc失败回调onFail（若它们指定的话）
var HttpRequest = function(url, onSucc, onFail) {
	var xmlHttp = null;
	try {
		// Firefox, Opera 8.0+, Safari
		xmlHttp = new XMLHttpRequest();
	} catch (e) {
		// Internet Explorer
		try {
			xmlHttp = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
		}
	}
	this.xmlhttp = xmlHttp;
	if (onSucc || onFail) {
		var id = this.push(xmlHttp, onSucc, onFail);
//		xmlHttp.onreadystatechange = new Function(
//				"var the=HttpRequest.prototype.elements[" + id
//						+ "];the.onState();");
		xmlHttp.onreadystatechange = function(){
			var the = HttpRequest.prototype.elements[id];
			the.onState();
		}
	}
	if (url) {
		xmlHttp.open("GET", url, true);
		// xmlHttp.setRequestHeader("Accept-Encoding", "");
		xmlHttp.setRequestHeader("Not-Accepts", "Accept-Encoding");
		xmlHttp.setRequestHeader("not-redirect", "true");
		xmlHttp.send('');
	}
}

HttpRequest.prototype.push = function(xmlhttp, onSucc, onFail) {
	this.xmlhttp = xmlhttp;
	this.onSucc = onSucc;
	this.onFail = onFail;
	this.id = this.elements.push(this) - 1;
	++HttpRequest.prototype.count;
	return this.id;
}

HttpRequest.prototype.onState = function() {	
	if (4 == this.xmlhttp.readyState) {
		delete this.elements[this.id];
		if (0 == (--HttpRequest.prototype.count))
			this.elements.length = 0;
		if (this.xmlhttp.status >= 200 && this.xmlhttp.status < 400) {
			if (this.onSucc)
				this.onSucc(this.xmlhttp);
		} else {
			if(this.onFailLogin && 403==this.xmlhttp.status){
				this.onFailLogin(this.xmlhttp);
			}else if (this.onFail){
				this.onFail(this.xmlhttp);
			}
		}
	}
}

HttpRequest.prototype.abort = function() {
	try{
		// 如果支持abort，将触发xmlhttp.readyState=4
		this.xmlhttp.abort();
	}catch(e){
		// 对象不支持该方法
		this.xmlhttp.onreadystatechange = function(){};
		delete this.elements[this.id];
		if (0 == (--HttpRequest.prototype.count))
			this.elements.length = 0;
	}
}

function loadBlank(url){
	window.open(url,"_blank");
	closeState();
}

function loadUrl(url){
	window.location.href=url;
}

//状态是 403时（提示需要登录）
HttpRequest.prototype.onFailLogin = function(xh) {
	try{
		showState('<center>您需要 <a href="javascript:loadBlank(\'/login.jspx?ref=_close\')">[登录坐车网]</a> 后使用此功能！</center>',null,350);
	}catch(e){
	}
}

// POST方式提交普通表单，例：http.postForms('testurl.jsp',[{name:name1,value:value1},{name:name2,value:v2}]);
HttpRequest.prototype.postForms = function(url, forms) {
	var content = '';
	for ( var i = 0; i < forms.length; i++) {
		var f = forms[i];
		if (i > 0)
			content += '&';
		content += f.name;
		content += '=';
		content += EscapeURI(f.value);
	}
	this.xmlhttp.open('POST', url, true);
	this.xmlhttp.setRequestHeader('Content-Type',
			'application/x-www-form-urlencoded;charset=utf-8');
	this.xmlhttp.setRequestHeader('Content-Length', content.length);
	// this.xmlHttp.setRequestHeader("accept-encoding", "");
	this.xmlhttp.setRequestHeader("Not-Accepts", "Accept-Encoding");
	this.xmlhttp.setRequestHeader("not-redirect", "true");
	this.xmlhttp.send(content);
}

HttpRequest.prototype.elements = new Array();
HttpRequest.prototype.count = 0;
