﻿if (typeof WebTool == "undefined") {
	WebTool = {};
}
WebTool.pkg = function (ns) {
	if (!ns || !ns.length) {
		return null;
	}
	var levels = ns.split(".");
	var nsobj = WebTool;
	for (var i = (levels[0] == "WebTool") ? 1 : 0; i < levels.length; ++i) {
		nsobj[levels[i]] = nsobj[levels[i]] || {};
		nsobj = nsobj[levels[i]];
	}
	return nsobj;
};
function $E(oID) {
	var node = typeof oID == "string" ? document.getElementById(oID) : oID;
	if (node != null) {
		return node;
	} 
	return null;
}
WebTool.pkg("WebTool_Core");
if (typeof WebTool_Core == "undefined") {
	WebTool_Core = WebTool.WebTool_Core;
}
WebTool.pkg("WebTool_Core.Array");
function WebTool_Jobs() {
	this._jobTable = [];
}
WebTool_Jobs.prototype = {_registedJobTable:{}, initialize:function () {
}, _registJob:function (jobName, rel) {
	this._registedJobTable[jobName] = rel;
}, add:function (jobName) {
	this._jobTable.push(jobName);
}, start:function () {
	var jobs = this._jobTable;
	var regWebTool_Jobs = this._registedJobTable;
	var i = 0;
	var joblen = this._jobTable.length;
	var getTime = function () {
		return new Date().valueOf();
	};
	var interNum = window.setInterval(function () {
		if (i >= joblen) {
			clearInterval(interNum);
			return;
		}
		var jobName = jobs[i];
		var job = regWebTool_Jobs[jobName];
		i++;
		if (typeof job == "undefined") {
			return;
		}
		var _try = true;
		var _start = getTime();
		try {
			job.call();
		}
		catch (e) {
			_try = false;
		}
		finally {
			if (_try) {
				var _end = getTime();
			}
		}
	}, 10);
}, call:function (jobName, args) {
	/*if (typeof this._registedJobTable[jobName] != "undefined") {
		this._registedJobTable[jobName].apply(this, args);
	} */
}};
$registJob = function (name, rel) {
	WebTool_Jobs.prototype._registJob(name, rel);
};
 
if (typeof WebTool_App == "undefined") {
	var WebTool_App = {};
}
WebTool.pkg("Utils");
if (typeof Utils == "undefined") {
	Utils = WebTool.Utils;
}
WebTool.pkg("WebTool_Core.Events");
WebTool_Core.Events.addEvent = function (elm, func, evType, useCapture) {
	var _el = $E(elm);
	if (_el == null) {
		return;
	}
	if (typeof useCapture == "undefined") {
		useCapture = false;
	}
	if (typeof evType == "undefined") {
		evType = "click";
	}
	if (_el.addEventListener) {
		_el.addEventListener(evType, func, useCapture);
		return true;
	} else {
		if (_el.attachEvent) {
			var r = _el.attachEvent("on" + evType, func);
			return true;
		} else {
			_el["on" + evType] = func;
		}
	}
};
WebTool_Core.Events.removeEvent = function (oElement, fHandler, sName) {
	/*var _el = $E(oElement);
	if (_el == null) {
		return;
	}
	if (typeof fHandler != "function") {
		return;
	}
	if (typeof sName == "undefined") {
		sName = "click";
	}
	if (_el.addEventListener) {
		_el.removeEventListener(sName, fHandler, false);
	} else {
		if (_el.attachEvent) {
			_el.detachEvent("on" + sName, fHandler);
		}
	}
	fHandler[sName] = null;*/
};
WebTool_Core.Events.getEvent = function () {
	return window.event;
};
WebTool.pkg("WebTool_Core.Dom");

WebTool_App.timer = new function () {
	this.list = {};
	this.refNum = 0;
	this.clock = null;
	this.allpause = false;
	this.delay = 25;
	this.add = function (fun) {
		if (typeof fun != "function") {
			throw ("The timer needs add a function as a parameters");
		}
		var key = "" + (new Date()).getTime() + (Math.random()) * Math.pow(10, 17);
		this.list[key] = {fun:fun, pause:false};
		if (this.refNum <= 0) {
			this.start();
		}
		this.refNum++;
		return key;
	};
	this.remove = function (key) {
		if (this.list[key]) {
			delete this.list[key];
			this.refNum--;
		}
		if (this.refNum <= 0) {
			this.stop();
		}
	};
	this.pause = function (key) {
		if (this.list[key]) {
			this.list[key]["pause"] = true;
		}
	};
	this.play = function (key) {
		if (this.list[key]) {
			this.list[key]["pause"] = false;
		}
	};
	this.stop = function () {
		clearInterval(this.clock);
		this.clock = null;
	};
	this.start = function () {
		var _this = this;
		this.clock = setInterval(function () {
			_this.loop.apply(_this);
		}, this.delay);
	};
	this.loop = function () {
		for (var k in this.list) {
			if (!this.list[k]["pause"]) {
				this.list[k]["fun"]();
			}
		}
	};
};
WebTool_App.animation = {speed:function (d, h, v) {
	var t = Math.ceil(h / v);
	var n = Math.ceil(t * 100 / d);
	var orbit = [];
	for (var i = 0; i < n; i++) {
		orbit.push((i + 1) * h / n);
	}
	return orbit;
}};

(function (proxy) {
	proxy.setOpacity = function (element, value) {
		element.style.filter = "alpha(opacity=" + value + ")";
		element.style.opacity = value / 100;
	};
	proxy.opacity = function (element, cfg, callback) {
		var _first = cfg.first;
		var _last = cfg.last || 0;
		if (_last == _first) {
			proxy.setOpacity(element, _first);
			if (typeof callback === "function") {
				callback(_first, _last);
			}
			return false;
		}
		var _time = Math.floor((cfg.time || 5) * 100 / proxy.timer.delay);
		var _orbit = [];
		for (var i = 0; i < _time; i++) {
			_orbit.push(_first + (_last - _first) * i / _time);
		}
		var _current = 0;
		var _timerhook = proxy.timer.add(function () {
			if (_current >= _orbit.length) {
				proxy.timer.remove(_timerhook);
				proxy.setOpacity(element, _last);
				if (typeof callback === "function") {
					callback(_first, _last);
				}
				return false;
			}
			proxy.setOpacity(element, _orbit[_current]);
			_current++;
		});
	};
})(WebTool_App);
WebTool_Core.Dom.getTop = function (element) {
	var top = 0;
	var el = $E(element);
	if (el.offsetParent) {
		while (el.offsetParent) {
			top += el.offsetTop;
			el = el.offsetParent;
		}
	} else {
		if (el.y) {
			top += el.y;
		}
	}
	return top;
};
WebTool_Core.Dom.insertAfter = function (newElement, targetElement) {
	/*var parent = targetElement.parentNode;
	if (parent.lastChild == targetElement) {
		parent.appendChild(newElement);
	} else {
		parent.insertBefore(newElement, targetElement.nextSibling);
	}
	return newElement;*/
};
WebTool_Core.Dom.removeNode = function (node) {
	/*node = $E(node) || node;
	try {
		node.parentNode.removeChild(node);
	}
	catch (e) {
	}*/
};
WebTool_Core.Dom.domInsert = function (pnode, param, pos, callback) {
	pos = /^(afterBegin|afterEnd|beforeBegin|beforeEnd)$/.test(pos) ? pos : "beforeEnd";
	callback = (typeof callback == "function" ? callback : function () {
	});
	var args = arguments;
		if (typeof param == "object" && /^(1|3)$/.test(param.nodeType)) {
			switch (pos) {
			  case "afterBegin":
				pnode.insertBefore(param, pnode.firstChild);
				break;
			  case "afterEnd":
				if (pnode.parentNode.nodeType == 1) {
					pnode.parentNode.insertBefore(param, pnode.nextSibling);
				}
				break;
			  case "beforeBegin":
				if (pnode.parentNode.nodeType == 1) {
					pnode.parentNode.insertBefore(param, pnode);
				}
				break;
			  case "beforeEnd":
				pnode.appendChild(param);
				break;
			}
		} 
		callback.call(args.caller);
};

(function (proxy) {
	proxy.insmarquee = function (pulley, list, cfg) {
		var that = {hooker:null, list:list, sttimeout:cfg.sttimeout};
		var insorbit = [];
		var hooker = null;
		var current = 0;
		var showing = 0;
		var scroll = 0;
		var parent = that.list[0].parentNode;
		
		var st;
		var ele;
		if (cfg === undefined) {
			cfg = {};
		}
		var speed = cfg.speed || 5;
		var forward = cfg.forward || "left";
		var orbitk = 2;
		var getinsOrbit = function (distance) {
			return proxy.animation.speed(proxy.timer.delay * orbitk, distance, speed);
		};
		pulley.style.overflow = "hidden";
		var isIns = false;
		if (forward === "up") {
		} else 	if (forward === "down") {
				scroll = pulley.scrollTop;
				insorbit = getinsOrbit(that.list[that.list.length - 1].offsetHeight);
				finishOne = function (itemNum) {
					that.pause("opacity");
					isIns = false;
					that.list[that.list.length - 1 - itemNum].style.backgroundColor = "#fff";
					proxy.opacity(that.list[that.list.length - 1 - itemNum], {first:0, last:100, time:Math.ceil(that.list[that.list.length - 1 - itemNum].offsetHeight / speed / 4)}, function () {
						clearTimeout(st);
						st = setTimeout(function () {
							if (!that.hooker || that.hooker == "parse") {
								return false;
							}
							that.restart();
						}, that.sttimeout || 5000);
					});
				};
				moveOne = function (itemNum) {
					insorbit = getinsOrbit(that.list[that.list.length - 1 - itemNum].offsetHeight);
				};
				looping = function (step, itemNum) {
					if (!isIns) {
						parent.removeChild(that.list[that.list.length - 1 - itemNum]);
						proxy.setOpacity(that.list[that.list.length - 1 - itemNum], "0");
						that.list[that.list.length - 1 - itemNum].style.height = "0px";
						that.list[that.list.length - 1 - itemNum].style.overflow = "hidden";
						WebTool_Core.Dom.domInsert(parent, that.list[that.list.length - 1 - itemNum], "afterBegin");
					}
					isIns = true;
					that.list[that.list.length - 1 - itemNum].style.height = insorbit[step] + "px";
				};
			} 
		that.start = function () {
			hooker = proxy.timer.add(function () {
				looping(current, showing);
				current += 1;
				if (current >= insorbit.length) {
					finishOne(showing);
					showing += 1;
					showing %= that.list.length;
					moveOne(showing);
					current = 0;
				}
			});
			that.hooker = hooker;
		};
		that.stop = function () {
			/*proxy.timer.remove(hooker);
			that.hooker = null;*/
		};
		that.pause = function (str) {
			proxy.timer.pause(hooker);
			that.hooker = str || "parse";
		};
		that.restart = function () {
			proxy.timer.play(hooker);
			that.hooker = hooker;
		};
		that.setList = function (arr, act) {
			if (act === "reset" || that.list.length == 0) {
				that.list = [];
				for (var k = 0; k < arr.length; k++) {
					that.list.push(arr[k]);
				}
				clearTimeout(st);
				ele = that.list.shift();
				that.setLivePlay();
			} else {
				that.list = that.list.concat(arr);
			}
		};
		that.getList = function () {
			return that.list;
		};
		that.setLiveStop = function (fun) {
			/*that.liveStop = true;
			if (typeof fun == "function") {
				fun();
			}*/
		};
		that.getLiveStop = function () {
			//return that.liveStop;
		};
		that.setLivePlay = function () {
			/*proxy.timer.play(hooker);
			that.hooker = hooker;
			that.liveStop = false;*/
		};
		return that;
	};
})(WebTool_App);

$registJob("marquee", function () {
	var marqueeBox = $E("scroll_div").parentNode;
	var divs = marqueeBox.getElementsByTagName("div");
	//无要滚动的元素返回
	if(divs.length == 1)return;
	
	var items = [];
	for (var i = 0, len = divs.length; i < len; i += 1) {
		if (divs[i].className === "itemt") {
			items.push(divs[i]);
		}
	}
	var ss = setTimeout(function (event) {
		event = event || window.event;
		var doMarquee = new WebTool_App.insmarquee(marqueeBox, items, {forward:"down", speed:5});
		if(null==StopObj) StopObj=doMarquee;
		WebTool_Core.Events.addEvent(marqueeBox, function () {if (event){
		         var browser=navigator.userAgent;   //取得浏览器属性
	          if (browser.indexOf("WebKit")>0||browser.indexOf("Firefox")>0){  //如果是Firefox
	　             if ($("scroll_div").contains(event.relatedTarget)) {  //如果是子元素
	　　                  return;   //结束函式
	                   } 
	             } 
	             if (browser.indexOf("MSIE")>0){  //如果是IE
	                    if ($("scroll_div").contains(event.toElement)) {  //如果是子元素
	                           return;  //结束函式
	                     }
	              }
	        }isOver=false;
			doMarquee.pause();
		}, "mouseout");		
		WebTool_Core.Events.addEvent(marqueeBox, function () {
			if(isOver)return;
			isOver=true;
			doMarquee.restart();
		}, "mouseover");
		doMarquee.start();
		clearTimeout(ss);
	}, 500);
});
var isOver=false;
var StopObj;
var jobs = new WebTool_Jobs();
	jobs.add("marquee");
	jobs.start();	
	_stop();
function _stop(){
	if(null==StopObj)
		setTimeout(function (){_stop()},10);
	else {StopObj.pause();}
}