<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/caiji_common_control.class.php';
include_once APP_PATH.'lib/string.func.php';

class content_control extends caiji_common_control {
	private $db;
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['caiji'] = 'active';
		$this->db=$this->caiji_content;
	}
	public function on_index(){
		
		$nid=intval(core::gpc('nid','G'));
		$status=intval(core::gpc('status','G'));
		$count=intval(core::gpc('totalnum','G'));
		
		$node=$this->kv->get('node_'.$nid);
		$this->caiji_node->format($node);
		
		$this->_title[]=$node['name'];
		$this->_title[]=$this->conf['app_name'];
		
		$page=misc::page();
		$pagesize=20;
		$start=($page-1)*$pagesize;
		$map=array('nid'=>$nid);
		$status>0 && $map['status']=$status-1;
		
		empty($count) && $count=$this->db->get_count($map);
		
		$list=$this->db->get_list($map,$start,$pagesize);
		
		foreach($list as &$content){
			$this->db->format($content);
		}
		
		$pages=misc::pages('?content-index-nid-'.$nid.'-totalnum-'.$count.'-status-'.$status.'.htm',$count,$page,$pagesize);
		$this->view->assign('status',$status);
		$this->view->assign('node',$node);
		$this->view->assign('list',$list);
		$this->view->assign('totalnum',$count);
		$this->view->assign('pages',$pages);
		$this->view->display('content_list.htm');	
	}
	public function on_manage(){
		$a=core::gpc('a','G');
		$nid=core::gpc('nid','G');
		switch($a){
			case 'delete':
			      $ids=core::gpc('ids','R');
				  if(is_array($ids)){
					  foreach($ids as $id){
					      $this->db->delete($id);
						  $this->caiji_content_pages->del_contentid($id);
					  }
				  }else{
					  $this->caiji_content_pages->del_contentid($ids);
					  $this->db->delete($ids);
					  
				  }
				  $this->message('数据删除成功！',1,'?content-index-nid-'.$nid.'.htm');
			
			break;
			
			case 'delete_all':
			      $this->db->delete_by_nid($nid);
				  $this->caiji_content_pages->del_nid($nid);
				  $this->message('数据清除成功！',1,'?content-index-nid-'.$nid.'.htm');
			break;
			
			case 'delete_urls':
			      $this->caiji_urls->delete_by_nid($nid);
				  $this->message('网址数据清除成功！',1,'?content-index-nid-'.$nid.'.htm');
			break;
			
			case 'upstatus':
			      $this->db->upstatus_by_nid($nid,1);
				  $this->message('操作成功！',1,'?content-index-nid-'.$nid.'.htm');
			break;
			
			case 'img_delete':
			      $ids=core::gpc('ids','R');
				  if(is_array($ids)){
					  foreach($ids as $id){
					      $this->caiji_images->xdelete($id);
					  }
				  }else{
					  $this->caiji_images->xdelete($ids);
					  
				  }
				  $this->message('图片删除成功！',1,'?content-images-nid-'.$nid.'.htm');
			
			break;
			case 'img_delete_all':
			     $this->caiji_images->delete_by_nid($nid);
				 $this->message('图片清除成功！',1,'?content-images-nid-'.$nid.'.htm');
			
			break;
			
			
		}
		
		
		
	}
	public function on_read(){
		$id=intval(core::gpc('id','G'));
		
		$rs=$this->db->read($id);
		$this->db->format($rs);
		$node=$this->kv->get('node_'.$rs['nid']);
		
		$infos=array();
		$infos['title']=array('name'=>'标题','value'=>$rs['title']);
		$infos['url']=array('name'=>'源网址','value'=>$rs['url']);
		$infos['status']=array('name'=>'状态','value'=>$rs['status_fmt']);
		$infos['img']=array('name'=>'缩略图','value'=>$rs['img']);
		$infos['content']=array('name'=>'内容','value'=>$rs['content']);
		$infos['reply']=array('name'=>'回帖','value'=>$rs['reply']);
		
		$rs['content_pages']=str_replace('[|]','<br />',$rs['content_pages']);
		
		$infos['content_pages']=array('name'=>'内容分页','value'=>$rs['content_pages']);
		
		$data=explode('[_xgcms_]',$rs['data']);
		foreach($data as $v){
			if(empty($v)) continue;
			$arr=explode('[field]',$v);
			//if($arr[0]=='title') continue;
            //$infos[$arr[0]]=array('name'=>$arr[0],'value'=>htmlspecialchars($arr[1]));
			$infos[$arr[0]]=array('name'=>$arr[0],'value'=>$arr[1]);
		}
		
		$infos=new_stripslashes($infos);
		
		$this->view->assign('data',$rs);
		$this->view->assign('infos',$infos);
		$this->view->display('content_read.htm');
		
		
		
	}
	public function on_edit(){
		$id=intval(core::gpc('id','G'));
		
		$rs=$this->db->read($id);
		//$this->caiji_content->format($rs);
		$node=$this->kv->get('node_'.$rs['nid']);
		
		if($this->form_submit()){
			$infos=core::gpc('info','P');
			$rs=array_merge($rs,$infos);
			$this->db->update($rs);
			$this->message('修改成功！',1,'?content-edit-id-'.$id.'.htm');
			
			
		}else{
			  $infos=array();
			  foreach($rs as $k=>$v){
				 if(!in_array($k,array('title','aid','status','url','img','content','reply','data'))) continue;
				 if(in_array($k,array('content','reply','data'))){
					 $height=empty($v)?100:500;
					 $infos[$k] = form::get_textarea('info['.$k.']',$v,800,$height);
					 continue;
					 
				 }
				 $infos[$k] = form::get_text('info['.$k.']', $v, 350);
 
			  }
			  $this->_title[]='修改内容';
		      $this->_title[]=$this->conf['app_name'];
              $this->view->assign('data',$rs);
			  $this->view->assign('infos',$infos);
			  $this->view->display('content_edit.htm');
		}
		
		
		
	}
	public function on_images(){
		$nid=intval(core::gpc('nid','G'));
		$status=intval(core::gpc('status','G'));
		$count=intval(core::gpc('totalnum','G'));
		
		$node=$this->kv->get('node_'.$nid);
		$this->caiji_node->format($node);
		
		$this->_title[]=$node['name'];
		$this->_title[]=$this->conf['app_name'];
		
		$page=misc::page();
		$pagesize=20;
		$start=($page-1)*$pagesize;
		$map=array('nid'=>$nid);
		$status && $map['status']=$status;
		
		empty($count) && $count=$this->caiji_images->index_count($map);
		
		$list=$this->caiji_images->get_list($map,$start,$pagesize);

		foreach($list as &$content){
			$this->caiji_images->format($content);
		}
        
		$pages=misc::pages('?content-images-nid-'.$nid.'-status-'.$status.'-totalnum-'.$count.'.htm',$count,$page,$pagesize);
		$this->view->assign('status',$status);
		$this->view->assign('node',$node);
		$this->view->assign('list',$list);
		$this->view->assign('totalnum',$count);
		$this->view->assign('pages',$pages);
		$this->view->display('content_images.htm');		
	
	}
	public function on_down_images(){
		
		$nid=intval(core::gpc('nid','G'));
		$count=intval(core::gpc('totalnum','G'));
		
		$node=$this->kv->get('node_'.$nid);
		
		$this->caiji_node->format($node);
		
		$this->_title[]=$node['name'];
		$this->_title[]=$this->conf['app_name'];
		
		$page=misc::page();
		
		$xc = max(1,intval(core::gpc('xc','G')));
		$jg = max(2,intval(core::gpc('jg','G')));

		$map=array('nid'=>$nid,'status'=>1);
		
		$path='upload/'.$nid.'/';
		$ids=core::gpc('ids','P');
		if(!empty($ids)){
			foreach($ids as $id){
				$img=$this->caiji_images->read($id);
				$this->caiji_images->download($img,$path);
			}	
			$this->message('下载完成',1,'?content-images-nid-'.$nid.'.htm');
		}
		
		
		empty($count) && $count=$this->caiji_images->index_count($map);
		
		$list=$this->caiji_images->get_list($map,0,$xc);

		if(empty($list)) $this->message('下载完成',1,'?content-images-nid-'.$nid.'.htm');
		
		foreach($list as $v){
			if(empty($v['image'])){
				$v['status']=3;	
				$this->caiji_images->update($v);
				continue;
			}
			$this->caiji_images->download($v,$path);
		}
		if($page*$xc>$count) $this->message('下载完成',1,'?content-images-nid-'.$nid.'.htm');

		$page++;
		$msg='正在下载:'.($page*$xc).'/'.$count;
		$this->message($msg,1,"?content-down_images-nid-$nid-jg-$jg-xc-$xc-page-$page-totalnum-$count.htm");
		
		
	}
	public function on_big5_gb(){
		
		
		
		$this->view->display('content_big5_gb_ajax.htm');
	}
}


?>