<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/caiji_common_control.class.php';

class index_control extends caiji_common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['caiji'] = 'active';
	}
	public function on_login(){
		$this->location($this->conf['post_url'].'admin/?index-login.htm');
	}
	// 给插件预留个位置
	public function on_index() {

        // hook index_index_before.php

		$this->_checked['node_list']=1;
		$gid=intval(core::gpc('gid','G'));
		$con=array();
		if($gid) $con=array('gid'=>$gid);
		
		$pagesize=20;
		$page = misc::page();
		$start = ($page -1 ) * $pagesize;
		
        $node_list=$this->caiji_node->get_list($con,$start,$pagesize);
		foreach( $node_list as &$node){
			$this->caiji_node->format($node);
		}
		$pages = misc::simple_pages('?index-index-gid-'.$gid.'.htm', count($node_list), $page, $pagesize);
		
		$group_list=$this->caiji_group->get_list();
		if($gid>0) $this->_title[]=$this->caiji_group->groupid_to_name($gid);
		$this->_title[]='采集任务';
		$this->_title[]=$this->conf['app_name'];
		
		$this->view->assign('group_list',$group_list);
		$this->view->assign('node_list',$node_list);
		$this->view->assign('gid',$gid);
		$this->view->assign('pages', $pages);
		$this->view->display('index.htm');

	}
	//添加分组
	public function on_group(){
		if($this->form_submit()){
			$name=htmlspecialchars(core::gpc('name','P'));
			$error=array();
			$error['name']=$this->caiji_group->check_name($name);
			if(!array_filter($error)){
				$data=array();
				$data['name']=$name;
				$data['rules']=0;
				$gid=$this->caiji_group->create($data);
				$this->message('新建分组成功！');
			}else{
				$this->message($error);
			}
			
		}else{
			
			$this->view->display('node_group_ajax.htm');
		}

	}
	public function on_node() {
        // hook index_node_before.php
        $this->_checked['node']=1;
		$nid=intval(core::gpc('nid','R'));
		$gid=intval(core::gpc('gid','G'));
		if($this->form_submit()){
			$data =core::gpc('data','P');
			$data['urlpage']=core::gpc('urlpage'.$data['sourcetype'],'P');
			
			if(empty($data['name'])) $this->message('任务名不能为空！');
			$new=array();
			$new['name_en']=core::gpc('newname_en','P');
			$new['name']=core::gpc('newname','P');
			$new['html_rule']=core::gpc('newhtml_rule','P');
			$new['filter']=core::gpc('new_filter','P');
			
			
			if($nid>0){
				$where=array("nid"=>$nid);
				$rs=$this->caiji_node->read($nid);
				$rs=array_merge($rs,$data);
				$this->caiji_node->update($rs);
                
				$newlist=$this->caiji_newfield->get_list($where);
				foreach($newlist as $f){
					$this->caiji_newfield->delete($f['id']);
				}
			    if(is_array($new['name_en']))foreach($new['name_en'] as $k=>$v){
				    if(empty($v)) continue;
				    $newdata=array( 'name_en'=>$v,
				                    'name'=>$new['name'][$k],
									'html_rule'=>$new['html_rule'][$k],
									'filter'=>$new['filter'][$k],
									'nid'=>$nid,
									
								  );

					$this->caiji_newfield->create($newdata);
			    }
				
				$this->cache_update_node($nid);
				
				$this->message('更新成功！',1,'?index-index-gid-'.$rs['gid'].'.htm');
			}else{
				
                $newdata=array();
			    if(is_array($new['name_en']))foreach($new['name_en'] as $k=>$v){
				     if(empty($v)) continue;
				     $newdata[]=array( 'name_en'=>$v,
				                    'name'=>$new['name'][$k],
									'html_rule'=>$new['html_rule'][$k],
									'filter'=>$new['filter'][$k],
									'nid'=>0,
									
								  );
				}
				$data['newfield']=$newdata;
				
				$nid=$this->caiji_node->xcreate($data);

				$this->cache_update_node($nid);
				
				$this->message('添加成功！',1,'?index-index-gid-'.$data['gid'].'.htm');
			}

		} else{	
		   
		    if($nid>0){
				$node=$this->caiji_node->read($nid);
				$gid=$node['gid'];
				$post_id=$node['post_id'];
				$newfield=$this->caiji_newfield->get_list(array('nid'=>$nid));
			}else{
				$node=$this->caiji_node->get_list(array(),0,1);
				if($node) $node=array_pop($node);
				foreach($node as &$n){
					$n='';
				}
				$post_id=0;
				$newfield=array();
			}
			$group_list=$this->caiji_group->get_list();
			$group_list=misc::arrlist_key_values($group_list,'gid','name');
			
			$post_list=$this->caiji_post->get_list();
			$post_list=misc::arrlist_key_values($post_list,'id','name');
			
			$node['input_group']=form::get_select('data[gid]',$group_list,$gid);
			$node['input_postid']=form::get_select('data[post_id]',$post_list,$post_id);
			$node['input_sourcecharset'] = form::get_radio('data[sourcecharset]', array('utf-8'=>'utf-8', 'gbk'=>'gbk', 'big5'=>'big5'), $node['sourcecharset']);
			
			for($i=1;$i<=4;$i++){				
				if($node['sourcetype']==$i){
				   $node['urlpage'.$i]=$node['urlpage'];
				}else{
				  $node['urlpage'.$i]='';
					
				}
				
				
			}
			
			$this->_title[]='新建采集任务';
			if($gid>0) $this->_title[]=$this->caiji_group->groupid_to_name($gid);
		    $this->_title[]=$this->conf['app_name'];
		
			$htmlrule=$this->htmlrule();
			$this->view->assign('htmlrule',$htmlrule);
			$this->view->assign('node',$node);
			$this->view->assign('newfield',$newfield);
			$this->view->assign('nid',$nid);
			$this->view->assign('gid',$gid);
			$this->view->display('node_add.htm');
		}


	}
	public function on_manage(){
		$a=core::gpc('a','G');
		switch($a){
			case 'export':
			              $nid=intval(core::gpc('nid','G'));
			              $data=$this->caiji_node->xget($nid);
						  $name=$data['name'];
						  $name=misc::safe_str($name,'-.');
						  $data='BASE64:'.base64_encode(json_encode($data)).':END';
			              header("Content-type: application/octet-stream");
		                  header("Content-Disposition: attachment; filename=coll_".$name.'.txt');
		                  echo $data;
						  break;
			case 'import':
						  if($this->form_submit()){
											
							  $StrData=core::gpc('data','P');
							  
							  empty($StrData) && $this->message('请输入已导出规则TXT的内容！',0);
							  $Arr    =explode(':',$StrData);
			  
							  $ArrData=json_decode(base64_decode($Arr[1]),true);
			  
							  if(!$ArrData) $this->message('内容不正确！',0);
							  
							  $nid=$this->caiji_node->xcreate($ArrData);
							  
                              $this->cache_update_node($nid);
							  
							  $this->message('导入成功！');
							  
					     }else{
							  $this->view->display('node_import_ajax.htm');
					     }
						 break;
		   case 'delete':
				         $nid=core::gpc('nid','R');
		
						 if(is_array($nid)){
							  foreach($nid as $n){
								  $this->caiji_node->xdelete($n);
								  $this->cache_delete_node($n);
							  }
							  
						 }else{
							  $this->caiji_node->xdelete($nid);
							  $this->cache_delete_node($nid);
							  
						 }
						 $this->message('任务删除完成！',1,'?index.htm');
						 break;
			case 'copy':
			            $nid=intval(core::gpc('nid','G'));
			            if($this->form_submit()){
							  
							  $name=core::gpc('name','P');
							  if($this->caiji_node->check_name($name)) $this->message('请填写名称！',0);
							  $rs=$this->caiji_node->xget($nid);
							  
							  if(empty($rs['nid'])) $this->message('该任务不存在！',0);
							  
							  $rs['name']=$name;
							  $nid=$this->caiji_node->xcreate($rs);
							  
							  $this->cache_update_node($nid);
							  
							  $this->message('复制成功！');
						}else{
							  $this->view->assign('nid',$nid);
							  $this->view->display('node_copy_ajax.htm');
						}
			            break;          
		   case  'group_del':
		                $gid=intval(core::gpc('gid','G'));
		                $node_list=$this->caiji_node->get_list(array('gid'=>$gid),0,1000);
						if($node_list)foreach($node_list as $node){
							
							 $this->caiji_node->xdelete($node['nid']);
							 $this->cache_delete_node($node['nid']);
							
						}
						$this->caiji_group->delete($gid);
						$this->message('分组删除成功！',1,'?index.htm');
		                break;
			
		}
	}
	//URL配置结果测试
	public function on_testurl() {
		$url=urldecode(core::gpc('url','G'));
        $charset=urldecode(core::gpc('charset','G'));
		if(!$url){
		    $this->message('没有填写网址');
		}else{
		    // $conf=array('sourcecharset'=>$charset,'sourcetype'=>1);
            $html= misc::fetch_url($url);
			if ('utf-8' != $charset) {
					$html = iconv($charset, 'utf-8', $html);
			}
			    
			$html=htmlspecialchars($html);
			
            $this->view->assign('url',$url);
            $this->view->assign('charset',$charset);
            $this->view->assign('html',$html);
            $this->view->display('node_testurl.htm');
		}
	}
	private function htmlrule(){
	    return $text='<p([^>]*)>(.*)</p>[|]\n
<a([^>]*)>(.*)</a>[|]\n
<script([^>]*)>(.*)</script>[|]\n
<iframe([^>]*)>(.*)</iframe>[|]\n
<table([^>]*)>(.*)</table>[|]\n
<span([^>]*)>(.*)</span>[|]\n
<b([^>]*)>(.*)</b>[|]\n
<img([^>]*)>[|]\n
<object([^>]*)>(.*)</object>[|]\n
<embed([^>]*)>(.*)</embed>[|]\n
<param([^>]*)>(.*)</param>[|]\n
<div([^>]*)>[|]\n
</div>[|]\n
<!--([^>]*)-->[|]';	
	}

	//hook index_control_after.php
}

?>