<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/caiji_common_control.class.php';
include_once APP_PATH.'lib/string.func.php';

class post_control extends caiji_common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['post'] = 'active';

	}
	public function on_index(){
		$this->_checked['post_list']='checked';
		$this->_title[]='发布模块';
		$this->_title[]=$this->conf['app_name'];
		
		$list=$this->caiji_post->get_list();
        foreach($list as &$p){
			$this->caiji_post->format($p);
		}
		$this->view->assign('list',$list);
		
	    $this->view->display('post_list.htm');

	}
	public function on_manage(){
		$a=core::gpc('a','G');
		switch($a){
			case 'add':
			      $id=intval(core::gpc('id','G'));
				  if($this->form_submit()){
					  $infos=core::gpc('infos','P');
					  if(empty($infos['name'])) $this->message(array('name'=>'请填写模型名称！'));
					  
					  if($id){
						  $infos['id']=$id;
						  $this->caiji_post->update($infos);
						  $this->message('发布模型编辑成功！');
					  }
					  $this->caiji_post->create($infos);
					  
					  $this->message('发布模型建立成功！');
		  
				  }else{
					  
					 $data=array('post_type'=>1);
					 if($id>0) $data=$this->caiji_post->read($id);
					 
					 $data['post_type']=form::get_select('infos[post_type]',array('1'=>'顺序','2'=>'倒序','3'=>'乱序'),$data['post_type']);
					 
					 $dialog_title=$id?'编辑发布模型':'新建发布模型';
					 
					 $this->view->assign('id',$id);
					 $this->view->assign('dialog_title',$dialog_title);
					 $this->view->assign('post',$data);
					 $this->view->display('post_add_ajax.htm');
				  }
			break;
			
			case 'delete':
				  $ids=core::gpc('ids','R');
				  if(is_array($ids)){
					  foreach($ids as $id){
						  $this->caiji_post->delete($id);	
					  }
					  
				  }else{
					   $this->caiji_post->delete($ids);	
				  }
				  $this->message('删除成功！',1,'?post.htm');
			break;
			
			case 'copy':
			            $id=intval(core::gpc('id','G'));
			            if($this->form_submit()){
							  
							  $name=core::gpc('name','P');
							  if($this->caiji_node->check_name($name)) $this->message('请填写名称！',0);
							  $rs=$this->caiji_post->get($id);
							  
							  if(empty($rs['id'])) $this->message('该模型不存在！',0);
							  
							  $rs['name']=$name;
							  unset($rs['id']);
							  $nid=$this->caiji_post->create($rs);
							  
							  $this->message('复制成功！');
						}else{
							  $this->view->assign('id',$id);
							  $this->view->display('post_copy_ajax.htm');
						}
			  break;  	
		}
		
	}
	public function on_test(){
		$id=intval(core::gpc('id','G'));
		$post=$this->caiji_post->read($id);
		
		if($this->form_submit()){
			$infos=core::gpc('info','P');
			$str='';
			foreach($infos as $k=>$v){
				$str.=$k.'='.$v.'&';
			}
			$post_url=$post['post_domain'].$post['post_url'];
			$html=misc::fetch_url($post_url,5,$str);
			if(!empty($post['post_success'])&&(stripos($html,$post['post_success'])||$post['post_success']==$html)){
				$status='发布成功';
			}else{
				$status='发布失败';
			}
			$msg=array();
			$msg['status']=$status;
			$msg['html']=$html;
			$this->message($msg);
		}else{
		   $arr=explode('&',$post['post_data']);
		   $fields=array();
		   foreach($arr as $v){
			   $pos=stripos($v,'=');
			   $field=utf8::substr($v,0,$pos);
			   
			   $str=substr($v,$pos+1);
			   
			   $input=form::get_textarea('info['.$field.']', $str, 400,60);
			   $fields[]=array('name'=>$field,'input'=>$input);
		   }
		   $this->view->assign('id',$id);
		   $this->view->assign('fields',$fields);
		   $this->view->display('post_test_ajax.htm');	
		}
	}
	public function on_go(){
		$nid=intval(core::gpc('nid','G'));
		
		$xc=intval(core::gpc('xc','G'));
		$jg=intval(core::gpc('jg','G'));
		
		$page=misc::page();
		
		$node=$this->kv->get('node_'.$nid);
		
		$this->caiji_node->format($node);
		
		$post_id=$node['post_id']; empty($post_id) && $this->message('还没有设置发布模块',0,'?index-node-nid-'.$nid.'.htm');
		
		$url="?post-content-nid-$nid-xc-$xc-jg-$jg-page-$page.htm";
		
		$a='发布内容';
		
		$this->_title[]='【'.$node['name'].'】 发布内容';
		
		$this->view->assign('url',$url);
		$this->view->assign('node',$node);
		$this->view->assign('a',$a);
		$this->view->display('run_collect.htm');
	}
	
	public function on_content(){
		
		$nid=intval(core::gpc('nid','G'));

		$count=intval(core::gpc('count','G'));
		
		$page=misc::page();
		$xc = misc::page('xc');
		$jg = misc::page('jg');
		
		$conf=$this->kv->get('node_'.$nid);
		
		$post_id=$conf['post_id']; empty($post_id) && $this->message('还没有设置发布模块');
		$post_info=$this->caiji_post->read($post_id); empty($post_info) &&  $this->message('发布模块不存在！');
		
		$this->caiji_node->format($conf);
		
		$map = array();
        $map['nid'] = $nid;
        $map['status'] = 1;

        

        empty($count) && $count=$this->caiji_content->index_count($map);
		
		$start=0;
		$order=array('id'=>1);
		
		$post_info['post_type']==2 && $order=array('id'=>-1);

		if($post_info['post_type']==3){
			
			$total=$this->caiji_content->index_count($map);
			
		    $start=rand(0,$total-$xc);
			$start=max(0,$start);
	    }
		
        $list = $this->caiji_content->get_list($map,$start,$xc,$order);

		$current=$page*$xc;
		
		$current=max(1,$current);
		
		$percent=round($current/$count*100);
		$percent=min(100,$percent);
		$percent.='%';
		
        if (empty($list)||$current>$count) {
            
            $conurl = '?content-index-nid-'.$conf['nid'].'.htm';
			//$this->message('内容发布完成！',1,$conurl);
			echo '内容发布完成...<script language="JavaScript">
			setTimeout(function() {
		 			if (window.top!=window.self){parent.location.href="'. $conurl.'";}else{window.location.href="'.$conurl.'";}
}, 3000);
</script>';exit;
        }
		$this->_title[]='【'.$conf['name'].'】 发布内容 '.$current.'/'.$count;
		$this->view->assign('current',$current);
		$this->view->assign('total',$count);
		$this->view->assign('percent',$percent);
		$this->view->assign('node',$conf);
		$this->view->display('run_progress.htm');
		
		$post_url=$post_info['post_domain'].$post_info['post_url'];
		
		$fid=$post_info['catid'];
		
		if($post_info['post_to']==2){
			$fid=$this->forum->get_fid_by_name($conf['name']);
		}elseif($post_info['post_to']==5){
			$cms_c=$this->apps->m('xgcms','xgcms_category');
		    $c=$cms_c->get_one(array('catname'=>$conf['name']));
			if(!$c) $this->message('栏目：'.$conf['name'].' 不存在',0);
			$fid=$c['catid'];
		}

		foreach($list as $v){
			
			$postdata=$this->get_postdata($v,$post_info['post_data']);
            if($fid){
				//$postdata=str_replace('[_page_]','[\page]',$postdata);
				$infos=$postdata;//misc::explode('=', '&', $postdata);
				if($post_info['post_to']<4){
				    $id=$this->caiji_xgpost->topic($infos,$fid);
				}else{
					$id=$this->caiji_xgcms->add($infos,$fid);
				}
				if($id){
					$v['status']=2;
				    $msg='<font color="green">发布成功</font>';
				}else{
					$v['status']=3;
				    $msg='<font color="red">发布失败</font>';
				}
				
			}else{
				$html=misc::fetch_url($post_url,5,$postdata);
				if(!empty($html)&&!empty($post_info['post_success'])&&(stripos($html,$post_info['post_success'])||$html==$post_info['post_success'])){
					$v['status']=2;
					$msg='<font color="green">发布成功</font>';
				}else{
					$v['status']=3;
					$msg='<font color="red">发布失败</font>';
				}
			}
			$this->caiji_content->update($v);
			
			echo '《'.$v['title'].'》'.$msg.'<br />';
		}
		$page++;
		$next="?post-content-nid-$nid-xc-$xc-jg-$jg-count-$count-page-$page.htm";
		echo '<html>
					  <head>
					  <meta http-equiv="Content-Language" content="zh-CN">
					  <meta HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=utf-8">
					  <meta http-equiv="refresh" content="'.$jg.';url=' . $next . '">
					  <title>发布数据</title>
					  </head>
					  <body>
					  <a href="' . $next . '">继续发布下一页</a>
					  </body>
					  </html>';
					 exit;
	}
	private function get_postdata($arr,$post){
		$arr_data=explode('[_xgcms_]',$arr['data']);
		
		foreach((array)$arr_data as $kd=>$vd){
			if(empty($vd)) continue;
			$field=explode('[field]',$vd);
			$arr[$field[0]]=$field[1];	
		}
		$postarr=misc::explode('=','&',$post);
		$data=array();
		foreach($postarr as $k=>$v){
			$v=str_replace(array('[',']'),'',$v);
			if(isset($arr[$v])){
				$data[$k]=$arr[$v];
			}else{
				$data[$k]=$v;
			}
		}
		$data=new_stripslashes($data);
		return $data;
		
		
		foreach($arr as $k=>$v){
			$k2='['.$k.']';
			if(stripos($post,$k2)===false) continue;
			$v=str_replace('&nbsp;',' ',$v);
			$v=str_replace(array('&','='),array('FH_YU','FH_DENG'),$v);
			$post=str_replace($k2,$v,$post);
		}
		$post=new_stripslashes($post);
		return $post;
		
	}
}



?>