<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include $conf['xcenter_path'].'control/common_control.class.php';

class admin_control extends common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_xss();
		$this->check_admin_group();
		$this->conf['first_view_path'] = array(APP_PATH.'view/');
	}
	// 是否为最高级别的管理员
	protected function check_admin_group() {
		$admin_auth = core::gpc($this->conf['cookie_pre'].'admin_auth', 'R');
		$login = 0;
		if(empty($admin_auth)) {
			// 登录页面放行
			 if(!(core::gpc(0) == 'index' && (core::gpc(1) == 'login' || core::gpc(1) == 'logout'))) {
				$login = 1;
			}
		} else {
			$s = decrypt($admin_auth, $this->conf['auth_key']);
			
			if(empty($s)) {
				$login = 1;
			} else {
				$arr = explode("\t", $s);
				if(empty($arr)) {
					$login = 1;
				} else {
					list($time, $ip) = $arr;
					
					/*
						1. cookie 连续实效半小时，半小时不活动视为自动退出。
						2. IP发生变化，退出登录
						3. 更换浏览器，退出登录（浏览器同样可以被xss获取，此项废除）
					*/
					if($_SERVER['time'] - $time > 86400) {
						$s = encrypt("$_SERVER[time]\t$_SERVER[ip]", $this->conf['auth_key']);
						misc::setcookie($this->conf['cookie_pre'].'admin_auth', $s, $_SERVER['time'] + 86400, $this->conf['cookie_path'], $this->conf['cookie_domain']);
						$time = $_SERVER['time'];
					}
					
					// 仅比较IP段！放宽一点。
					$pos = strrpos($ip, '.');
					if(substr($ip, 0, $pos) != substr($_SERVER['ip'], 0, $pos)) {
						$login = 1;
					}
				}
			}
			// dateline	ip
		}
		if($login) {
			misc::setcookie($this->conf['cookie_pre'].'admin_auth', '', $_SERVER['time'], $this->conf['cookie_path'], $this->conf['cookie_domain']);
		    $url =$this->conf['xcenter_url'].'?'.'index-'.'login.'.'htm';
			echo '<html><body><script>top.location="'.$url.'"</script></body></html>';
			exit;
		}
	}
	// 检查 xss
	protected function check_xss() {
		$referer = core::gpc('HTTP_REFERER', 'S');
		// 如果来自前台，则停顿一下！点击后继续访问
		$len = strlen($this->conf['xcenter_url']);
		$len2 = strlen($this->conf['app_url']);
		$len3 = strlen($this->conf['cms_url']);
		$url = misc::get_script_uri();
		if(substr($referer, 0, $len2) == substr($this->conf['app_url'], 0, $len2)) {
			// 合法
		} elseif(empty($referer) || substr($referer, 0, $len) == substr($this->conf['xcenter_url'], 0, $len)|| substr($referer, 0, $len3) == substr($this->conf['cms_url'].'xgcms/admin/', 0, $len3)) {
			//$this->message("<a href=\"$url\">通过了来路检查, 点击【继续访问管理后台】</a>");
		} else {
			$this->message("此来路可能存在安全问题：<br />$referer, <br /><br /><a href=\"$url\">点击【继续访问管理后台】</a>");
		}
	}
	protected function clear_tmp($pre = '') {
		$len = strlen($pre);
		$dh = opendir($this->conf['tmp_path']);
		while(($file = readdir($dh)) !== FALSE ) {
			if($file != "." && $file != ".." && $file[0] != '.') {
				if(empty($pre) || substr($file, 0, $len) == $pre) {
					$filename = $this->conf['tmp_path']."$file";
					is_file($filename) && unlink($filename);
				}
			}
		}
		closedir($dh);
	}
	protected function check_mod_group() {
		if($this->_group['groupid'] == 0 || $this->_group['groupid']  > 5) {
			log::write("非法尝试后台登录", 'login.php');
			$this->message('对不起，您所在的用户组不是管理组，无权访问。', 0);
		}
	}
		// 是否为最高级别的管理员
	protected function check_super_admin() {
		if($this->_group['groupid'] != 1) {
			$this->message('对不起，您不是管理员，无权访问。', 0, '?index-login.htm');
		}
	}
}

?>