<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include $conf['xcenter_path'].'control/admin_control.class.php';

class index_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['xgcms'] = ' class="checked"';
	}
	
	public function on_index() {
        // hook xcenter_index_index_before.php
        $list=$this->apps->get_list(array('ismenu'=>1,'installed'=>1));
		$this->view->assign('list',$list);
		$this->view->display('index.htm');

	}
	public function on_apps(){
        $this->_checked['apps']='active'; 
		$this->_checked['apps_list']=1;
		$this->_title[]='应用列表';
		$this->_title[]=$this->conf['app_name'];
		
		if($this->form_submit()){
			$ismenu=core::gpc('ismenu','P');
			$ids=core::gpc('ids','P');
			foreach($ids as $id){
				$rs=$this->apps->read($id);
				isset($ismenu[$id])  &&  $rs['ismenu']=1;
				!isset($ismenu[$id])  &&  $rs['ismenu']=0;
				$this->apps->update($rs);

			}
			$this->message('更新成功');
			
		}
		$list=$this->apps->get_list(array('id'=>array('>'=>3)));
		foreach($list as $k=>$v){
			if($v['isxgcms']&&!$v['installed']) unset($list[$k]);
			
		}
		$this->view->assign('list',$list);
        $this->view->display('apps.htm');

	}
	public function on_app_add(){
       $id=intval(core::gpc('id','G'));
	   
	   if($this->form_submit()){
		   
		   $infos=core::gpc('infos','P');
		   $infos['id']=$id;
		   empty($infos['name']) && $this->message('请填写名称',0);
		   if($id>0){
			   
			   $this->apps->update($infos);
		   }else{

		       $this->apps->create($infos);
		   }
		   $this->message('操作成功！');
		   
	   }
	   $app=$this->apps->read($id);
	   $this->view->assign('id',$id);
	   $this->view->assign('app',$app);
       $this->view->display('app_add_ajax.htm');

	}
	public function on_app_delete(){
		$id=intval(core::gpc('id','G'));
		$app=$this->apps->read($id);
		if($app['isxgcms']){
			$app['installed']=0;
			$this->apps->update($app);
		}else{
		    $this->apps->delete($id);
		}
		$this->message('删除成功！',1,'?index-apps.htm');
	}
    public function on_app(){
		$id=intval(core::gpc('id','G'));
		$model=core::gpc('name','G');
		if($model){
			$rs=$this->apps->get_app_by_modelname($model);
			empty($rs['installed']) && $this->message('您还没有安装'.$rs['name'].'模块，请到资源平台下载安装！');
		}else{
		    $rs=$this->apps->read($id);
		}
        $this->location($rs['admin_url']);
	}
	public function on_login(){
		$referer = core::gpc('HTTP_REFERER', 'S');
		if(strpos($referer, 'index-logout') !== FALSE || strpos($referer, 'index-login') !== FALSE || strpos($referer, 'user-login') !== FALSE) {
			$referer = '';
		}
		
		if($this->form_submit()){
			$ip = substr(md5($_SERVER['ip']),10);
			$login_count=$this->runtime->get('login_'.$ip);
            if($login_count>5) $this->message('密码错误5次以上，请10分钟后再次登陆！');
			
			$referer = core::gpc('referer', 'P');
			$username = core::gpc('username', 'P');
			$password = core::gpc('password', 'P');
			$clienttime = core::gpc('clienttime', 'P');
			$safe_admin_auth = core::gpc('safe_admin_auth', 'P');
			$username=misc::safe_str($username);
			$user=$this->user->get_user_by_username($username);
			if(empty($user)){
				log::write('[后台]管理员不存在:'.$username, 'login.php');
				
				$this->runtime->set('login_'.$ip,$login_count+1,600);
				$this->message('账户密码不对，还有'.(5-$login_count).'次机会');
			}
			if(!$this->user->verify_password($password, $user['password'], $user['salt'])) {
				$log_password = '******'.substr($password, 6);
				log::write("[后台]密码错误：$username - $log_password", 'login.php');
				
				$this->runtime->set('login_'.$ip,$login_count+1,600);
				$this->message('账户密码不对，还有'.(5-$login_count).'次机会');
			}
			if($user['groupid'] == 0 || $user['groupid']  > 4) {
				log::write("非法尝试后台登录", 'login.php');
				$this->message('对不起，您所在的用户组不是管理组，无权访问。', 0);
			}
			$this->user->set_login_cookie($user, $clienttime + 86400 * 30);
			
			misc::setcookie($this->conf['cookie_pre'].'safe_admin_auth', intval($safe_admin_auth), $clienttime + 86400, $this->conf['cookie_path'], $this->conf['cookie_domain']);
			
			// 登陆成功，设置 cookie
			$s = encrypt("$_SERVER[time]\t$_SERVER[ip]", $this->conf['auth_key']);
			
			// 客户端时间解决服务器与客户端不在一个时区的问题。
			misc::setcookie($this->conf['cookie_pre'].'admin_auth', $s, $clienttime + 86400, $this->conf['cookie_path'], $this->conf['cookie_domain']);
			$this->message('登录后台成功！', 1, $referer ? $referer : './');
			
			
			
		}
		$this->view->assign('referer', $referer);
		$this->view->display('index_login.htm');
		
	}
	function on_logout() {
		misc::setcookie($this->conf['cookie_pre'].'auth', '', 0, $this->conf['cookie_path'], $this->conf['cookie_domain']);
		misc::setcookie($this->conf['cookie_pre'].'admin_auth', '', $_SERVER['time'], $this->conf['cookie_path'], $this->conf['cookie_domain']);
		$url = "?index-login.htm";
		echo '<html><body><script>top.location="'.$url.'"</script></body></html>';
		exit;
	}
	public function on_password(){
		if($this->form_submit()){
			$oldpassword=core::gpc('oldpassword', 'P');
		    $password = core::gpc('password', 'P');
			$password2 = core::gpc('password2', 'P');
			
			$error['password'] = $this->user->check_password($password);

			if(!empty($error['password'])) $this->message($error['password'],0);
			
			$user=$this->user->read($this->_user['uid']);
			
			if(empty($user)){
				log::write("[后台]修改密码，用户不在", 'login.php');
				
				$this->message('账户密码不对',0);
			}
			
			if(!$this->user->verify_password($oldpassword, $user['password'], $user['salt'])) {
				$log_password = '******'.substr($oldpassword, 6);
				log::write("[后台]修改密码错误：".$user['username']." - $log_password", 'login.php');
				$this->message('原账户密码不对',0);
			}
			
				if($password != $password2) {
					$this->message('两次输入的不一致',0);
				} else {

						$user['password'] = $this->user->md5_md5($password, $user['salt']);
						$this->user->update($user);
						$error = array();
						
						// 重新设置 cookie
						$this->user->set_login_cookie($user);
						$this->message($user['username'].'，您好，修改密码成功！', 1, './');
				}
			
			
		}
		
		$this->view->display('index_password_ajax.htm');
		
	}
	//hook xcenter_index_control_after.php
}

?>