<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include $conf['xcenter_path'].'control/admin_control.class.php';

class user_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked['user'] = ' active';
	}
    public function on_index(){
		//hook xcenter_user_index_before.php
		$this->_checked['user_list']=1;
		$groupid=intval(core::gpc('groupid','G'));
		$count=intval(core::gpc('count','G'));
		$page=misc::page();
		$pagesize=20;
		$start=($page-1)*$pagesize;
		$map=array();
		$groupid && $map['groupid']=$groupid;
		empty($count) && $count=$this->user->index_count($map);
        $list=$this->user->get_list($map,$start,$pagesize);
		foreach($list as &$u){
			$this->user->format($u);
		}
		$pages=misc::pages('?user-index-groupid-'.$groupid.'-count-'.$count.'.htm',$count,$page,20);
		$this->view->assign('list',$list);
		//hook xcenter_user_index_after.php
		$this->view->display('user_list.htm');
	}
	public function on_edit(){
		$uid=intval(core::gpc('uid','G'));
		$user=$this->user->read($uid);
		if(!$user) $this->message('用户不存在！',0);
		if($this->form_submit()){
			$username=core::gpc('username','P');
			$email=core::gpc('email','P');
			$groupid=intval(core::gpc('groupid','P'));
			$credits=intval(core::gpc('credits','P'));
			$golds=intval(core::gpc('golds','P'));
			$password=core::gpc('password','P');
			
			$this->user->safe_username($username);
			$error=array();
			$error['username']=$this->user->check_username($username);
			$error['email']=$this->user->check_email($email);
			$username!=$user['username'] && $error['reusername']=$this->user->check_username_exists($username);
			
			$password && $error['password']=$this->user->check_password($password);
			if(!array_filter($error)){
				$error=array();
				$user['username']=$username;
				$user['email']=$email;
				$user['groupid']=$groupid;
				$user['credits']=$credits;
				$user['golds']=$golds;
				$password && $user['password']=$this->user->md5_md5($password,$user['salt']);
				$this->user->update($user);
				$this->message('编辑成功');
			}
			$this->message($error);
			
		}
		$this->view->assign('uid',$uid);
		$this->view->assign('user',$user);
		$this->view->display('user_edit_ajax.htm');
	}
	public function on_delete(){
		$uids=core::gpc('uids','P');
		foreach((array)$uids as $uid){
			$uid=intval($uid);
            if($uid<3) continue;
			$this->user->delete($uid);
		}
		$this->message('删除成功！');	
	}
	public function on_search(){
		$keyword=urldecode(core::gpc('keyword','R'));
		$keyword = misc::safe_str($keyword,'@._-');
        $keyword_url = urlencode($keyword);
		$page=misc::page();
		$start=($page-1)*20;
		$list=array();
		if(intval($keyword)){
			$list=$this->user->get_list(array('username'=>array('LIKE'=>$keyword)),$start,20);
			$user=$this->user->read($keyword);
			$user && $list[$user['uid']]=$user;
		}elseif(check::is_email($keyword)){
			$list[]=$this->user->get_user_by_email($keyword);
		}else{
			$keyword=utf8::substr($keyword,0,20);
			$list=$this->user->get_list(array('username'=>array('LIKE'=>$keyword)),$start,20);	
		}
		foreach($list as &$u){
			$this->user->format($u);
			$u['username']=str_replace($keyword,'<span class="red">'.$keyword.'</span>',$u['username']);
		}
		$pages=misc::simple_pages('?user-search-keyword-'.$keyword_url.'.htm',count($list),$page,20);
		$this->view->assign('keyword',$keyword);
		$this->view->assign('list',$list);
		$this->view->assign('pages',$pages);
		$this->view->display('user_list.htm');
	
	}
	//hook xcenter_user_control_after.php
}
?>