<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');
define('MODEL_LIB_PATH',APP_PATH.'../lib/');

include $conf['xcenter_path'].'control/admin_control.class.php';
 
class admin_common_control extends admin_control{
    
	function __construct(&$conf) {
		// hook admin_common_control_construct_before.php
		parent::__construct($conf);    
		// hook admin_common_control_construct_after.php
		
		// 设置风格不受前台影响
		$this->conf['first_view_path'] = array(APP_PATH.'view/');

	}
    protected function update_cate_cache(){
        $cats=$this->xgcms_category->get_list();
        $arr=array();
        if(is_array($cats))foreach($cats as $cid=>$cat){
            
            $cat['parentid']>0 && $cat['arrparentid']=$this->get_arrparentid($cid);
            
            $cat['arrchildid']=$this->get_arrchildid($cid);

            if(empty($cat['arrchildid'])||$cat['arrchildid']===$cid){
                $cat['child']=0;
            } else{
                $cat['child']=1;
            }
			$this->xgcms_content->set_model($cat['modelid']);
			$cat['items']=$this->xgcms_content->index_count(array('catid'=>$cat['catid']));
            $this->xgcms_category->update($cat);
			$this->mcache->clear('cate',$cid);
			$this->mcache->clear('cate_dir',$cat['catdir']);
			$this->mcache->clear('childcate',$cid);
			$arr[$cid]=array('catid'=>$cat['catid'],'catname'=>$cat['catname'],'url'=>$cat['url'],'modelid'=>$cat['modelid'],'type'=>$cat['type'],'arrparentid'=>$cat['arrparentid']); 
        }   
		$this->mcache->real_set('category_arr','',$arr);
		//hook admin_admin_common_update_cate_cache_after.php
    }

	/**
	 * 
	 * 获取父栏目ID列表
	 * @param integer $catid              栏目ID
	 * @param array $arrparentid          父目录ID
	 * @param integer $n                  查找的层次
	 */
	protected function get_arrparentid($catid, $arrparentid = '', $n = 1) {
	    $categorys=$this->xgcms_category->get_list();
		if($n > 5 || !is_array($categorys) || !isset($categorys[$catid])) return false;
        
		$parentid = $categorys[$catid]['parentid'];
		$arrparentid = $arrparentid ? $parentid.','.$arrparentid : $parentid;
		if($parentid) {
			$arrparentid = $this->get_arrparentid($parentid, $arrparentid, ++$n);
		} else {
			$categorys[$catid]['arrparentid'] = $arrparentid;
		}
		$parentid = $categorys[$catid]['parentid'];
        

        //hook admin_admin_common_get_arrparentid_after.php
		return $arrparentid;
	}

	/**
	 * 
	 * 获取子栏目ID列表
	 * @param $catid 栏目ID
	 */
	protected function get_arrchildid($catid) {
	   
	    $categorys=$this->xgcms_category->get_list();
        
		$arrchildid = $catid;
		if(is_array($categorys)) {
			foreach($categorys as $id => $cat) {
				if($cat['parentid'] && $id != $catid && $cat['parentid']==$catid) {
					$arrchildid .= ','.$this->get_arrchildid($id);
				}
			}
		}
        
        $cate=$categorys[$catid];
        $cate['arrchildid']=$arrchildid;
        $arrchildid===$catid && $cate['child']=0;
        $this->xgcms_category->update($cate);
        //hook admin_admin_common_get_arrchildid_after.php
		return $arrchildid;
	}
    //hook admin_admin_common_control_after.php
    
}
?>