<?php

/*
* Copyright (C) xgcms.com
*/

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH . 'control/admin_common_control.class.php';

class extend_control extends admin_common_control
{
    function __construct(&$conf)
    {
        parent::__construct($conf);
        
        $this->_title[] = $conf['app_name'];
		$this->_checked['extend'] = 'active';
    }
    public function on_index(){
		//hook admin_extent_index_before.php
		$this->on_attach();
	}
	public function on_attach(){
		
		//hook admin_extent_attach_before.php
		
		$this->_checked['extend_attach']=1;
		$this->_title[] = '附件管理';
		$t = core::gpc('t', 'G');

		if($this->form_submit()){
			$aids = core::gpc('aid', 'P');
			$catids = core::gpc('catid', 'P');
			foreach((array)$aids as $k=>$v) {
				$attach=$this->xgcms_attach->read($catids[$k],$v);
				
				//hook admin_extent_attach_unlink_before.php
				
			    $this->xgcms_attach->unlink($attach);
			    $this->xgcms_attach->delete($attach['catid'],$v);
			}
		}
		
		$page = misc::page();
		$pagesize = 15;
		
		$count = $this->xgcms_attach->count();
		$map=array();
		if($t=='image'){
			$map=array('isimage'=>1);
			$count = $this->xgcms_attach->index_count($map);
		}elseif($t=='file'){
		    $map=array('isimage'=>0);	
			$count = $this->xgcms_attach->index_count($map);
		}else{
			$t='all';
		}
		$list=$this->xgcms_attach->get_attach_list($map,$page,$pagesize);
		$pages = misc::pages("?extend-attach-t-$t.htm", $count, $page, $pagesize);
		
		//hook admin_extent_attach_view_before.php
		
		$this->view->assign('pages', $pages);
		$this->view->assign('error', $error);
		$this->view->assign('list', $list);
		$this->view->assign('t', $t);
		$this->view->assign('pages',$pages);
		$this->view->assign('count',$count);
		$this->view->display('extend_attach.htm');
	}
	//hook admin_extent_control_after.php
}
?>