<?php

/*
* Copyright (C) xgcms.com
*/

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH . 'control/admin_common_control.class.php';

class search_control extends admin_common_control
{
    function __construct(&$conf)
    {
        parent::__construct($conf);
        
        $this->_title[] = $conf['app_name'];
    }
    public function on_index(){
        $this->_checked['content'] = 'active';
        $keyword = urldecode(core::gpc('keyword', 'R'));
        $keyword = misc::safe_str($keyword);
        $keyword_url = urlencode($keyword);
        $page=misc::page();
        $map = array('data' => array('LIKE'=>$keyword));

        $pagesize = 20;
        $start = ($page - 1) * $pagesize;
        //hook admin_search_index_list_before.php
        //  like
        $list = $this->xgcms_search->index_fetch($map, array(), $start, $pagesize,array('searchid'=>-1));
        $count=count($list);
        foreach($list as $k=>&$v){
             if(!$v['modelid'])  continue;
             $this->xgcms_content->set_model($v['modelid']);
             $info=$this->xgcms_content->read($v['catid'],$v['id']);
             if($info){
                 $v=array_merge($v,$info);
                 $v['title']=str_replace($keyword,'<span class="red">'.$keyword.'</span>',$v['title']);
                 $this->xgcms_content->format($v);
             }else{
                unset($list[$k]);
             }
        }
        $pages = misc::simple_pages("?search-index-keyword-$keyword_url.htm", $count, $page,
                $pagesize);
        $cate=0;
		
		//hook admin_search_index_view_before.php
		
            $this->view->assign('list', $list);
            $this->view->assign('pages', $pages);
            $this->view->assign('count', $count);
            $this->view->assign('cate', $cate);
            $this->view->assign('keyword', $keyword);
            $categorys = $this->xgcms_category->get_tree_category();
        $this->view->assign('categorys', $categorys);
        $this->view->display('content_list.htm');

    }
    public function on_createindex(){
        $this->_checked['html'] = 'active';
        $this->_checked['createindex']=1;
        $pernum=core::gpc('pernum','P');
        $last=$this->runtime->get('search_createindex');
		if($last&&core::gpc('continue','G')){
			
			//hook admin_search_createindex_continue_before.php
			
			$gourl='?search-createindex_run.htm';
            $this->view->assign('gourl',$gourl);
            $this->view->display('html_run.htm');
		}
        if($this->form_submit()){
            $models=$this->xgcms_model->get_list();
            $models=misc::arrlist_values($models,'modelid');
            $modelid=array_pop($models);
            !$modelid && $this->message('没有需要更新的内容模型！');

            $this->xgcms_search->truncate();
            $this->runtime->set('search_createindex',array('models'=>$models,'pernum'=>$pernum,'current'=>$modelid,'page'=>1));
            $gourl='?search-createindex_run-modelid-'.$modelid.'.htm';
			
			//hook admin_search_createindex_gorun_before.php
			
            $this->view->assign('gourl',$gourl);
            $this->view->display('html_run.htm');
        }
		$this->view->assign('last',$last);
        $this->view->display('search_createindex.htm');
    }
    public function on_createindex_run(){
        $this->_checked['html'] = 'active';
        //$modelid=core::gpc('modelid','G');
        $info=$this->runtime->get('search_createindex');
        empty($info) && $this->message('请选择需要更新的内容模型！');

        $pernum=$info['pernum'];
		$modelid=$info['current'];
        $page=$info['page'];
        $model=$this->xgcms_model->read($modelid);
        $this->xgcms_content->set_model($modelid);
        
        $start = ($page - 1) * $pernum;
		
		//hook admin_search_createindex_run_list_before.php
		
        $list = $this->xgcms_content->get_list(array('status'=>99), $start, $pernum, array('id' =>-1));
        $next=0;
        empty($list) && $next=1;
        foreach($list as $v){
             $words=$this->xgcms_search->safe_replace($v['title']);
             $words.=' '.$this->xgcms_search->safe_replace($v['keywords']);
             $arr=array(
                 'modelid'=>$modelid,
                 'catid'=>$v['catid'],
                 'id'=>$v['id'],
                 'adddate'=>$_SERVER['time'],
                 'data'=>$words

                );
             $this->xgcms_search->create($arr);
        }
		$page++;
        if($next){
                if(empty($info['models'])){ 
                    $this->runtime->delete('search_createindex');
                    $this->message('更新完成',1,'?search-createindex.htm');
                }
                $info['current']=$modelid=array_pop($info['models']);
                $model=$this->xgcms_model->read($modelid);
                
                $page=$start=1;
            }
			$info['page']=$page;
			$this->runtime->set('search_createindex',$info);
            $count=$this->xgcms_content->count();
            $page++;
			
			//hook admin_search_createindex_run_after.php
			
            $this->message('正在更新【'.$model['name'].'】:'.$start.'-'.($start+$pernum).' <br>总数:'.$count,1,'?search-createindex_run-modelid-'.$modelid.'-page-'.$page.'.htm');


    }
	//hook admin_search_control_after.php
}
?>