<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include APP_PATH.'control/list_control.class.php';

class html_list_control extends list_control {
    function __construct(&$conf) {
		parent::__construct($conf);
		$this->check_admin_group();
		$conf['html_cache']=0;
	}

	public function on_create(){
		$time=core::gpc('time','G');
/*		$catid=intval(core::gpc('catid','G'));
		$cate=$this->mcache->read('cate',$catid);
		$this->check_cate_exists($cate);
		$page=misc::page();*/

		$info=$this->runtime->get('html_list');
        empty($info) && $this->message('请选择需要更新的栏目！');
        $startid=$info['startid'];
        $endid=$info['endid'];
        $pernum=$info['pernum'];

		$_GET['catid']=$catid=$info['current'];
		$page=$info['page'];
		$cate=$this->mcache->read('cate',$catid);
		
		$this->check_cate_exists($cate);

		$count =$cate['items'];
		$totalpage=ceil($count/$this->conf['pagesize']);
		$cate['type']==1 && $totalpage=1;
		$next=0;
		
		for($i=1;$i<=$pernum;$i++){
			if($page>$totalpage){
				$next=1;
				break;
			}
			$_GET['page']=$page;
			ob_start();
			$this->on_index();
			$html = ob_get_contents();
			ob_end_clean();
			$this->xgcms_html->build_list_html($html,$cate,$page);
			$page++;

		}
		$endpage=$page+$pernum;
		if($next){
			if(empty($info['catarr'])){ 
				$this->runtime->delete('html_list');
				$this->message('更新完成',1,'xgcms/admin/?html-index.'.'htm');
			}
			$catid=array_pop($info['catarr']);
			$cate=$this->mcache->read('cate',$catid);
			$info['current']=$catid;
			$page=$start=1;
		}
		$info['page']=$page;
		$this->runtime->set('html_list',$info);

		$time+=(number_format(microtime(1) - $_SERVER['starttime'],2));

		$this->message("【".$cate['catname']."】总数：$totalpage 页<br>正在生成$page - $endpage 页<br>总耗时：$time 秒",1,'?html_list-create-catid-'.$catid.'-page-'.$page.'-time-'.$time.'.htm');
		
	}
    //hook html_list_control_after.php
}

?>