<?php
defined('IN_ADMIN') or exit('No permission resources.');
$defaultvalue = isset($setting['defaultvalue']) ? $setting['defaultvalue'] : '';
//正整数 UNSIGNED && SIGNED
$minnumber = isset($setting['minnumber']) ? $setting['minnumber'] : 1;
$decimaldigits = isset($setting['decimaldigits']) ? $setting['decimaldigits'] : '';

switch($field_type) {
	case 'varchar':
		if(!$maxlength) $maxlength = 255;
		$maxlength = min($maxlength, 255);
		$sql = "ALTER TABLE `$tablename` ADD `$field` VARCHAR( $maxlength ) NOT NULL DEFAULT '$defaultvalue'";
		$this->xgcms_model->db->query($sql);
	break;

	case 'tinyint':
		if(!$maxlength) $maxlength = 3;
		$minnumber = intval($minnumber);
		$defaultvalue = intval($defaultvalue);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `$field` TINYINT( $maxlength ) ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'");
	break;
	
	case 'number':
		$minnumber = intval($minnumber);
		$defaultvalue = $decimaldigits == 0 ? intval($defaultvalue) : floatval($defaultvalue);
		$sql = "ALTER TABLE `$tablename` ADD `$field` ".($decimaldigits == 0 ? 'INT' : 'FLOAT')." ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'";
		$this->xgcms_model->db->query($sql);
	break;

	case 'smallint':
		$minnumber = intval($minnumber);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `$field` SMALLINT ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL");
	break;

	case 'int':
		$minnumber = intval($minnumber);
		$defaultvalue = intval($defaultvalue);
		$sql = "ALTER TABLE `$tablename` ADD `$field` INT ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'";
		$this->xgcms_model->db->query($sql);
	break;

	case 'mediumint':
		$minnumber = intval($minnumber);
		$defaultvalue = intval($defaultvalue);
		$sql = "ALTER TABLE `$tablename` ADD `$field` INT ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'";
		$this->xgcms_model->db->query($sql);
	break;

	case 'mediumtext':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `$field` MEDIUMTEXT NOT NULL");
	break;
	
	case 'text':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `$field` TEXT NOT NULL");
	break;

	case 'date':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `$field` DATE NULL");
	break;
	
	case 'datetime':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `$field` DATETIME NULL");
	break;
	
	case 'timestamp':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `$field` TIMESTAMP NOT NULL");
	break;
	//特殊自定义字段
	case 'pages':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `paginationtype` TINYINT( 1 ) NOT NULL DEFAULT '0'");
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `maxcharperpage` MEDIUMINT( 6 ) NOT NULL DEFAULT '0'");
	break;
	case 'readpoint':
		$defaultvalue = intval($defaultvalue);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `readpoint` smallint(5) unsigned NOT NULL default '$defaultvalue'");
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` ADD `paytype` tinyint(1) unsigned NOT NULL default '0'");
	break;
}
?>