<?php
defined('IN_ADMIN') or exit('No permission resources.');
$defaultvalue = isset($setting['defaultvalue']) ? $setting['defaultvalue'] : '';
$minnumber = isset($setting['minnumber']) ? $setting['minnumber'] : 1;
$decimaldigits = isset($setting['decimaldigits']) ? $setting['decimaldigits'] : '';

switch($field_type) {
	case 'varchar':
		if(!$maxlength) $maxlength = 255;
		$maxlength = min($maxlength, 255);
		$fieldtype = $issystem ? 'CHAR' : 'VARCHAR';
		$sql = "ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` $fieldtype( $maxlength ) NOT NULL DEFAULT '$defaultvalue'";
		$this->xgcms_model->db->query($sql);
	break;

	case 'tinyint':
		$minnumber = intval($minnumber);
		$defaultvalue = intval($defaultvalue);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` TINYINT ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'");
	break;

	case 'number':
		$minnumber = intval($minnumber);
		$defaultvalue = $decimaldigits == 0 ? intval($defaultvalue) : floatval($defaultvalue);
		$sql = "ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` ".($decimaldigits == 0 ? 'INT' : 'FLOAT')." ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'";
		$this->xgcms_model->db->query($sql);
	break;

	case 'smallint':
		$minnumber = intval($minnumber);
		$defaultvalue = intval($defaultvalue);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` SMALLINT ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'");
	break;

	case 'mediumint':
		$minnumber = intval($minnumber);
		$defaultvalue = intval($defaultvalue);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` MEDIUMINT ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'");
	break;


	case 'int':
		$minnumber = intval($minnumber);
		$defaultvalue = intval($defaultvalue);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` INT ".($minnumber >= 0 ? 'UNSIGNED' : '')." NOT NULL DEFAULT '$defaultvalue'");
	break;

	case 'mediumtext':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` MEDIUMTEXT NOT NULL");
	break;
	
	case 'text':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` TEXT NOT NULL");
	break;

	case 'date':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` DATE NULL");
	break;
	
	case 'datetime':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` DATETIME NULL");
	break;
	
	case 'timestamp':
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `$field` TIMESTAMP NOT NULL");
	break;
	//特殊自定义字段
	case 'pages':
		
	break;
	case 'readpoint':
		$defaultvalue = intval($defaultvalue);
		$this->xgcms_model->db->query("ALTER TABLE `$tablename` CHANGE `$oldfield` `readpoint` smallint(5) unsigned NOT NULL default '$defaultvalue'");
	break;

}
?>