<?php

/*
 * Copyright (C) xgcms.com
 */

class xgcms_pos extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'xgcms_pos';
		$this->primarykey = array('posid');
		$this->maxcol='posid';
	}
	
	public function get_one($map) {
		$rs = $this->index_fetch($map,array('posid'=>1),0,1);
		return $rs=$rs?array_pop($rs):false;
	}
	public function get_list($map=array(),$start=0,$limit=1000,$order=array('listorder'=>-1)){
		$list = $this->index_fetch($map,$order,$start,$limit);
        misc::arrlist_change_key($list, 'posid');
		return $list;
	}
	public function format(&$pos){
		if($pos['modelid']){
			$model=$this->xgcms_model->read($pos['modelid']);
			$pos['modelname']=$model['name'];
		}else{
			$pos['modelname']='全部';
		}
		if($pos['catid']){
			$cate=$this->xgcms_category->read($pos['catid']);
			$pos['catname']=$cate['catname'];
		}else{
			$pos['catname']='全部';
		}
	    // hook xgcms_pos_model_format_end.php
	}
	public function xdelete($posid){
		$this->xgcms_pos_data->delete_by_posid($posid);
		$this->delete($posid);
		// hook xgcms_pos_model_xdelete_end.php
	}
	// hook xgcms_pos_model_end.php
}

?>